/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.moduleloader;

import java.net.URL;
import java.util.Enumeration;
import org.apache.felix.framework.Logger;
import org.apache.felix.moduleloader.IContentLoader;
import org.apache.felix.moduleloader.IModule;
import org.apache.felix.moduleloader.IModuleDefinition;
import org.apache.felix.moduleloader.IWire;
import org.apache.felix.moduleloader.ResourceNotFoundException;

public class ModuleImpl
implements IModule {
    private Logger m_logger = null;
    private String m_id = null;
    private boolean m_removalPending = false;
    private IModuleDefinition m_md = null;
    private IContentLoader m_contentLoader = null;
    private IWire[] m_wires = null;
    private Object m_securityContext = null;

    ModuleImpl(Logger logger, String id, IModuleDefinition md) {
        this.m_logger = logger;
        this.m_id = id;
        this.m_md = md;
    }

    public String getId() {
        return this.m_id;
    }

    public IModuleDefinition getDefinition() {
        return this.m_md;
    }

    public IContentLoader getContentLoader() {
        return this.m_contentLoader;
    }

    protected void setContentLoader(IContentLoader contentLoader) {
        this.m_contentLoader = contentLoader;
    }

    protected void setSecurityContext(Object securityContext) {
        this.m_securityContext = securityContext;
    }

    public IWire[] getWires() {
        return this.m_wires;
    }

    public void setWires(IWire[] wires) {
        this.m_wires = wires;
    }

    public boolean isRemovalPending() {
        return this.m_removalPending;
    }

    public void setRemovalPending(boolean removalPending) {
        this.m_removalPending = removalPending;
    }

    public Class getClass(String name) {
        try {
            return this.m_contentLoader.getSearchPolicy().findClass(name);
        }
        catch (ClassNotFoundException ex) {
            this.m_logger.log(2, ex.getMessage(), ex);
            return null;
        }
    }

    public URL getResource(String name) {
        try {
            return this.m_contentLoader.getSearchPolicy().findResource(name);
        }
        catch (ResourceNotFoundException ex) {
            this.m_logger.log(2, ex.getMessage(), ex);
            return null;
        }
    }

    public Enumeration getResources(String name) {
        try {
            return this.m_contentLoader.getSearchPolicy().findResources(name);
        }
        catch (ResourceNotFoundException ex) {
            this.m_logger.log(2, ex.getMessage(), ex);
            return null;
        }
    }

    public String toString() {
        return this.m_id;
    }

    public Object getSecurityContext() {
        return this.m_securityContext;
    }
}

