/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import org.apache.felix.bundlerepository.CapabilityImpl;
import org.apache.felix.bundlerepository.CategoryImpl;
import org.apache.felix.bundlerepository.PropertyImpl;
import org.apache.felix.bundlerepository.RequirementImpl;
import org.apache.felix.bundlerepository.ResourceComparator;
import org.apache.felix.bundlerepository.ResourceImpl;
import org.apache.felix.bundlerepository.Util;
import org.apache.felix.bundlerepository.metadataparser.XmlCommonHandler;
import org.apache.felix.bundlerepository.metadataparser.kxmlsax.KXml2SAXParser;
import org.osgi.service.obr.Capability;
import org.osgi.service.obr.Repository;
import org.osgi.service.obr.Requirement;
import org.osgi.service.obr.Resource;

public class RepositoryImpl
implements Repository {
    private String m_name = null;
    private long m_lastmodified = 0L;
    private URL m_url = null;
    private Resource[] m_resources = null;
    private int m_hopCount = 1;
    private ResourceComparator m_nameComparator = new ResourceComparator();

    public RepositoryImpl(URL url) throws Exception {
        this.m_url = url;
        this.parseRepositoryFile(this.m_hopCount);
    }

    public URL getURL() {
        return this.m_url;
    }

    protected void setURL(URL url) {
        this.m_url = url;
    }

    public Resource[] getResources() {
        return this.m_resources;
    }

    public void addResource(Resource resource) {
        ((ResourceImpl)resource).setRepository(this);
        if (this.m_resources == null) {
            this.m_resources = new Resource[]{resource};
        } else {
            Resource[] newResources = new Resource[this.m_resources.length + 1];
            System.arraycopy(this.m_resources, 0, newResources, 0, this.m_resources.length);
            newResources[this.m_resources.length] = resource;
            this.m_resources = newResources;
        }
        Arrays.sort(this.m_resources, this.m_nameComparator);
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public long getLastModified() {
        return this.m_lastmodified;
    }

    public void setLastmodified(String s) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddhhmmss.SSS");
        try {
            this.m_lastmodified = format.parse(s).getTime();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    protected Object put(Object key, Object value) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseRepositoryFile(int hopCount) throws Exception {
        InputStream is = null;
        BufferedReader br = null;
        try {
            URLConnection conn = this.m_url.openConnection();
            String auth = System.getProperty("http.proxyAuth");
            if (auth != null && auth.length() > 0 && ("http".equals(this.m_url.getProtocol()) || "https".equals(this.m_url.getProtocol()))) {
                String base64 = Util.base64Encode(auth);
                conn.setRequestProperty("Proxy-Authorization", "Basic " + base64);
            }
            is = conn.getInputStream();
            XmlCommonHandler handler = new XmlCommonHandler();
            Object factory = new Object(){

                public RepositoryImpl newInstance() {
                    return RepositoryImpl.this;
                }
            };
            Method repoSetter = RepositoryImpl.class.getDeclaredMethod("put", Object.class, Object.class);
            Method resSetter = ResourceImpl.class.getDeclaredMethod("put", Object.class, Object.class);
            handler.addType("repository", factory, Repository.class, repoSetter);
            handler.addType("resource", ResourceImpl.class, Resource.class, resSetter);
            handler.addType("category", CategoryImpl.class, null, null);
            handler.addType("require", RequirementImpl.class, Requirement.class, null);
            handler.addType("capability", CapabilityImpl.class, Capability.class, null);
            handler.addType("p", PropertyImpl.class, null, null);
            handler.setDefaultType(String.class, null, null);
            br = new BufferedReader(new InputStreamReader(is));
            KXml2SAXParser parser = new KXml2SAXParser(br);
            parser.parseXML(handler);
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException ex) {}
    }
}

