/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.util.Map;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.cache.BundleArchive;
import org.apache.felix.moduleloader.IModule;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

class BundleInfo {
    private Logger m_logger = null;
    private BundleArchive m_archive = null;
    private IModule[] m_modules = null;
    private int m_state = 0;
    private BundleActivator m_activator = null;
    private BundleContext m_context = null;
    private boolean m_stale = false;
    private int m_lockCount = 0;
    private Thread m_lockThread = null;

    protected BundleInfo(Logger logger, BundleArchive archive, IModule module) throws Exception {
        IModule[] iModuleArray;
        this.m_logger = logger;
        this.m_archive = archive;
        if (module == null) {
            iModuleArray = new IModule[]{};
        } else {
            IModule[] iModuleArray2 = new IModule[1];
            iModuleArray = iModuleArray2;
            iModuleArray2[0] = module;
        }
        this.m_modules = iModuleArray;
        this.m_state = 2;
        this.m_stale = false;
        this.m_activator = null;
        this.m_context = null;
    }

    public BundleArchive getArchive() {
        return this.m_archive;
    }

    public IModule[] getModules() {
        return this.m_modules;
    }

    public boolean hasModule(IModule module) {
        for (int i = 0; i < this.m_modules.length; ++i) {
            if (this.m_modules[i] != module) continue;
            return true;
        }
        return false;
    }

    public IModule getCurrentModule() {
        return this.m_modules[this.m_modules.length - 1];
    }

    public void addModule(IModule module) {
        IModule[] dest = new IModule[this.m_modules.length + 1];
        System.arraycopy(this.m_modules, 0, dest, 0, this.m_modules.length);
        dest[this.m_modules.length] = module;
        this.m_modules = dest;
    }

    public long getBundleId() {
        try {
            return this.m_archive.getId();
        }
        catch (Exception ex) {
            this.m_logger.log(1, "Error getting the identifier from bundle archive.", ex);
            return -1L;
        }
    }

    public String getLocation() {
        try {
            return this.m_archive.getLocation();
        }
        catch (Exception ex) {
            this.m_logger.log(1, "Error getting location from bundle archive.", ex);
            return null;
        }
    }

    public int getStartLevel(int defaultLevel) {
        try {
            return this.m_archive.getStartLevel();
        }
        catch (Exception ex) {
            this.m_logger.log(1, "Error reading start level from bundle archive.", ex);
            return defaultLevel;
        }
    }

    public void setStartLevel(int i) {
        try {
            this.m_archive.setStartLevel(i);
        }
        catch (Exception ex) {
            this.m_logger.log(1, "Error writing start level to bundle archive.", ex);
        }
    }

    public Map getCurrentHeader() {
        try {
            return this.m_archive.getRevision(this.m_archive.getRevisionCount() - 1).getManifestHeader();
        }
        catch (Exception ex) {
            this.m_logger.log(1, "Error reading manifest from bundle archive.", ex);
            return null;
        }
    }

    public int getState() {
        return this.m_state;
    }

    public void setState(int i) {
        this.m_state = i;
    }

    public long getLastModified() {
        try {
            return this.m_archive.getLastModified();
        }
        catch (Exception ex) {
            this.m_logger.log(1, "Error reading last modification time from bundle archive.", ex);
            return 0L;
        }
    }

    public void setLastModified(long l) {
        try {
            this.m_archive.setLastModified(l);
        }
        catch (Exception ex) {
            this.m_logger.log(1, "Error writing last modification time to bundle archive.", ex);
        }
    }

    public int getPersistentState() {
        try {
            return this.m_archive.getPersistentState();
        }
        catch (Exception ex) {
            this.m_logger.log(1, "Error reading persistent state from bundle archive.", ex);
            return 2;
        }
    }

    public void setPersistentStateInactive() {
        try {
            this.m_archive.setPersistentState(2);
        }
        catch (Exception ex) {
            this.m_logger.log(1, "Error writing persistent state to bundle archive.", ex);
        }
    }

    public void setPersistentStateActive() {
        try {
            this.m_archive.setPersistentState(32);
        }
        catch (Exception ex) {
            this.m_logger.log(1, "Error writing persistent state to bundle archive.", ex);
        }
    }

    public void setPersistentStateUninstalled() {
        try {
            this.m_archive.setPersistentState(1);
        }
        catch (Exception ex) {
            this.m_logger.log(1, "Error writing persistent state to bundle archive.", ex);
        }
    }

    public BundleContext getContext() {
        return this.m_context;
    }

    public void setContext(BundleContext context) {
        this.m_context = context;
    }

    public BundleActivator getActivator() {
        return this.m_activator;
    }

    public void setActivator(BundleActivator activator) {
        this.m_activator = activator;
    }

    public boolean isStale() {
        return this.m_stale;
    }

    public void setStale() {
        this.m_stale = true;
    }

    public boolean isLockable() {
        return this.m_lockCount == 0 || this.m_lockThread == Thread.currentThread();
    }

    public void lock() {
        if (this.m_lockCount > 0 && this.m_lockThread != Thread.currentThread()) {
            throw new IllegalStateException("Bundle is locked by another thread.");
        }
        ++this.m_lockCount;
        this.m_lockThread = Thread.currentThread();
    }

    public void unlock() {
        if (this.m_lockCount == 0) {
            throw new IllegalStateException("Bundle is not locked.");
        }
        if (this.m_lockCount > 0 && this.m_lockThread != Thread.currentThread()) {
            throw new IllegalStateException("Bundle is locked by another thread.");
        }
        --this.m_lockCount;
        if (this.m_lockCount == 0) {
            this.m_lockThread = null;
        }
    }

    public void syncLock(BundleInfo info) {
        this.m_lockCount = info.m_lockCount;
        this.m_lockThread = info.m_lockThread;
    }
}

