/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.AccessControlException;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.felix.framework.BundleContextImpl;
import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.BundleInfo;
import org.apache.felix.framework.ExportedPackageImpl;
import org.apache.felix.framework.FakeURLStreamHandler;
import org.apache.felix.framework.FilterImpl;
import org.apache.felix.framework.FindEntriesEnumeration;
import org.apache.felix.framework.GetEntryPathsEnumeration;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.ServiceRegistry;
import org.apache.felix.framework.StartLevelImpl;
import org.apache.felix.framework.SystemBundle;
import org.apache.felix.framework.URLHandlersBundleStreamHandler;
import org.apache.felix.framework.cache.BundleArchive;
import org.apache.felix.framework.cache.BundleCache;
import org.apache.felix.framework.cache.SystemBundleArchive;
import org.apache.felix.framework.searchpolicy.ContentClassLoader;
import org.apache.felix.framework.searchpolicy.ContentLoaderImpl;
import org.apache.felix.framework.searchpolicy.ModuleDefinition;
import org.apache.felix.framework.searchpolicy.R4Export;
import org.apache.felix.framework.searchpolicy.R4Import;
import org.apache.felix.framework.searchpolicy.R4LibraryClause;
import org.apache.felix.framework.searchpolicy.R4SearchPolicy;
import org.apache.felix.framework.searchpolicy.R4SearchPolicyCore;
import org.apache.felix.framework.searchpolicy.ResolveException;
import org.apache.felix.framework.searchpolicy.ResolveListener;
import org.apache.felix.framework.searchpolicy.URLPolicyImpl;
import org.apache.felix.framework.util.EventDispatcher;
import org.apache.felix.framework.util.ManifestParser;
import org.apache.felix.framework.util.MapToDictionary;
import org.apache.felix.framework.util.MutablePropertyResolver;
import org.apache.felix.framework.util.MutablePropertyResolverImpl;
import org.apache.felix.framework.util.PropertyResolver;
import org.apache.felix.framework.util.SecureAction;
import org.apache.felix.framework.util.StringMap;
import org.apache.felix.framework.util.Util;
import org.apache.felix.moduleloader.IContentLoader;
import org.apache.felix.moduleloader.IModule;
import org.apache.felix.moduleloader.IModuleFactory;
import org.apache.felix.moduleloader.IWire;
import org.apache.felix.moduleloader.ModuleEvent;
import org.apache.felix.moduleloader.ModuleFactoryImpl;
import org.apache.felix.moduleloader.ModuleImpl;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.PackagePermission;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.startlevel.StartLevel;

public class Felix {
    private Logger m_logger = new Logger();
    private PropertyResolver m_config = new ConfigImpl();
    private MutablePropertyResolver m_configMutable = null;
    private IModuleFactory m_factory = null;
    private R4SearchPolicyCore m_policyCore = null;
    private Object[] m_bundleLock = new Object[0];
    private Map m_installRequestMap = null;
    private Object[] m_installRequestLock_Priority1 = new Object[0];
    private HashMap m_installedBundleMap = null;
    private Object[] m_installedBundleLock_Priority2 = new Object[0];
    private BundleImpl[] m_uninstalledBundles = null;
    private Object[] m_uninstalledBundlesLock_Priority3 = new Object[0];
    public static final int INITIAL_STATUS = -1;
    public static final int RUNNING_STATUS = 0;
    public static final int STARTING_STATUS = 1;
    public static final int STOPPING_STATUS = 2;
    private int m_frameworkStatus = -1;
    private int m_activeStartLevel = 0;
    private BundleCache m_cache = null;
    private long m_nextId = 1L;
    private Object m_nextIdLock = new Object[0];
    private EventDispatcher m_dispatcher = null;
    private ServiceRegistry m_registry = null;
    private URLStreamHandler m_bundleStreamHandler = null;
    private SecureAction m_secureAction = new SecureAction();
    private Collection m_trustedCaCerts = null;
    private Comparator m_comparator = null;

    public synchronized void start(MutablePropertyResolver configMutable, List activatorList) {
        this.start(configMutable, activatorList, null);
    }

    public synchronized void start(MutablePropertyResolver configMutable, List activatorList, Collection trustedCaCerts) {
        if (this.m_frameworkStatus != -1) {
            throw new IllegalStateException("Invalid framework status: " + this.m_frameworkStatus);
        }
        this.m_trustedCaCerts = trustedCaCerts;
        this.m_frameworkStatus = 1;
        this.m_factory = null;
        this.m_configMutable = configMutable == null ? new MutablePropertyResolverImpl(new StringMap(false)) : configMutable;
        this.m_activeStartLevel = 0;
        this.m_installRequestMap = new HashMap();
        this.m_installedBundleMap = new HashMap();
        this.m_uninstalledBundles = null;
        this.m_cache = null;
        this.m_nextId = 1L;
        this.m_dispatcher = null;
        this.m_bundleStreamHandler = new URLHandlersBundleStreamHandler(this);
        this.m_registry = new ServiceRegistry(this.m_logger);
        this.m_registry.addServiceListener(new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                Felix.this.fireServiceEvent(event);
            }
        });
        try {
            this.m_cache = new BundleCache(this.m_config, this.m_logger, this.m_trustedCaCerts);
        }
        catch (Exception ex) {
            boolean isEmbedded;
            System.err.println("Error creating bundle cache:");
            ex.printStackTrace();
            String embedded = this.m_config.get("felix.embedded.execution");
            boolean bl = isEmbedded = embedded == null ? false : embedded.equals("true");
            if (!isEmbedded) {
                this.m_secureAction.exit(-1);
            }
            throw new RuntimeException(ex.toString());
        }
        this.m_policyCore = new R4SearchPolicyCore(this.m_logger, this.m_config);
        this.m_policyCore.addResolverListener(new ResolveListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void moduleResolved(ModuleEvent event) {
                block6: {
                    BundleImpl bundle = null;
                    try {
                        long id = Util.getBundleIdFromModuleId(event.getModule().getId());
                        if (id < 0L) break block6;
                        bundle = (BundleImpl)Felix.this.getBundle(id);
                        try {
                            Felix.this.acquireBundleLock(bundle);
                            if (bundle.getInfo().getCurrentModule() == event.getModule()) {
                                bundle.getInfo().setState(4);
                                Felix.this.fireBundleEvent(32, bundle);
                            }
                        }
                        finally {
                            Felix.this.releaseBundleLock(bundle);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }

            public void moduleUnresolved(ModuleEvent event) {
            }
        });
        this.m_factory = new ModuleFactoryImpl(this.m_logger);
        this.m_policyCore.setModuleFactory(this.m_factory);
        this.m_dispatcher = new EventDispatcher(this.m_logger);
        this.initializeFrameworkProperties();
        SystemBundle systembundle = null;
        try {
            BundleInfo info = new BundleInfo(this.m_logger, new SystemBundleArchive(), null);
            systembundle = new SystemBundle(this, info, activatorList);
            ModuleDefinition md = new ModuleDefinition(systembundle.getExports(), null, null, null);
            systembundle.getInfo().addModule(this.m_factory.createModule("0", md));
            systembundle.getContentLoader().setSearchPolicy(new R4SearchPolicy(this.m_policyCore, systembundle.getInfo().getCurrentModule()));
            this.m_factory.setContentLoader(systembundle.getInfo().getCurrentModule(), systembundle.getContentLoader());
            this.m_factory.setSecurityContext(systembundle.getInfo().getCurrentModule(), systembundle.getClass().getProtectionDomain());
            this.m_installedBundleMap.put(systembundle.getInfo().getLocation(), systembundle);
            try {
                this.m_policyCore.resolve(systembundle.getInfo().getCurrentModule());
            }
            catch (ResolveException ex) {
                throw new BundleException("Unresolved package in System Bundle:" + ex.getPackage());
            }
            systembundle.start();
        }
        catch (Exception ex) {
            this.m_factory = null;
            EventDispatcher.shutdown();
            this.m_logger.log(1, "Unable to start system bundle.", ex);
            throw new RuntimeException("Unable to start system bundle.");
        }
        BundleArchive[] archives = null;
        try {
            archives = this.m_cache.getArchives();
        }
        catch (Exception ex) {
            this.m_logger.log(1, "Unable to list saved bundles: " + ex, ex);
            archives = null;
        }
        BundleImpl bundle = null;
        for (int i = 0; archives != null && i < archives.length; ++i) {
            try {
                this.m_nextId = Math.max(this.m_nextId, archives[i].getId() + 1L);
                if (archives[i].getPersistentState() == 1) {
                    this.m_cache.remove(archives[i]);
                    continue;
                }
                bundle = (BundleImpl)this.installBundle(archives[i].getId(), archives[i].getLocation(), null);
                continue;
            }
            catch (Exception ex) {
                this.fireFrameworkEvent(2, bundle, ex);
                try {
                    this.m_logger.log(1, "Unable to re-install " + archives[i].getLocation(), ex);
                    continue;
                }
                catch (Exception ex2) {
                    this.m_logger.log(1, "Unable to re-install cached bundle.", ex);
                }
            }
        }
        int startLevel = 1;
        String s = this.m_config.get("felix.startlevel.framework");
        if (s != null) {
            try {
                startLevel = Integer.parseInt(s);
            }
            catch (NumberFormatException ex) {
                startLevel = 1;
            }
        }
        this.processAutoProperties();
        try {
            StartLevel sl = (StartLevel)this.getService(this.getBundle(0L), this.getServiceReferences((BundleImpl)this.getBundle(0L), StartLevel.class.getName(), null)[0]);
            if (sl instanceof StartLevelImpl) {
                ((StartLevelImpl)sl).setStartLevelAndWait(startLevel);
            } else {
                sl.setStartLevel(startLevel);
            }
        }
        catch (InvalidSyntaxException ex) {
            // empty catch block
        }
        this.m_frameworkStatus = 0;
        systembundle.getInfo().setState(32);
        this.fireBundleEvent(2, systembundle);
        this.fireFrameworkEvent(1, this.getBundle(0L), null);
    }

    public synchronized void shutdown() {
        boolean isEmbedded;
        if (this.m_frameworkStatus != 0) {
            return;
        }
        this.m_frameworkStatus = 2;
        try {
            this.shutdownInternal();
        }
        catch (Exception ex) {
            this.fireFrameworkEvent(2, this.getBundle(0L), ex);
            this.m_logger.log(1, "Error stopping framework.", ex);
        }
        String embedded = this.m_config.get("felix.embedded.execution");
        boolean bl = isEmbedded = embedded == null ? false : embedded.equals("true");
        if (!isEmbedded) {
            this.m_secureAction.exit(0);
        }
    }

    private void shutdownInternal() {
        BundleImpl bundle;
        int i;
        try {
            StartLevelImpl sl = (StartLevelImpl)this.getService(this.getBundle(0L), this.getServiceReferences((BundleImpl)this.getBundle(0L), StartLevel.class.getName(), null)[0]);
            sl.setStartLevelAndWait(0);
        }
        catch (InvalidSyntaxException ex) {
            // empty catch block
        }
        try {
            ((SystemBundle)this.getBundle(0L)).shutdown();
        }
        catch (Exception ex) {
            this.fireFrameworkEvent(2, this.getBundle(0L), ex);
            this.m_logger.log(1, "Error stopping system bundle.", ex);
        }
        Bundle[] bundles = this.getBundles();
        for (i = 0; i < bundles.length; ++i) {
            bundle = (BundleImpl)bundles[i];
            if (bundle.getInfo().getArchive().getRevisionCount() <= 1) continue;
            try {
                this.purgeBundle(bundle);
                continue;
            }
            catch (Exception ex) {
                this.fireFrameworkEvent(2, bundle, ex);
                this.m_logger.log(1, "Unable to purge bundle " + bundle.getInfo().getLocation(), ex);
            }
        }
        for (i = 0; this.m_uninstalledBundles != null && i < this.m_uninstalledBundles.length; ++i) {
            try {
                this.garbageCollectBundle(this.m_uninstalledBundles[i]);
                continue;
            }
            catch (Exception ex) {
                this.m_logger.log(1, "Unable to remove " + this.m_uninstalledBundles[i].getInfo().getLocation(), ex);
            }
        }
        EventDispatcher.shutdown();
        this.m_frameworkStatus = -1;
        bundles = this.getBundles();
        for (i = 0; i < bundles.length; ++i) {
            bundle = (BundleImpl)bundles[i];
            try {
                IModule[] modules = bundle.getInfo().getModules();
                for (int j = 0; j < modules.length; ++j) {
                    this.m_factory.removeModule(modules[j]);
                }
                continue;
            }
            catch (Exception ex) {
                this.m_logger.log(1, "Unable to clean up " + bundle.getInfo().getLocation(), ex);
            }
        }
    }

    public int getStatus() {
        return this.m_frameworkStatus;
    }

    protected int getStartLevel() {
        return this.m_activeStartLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setFrameworkStartLevel(int requestedLevel) {
        Bundle[] bundles = null;
        Object[] objectArray = this.m_installedBundleLock_Priority2;
        synchronized (this.m_installedBundleLock_Priority2) {
            boolean lowering = requestedLevel < this.m_activeStartLevel;
            this.m_activeStartLevel = requestedLevel;
            bundles = this.getBundles();
            Comparator comparator = null;
            comparator = lowering ? new Comparator(){

                public int compare(Object o1, Object o2) {
                    BundleImpl b1 = (BundleImpl)o1;
                    BundleImpl b2 = (BundleImpl)o2;
                    if (b1.getInfo().getStartLevel(Felix.this.getInitialBundleStartLevel()) < b2.getInfo().getStartLevel(Felix.this.getInitialBundleStartLevel())) {
                        return 1;
                    }
                    if (b1.getInfo().getStartLevel(Felix.this.getInitialBundleStartLevel()) > b2.getInfo().getStartLevel(Felix.this.getInitialBundleStartLevel())) {
                        return -1;
                    }
                    if (b1.getInfo().getBundleId() < b2.getInfo().getBundleId()) {
                        return 1;
                    }
                    return -1;
                }
            } : new Comparator(){

                public int compare(Object o1, Object o2) {
                    BundleImpl b1 = (BundleImpl)o1;
                    BundleImpl b2 = (BundleImpl)o2;
                    if (b1.getInfo().getStartLevel(Felix.this.getInitialBundleStartLevel()) > b2.getInfo().getStartLevel(Felix.this.getInitialBundleStartLevel())) {
                        return 1;
                    }
                    if (b1.getInfo().getStartLevel(Felix.this.getInitialBundleStartLevel()) < b2.getInfo().getStartLevel(Felix.this.getInitialBundleStartLevel())) {
                        return -1;
                    }
                    if (b1.getInfo().getBundleId() > b2.getInfo().getBundleId()) {
                        return 1;
                    }
                    return -1;
                }
            };
            Arrays.sort(bundles, comparator);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            for (int i = 0; bundles != null && i < bundles.length; ++i) {
                BundleImpl impl = (BundleImpl)bundles[i];
                if (impl.getInfo().getBundleId() == 0L) continue;
                this.acquireBundleLock(impl);
                try {
                    if (impl.getInfo().getPersistentState() == 32 && impl.getInfo().getStartLevel(this.getInitialBundleStartLevel()) <= this.m_activeStartLevel) {
                        try {
                            this.startBundle(impl, false);
                        }
                        catch (Throwable th) {
                            this.fireFrameworkEvent(2, impl, th);
                            this.m_logger.log(1, "Error starting " + impl.getInfo().getLocation(), th);
                        }
                        continue;
                    }
                    if (impl.getInfo().getStartLevel(this.getInitialBundleStartLevel()) <= this.m_activeStartLevel) continue;
                    try {
                        this.stopBundle(impl, false);
                    }
                    catch (Throwable th) {
                        this.fireFrameworkEvent(2, impl, th);
                        this.m_logger.log(1, "Error stopping " + impl.getInfo().getLocation(), th);
                    }
                    continue;
                }
                finally {
                    this.releaseBundleLock(impl);
                }
            }
            if (this.m_frameworkStatus == 0) {
                this.fireFrameworkEvent(8, this.getBundle(0L), null);
            }
            return;
        }
    }

    protected int getInitialBundleStartLevel() {
        String s = this.m_config.get("felix.startlevel.bundle");
        if (s != null) {
            try {
                int i = Integer.parseInt(s);
                return i > 0 ? i : 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1;
    }

    protected void setInitialBundleStartLevel(int startLevel) {
        if (startLevel <= 0) {
            throw new IllegalArgumentException("Initial start level must be greater than zero.");
        }
        this.m_configMutable.put("felix.startlevel.bundle", Integer.toString(startLevel));
    }

    protected int getBundleStartLevel(Bundle bundle) {
        if (bundle.getState() == 1) {
            throw new IllegalArgumentException("Bundle is uninstalled.");
        }
        return ((BundleImpl)bundle).getInfo().getStartLevel(this.getInitialBundleStartLevel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBundleStartLevel(Bundle bundle, int startLevel) {
        Throwable rethrow;
        block11: {
            this.acquireBundleLock((BundleImpl)bundle);
            rethrow = null;
            try {
                if (bundle.getState() == 1) {
                    throw new IllegalArgumentException("Bundle is uninstalled.");
                }
                if (startLevel >= 1) {
                    BundleImpl impl = (BundleImpl)bundle;
                    impl.getInfo().setStartLevel(startLevel);
                    try {
                        if (impl.getInfo().getPersistentState() == 32 && impl.getInfo().getStartLevel(this.getInitialBundleStartLevel()) <= this.m_activeStartLevel) {
                            this.startBundle(impl, false);
                        } else if (impl.getInfo().getStartLevel(this.getInitialBundleStartLevel()) > this.m_activeStartLevel) {
                            this.stopBundle(impl, false);
                        }
                        break block11;
                    }
                    catch (Throwable th) {
                        rethrow = th;
                        this.m_logger.log(1, "Error starting/stopping bundle.", th);
                    }
                    break block11;
                }
                this.m_logger.log(2, "Bundle start level must be greater than zero.");
            }
            finally {
                this.releaseBundleLock((BundleImpl)bundle);
            }
        }
        if (rethrow != null) {
            this.fireFrameworkEvent(2, bundle, rethrow);
        }
    }

    protected boolean isBundlePersistentlyStarted(Bundle bundle) {
        if (bundle.getState() == 1) {
            throw new IllegalArgumentException("Bundle is uninstalled.");
        }
        return ((BundleImpl)bundle).getInfo().getPersistentState() == 32;
    }

    protected Dictionary getBundleHeaders(BundleImpl bundle) {
        return new MapToDictionary(bundle.getInfo().getCurrentHeader());
    }

    protected String getBundleLocation(BundleImpl bundle) {
        return bundle.getInfo().getLocation();
    }

    protected URL getBundleResource(BundleImpl bundle, String name) {
        if (bundle.getInfo().getState() == 1) {
            throw new IllegalStateException("The bundle is uninstalled.");
        }
        return bundle.getInfo().getCurrentModule().getResource(name);
    }

    protected Enumeration getBundleResources(BundleImpl bundle, String name) {
        if (bundle.getInfo().getState() == 1) {
            throw new IllegalStateException("The bundle is uninstalled.");
        }
        return bundle.getInfo().getCurrentModule().getResources(name);
    }

    protected URL getBundleEntry(BundleImpl bundle, String name) {
        if (bundle.getInfo().getState() == 1) {
            throw new IllegalStateException("The bundle is uninstalled.");
        }
        return bundle.getInfo().getCurrentModule().getContentLoader().getResourceFromContent(name);
    }

    protected Enumeration getBundleEntryPaths(BundleImpl bundle, String path) {
        if (bundle.getInfo().getState() == 1) {
            throw new IllegalStateException("The bundle is uninstalled.");
        }
        GetEntryPathsEnumeration enumeration = new GetEntryPathsEnumeration(bundle, path);
        return !enumeration.hasMoreElements() ? null : enumeration;
    }

    public Enumeration findBundleEntries(BundleImpl bundle, String path, String filePattern, boolean recurse) {
        this.resolveBundles(new Bundle[]{bundle});
        FindEntriesEnumeration enumeration = new FindEntriesEnumeration(bundle, path, filePattern, recurse);
        return !enumeration.hasMoreElements() ? null : enumeration;
    }

    protected ServiceReference[] getBundleRegisteredServices(BundleImpl bundle) {
        if (bundle.getInfo().getState() == 1) {
            throw new IllegalStateException("The bundle is uninstalled.");
        }
        ServiceReference[] refs = this.m_registry.getRegisteredServices(bundle);
        return refs;
    }

    protected ServiceReference[] getBundleServicesInUse(Bundle bundle) {
        ServiceReference[] refs = this.m_registry.getServicesInUse(bundle);
        return refs;
    }

    protected boolean bundleHasPermission(BundleImpl bundle, Object obj) {
        if (bundle.getInfo().getState() == 1) {
            throw new IllegalStateException("The bundle is uninstalled.");
        }
        if (System.getSecurityManager() != null) {
            try {
                return obj instanceof Permission ? ((ProtectionDomain)bundle.getInfo().getCurrentModule().getSecurityContext()).implies((Permission)obj) : false;
            }
            catch (Exception ex) {
                this.m_logger.log(2, "Exception while evaluating the permission.", ex);
                return false;
            }
        }
        return true;
    }

    protected Class loadBundleClass(BundleImpl bundle, String name) throws ClassNotFoundException {
        Class clazz = bundle.getInfo().getCurrentModule().getClass(name);
        if (clazz == null) {
            ClassNotFoundException ex = new ClassNotFoundException(name);
            this.fireFrameworkEvent(2, bundle, new BundleException(ex.getMessage()));
            throw ex;
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startBundle(BundleImpl bundle, boolean record) throws BundleException {
        this.acquireBundleLock(bundle);
        try {
            this._startBundle(bundle, record);
        }
        finally {
            this.releaseBundleLock(bundle);
        }
    }

    private void _startBundle(BundleImpl bundle, boolean record) throws BundleException {
        BundleInfo info;
        if (record) {
            bundle.getInfo().setPersistentStateActive();
        }
        if ((info = bundle.getInfo()).getPersistentState() != 32 || info.getStartLevel(this.getInitialBundleStartLevel()) > this.getStartLevel()) {
            return;
        }
        switch (info.getState()) {
            case 1: {
                throw new IllegalStateException("Cannot start an uninstalled bundle.");
            }
            case 8: 
            case 16: {
                throw new BundleException("Starting a bundle that is starting or stopping is currently not supported.");
            }
            case 32: {
                return;
            }
            case 2: {
                this._resolveBundle(bundle);
            }
            case 4: {
                info.setState(8);
                this.fireBundleEvent(128, bundle);
            }
        }
        try {
            info.setContext(new BundleContextImpl(this, bundle));
            info.setActivator(this.createBundleActivator(bundle.getInfo()));
            if (bundle.getInfo().getActivator() != null) {
                this.m_secureAction.startActivator(info.getActivator(), info.getContext());
            }
            info.setState(32);
            this.fireBundleEvent(2, bundle);
        }
        catch (Throwable th2) {
            Exception th2;
            info.setState(4);
            ((BundleContextImpl)info.getContext()).invalidate();
            info.setContext(null);
            this.m_registry.unregisterServices(bundle);
            this.m_registry.ungetServices(bundle);
            this.m_dispatcher.removeListeners(bundle);
            if (th2 instanceof BundleException) {
                throw (BundleException)th2;
            }
            if (th2 instanceof SecurityException) {
                throw (SecurityException)th2;
            }
            if (System.getSecurityManager() != null && th2 instanceof PrivilegedActionException) {
                th2 = ((PrivilegedActionException)th2).getException();
            }
            throw new BundleException("Activator start error.", th2);
        }
    }

    protected void _resolveBundle(BundleImpl bundle) throws BundleException {
        if (System.getSecurityManager() != null) {
            ProtectionDomain pd = (ProtectionDomain)bundle.getInfo().getCurrentModule().getSecurityContext();
            R4Import[] imports = bundle.getInfo().getCurrentModule().getDefinition().getImports();
            for (int i = 0; i < imports.length; ++i) {
                PackagePermission perm = new PackagePermission(imports[i].getName(), "import");
                if (pd.implies(perm)) continue;
                throw new AccessControlException("PackagePermission.IMPORT denied for import: " + imports[i].getName(), perm);
            }
            R4Export[] implicitImports = bundle.getInfo().getCurrentModule().getDefinition().getExports();
            for (int i = 0; i < implicitImports.length; ++i) {
                PackagePermission perm = new PackagePermission(implicitImports[i].getName(), "export");
                if (pd.implies(perm)) continue;
                throw new AccessControlException("PackagePermission.EXPORT denied for implicit export: " + implicitImports[i].getName(), perm);
            }
        }
        IModule module = bundle.getInfo().getCurrentModule();
        try {
            this.m_policyCore.resolve(module);
        }
        catch (ResolveException ex) {
            if (ex.getModule() != null) {
                throw new BundleException("Unresolved package in bundle " + Util.getBundleIdFromModuleId(ex.getModule().getId()) + ": " + ex.getPackage());
            }
            throw new BundleException(ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateBundle(BundleImpl bundle, InputStream is) throws BundleException {
        this.acquireBundleLock(bundle);
        try {
            this._updateBundle(bundle, is);
        }
        finally {
            this.releaseBundleLock(bundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _updateBundle(BundleImpl bundle, InputStream is) throws BundleException {
        try {
            Exception rethrow = null;
            BundleInfo info = bundle.getInfo();
            if (info.getState() == 1) {
                throw new IllegalStateException("The bundle is uninstalled.");
            }
            String updateLocation = (String)info.getCurrentHeader().get("Bundle-UpdateLocation");
            if (updateLocation == null) {
                updateLocation = info.getLocation();
            }
            this.stopBundle(bundle, false);
            try {
                BundleArchive archive = this.m_cache.getArchive(info.getBundleId());
                archive.revise(updateLocation, is);
                try {
                    IModule module = this.createModule(info.getBundleId(), archive.getRevisionCount() - 1, info.getCurrentHeader());
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        sm.checkPermission(new AdminPermission(bundle, "lifecycle"));
                    }
                    info.addModule(module);
                }
                catch (Exception ex) {
                    try {
                        archive.undoRevise();
                    }
                    catch (Exception busted) {
                        this.m_logger.log(1, "Unable to rollback.", busted);
                    }
                    throw ex;
                }
            }
            catch (Exception ex) {
                this.m_logger.log(1, "Unable to update the bundle.", ex);
                rethrow = ex;
            }
            if (rethrow == null) {
                info.setLastModified(System.currentTimeMillis());
                info.setState(2);
                this.fireBundleEvent(64, bundle);
                ((ModuleImpl)info.getModules()[info.getModules().length - 2]).setRemovalPending(true);
                this.fireBundleEvent(8, bundle);
            }
            this.startBundle(bundle, false);
            if (rethrow != null) {
                if (System.getSecurityManager() != null && rethrow instanceof SecurityException) {
                    throw (SecurityException)rethrow;
                }
                throw new BundleException("Update failed.", rethrow);
            }
            Object var10_12 = null;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {
                this.m_logger.log(1, "Unable to close input stream.", ex);
            }
            throw throwable;
        }
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException ex) {
            this.m_logger.log(1, "Unable to close input stream.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopBundle(BundleImpl bundle, boolean record) throws BundleException {
        this.acquireBundleLock(bundle);
        try {
            this._stopBundle(bundle, record);
        }
        finally {
            this.releaseBundleLock(bundle);
        }
    }

    private void _stopBundle(BundleImpl bundle, boolean record) throws BundleException {
        Throwable rethrow = null;
        if (record) {
            bundle.getInfo().setPersistentStateInactive();
        }
        BundleInfo info = bundle.getInfo();
        switch (info.getState()) {
            case 1: {
                throw new IllegalStateException("Cannot stop an uninstalled bundle.");
            }
            case 8: 
            case 16: {
                throw new BundleException("Stopping a bundle that is starting or stopping is currently not supported.");
            }
            case 2: 
            case 4: {
                return;
            }
            case 32: {
                info.setState(16);
                this.fireBundleEvent(256, bundle);
            }
        }
        try {
            String strict;
            boolean isStrict;
            if (bundle.getInfo().getActivator() != null) {
                this.m_secureAction.stopActivator(info.getActivator(), info.getContext());
            }
            boolean bl = isStrict = (strict = this.m_config.get("felix.strict.osgi")) == null ? true : strict.equals("true");
            if (!isStrict) {
                try {
                    this.m_cache.getArchive(info.getBundleId()).setActivator(info.getActivator());
                }
                catch (Exception ex) {}
            }
        }
        catch (Throwable th) {
            this.m_logger.log(1, "Error stopping bundle.", th);
            rethrow = th;
        }
        ((BundleContextImpl)info.getContext()).invalidate();
        info.setContext(null);
        this.m_registry.unregisterServices(bundle);
        this.m_registry.ungetServices(bundle);
        this.m_dispatcher.removeListeners(bundle);
        info.setState(4);
        this.fireBundleEvent(4, bundle);
        if (rethrow != null) {
            if (rethrow instanceof BundleException) {
                throw (BundleException)rethrow;
            }
            if (rethrow instanceof SecurityException) {
                throw (SecurityException)rethrow;
            }
            if (System.getSecurityManager() != null && rethrow instanceof PrivilegedActionException) {
                rethrow = ((PrivilegedActionException)rethrow).getException();
            }
            throw new BundleException("Activator stop error.", rethrow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uninstallBundle(BundleImpl bundle) throws BundleException {
        this.acquireBundleLock(bundle);
        try {
            this._uninstallBundle(bundle);
        }
        finally {
            this.releaseBundleLock(bundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _uninstallBundle(BundleImpl bundle) throws BundleException {
        BundleInfo info = bundle.getInfo();
        if (info.getState() == 1) {
            throw new IllegalStateException("The bundle is uninstalled.");
        }
        try {
            this.stopBundle(bundle, true);
        }
        catch (BundleException ex) {
            this.fireFrameworkEvent(2, bundle, ex);
        }
        BundleImpl target = null;
        Object[] objectArray = this.m_installedBundleLock_Priority2;
        synchronized (this.m_installedBundleLock_Priority2) {
            target = (BundleImpl)this.m_installedBundleMap.remove(info.getLocation());
            // ** MonitorExit[var4_5] (shouldn't be in output)
            if (target != null) {
                target.getInfo().setPersistentStateUninstalled();
                ((ModuleImpl)target.getInfo().getCurrentModule()).setRemovalPending(true);
                this.rememberUninstalledBundle(bundle);
            } else {
                this.m_logger.log(1, "Unable to remove bundle from installed map!");
            }
            info.setState(1);
            info.setLastModified(System.currentTimeMillis());
            this.fireBundleEvent(16, bundle);
            return;
        }
    }

    protected String getProperty(String key) {
        String val = this.m_config.get(key);
        return val == null ? System.getProperty(key) : val;
    }

    protected Bundle installBundle(String location, InputStream is) throws BundleException {
        return this.installBundle(-1L, location, is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Bundle installBundle(long id, String location, InputStream is) throws BundleException {
        bundle = null;
        this.acquireInstallLock(location);
        try {
            if (this.getStatus() == 2) throw new BundleException("The framework has been shutdown.");
            if (this.getStatus() == -1) {
                throw new BundleException("The framework has been shutdown.");
            }
            bundle = (BundleImpl)this.getBundle(location);
            if (bundle != null) {
                var6_5 = bundle;
                var13_7 = null;
                this.releaseInstallLock(location);
                try {
                    if (is == null) return var6_5;
                    is.close();
                    return var6_5;
                }
                catch (IOException ex) {
                    this.m_logger.log(1, "Unable to close input stream.", ex);
                }
                return var6_5;
            }
            v0 = isNew = id < 0L;
            if (isNew) {
                id = this.getNextId();
                try {
                    try {
                        this.m_cache.create(id, location, is);
                    }
                    catch (Exception ex) {
                        throw new BundleException("Unable to cache bundle: " + location, ex);
                    }
                    var9_13 = null;
                    try {
                        if (is == null) ** GOTO lbl54
                        is.close();
                    }
                    catch (IOException ex) {
                        this.m_logger.log(1, "Unable to close input stream.", ex);
                    }
                }
                catch (Throwable var8_21) {
                    var9_14 = null;
                    ** try [egrp 3[TRYBLOCK] [3 : 143->156)] { 
lbl42:
                    // 1 sources

                    if (is == null) throw var8_21;
                    is.close();
                    throw var8_21;
lbl45:
                    // 1 sources

                    catch (IOException ex) {
                        this.m_logger.log(1, "Unable to close input stream.", ex);
                    }
                    throw var8_21;
                }
            } else {
                try {
                    if (this.m_cache.getArchive(id).getRevisionCount() > 1) {
                        this.m_cache.getArchive(id).purge();
                    }
                }
                catch (Exception ex) {
                    this.m_logger.log(1, "Could not purge bundle.", ex);
                }
            }
lbl54:
            // 5 sources

            try {
                archive = this.m_cache.getArchive(id);
                bundle = new BundleImpl(this, this.createBundleInfo(archive));
                sm = System.getSecurityManager();
                if (sm != null) {
                    sm.checkPermission(new AdminPermission(bundle, "lifecycle"));
                }
            }
            catch (Exception ex) {
                if (isNew) {
                    try {
                        this.m_cache.remove(this.m_cache.getArchive(id));
                    }
                    catch (Exception ex1) {
                        this.m_logger.log(1, "Could not remove from cache.", ex1);
                    }
                }
                if (System.getSecurityManager() == null) throw new BundleException("Could not create bundle object.", ex);
                if (ex instanceof SecurityException == false) throw new BundleException("Could not create bundle object.", ex);
                throw (SecurityException)ex;
            }
            if (isNew) {
                bundle.getInfo().setStartLevel(this.getInitialBundleStartLevel());
                bundle.getInfo().setLastModified(System.currentTimeMillis());
            }
            var7_19 = this.m_installedBundleLock_Priority2;
            synchronized (this.m_installedBundleLock_Priority2) {
                this.m_installedBundleMap.put(location, bundle);
                // ** MonitorExit[var7_19] (shouldn't be in output)
                var13_8 = null;
                this.releaseInstallLock(location);
                ** try [egrp 8[TRYBLOCK] [12 : 431->444)] { 
lbl83:
                // 1 sources

                if (is != null) {
                    is.close();
                }
                ** break block30
lbl87:
                // 1 sources

                catch (IOException ex) {
                    this.m_logger.log(1, "Unable to close input stream.", ex);
                }
            }
        }
        catch (Throwable var12_24) {
            var13_9 = null;
            this.releaseInstallLock(location);
            ** try [egrp 8[TRYBLOCK] [12 : 431->444)] { 
lbl95:
            // 1 sources

            if (is == null) throw var12_24;
            is.close();
            throw var12_24;
lbl98:
            // 1 sources

            catch (IOException ex) {
                this.m_logger.log(1, "Unable to close input stream.", ex);
            }
            throw var12_24;
        }
lbl-1000:
        // 3 sources

        {
            this.fireBundleEvent(1, bundle);
            return bundle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Bundle getBundle(String location) {
        Object[] objectArray = this.m_installedBundleLock_Priority2;
        synchronized (this.m_installedBundleLock_Priority2) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return (Bundle)this.m_installedBundleMap.get(location);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Bundle getBundle(long id) {
        Object[] objectArray = this.m_installedBundleLock_Priority2;
        synchronized (this.m_installedBundleLock_Priority2) {
            BundleImpl bundle = null;
            Iterator i = this.m_installedBundleMap.values().iterator();
            while (i.hasNext()) {
                bundle = (BundleImpl)i.next();
                if (bundle.getInfo().getBundleId() != id) continue;
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return bundle;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            objectArray = this.m_uninstalledBundlesLock_Priority3;
            synchronized (this.m_uninstalledBundlesLock_Priority3) {
                for (int i2 = 0; this.m_uninstalledBundles != null && i2 < this.m_uninstalledBundles.length; ++i2) {
                    if (this.m_uninstalledBundles[i2].getInfo().getBundleId() != id) continue;
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return this.m_uninstalledBundles[i2];
                }
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Bundle[] getBundles() {
        if (this.m_comparator == null) {
            this.m_comparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    Bundle b1 = (Bundle)o1;
                    Bundle b2 = (Bundle)o2;
                    if (b1.getBundleId() > b2.getBundleId()) {
                        return 1;
                    }
                    if (b1.getBundleId() < b2.getBundleId()) {
                        return -1;
                    }
                    return 0;
                }
            };
        }
        Bundle[] bundles = null;
        Object[] objectArray = this.m_installedBundleLock_Priority2;
        synchronized (this.m_installedBundleLock_Priority2) {
            if (this.m_installedBundleMap.size() == 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            bundles = new Bundle[this.m_installedBundleMap.size()];
            int counter = 0;
            Iterator i = this.m_installedBundleMap.values().iterator();
            while (i.hasNext()) {
                bundles[counter++] = (Bundle)i.next();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            Arrays.sort(bundles, this.m_comparator);
            return bundles;
        }
    }

    protected void addBundleListener(Bundle bundle, BundleListener l) {
        this.m_dispatcher.addListener(bundle, BundleListener.class, l, null);
    }

    protected void removeBundleListener(Bundle bundle, BundleListener l) {
        this.m_dispatcher.removeListener(bundle, BundleListener.class, l);
    }

    protected void addServiceListener(Bundle bundle, ServiceListener l, String f) throws InvalidSyntaxException {
        this.m_dispatcher.addListener(bundle, ServiceListener.class, l, f == null ? null : new FilterImpl(this.m_logger, f));
    }

    protected void removeServiceListener(Bundle bundle, ServiceListener l) {
        this.m_dispatcher.removeListener(bundle, ServiceListener.class, l);
    }

    protected void addFrameworkListener(Bundle bundle, FrameworkListener l) {
        this.m_dispatcher.addListener(bundle, FrameworkListener.class, l, null);
    }

    protected void removeFrameworkListener(Bundle bundle, FrameworkListener l) {
        this.m_dispatcher.removeListener(bundle, FrameworkListener.class, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServiceRegistration registerService(BundleImpl bundle, String[] classNames, Object svcObj, Dictionary dict) {
        if (classNames == null) {
            throw new NullPointerException("Service class names cannot be null.");
        }
        if (svcObj == null) {
            throw new IllegalArgumentException("Service object cannot be null.");
        }
        this.acquireBundleLock(bundle);
        ServiceRegistration reg = null;
        try {
            BundleInfo info = bundle.getInfo();
            if ((info.getState() & 0x28) == 0) {
                throw new IllegalStateException("Can only register services while bundle is active or activating.");
            }
            if (!(svcObj instanceof ServiceFactory)) {
                for (int i = 0; i < classNames.length; ++i) {
                    Class clazz = Util.loadClassUsingClass(svcObj.getClass(), classNames[i]);
                    if (clazz == null) {
                        throw new IllegalArgumentException("Cannot cast service: " + classNames[i]);
                    }
                    if (clazz.isAssignableFrom(svcObj.getClass())) continue;
                    throw new IllegalArgumentException("Service object is not an instance of \"" + classNames[i] + "\".");
                }
            }
            reg = this.m_registry.registerService(bundle, classNames, svcObj, dict);
        }
        finally {
            this.releaseBundleLock(bundle);
        }
        return reg;
    }

    protected ServiceReference[] getServiceReferences(BundleImpl bundle, String className, String expr) throws InvalidSyntaxException {
        FilterImpl filter = null;
        if (expr != null) {
            filter = new FilterImpl(this.m_logger, expr);
        }
        List refList = this.m_registry.getServiceReferences(className, filter);
        for (int refIdx = 0; refList != null && refIdx < refList.size(); ++refIdx) {
            ServiceReference ref = (ServiceReference)refList.get(refIdx);
            if (Felix.isServiceAssignable(bundle, ref)) continue;
            refList.remove(refIdx);
            --refIdx;
        }
        if (refList.size() > 0) {
            return refList.toArray(new ServiceReference[refList.size()]);
        }
        return null;
    }

    public static boolean isServiceAssignable(Bundle requester, ServiceReference ref) {
        boolean allow = true;
        String[] objectClass = (String[])ref.getProperty("objectClass");
        for (int classIdx = 0; allow && classIdx < objectClass.length; ++classIdx) {
            if (ref.isAssignableTo(requester, objectClass[classIdx])) continue;
            allow = false;
        }
        return allow;
    }

    protected Object getService(Bundle bundle, ServiceReference ref) {
        String[] objectClass = (String[])ref.getProperty("objectClass");
        if (objectClass == null) {
            return null;
        }
        return this.m_registry.getService(bundle, ref);
    }

    protected boolean ungetService(Bundle bundle, ServiceReference ref) {
        return this.m_registry.ungetService(bundle, ref);
    }

    protected File getDataFile(BundleImpl bundle, String s) {
        if (bundle.getInfo().getState() != 32 && bundle.getInfo().getState() != 8 && bundle.getInfo().getState() != 16) {
            throw new IllegalStateException("Only active bundles can create files.");
        }
        try {
            return this.m_cache.getArchive(bundle.getInfo().getBundleId()).getDataFile(s);
        }
        catch (Exception ex) {
            this.m_logger.log(1, ex.getMessage());
            return null;
        }
    }

    protected Bundle getBundle(Class clazz) {
        if (clazz.getClassLoader() instanceof ContentClassLoader) {
            IContentLoader contentLoader = ((ContentClassLoader)clazz.getClassLoader()).getContentLoader();
            IModule[] modules = this.m_factory.getModules();
            for (int i = 0; i < modules.length; ++i) {
                if (modules[i].getContentLoader() != contentLoader) continue;
                long id = Util.getBundleIdFromModuleId(modules[i].getId());
                return this.getBundle(id);
            }
        }
        return null;
    }

    protected ExportedPackage[] getExportedPackages(String name) {
        ExportedPackage[] pkgs = null;
        IModule[] exporters = this.m_policyCore.getInUseExporters(new R4Import(name, null, null), true);
        if (exporters != null) {
            pkgs = new ExportedPackage[exporters.length];
            for (int pkgIdx = 0; pkgIdx < pkgs.length; ++pkgIdx) {
                BundleImpl bundle = (BundleImpl)this.getBundle(Util.getBundleIdFromModuleId(exporters[pkgIdx].getId()));
                IModule[] modules = bundle.getInfo().getModules();
                for (int modIdx = 0; modIdx < modules.length; ++modIdx) {
                    R4Export export = Util.getExportPackage(modules[modIdx], name);
                    if (export == null) continue;
                    pkgs[pkgIdx] = new ExportedPackageImpl(this, bundle, modules[modIdx], export);
                }
            }
        }
        return pkgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ExportedPackage[] getExportedPackages(Bundle b) {
        ArrayList list = new ArrayList();
        if (b != null) {
            BundleImpl bundle = (BundleImpl)b;
            this.getExportedPackages(bundle, list);
            return list.toArray(new ExportedPackage[list.size()]);
        }
        Object[] objectArray = this.m_installedBundleLock_Priority2;
        synchronized (this.m_installedBundleLock_Priority2) {
            Object[] objectArray2 = this.m_uninstalledBundlesLock_Priority3;
            synchronized (this.m_uninstalledBundlesLock_Priority3) {
                BundleImpl bundle;
                int bundleIdx;
                for (bundleIdx = 0; this.m_uninstalledBundles != null && bundleIdx < this.m_uninstalledBundles.length; ++bundleIdx) {
                    bundle = this.m_uninstalledBundles[bundleIdx];
                    this.getExportedPackages(bundle, list);
                }
                // ** MonitorExit[var4_5] (shouldn't be in output)
                Bundle[] bundles = this.getBundles();
                for (bundleIdx = 0; bundleIdx < bundles.length; ++bundleIdx) {
                    bundle = (BundleImpl)bundles[bundleIdx];
                    this.getExportedPackages(bundle, list);
                }
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return list.toArray(new ExportedPackage[list.size()]);
            }
        }
    }

    private void getExportedPackages(BundleImpl bundle, List list) {
        IModule[] modules = bundle.getInfo().getModules();
        for (int modIdx = 0; modIdx < modules.length; ++modIdx) {
            R4Export[] exports = modules[modIdx].getDefinition().getExports();
            if (exports == null || exports.length <= 0) continue;
            for (int expIdx = 0; expIdx < exports.length; ++expIdx) {
                IModule[] inUseModules = this.m_policyCore.getInUseExporters(new R4Import(exports[expIdx].getName(), null, null), true);
                for (int i = 0; inUseModules != null && i < inUseModules.length; ++i) {
                    if (inUseModules[i] != modules[modIdx]) continue;
                    list.add(new ExportedPackageImpl(this, bundle, modules[modIdx], exports[expIdx]));
                }
            }
        }
    }

    protected Bundle[] getImportingBundles(ExportedPackage ep) {
        BundleImpl exporter = (BundleImpl)ep.getExportingBundle();
        BundleInfo exporterInfo = exporter.getInfo();
        ArrayList<Bundle> list = new ArrayList<Bundle>();
        Bundle[] bundles = this.getBundles();
        block0: for (int bundleIdx = 0; bundleIdx < bundles.length; ++bundleIdx) {
            BundleImpl importer = (BundleImpl)bundles[bundleIdx];
            IModule[] modules = importer.getInfo().getModules();
            for (int modIdx = 0; modIdx < modules.length; ++modIdx) {
                IWire wire = Util.getWire(modules[modIdx], ep.getName());
                if (wire == null || !exporterInfo.hasModule(wire.getExporter())) continue;
                list.add(bundles[bundleIdx]);
                continue block0;
            }
        }
        if (list.size() > 0) {
            return list.toArray(new Bundle[list.size()]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean resolveBundles(Bundle[] targets) {
        BundleImpl[] bundles = this.acquireBundleResolveLocks(targets);
        try {
            boolean result = true;
            if (bundles != null) {
                for (int i = 0; i < bundles.length; ++i) {
                    try {
                        this._resolveBundle(bundles[i]);
                        continue;
                    }
                    catch (BundleException ex) {
                        result = false;
                        this.m_logger.log(2, "Unable to resolve bundle " + bundles[i].getBundleId(), ex);
                    }
                }
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.releaseBundleLocks(bundles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshPackages(Bundle[] targets) {
        BundleImpl[] bundles = this.acquireBundleRefreshLocks(targets);
        for (int i = 0; bundles != null && i < bundles.length; ++i) {
            this.forgetUninstalledBundle(bundles[i]);
        }
        try {
            if (bundles != null) {
                int i;
                RefreshHelper[] helpers = new RefreshHelper[bundles.length];
                for (i = 0; i < bundles.length; ++i) {
                    helpers[i] = new RefreshHelper(bundles[i]);
                }
                for (i = 0; i < helpers.length; ++i) {
                    helpers[i].stop();
                    helpers[i].purgeOrRemove();
                    helpers[i].reinitialize();
                }
                for (i = 0; i < helpers.length; ++i) {
                    helpers[i].restart();
                }
            }
        }
        finally {
            this.releaseBundleLocks(bundles);
        }
        this.fireFrameworkEvent(4, this.getBundle(0L), null);
    }

    private void populateImportGraph(BundleImpl target, Map map) {
        ExportedPackage[] pkgs = this.getExportedPackages(target);
        for (int pkgIdx = 0; pkgs != null && pkgIdx < pkgs.length; ++pkgIdx) {
            Bundle[] importers = this.getImportingBundles(pkgs[pkgIdx]);
            for (int impIdx = 0; importers != null && impIdx < importers.length; ++impIdx) {
                if (map.containsKey(importers[impIdx])) continue;
                map.put(importers[impIdx], importers[impIdx]);
                this.populateImportGraph((BundleImpl)importers[impIdx], map);
            }
        }
    }

    private BundleInfo createBundleInfo(BundleArchive archive) throws Exception {
        Map headerMap = null;
        try {
            headerMap = archive.getRevision(archive.getRevisionCount() - 1).getManifestHeader();
        }
        catch (Exception ex) {
            throw new BundleException("Unable to read JAR manifest.", ex);
        }
        if (headerMap == null) {
            throw new BundleException("Unable to read JAR manifest header.");
        }
        IModule module = this.createModule(archive.getId(), archive.getRevisionCount() - 1, headerMap);
        return new BundleInfo(this.m_logger, archive, module);
    }

    private IModule createModule(long targetId, int revision, Map headerMap) throws Exception {
        ManifestParser mp = new ManifestParser(this.m_logger, this.m_config, headerMap);
        if (mp.getManifestVersion().equals("2")) {
            Version bundleVersion = mp.getBundleVersion();
            bundleVersion = bundleVersion == null ? Version.emptyVersion : bundleVersion;
            String symName = mp.getSymbolicName();
            Bundle[] bundles = this.getBundles();
            for (int i = 0; bundles != null && i < bundles.length; ++i) {
                long id = ((BundleImpl)bundles[i]).getInfo().getBundleId();
                String sym = (String)((BundleImpl)bundles[i]).getInfo().getCurrentHeader().get("Bundle-SymbolicName");
                Version ver = Version.parseVersion((String)((BundleImpl)bundles[i]).getInfo().getCurrentHeader().get("Bundle-Version"));
                if (!symName.equals(sym) || !bundleVersion.equals(ver) || targetId == id) continue;
                throw new BundleException("Bundle symbolic name and version are not unique.");
            }
        }
        ModuleDefinition md = new ModuleDefinition(mp.getExports(), mp.getImports(), mp.getDynamicImports(), mp.getLibraries(this.m_cache.getArchive(targetId).getRevision(revision)));
        IModule module = this.m_factory.createModule(Long.toString(targetId) + "." + Integer.toString(revision), md);
        if (System.getSecurityManager() != null) {
            CodeSource codesource = new CodeSource(this.m_secureAction.createURL(null, this.m_cache.getArchive(targetId).getLocation(), new FakeURLStreamHandler()), this.m_cache.getArchive(targetId).getCertificates());
            this.m_factory.setSecurityContext(module, new ProtectionDomain(codesource, this.m_secureAction.getPolicy().getPermissions(codesource)));
        }
        ContentLoaderImpl contentLoader = new ContentLoaderImpl(this.m_logger, this.m_cache.getArchive(targetId).getRevision(revision).getContent(), this.m_cache.getArchive(targetId).getRevision(revision).getContentPath(), (ProtectionDomain)module.getSecurityContext());
        contentLoader.setSearchPolicy(new R4SearchPolicy(this.m_policyCore, module));
        contentLoader.setURLPolicy(new URLPolicyImpl(this.m_logger, this.m_bundleStreamHandler, module));
        this.m_factory.setContentLoader(module, contentLoader);
        return module;
    }

    private BundleActivator createBundleActivator(BundleInfo info) throws Exception {
        BundleArchive ba;
        Map headerMap;
        String className;
        boolean isStrict;
        BundleActivator activator = null;
        String strict = this.m_config.get("felix.strict.osgi");
        boolean bl = isStrict = strict == null ? true : strict.equals("true");
        if (!isStrict) {
            try {
                activator = this.m_cache.getArchive(info.getBundleId()).getActivator(info.getCurrentModule());
            }
            catch (Exception ex) {
                activator = null;
            }
        }
        if (activator == null && (className = (String)(headerMap = (ba = this.m_cache.getArchive(info.getBundleId())).getRevision(ba.getRevisionCount() - 1).getManifestHeader()).get("Bundle-Activator")) != null) {
            className = className.trim();
            Class clazz = info.getCurrentModule().getClass(className);
            if (clazz == null) {
                throw new BundleException("Not found: " + className, new ClassNotFoundException(className));
            }
            activator = (BundleActivator)clazz.newInstance();
        }
        return activator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeBundle(BundleImpl bundle) throws Exception {
        this.acquireBundleLock(bundle);
        try {
            BundleInfo info = bundle.getInfo();
            IModule[] modules = info.getModules();
            for (int i = 0; i < modules.length; ++i) {
                this.m_factory.removeModule(modules[i]);
            }
            this.m_cache.getArchive(info.getBundleId()).purge();
        }
        finally {
            this.releaseBundleLock(bundle);
        }
    }

    private void garbageCollectBundle(BundleImpl bundle) throws Exception {
        IModule[] modules = bundle.getInfo().getModules();
        for (int i = 0; i < modules.length; ++i) {
            this.m_factory.removeModule(modules[i]);
        }
        this.m_cache.remove(this.m_cache.getArchive(bundle.getInfo().getBundleId()));
    }

    private void fireFrameworkEvent(int type, Bundle bundle, Throwable throwable) {
        this.m_dispatcher.fireFrameworkEvent(new FrameworkEvent(type, bundle, throwable));
    }

    private void fireBundleEvent(int type, Bundle bundle) {
        this.m_dispatcher.fireBundleEvent(new BundleEvent(type, bundle));
    }

    private void fireServiceEvent(ServiceEvent event) {
        this.m_dispatcher.fireServiceEvent(event);
    }

    private void initializeFrameworkProperties() {
        this.m_configMutable.put("org.osgi.framework.version", "1.3");
        this.m_configMutable.put("org.osgi.framework.vendor", "Apache Software Foundation");
        this.m_configMutable.put("org.osgi.framework.language", System.getProperty("user.language"));
        this.m_configMutable.put("org.osgi.framework.os.version", System.getProperty("os.version"));
        String s = null;
        s = R4LibraryClause.normalizeOSName(System.getProperty("os.name"));
        this.m_configMutable.put("org.osgi.framework.os.name", s);
        s = R4LibraryClause.normalizeProcessor(System.getProperty("os.arch"));
        this.m_configMutable.put("org.osgi.framework.processor", s);
        this.m_configMutable.put("felix.version", Felix.getFrameworkVersion());
    }

    private static String getFrameworkVersion() {
        Properties props = new Properties();
        InputStream in = Felix.class.getResourceAsStream("Felix.properties");
        try {
            props.load(in);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        StringBuffer sb = new StringBuffer(props.getProperty("felix.version", "unknown"));
        if (sb.toString().indexOf("-") >= 0) {
            sb.setCharAt(sb.toString().indexOf("-"), '.');
        }
        return sb.toString();
    }

    private void processAutoProperties() {
        BundleImpl b;
        String location;
        StringTokenizer st;
        int startLevel;
        int i;
        String[] keys = this.m_config.getKeys();
        for (i = 0; keys != null && i < keys.length; ++i) {
            if (!keys[i].startsWith("felix.auto.install")) continue;
            startLevel = 1;
            try {
                startLevel = Integer.parseInt(keys[i].substring(keys[i].lastIndexOf(46) + 1));
            }
            catch (NumberFormatException ex) {
                this.m_logger.log(1, "Invalid property: " + keys[i]);
            }
            st = new StringTokenizer(this.m_config.get(keys[i]), "\" ", true);
            if (st.countTokens() <= 0) continue;
            location = null;
            do {
                if ((location = this.nextLocation(st)) == null) continue;
                try {
                    b = (BundleImpl)this.installBundle(location, null);
                    b.getInfo().setStartLevel(startLevel);
                }
                catch (Exception ex) {
                    this.m_logger.log(1, "Auto-properties install.", ex);
                }
            } while (location != null);
        }
        for (i = 0; keys != null && i < keys.length; ++i) {
            if (!keys[i].startsWith("felix.auto.start")) continue;
            startLevel = 1;
            try {
                startLevel = Integer.parseInt(keys[i].substring(keys[i].lastIndexOf(46) + 1));
            }
            catch (NumberFormatException ex) {
                this.m_logger.log(1, "Invalid property: " + keys[i]);
            }
            st = new StringTokenizer(this.m_config.get(keys[i]), "\" ", true);
            if (st.countTokens() <= 0) continue;
            location = null;
            do {
                if ((location = this.nextLocation(st)) == null) continue;
                try {
                    b = (BundleImpl)this.installBundle(location, null);
                    b.getInfo().setStartLevel(startLevel);
                }
                catch (Exception ex) {
                    this.m_logger.log(1, "Auto-properties install.", ex);
                }
            } while (location != null);
        }
        for (i = 0; keys != null && i < keys.length; ++i) {
            StringTokenizer st2;
            if (!keys[i].startsWith("felix.auto.start") || (st2 = new StringTokenizer(this.m_config.get(keys[i]), "\" ", true)).countTokens() <= 0) continue;
            String location2 = null;
            do {
                if ((location2 = this.nextLocation(st2)) == null) continue;
                try {
                    BundleImpl bundle = (BundleImpl)this.installBundle(location2, null);
                    if (bundle == null) continue;
                    this.startBundle(bundle, true);
                }
                catch (Exception ex) {
                    this.m_logger.log(1, "Auto-properties start.", ex);
                }
            } while (location2 != null);
        }
    }

    private String nextLocation(StringTokenizer st) {
        String retVal = null;
        if (st.countTokens() > 0) {
            String tokenList = "\" ";
            StringBuffer tokBuf = new StringBuffer(10);
            String tok = null;
            boolean inQuote = false;
            boolean tokStarted = false;
            boolean exit = false;
            while (st.hasMoreTokens() && !exit) {
                tok = st.nextToken(tokenList);
                if (tok.equals("\"")) {
                    boolean bl = inQuote = !inQuote;
                    if (inQuote) {
                        tokenList = "\"";
                        continue;
                    }
                    tokenList = "\" ";
                    continue;
                }
                if (tok.equals(" ")) {
                    if (!tokStarted) continue;
                    retVal = tokBuf.toString();
                    tokStarted = false;
                    tokBuf = new StringBuffer(10);
                    exit = true;
                    continue;
                }
                tokStarted = true;
                tokBuf.append(tok.trim());
            }
            if (!exit && tokStarted) {
                retVal = tokBuf.toString();
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextId() {
        Object object = this.m_nextIdLock;
        synchronized (object) {
            return this.m_nextId++;
        }
    }

    public PropertyResolver getConfig() {
        return this.m_config;
    }

    public Logger getLogger() {
        return this.m_logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rememberUninstalledBundle(BundleImpl bundle) {
        Object[] objectArray = this.m_uninstalledBundlesLock_Priority3;
        synchronized (this.m_uninstalledBundlesLock_Priority3) {
            for (int i = 0; this.m_uninstalledBundles != null && i < this.m_uninstalledBundles.length; ++i) {
                if (this.m_uninstalledBundles[i] != bundle) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (this.m_uninstalledBundles != null) {
                BundleImpl[] newBundles = new BundleImpl[this.m_uninstalledBundles.length + 1];
                System.arraycopy(this.m_uninstalledBundles, 0, newBundles, 0, this.m_uninstalledBundles.length);
                newBundles[this.m_uninstalledBundles.length] = bundle;
                this.m_uninstalledBundles = newBundles;
            } else {
                this.m_uninstalledBundles = new BundleImpl[]{bundle};
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forgetUninstalledBundle(BundleImpl bundle) {
        Object[] objectArray = this.m_uninstalledBundlesLock_Priority3;
        synchronized (this.m_uninstalledBundlesLock_Priority3) {
            if (this.m_uninstalledBundles == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int idx = -1;
            for (int i = 0; i < this.m_uninstalledBundles.length; ++i) {
                if (this.m_uninstalledBundles[i] != bundle) continue;
                idx = i;
                break;
            }
            if (idx >= 0) {
                if (this.m_uninstalledBundles.length - 1 == 0) {
                    this.m_uninstalledBundles = new BundleImpl[0];
                } else {
                    BundleImpl[] newBundles = new BundleImpl[this.m_uninstalledBundles.length - 1];
                    System.arraycopy(this.m_uninstalledBundles, 0, newBundles, 0, idx);
                    if (idx < newBundles.length) {
                        System.arraycopy(this.m_uninstalledBundles, idx + 1, newBundles, idx, newBundles.length - idx);
                    }
                    this.m_uninstalledBundles = newBundles;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acquireInstallLock(String location) throws BundleException {
        Object[] objectArray = this.m_installRequestLock_Priority1;
        synchronized (this.m_installRequestLock_Priority1) {
            while (this.m_installRequestMap.get(location) != null) {
                try {
                    this.m_installRequestLock_Priority1.wait();
                }
                catch (InterruptedException ex) {
                    throw new BundleException("Unable to install, thread interrupted.");
                }
            }
            this.m_installRequestMap.put(location, location);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseInstallLock(String location) {
        Object[] objectArray = this.m_installRequestLock_Priority1;
        synchronized (this.m_installRequestLock_Priority1) {
            this.m_installRequestMap.remove(location);
            this.m_installRequestLock_Priority1.notifyAll();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acquireBundleLock(BundleImpl bundle) {
        Object[] objectArray = this.m_bundleLock;
        synchronized (this.m_bundleLock) {
            while (!bundle.getInfo().isLockable()) {
                try {
                    this.m_bundleLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            bundle.getInfo().lock();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean acquireBundleLockOrFail(BundleImpl bundle) {
        Object[] objectArray = this.m_bundleLock;
        synchronized (this.m_bundleLock) {
            if (!bundle.getInfo().isLockable()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            bundle.getInfo().lock();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseBundleLock(BundleImpl bundle) {
        Object[] objectArray = this.m_bundleLock;
        synchronized (this.m_bundleLock) {
            bundle.getInfo().unlock();
            this.m_bundleLock.notifyAll();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected BundleImpl[] acquireBundleResolveLocks(Bundle[] targets) {
        BundleImpl[] bundles = null;
        if (targets != null) {
            bundles = new BundleImpl[targets.length];
            for (int i = 0; i < targets.length; ++i) {
                bundles[i] = (BundleImpl)targets[i];
            }
        }
        Object[] objectArray = this.m_bundleLock;
        // MONITORENTER : this.m_bundleLock
        boolean success = false;
        while (true) {
            if (success) {
                // MONITOREXIT : objectArray
                return bundles;
            }
            if (targets == null) {
                ArrayList<BundleImpl> list = new ArrayList<BundleImpl>();
                Object[] objectArray2 = this.m_installedBundleLock_Priority2;
                // MONITORENTER : this.m_installedBundleLock_Priority2
                Iterator iter = this.m_installedBundleMap.values().iterator();
                while (iter.hasNext()) {
                    BundleImpl bundle = (BundleImpl)iter.next();
                    if (bundle.getInfo().getState() != 2) continue;
                    list.add(bundle);
                }
                // MONITOREXIT : objectArray2
                if (list.size() > 0) {
                    bundles = list.toArray(new BundleImpl[list.size()]);
                }
            }
            boolean lockable = true;
            if (bundles != null) {
                int i;
                for (i = 0; lockable && i < bundles.length; ++i) {
                    lockable = bundles[i].getInfo().isLockable();
                }
                if (lockable) {
                    for (i = 0; i < bundles.length; ++i) {
                        bundles[i].getInfo().lock();
                    }
                    success = true;
                    continue;
                }
                try {
                    this.m_bundleLock.wait();
                }
                catch (InterruptedException ex) {}
                continue;
            }
            success = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected BundleImpl[] acquireBundleRefreshLocks(Bundle[] targets) {
        BundleImpl[] bundles = null;
        Object[] objectArray = this.m_bundleLock;
        // MONITORENTER : this.m_bundleLock
        boolean success = false;
        while (true) {
            if (success) {
                // MONITOREXIT : objectArray
                return bundles;
            }
            Bundle[] newTargets = targets;
            if (newTargets == null) {
                ArrayList<BundleImpl> list = new ArrayList<BundleImpl>();
                Object[] objectArray2 = this.m_uninstalledBundlesLock_Priority3;
                // MONITORENTER : this.m_uninstalledBundlesLock_Priority3
                for (int i = 0; this.m_uninstalledBundles != null && i < this.m_uninstalledBundles.length; ++i) {
                    list.add(this.m_uninstalledBundles[i]);
                }
                // MONITOREXIT : objectArray2
                objectArray2 = this.m_installedBundleLock_Priority2;
                // MONITORENTER : this.m_installedBundleLock_Priority2
                Iterator iter = this.m_installedBundleMap.values().iterator();
                while (iter.hasNext()) {
                    BundleImpl bundle = (BundleImpl)iter.next();
                    if (bundle.getInfo().getArchive().getRevisionCount() <= 1) continue;
                    list.add(bundle);
                }
                // MONITOREXIT : objectArray2
                if (list.size() > 0) {
                    newTargets = list.toArray(new Bundle[list.size()]);
                }
            }
            if (newTargets != null) {
                HashMap<BundleImpl, BundleImpl> map = new HashMap<BundleImpl, BundleImpl>();
                for (int targetIdx = 0; targetIdx < newTargets.length; ++targetIdx) {
                    BundleImpl target = (BundleImpl)newTargets[targetIdx];
                    map.put(target, target);
                    this.populateImportGraph(target, map);
                }
                bundles = map.values().toArray(new BundleImpl[map.size()]);
            }
            boolean lockable = true;
            if (bundles != null) {
                int i;
                for (i = 0; lockable && i < bundles.length; ++i) {
                    lockable = bundles[i].getInfo().isLockable();
                }
                if (lockable) {
                    for (i = 0; i < bundles.length; ++i) {
                        bundles[i].getInfo().lock();
                    }
                    success = true;
                    continue;
                }
                try {
                    this.m_bundleLock.wait();
                }
                catch (InterruptedException ex) {}
                continue;
            }
            success = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseBundleLocks(BundleImpl[] bundles) {
        Object[] objectArray = this.m_bundleLock;
        synchronized (this.m_bundleLock) {
            for (int i = 0; bundles != null && i < bundles.length; ++i) {
                bundles[i].getInfo().unlock();
            }
            this.m_bundleLock.notifyAll();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private class RefreshHelper {
        private BundleImpl m_bundle = null;

        public RefreshHelper(Bundle bundle) {
            this.m_bundle = (BundleImpl)bundle;
        }

        public void stop() {
            if (this.m_bundle.getInfo().getState() == 32) {
                try {
                    Felix.this.stopBundle(this.m_bundle, false);
                }
                catch (BundleException ex) {
                    Felix.this.fireFrameworkEvent(2, this.m_bundle, ex);
                }
            }
        }

        public void purgeOrRemove() {
            try {
                BundleInfo info = this.m_bundle.getInfo();
                info.setStale();
                if (info.getState() == 1) {
                    Felix.this.garbageCollectBundle(this.m_bundle);
                    this.m_bundle = null;
                } else {
                    Felix.this.purgeBundle(this.m_bundle);
                }
            }
            catch (Exception ex) {
                Felix.this.fireFrameworkEvent(2, this.m_bundle, ex);
            }
        }

        public void reinitialize() {
            if (this.m_bundle != null) {
                try {
                    BundleInfo info = this.m_bundle.getInfo();
                    BundleInfo newInfo = Felix.this.createBundleInfo(info.getArchive());
                    newInfo.syncLock(info);
                    this.m_bundle.setInfo(newInfo);
                    Felix.this.fireBundleEvent(64, this.m_bundle);
                }
                catch (Exception ex) {
                    Felix.this.fireFrameworkEvent(2, this.m_bundle, ex);
                }
            }
        }

        public void restart() {
            if (this.m_bundle != null) {
                try {
                    Felix.this.startBundle(this.m_bundle, false);
                }
                catch (BundleException ex) {
                    Felix.this.fireFrameworkEvent(2, this.m_bundle, ex);
                }
            }
        }
    }

    private class ConfigImpl
    implements PropertyResolver {
        private ConfigImpl() {
        }

        public String get(String key) {
            return Felix.this.m_configMutable == null ? null : Felix.this.m_configMutable.get(key);
        }

        public String[] getKeys() {
            return Felix.this.m_configMutable.getKeys();
        }
    }
}

