/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.apache.felix.framework.BundleImpl;

class FindEntriesEnumeration
implements Enumeration {
    private BundleImpl m_bundle = null;
    private Enumeration m_enumeration = null;
    private String m_path = null;
    private String[] m_filePattern = null;
    private boolean m_recurse = false;
    private Object m_next = null;

    public FindEntriesEnumeration(BundleImpl bundle, String path, String filePattern, boolean recurse) {
        this.m_bundle = bundle;
        this.m_path = path;
        this.m_enumeration = this.m_bundle.getInfo().getCurrentModule().getContentLoader().getContent() == null ? null : this.m_bundle.getInfo().getCurrentModule().getContentLoader().getContent().getEntries();
        this.m_recurse = recurse;
        if (this.m_path == null) {
            throw new IllegalArgumentException("The path for findEntries() cannot be null.");
        }
        if (this.m_path.length() > 0 && this.m_path.charAt(0) == '/') {
            this.m_path = this.m_path.substring(1);
        }
        if (this.m_path.length() > 0 && this.m_path.charAt(this.m_path.length() - 1) != '/') {
            this.m_path = this.m_path + "/";
        }
        filePattern = filePattern == null ? "*" : filePattern;
        this.m_filePattern = FindEntriesEnumeration.parseSubstring(filePattern);
        this.m_next = this.findNext();
    }

    public boolean hasMoreElements() {
        return this.m_next != null;
    }

    public Object nextElement() {
        if (this.m_next == null) {
            throw new NoSuchElementException("No more entry paths.");
        }
        Object last = this.m_next;
        this.m_next = this.findNext();
        return last;
    }

    private Object findNext() {
        while (this.m_enumeration != null && this.m_enumeration.hasMoreElements()) {
            String entryName = (String)this.m_enumeration.nextElement();
            if (entryName.equals(this.m_path) || !entryName.startsWith(this.m_path)) continue;
            int idx = entryName.indexOf(47, this.m_path.length());
            if ((!this.m_recurse || entryName.charAt(entryName.length() - 1) == '/') && idx >= 0) continue;
            idx = entryName.lastIndexOf(47);
            String lastElement = entryName;
            if (idx >= 0) {
                lastElement = entryName.substring(idx + 1);
            }
            if (!FindEntriesEnumeration.checkSubstring(this.m_filePattern, lastElement)) continue;
            return this.m_bundle.getInfo().getCurrentModule().getContentLoader().getResourceFromContent(entryName);
        }
        return null;
    }

    private static String[] parseSubstring(String target) {
        ArrayList<String> pieces = new ArrayList<String>();
        StringBuffer ss = new StringBuffer();
        boolean wasStar = false;
        boolean leftstar = false;
        boolean rightstar = false;
        int idx = 0;
        while (true) {
            char c;
            if (idx >= target.length()) {
                if (wasStar) {
                    rightstar = true;
                    break;
                }
                pieces.add(ss.toString());
                break;
            }
            if ((c = target.charAt(idx++)) == '*') {
                if (wasStar) {
                    throw new IllegalArgumentException("Invalid filter string: " + target);
                }
                if (ss.length() > 0) {
                    pieces.add(ss.toString());
                }
                ss.setLength(0);
                if (pieces.size() == 0) {
                    leftstar = true;
                }
                ss.setLength(0);
                wasStar = true;
                continue;
            }
            wasStar = false;
            ss.append(c);
        }
        ss.setLength(0);
        if (leftstar || rightstar || pieces.size() > 1) {
            if (rightstar) {
                pieces.add("");
            }
            if (leftstar) {
                pieces.add(0, "");
            }
        }
        return pieces.toArray(new String[pieces.size()]);
    }

    private static boolean checkSubstring(String[] pieces, String s) {
        boolean result = false;
        int len = pieces.length;
        int index = 0;
        for (int i = 0; i < len; ++i) {
            String piece = pieces[i];
            if (i == len - 1) {
                if (s.endsWith(piece)) {
                    result = true;
                    break;
                }
                result = false;
                break;
            }
            if (i == 0) {
                if (!s.startsWith(piece)) {
                    result = false;
                    break;
                }
            } else if ((index = s.indexOf(piece, index)) < 0) {
                result = false;
                break;
            }
            index += piece.length();
        }
        return result;
    }
}

