/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public class Logger {
    public static final int LOG_ERROR = 1;
    public static final int LOG_WARNING = 2;
    public static final int LOG_INFO = 3;
    public static final int LOG_DEBUG = 4;
    private Object m_logObj = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(int level, String msg) {
        Logger logger = this;
        synchronized (logger) {
            if (this.m_logObj == null) {
                this._log(null, level, msg, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(int level, String msg, Throwable ex) {
        Logger logger = this;
        synchronized (logger) {
            if (this.m_logObj == null) {
                this._log(null, level, msg, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(ServiceReference sr, int level, String msg) {
        Logger logger = this;
        synchronized (logger) {
            if (this.m_logObj == null) {
                this._log(sr, level, msg, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(ServiceReference sr, int level, String msg, Throwable ex) {
        Logger logger = this;
        synchronized (logger) {
            if (this.m_logObj == null) {
                this._log(sr, level, msg, ex);
            }
        }
    }

    private void _log(ServiceReference sr, int level, String msg, Throwable ex) {
        String s = sr == null ? null : "SvcRef " + sr;
        s = s == null ? msg : s + " " + msg;
        s = ex == null ? s : s + " (" + ex + ")";
        switch (level) {
            case 4: {
                System.out.println("DEBUG: " + s);
                break;
            }
            case 1: {
                System.out.println("ERROR: " + s);
                if (ex == null) break;
                if (ex instanceof BundleException && ((BundleException)ex).getNestedException() != null) {
                    ex = ((BundleException)ex).getNestedException();
                }
                ex.printStackTrace();
                break;
            }
            case 3: {
                System.out.println("INFO: " + s);
                break;
            }
            case 2: {
                System.out.println("WARNING: " + s);
                break;
            }
            default: {
                System.out.println("UNKNOWN[" + level + "]: " + s);
            }
        }
    }
}

