/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.framework.BundleContextImpl;
import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.BundleInfo;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.PackageAdminActivator;
import org.apache.felix.framework.StartLevelActivator;
import org.apache.felix.framework.SystemBundleActivator;
import org.apache.felix.framework.SystemBundleContentLoader;
import org.apache.felix.framework.URLHandlersActivator;
import org.apache.felix.framework.cache.SystemBundleArchive;
import org.apache.felix.framework.searchpolicy.R4Export;
import org.apache.felix.framework.searchpolicy.R4Package;
import org.apache.felix.framework.util.ManifestParser;
import org.apache.felix.framework.util.StringMap;
import org.apache.felix.moduleloader.IContentLoader;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleException;

class SystemBundle
extends BundleImpl {
    private List m_activatorList = null;
    private BundleActivator m_activator = null;
    private Thread m_shutdownThread = null;
    private R4Export[] m_exports = null;
    private IContentLoader m_contentLoader = null;

    protected SystemBundle(Felix felix, BundleInfo info, List activatorList) {
        super(felix, info);
        if (activatorList == null) {
            activatorList = new ArrayList<PackageAdminActivator>();
        }
        activatorList.add(new PackageAdminActivator(felix));
        activatorList.add((PackageAdminActivator)((Object)new StartLevelActivator(felix)));
        activatorList.add((PackageAdminActivator)((Object)new URLHandlersActivator(felix)));
        this.m_activatorList = activatorList;
        R4Package[] classPathPkgs = null;
        try {
            classPathPkgs = ManifestParser.parseImportExportHeader(this.getFelix().getConfig().get("org.osgi.framework.system.packages"));
        }
        catch (Exception ex) {
            classPathPkgs = new R4Package[]{};
            this.getFelix().getLogger().log(1, "Error parsing system bundle export statement: " + this.getFelix().getConfig().get("org.osgi.framework.system.packages"), ex);
        }
        this.m_exports = new R4Export[classPathPkgs.length];
        for (int i = 0; i < classPathPkgs.length; ++i) {
            this.m_exports[i] = new R4Export(classPathPkgs[i]);
        }
        this.m_contentLoader = new SystemBundleContentLoader(this.getFelix().getLogger());
        StringBuffer exportSB = new StringBuffer("");
        for (int i = 0; i < this.m_exports.length; ++i) {
            if (i > 0) {
                exportSB.append(", ");
            }
            exportSB.append(this.m_exports[i].getName());
            exportSB.append("; version=\"");
            exportSB.append(this.m_exports[i].getVersion().toString());
            exportSB.append("\"");
        }
        StringMap map = new StringMap(false);
        map.put("Bundle-Version", this.getFelix().getConfig().get("felix.version"));
        map.put("Bundle-SymbolicName", "system.bundle");
        map.put("Bundle-Name", "System Bundle");
        map.put("Bundle-Description", "This bundle is system specific; it implements various system services.");
        map.put("Export-Package", exportSB.toString());
        map.put("Export-Service", "org.osgi.service.packageadmin.PackageAdmin,org.osgi.service.startlevel.StartLevel");
        ((SystemBundleArchive)this.getInfo().getArchive()).setManifestHeader(map);
    }

    public R4Export[] getExports() {
        return this.m_exports;
    }

    public IContentLoader getContentLoader() {
        return this.m_contentLoader;
    }

    public synchronized void start() throws BundleException {
        if (this.getState() == 32) {
            return;
        }
        this.getInfo().setState(8);
        try {
            this.getInfo().setContext(new BundleContextImpl(this.getFelix(), this));
            this.getActivator().start(this.getInfo().getContext());
        }
        catch (Throwable throwable) {
            throw new BundleException("Unable to start system bundle.", throwable);
        }
    }

    public synchronized void stop() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this, "execute"));
        }
        if (this.getFelix().getStatus() == 0) {
            this.m_shutdownThread = new Thread("FelixShutdown"){

                public void run() {
                    try {
                        SystemBundle.this.getFelix().shutdown();
                    }
                    catch (Exception ex) {
                        SystemBundle.this.getFelix().getLogger().log(1, "SystemBundle: Error while shutting down.", ex);
                    }
                }
            };
            this.getInfo().setState(16);
            this.m_shutdownThread.start();
        }
    }

    public synchronized void uninstall() throws BundleException {
        throw new BundleException("Cannot uninstall the system bundle.");
    }

    public synchronized void update() throws BundleException {
        this.update(null);
    }

    public synchronized void update(InputStream is) throws BundleException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this, "execute"));
        }
        throw new BundleException("System bundle update not implemented yet.");
    }

    protected BundleActivator getActivator() {
        if (this.m_activator == null) {
            this.m_activator = new SystemBundleActivator(this.getFelix(), this.m_activatorList);
        }
        return this.m_activator;
    }

    void shutdown() throws BundleException {
        try {
            this.getActivator().stop(this.getInfo().getContext());
        }
        catch (Throwable throwable) {
            throw new BundleException("Unable to stop system bundle.", throwable);
        }
    }
}

