/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.net.ContentHandler;
import java.net.ContentHandlerFactory;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.URLHandlersBundleStreamHandler;
import org.apache.felix.framework.URLHandlersContentHandlerProxy;
import org.apache.felix.framework.URLHandlersStreamHandlerProxy;
import org.apache.felix.framework.searchpolicy.ContentClassLoader;
import org.apache.felix.framework.util.SecureAction;
import org.apache.felix.framework.util.SecurityManagerEx;
import org.osgi.framework.BundleContext;

class URLHandlers
implements URLStreamHandlerFactory,
ContentHandlerFactory {
    private static final String STREAM_HANDLER_PACKAGE_PROP = "java.protocol.handler.pkgs";
    private static final String CONTENT_HANDLER_PACKAGE_PROP = "java.content.handler.pkgs";
    private static final String DEFAULT_STREAM_HANDLER_PACKAGE = "sun.net.www.protocol";
    private static final String DEFAULT_CONTENT_HANDLER_PACKAGE = "sun.net.www.content";
    private static String m_lock = new String("string-lock");
    private static SecurityManagerEx m_sm = null;
    private static URLHandlers m_handler = null;
    private static int m_frameworkCount = 0;
    private static List m_frameworkList = null;
    private static Map m_streamHandlerCache = null;
    private static Map m_contentHandlerCache = null;
    private static final SecureAction m_secureAction = new SecureAction();

    private URLHandlers() {
        URL.setURLStreamHandlerFactory(this);
        URLConnection.setContentHandlerFactory(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLStreamHandler createURLStreamHandler(String protocol) {
        URLHandlers uRLHandlers = this;
        synchronized (uRLHandlers) {
            URLStreamHandler handler;
            URLStreamHandler uRLStreamHandler = handler = m_streamHandlerCache == null ? null : (URLStreamHandler)m_streamHandlerCache.get(protocol);
            if (protocol.equals("bundle")) {
                handler = new URLHandlersBundleStreamHandler(null);
                if (m_streamHandlerCache == null) {
                    m_streamHandlerCache = new HashMap();
                }
                m_streamHandlerCache.put(protocol, handler);
                return handler;
            }
            if (handler == null) {
                String pkgs = m_secureAction.getSystemProperty(STREAM_HANDLER_PACKAGE_PROP, "");
                pkgs = pkgs.equals("") ? DEFAULT_STREAM_HANDLER_PACKAGE : pkgs + "|" + DEFAULT_STREAM_HANDLER_PACKAGE;
                StringTokenizer pkgTok = new StringTokenizer(pkgs, "| ");
                while (pkgTok.hasMoreTokens()) {
                    String pkg = pkgTok.nextToken().trim();
                    String className = pkg + "." + protocol + ".Handler";
                    try {
                        if (m_secureAction.forName(className) == null) continue;
                        return null;
                    }
                    catch (Exception ex) {
                    }
                }
                handler = new URLHandlersStreamHandlerProxy(protocol);
                if (m_streamHandlerCache == null) {
                    m_streamHandlerCache = new HashMap();
                }
                m_streamHandlerCache.put(protocol, handler);
            }
            return handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentHandler createContentHandler(String mimeType) {
        URLHandlers uRLHandlers = this;
        synchronized (uRLHandlers) {
            ContentHandler handler;
            ContentHandler contentHandler = handler = m_contentHandlerCache == null ? null : (ContentHandler)m_contentHandlerCache.get(mimeType);
            if (handler == null) {
                String pkgs = m_secureAction.getSystemProperty(CONTENT_HANDLER_PACKAGE_PROP, "");
                pkgs = pkgs.equals("") ? DEFAULT_CONTENT_HANDLER_PACKAGE : pkgs + "|" + DEFAULT_CONTENT_HANDLER_PACKAGE;
                String fixedType = mimeType.replace('.', '_').replace('/', '.').replace('-', '_');
                StringTokenizer pkgTok = new StringTokenizer(pkgs, "| ");
                while (pkgTok.hasMoreTokens()) {
                    String pkg = pkgTok.nextToken().trim();
                    String className = pkg + "." + fixedType;
                    try {
                        if (m_secureAction.forName(className) == null) continue;
                        return null;
                    }
                    catch (Exception ex) {
                    }
                }
                handler = new URLHandlersContentHandlerProxy(mimeType);
                if (m_contentHandlerCache == null) {
                    m_contentHandlerCache = new HashMap();
                }
                m_contentHandlerCache.put(mimeType, handler);
            }
            return handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerInstance(Felix framework, BundleContext context, boolean enable) {
        String string = m_lock;
        synchronized (string) {
            ++m_frameworkCount;
            if (enable) {
                if (m_handler == null) {
                    m_sm = new SecurityManagerEx();
                    m_handler = new URLHandlers();
                }
                if (m_frameworkList == null) {
                    m_frameworkList = new ArrayList();
                }
                m_frameworkList.add(framework);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterInstance(Felix framework) {
        String string = m_lock;
        synchronized (string) {
            --m_frameworkCount;
            if (m_frameworkList != null) {
                m_frameworkList.remove(framework);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Felix getFrameworkFromContext() {
        String string = m_lock;
        synchronized (string) {
            if (m_frameworkList != null) {
                int i;
                if (m_frameworkList.size() == 1 && m_frameworkCount == 1) {
                    return (Felix)m_frameworkList.get(0);
                }
                Class[] stack = m_sm.getClassContext();
                Class targetClass = null;
                for (i = 0; i < stack.length; ++i) {
                    if (!(stack[i].getClassLoader() instanceof ContentClassLoader)) continue;
                    targetClass = stack[i];
                    break;
                }
                if (targetClass != null) {
                    for (i = 0; i < m_frameworkList.size(); ++i) {
                        if (((Felix)m_frameworkList.get(i)).getBundle(targetClass) == null) continue;
                        return (Felix)m_frameworkList.get(i);
                    }
                }
            }
            return null;
        }
    }
}

