/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.cache.BundleCache;
import org.apache.felix.framework.cache.BundleRevision;
import org.apache.felix.framework.util.StringMap;
import org.apache.felix.framework.util.Util;
import org.apache.felix.moduleloader.DirectoryContent;
import org.apache.felix.moduleloader.IContent;
import org.apache.felix.moduleloader.JarContent;
import org.apache.felix.moduleloader.JarFileX;

class DirectoryRevision
extends BundleRevision {
    private static final transient String BUNDLE_JAR_FILE = "bundle.jar";
    private File m_refDir = null;
    private Map m_header = null;

    public DirectoryRevision(Logger logger, File revisionRootDir, String location) throws Exception {
        super(logger, revisionRootDir, location);
        this.m_refDir = new File(location.substring(location.indexOf("file:") + "file:".length()));
        if (BundleCache.getSecureAction().fileExists(this.getRevisionRootDir())) {
            return;
        }
        if (!BundleCache.getSecureAction().mkdir(this.getRevisionRootDir())) {
            this.getLogger().log(1, this.getClass().getName() + ": Unable to create revision directory.");
            throw new IOException("Unable to create archive directory.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Map getManifestHeader() throws Exception {
        if (this.m_header != null) {
            return this.m_header;
        }
        InputStream is = null;
        try {
            is = BundleCache.getSecureAction().getFileInputStream(new File(this.m_refDir, "META-INF/MANIFEST.MF"));
            if (is == null) {
                throw new IOException("No manifest file found.");
            }
            Manifest mf = new Manifest(is);
            Map map = this.m_header = new StringMap(mf.getMainAttributes(), false);
            return map;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public IContent getContent() throws Exception {
        return new DirectoryContent(this.m_refDir);
    }

    public synchronized IContent[] getContentPath() throws Exception {
        Map map = this.getManifestHeader();
        String classPath = map == null ? null : (String)map.get("Bundle-ClassPath");
        String[] classPathStrings = Util.parseDelimitedString(classPath, ",");
        if (classPathStrings == null) {
            classPathStrings = new String[]{};
        }
        DirectoryContent self = new DirectoryContent(this.m_refDir);
        ArrayList<IContent> contentList = new ArrayList<IContent>();
        for (int i = 0; i < classPathStrings.length; ++i) {
            if (classPathStrings[i].equals(".")) {
                contentList.add(self);
                continue;
            }
            File file = new File(this.m_refDir, classPathStrings[i]);
            if (BundleCache.getSecureAction().isFileDirectory(file)) {
                contentList.add(new DirectoryContent(file));
                continue;
            }
            if (!BundleCache.getSecureAction().fileExists(file)) continue;
            contentList.add(new JarContent(file));
        }
        if (contentList.size() == 0) {
            contentList.add(self);
        }
        return contentList.toArray(new IContent[contentList.size()]);
    }

    public String findLibrary(String libName) throws Exception {
        return BundleCache.getSecureAction().getAbsolutePath(new File(this.m_refDir, libName));
    }

    public void dispose() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected X509Certificate[] getRevisionCertificates() throws Exception {
        X509Certificate[] x509CertificateArray;
        File tmp = new File(this.getRevisionRootDir(), BUNDLE_JAR_FILE);
        if (BundleCache.getSecureAction().fileExists(tmp)) {
            BundleCache.getSecureAction().deleteFile(tmp);
        }
        try {
            BundleCache.copyStreamToFile(new RevisionToInputStream(this.m_refDir), tmp);
            JarFileX bundle = BundleCache.getSecureAction().openJAR(tmp);
            x509CertificateArray = this.getCertificatesForJar(bundle);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                if (BundleCache.getSecureAction().fileExists(tmp)) {
                    BundleCache.getSecureAction().deleteFile(tmp);
                }
            }
            catch (Exception e) {}
            throw throwable;
        }
        try {
            if (BundleCache.getSecureAction().fileExists(tmp)) {
                BundleCache.getSecureAction().deleteFile(tmp);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return x509CertificateArray;
    }

    private class RevisionToInputStream
    extends InputStream {
        private File m_revisionDir = null;
        private File[] m_content = null;
        private File m_manifest = null;
        private ByteArrayInputStream m_buffer = null;
        private int m_current = 0;
        private OutputStreamBuffer m_outputBuffer = new OutputStreamBuffer();
        private JarOutputStream m_output = null;

        RevisionToInputStream(File revisionDir) throws IOException {
            this.m_revisionDir = revisionDir;
            this.m_outputBuffer.outBuffer = new ByteArrayOutputStream();
            this.m_manifest = new File(this.m_revisionDir, "META-INF/MANIFEST.MF");
            this.m_output = new JarOutputStream(this.m_outputBuffer);
            this.readNext(this.m_manifest, false);
            this.m_content = this.listFilesRecursive(revisionDir);
        }

        private File[] listFilesRecursive(File dir) {
            File[] children;
            File[] combined = children = BundleCache.getSecureAction().listDirectory(dir);
            for (int i = 0; i < children.length; ++i) {
                File[] grandchildren;
                if (!BundleCache.getSecureAction().isFileDirectory(children[i]) || (grandchildren = this.listFilesRecursive(children[i])).length <= 0) continue;
                File[] tmp = new File[combined.length + grandchildren.length];
                System.arraycopy(combined, 0, tmp, 0, combined.length);
                System.arraycopy(grandchildren, 0, tmp, combined.length, grandchildren.length);
                combined = tmp;
            }
            return combined;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean readNext(File file, boolean close) throws IOException {
            if (BundleCache.getSecureAction().isFileDirectory(file)) {
                return false;
            }
            this.m_outputBuffer.outBuffer = new ByteArrayOutputStream();
            InputStream in = null;
            try {
                in = BundleCache.getSecureAction().getFileInputStream(file);
                JarEntry entry = new JarEntry(file.getPath().substring(this.m_revisionDir.getPath().length() + 1));
                this.m_output.putNextEntry(entry);
                int c = -1;
                while ((c = in.read()) != -1) {
                    this.m_output.write(c);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            this.m_output.closeEntry();
            this.m_output.flush();
            if (close) {
                this.m_output.close();
                this.m_output = null;
            }
            this.m_buffer = new ByteArrayInputStream(this.m_outputBuffer.outBuffer.toByteArray());
            this.m_outputBuffer.outBuffer = null;
            return true;
        }

        public int read() throws IOException {
            if (this.m_output == null && this.m_buffer == null) {
                return -1;
            }
            if (this.m_buffer != null) {
                int result = this.m_buffer.read();
                if (result == -1) {
                    this.m_buffer = null;
                    return this.read();
                }
                return result;
            }
            while (this.m_current < this.m_content.length && (this.m_content[this.m_current].equals(this.m_manifest) || !this.readNext(this.m_content[this.m_current], this.m_current + 1 == this.m_content.length))) {
                ++this.m_current;
            }
            ++this.m_current;
            return this.read();
        }

        class OutputStreamBuffer
        extends OutputStream {
            ByteArrayOutputStream outBuffer = null;

            OutputStreamBuffer() {
            }

            public void write(int b) {
                this.outBuffer.write(b);
            }
        }
    }
}

