/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.searchpolicy;

import java.net.URL;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.util.Enumeration;
import org.apache.felix.framework.searchpolicy.ContentLoaderImpl;
import org.apache.felix.framework.util.Util;
import org.apache.felix.moduleloader.IContentLoader;
import org.apache.felix.moduleloader.ResourceNotFoundException;

public class ContentClassLoader
extends SecureClassLoader {
    private ContentLoaderImpl m_contentLoader = null;
    private ProtectionDomain m_protectionDomain = null;

    public ContentClassLoader(ContentLoaderImpl contentLoader, ProtectionDomain protectionDomain) {
        this.m_contentLoader = contentLoader;
        this.m_protectionDomain = protectionDomain;
    }

    public IContentLoader getContentLoader() {
        return this.m_contentLoader;
    }

    protected Class loadClassFromModule(String name) throws ClassNotFoundException {
        Class clazz = this.findClass(name);
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        this.resolveClass(clazz);
        return clazz;
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class clazz = this.findLoadedClass(name);
        if (clazz == null) {
            clazz = this.m_contentLoader.getSearchPolicy().findClass(name);
        }
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz == null) {
            String actual = name.replace('.', '/') + ".class";
            byte[] bytes = null;
            for (int i = 0; bytes == null && i < this.m_contentLoader.getClassPath().length; ++i) {
                bytes = this.m_contentLoader.getClassPath()[i].getEntry(actual);
            }
            if (bytes != null) {
                String pkgName = Util.getClassPackage(name);
                if (pkgName.length() > 0 && this.getPackage(pkgName) == null) {
                    Object[] params = this.m_contentLoader.getSearchPolicy().definePackage(pkgName);
                    if (params != null) {
                        this.definePackage(pkgName, (String)params[0], (String)params[1], (String)params[2], (String)params[3], (String)params[4], (String)params[5], null);
                    } else {
                        this.definePackage(pkgName, null, null, null, null, null, null, null);
                    }
                }
                clazz = this.m_protectionDomain != null ? this.defineClass(name, bytes, 0, bytes.length, this.m_protectionDomain) : this.defineClass(name, bytes, 0, bytes.length);
            }
        }
        return clazz;
    }

    public URL getResourceFromModule(String name) {
        try {
            return this.findResource(name);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public URL getResource(String name) {
        try {
            return this.m_contentLoader.getSearchPolicy().findResource(name);
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            return null;
        }
    }

    protected URL findResource(String name) {
        return this.m_contentLoader.getResource(name);
    }

    protected Enumeration findResources(String name) {
        return this.m_contentLoader.getResources(name);
    }

    protected String findLibrary(String name) {
        return this.m_contentLoader.getSearchPolicy().findLibrary(name);
    }
}

