/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.searchpolicy;

import java.net.URL;
import java.util.Enumeration;
import org.apache.felix.framework.searchpolicy.R4Export;
import org.apache.felix.framework.util.Util;
import org.apache.felix.moduleloader.IModule;
import org.apache.felix.moduleloader.IWire;
import org.apache.felix.moduleloader.ResourceNotFoundException;

public class R4Wire
implements IWire {
    private IModule m_importer = null;
    private IModule m_exporter = null;
    private R4Export m_export = null;

    public R4Wire(IModule importer, IModule exporter, R4Export export) {
        this.m_importer = importer;
        this.m_exporter = exporter;
        this.m_export = export;
    }

    public IModule getImporter() {
        return this.m_importer;
    }

    public IModule getExporter() {
        return this.m_exporter;
    }

    public R4Export getExport() {
        return this.m_export;
    }

    public Class getClass(String name) throws ClassNotFoundException {
        Class clazz = null;
        String pkgName = Util.getClassPackage(name);
        if (this.m_export.getName().equals(pkgName)) {
            if (this.m_exporter == this.m_importer || this.m_export.isIncluded(name)) {
                clazz = this.m_exporter.getContentLoader().getClass(name);
            }
            if (clazz == null) {
                throw new ClassNotFoundException(name);
            }
        }
        return clazz;
    }

    public URL getResource(String name) throws ResourceNotFoundException {
        URL url = null;
        String pkgName = Util.getResourcePackage(name);
        if (this.m_export.getName().equals(pkgName) && (url = this.m_exporter.getContentLoader().getResource(name)) == null) {
            throw new ResourceNotFoundException(name);
        }
        return url;
    }

    public Enumeration getResources(String name) throws ResourceNotFoundException {
        Enumeration urls = null;
        String pkgName = Util.getResourcePackage(name);
        if (this.m_export.getName().equals(pkgName) && (urls = this.m_exporter.getContentLoader().getResources(name)) == null) {
            throw new ResourceNotFoundException(name);
        }
        return urls;
    }

    public String toString() {
        return this.m_importer + " -> " + this.m_export.getName() + " -> " + this.m_exporter;
    }
}

