/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.searchpolicy.R4Export;
import org.apache.felix.framework.searchpolicy.R4Import;
import org.apache.felix.framework.searchpolicy.R4LibraryClause;
import org.apache.felix.moduleloader.IModule;
import org.apache.felix.moduleloader.IWire;

public class Util {
    private static final byte[] encTab = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] decTab = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1};

    public static long getBundleIdFromModuleId(String id) {
        try {
            String bundleId = id.indexOf(46) >= 0 ? id.substring(0, id.indexOf(46)) : id;
            return Long.parseLong(bundleId);
        }
        catch (NumberFormatException ex) {
            return -1L;
        }
    }

    public static int getModuleRevisionFromModuleId(String id) {
        try {
            String rev = id.indexOf(46) >= 0 ? id.substring(id.indexOf(46) + 1) : id;
            return Integer.parseInt(rev);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    public static String getClassName(String className) {
        if (className == null) {
            className = "";
        }
        return className.lastIndexOf(46) < 0 ? "" : className.substring(className.lastIndexOf(46) + 1);
    }

    public static String getClassPackage(String className) {
        if (className == null) {
            className = "";
        }
        return className.lastIndexOf(46) < 0 ? "" : className.substring(0, className.lastIndexOf(46));
    }

    public static String getResourcePackage(String resource) {
        if (resource == null) {
            resource = "";
        }
        String pkgName = resource.startsWith("/") ? resource.substring(1) : resource;
        pkgName = pkgName.lastIndexOf(47) < 0 ? "" : pkgName.substring(0, pkgName.lastIndexOf(47));
        pkgName = pkgName.replace('/', '.');
        return pkgName;
    }

    public static Class loadClassUsingClass(Class clazz, String name) {
        Class loadedClass = null;
        while (clazz != null) {
            ClassLoader loader = clazz.getClassLoader();
            loader = loader == null ? ClassLoader.getSystemClassLoader() : loader;
            try {
                return loader.loadClass(name);
            }
            catch (ClassNotFoundException ex) {
                Class<?>[] ifcs = clazz.getInterfaces();
                for (int i = 0; i < ifcs.length; ++i) {
                    loadedClass = Util.loadClassUsingClass(ifcs[i], name);
                    if (loadedClass == null) continue;
                    return loadedClass;
                }
                clazz = clazz.getSuperclass();
            }
        }
        return null;
    }

    public static R4Export getExportPackage(IModule m, String name) {
        R4Export[] pkgs = m.getDefinition().getExports();
        for (int i = 0; pkgs != null && i < pkgs.length; ++i) {
            if (!pkgs[i].getName().equals(name)) continue;
            return pkgs[i];
        }
        return null;
    }

    public static R4Import getImportPackage(IModule m, String name) {
        R4Import[] pkgs = m.getDefinition().getImports();
        for (int i = 0; pkgs != null && i < pkgs.length; ++i) {
            if (!pkgs[i].getName().equals(name)) continue;
            return pkgs[i];
        }
        return null;
    }

    public static IWire getWire(IModule m, String name) {
        IWire[] wires = m.getWires();
        for (int i = 0; wires != null && i < wires.length; ++i) {
            if (!wires[i].getExport().getName().equals(name)) continue;
            return wires[i];
        }
        return null;
    }

    public static String[] parseDelimitedString(String value, String delim) {
        if (value == null) {
            value = "";
        }
        ArrayList<String> list = new ArrayList<String>();
        int CHAR = 1;
        int DELIMITER = 2;
        int STARTQUOTE = 4;
        int ENDQUOTE = 8;
        StringBuffer sb = new StringBuffer();
        int expecting = CHAR | DELIMITER | STARTQUOTE;
        for (int i = 0; i < value.length(); ++i) {
            boolean isQuote;
            char c = value.charAt(i);
            boolean isDelimiter = delim.indexOf(c) >= 0;
            boolean bl = isQuote = c == '\"';
            if (isDelimiter && (expecting & DELIMITER) > 0) {
                list.add(sb.toString().trim());
                sb.delete(0, sb.length());
                expecting = CHAR | DELIMITER | STARTQUOTE;
                continue;
            }
            if (isQuote && (expecting & STARTQUOTE) > 0) {
                sb.append(c);
                expecting = CHAR | ENDQUOTE;
                continue;
            }
            if (isQuote && (expecting & ENDQUOTE) > 0) {
                sb.append(c);
                expecting = CHAR | STARTQUOTE | DELIMITER;
                continue;
            }
            if ((expecting & CHAR) > 0) {
                sb.append(c);
                continue;
            }
            throw new IllegalArgumentException("Invalid delimited string: " + value);
        }
        if (sb.length() > 0) {
            list.add(sb.toString().trim());
        }
        return list.toArray(new String[list.size()]);
    }

    public static R4LibraryClause[] parseLibraryStrings(Logger logger, String[] libStrs) throws IllegalArgumentException {
        if (libStrs == null) {
            return new R4LibraryClause[0];
        }
        ArrayList<R4LibraryClause> libList = new ArrayList<R4LibraryClause>();
        for (int i = 0; i < libStrs.length; ++i) {
            R4LibraryClause clause = R4LibraryClause.parse(logger, libStrs[i]);
            libList.add(clause);
        }
        return libList.toArray(new R4LibraryClause[libList.size()]);
    }

    public static String base64Encode(String s) throws IOException {
        return Util.encode(s.getBytes(), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encode(byte[] in, int len) throws IOException {
        String string;
        ByteArrayInputStream bais;
        block4: {
            ByteArrayOutputStream baos = null;
            bais = null;
            try {
                baos = new ByteArrayOutputStream();
                bais = new ByteArrayInputStream(in);
                Util.encode(bais, baos, len);
                string = new String(baos.toByteArray());
                Object var6_5 = null;
                if (baos == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var6_6 = null;
                    if (baos != null) {
                        baos.close();
                    }
                    if (bais == null) break block5;
                    bais.close();
                }
                throw throwable;
            }
            baos.close();
        }
        if (bais != null) {
            bais.close();
        }
        return string;
    }

    public static void encode(InputStream in, OutputStream out, int len) throws IOException {
        int b;
        if (len % 4 != 0) {
            throw new IllegalArgumentException("Length must be a multiple of 4");
        }
        int bits = 0;
        int nbits = 0;
        int nbytes = 0;
        while ((b = in.read()) != -1) {
            bits = bits << 8 | b;
            nbits += 8;
            while (nbits >= 6) {
                out.write(encTab[0x3F & bits >> (nbits -= 6)]);
                if (len == 0 || ++nbytes < len) continue;
                out.write(13);
                out.write(10);
                nbytes -= len;
            }
        }
        switch (nbits) {
            case 2: {
                out.write(encTab[0x3F & bits << 4]);
                out.write(61);
                out.write(61);
                break;
            }
            case 4: {
                out.write(encTab[0x3F & bits << 2]);
                out.write(61);
            }
        }
        if (len != 0) {
            if (nbytes != 0) {
                out.write(13);
                out.write(10);
            }
            out.write(13);
            out.write(10);
        }
    }
}

