/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.main;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.util.MutablePropertyResolverImpl;
import org.apache.felix.framework.util.StringMap;

public class Main {
    public static final String SYSTEM_PROPERTIES_PROP = "felix.system.properties";
    public static final String SYSTEM_PROPERTIES_FILE_VALUE = "system.properties";
    public static final String CONFIG_PROPERTIES_PROP = "felix.config.properties";
    public static final String CONFIG_PROPERTIES_FILE_VALUE = "config.properties";
    public static final String KEYSTORE_FILE_PROP = "felix.keystore";
    public static final String KEYSTORE_FILE_VALUE = System.getProperty("java.home") + File.separatorChar + "lib" + File.separatorChar + "security" + File.separatorChar + "cacerts" + File.pathSeparatorChar + System.getProperty("user.home") + File.separatorChar + ".keystore";
    public static final String KEYSTORE_TYPE_PROP = "felix.keystore.type";
    public static final String KEYSTORE_TYPE_VALUE = "JKS" + File.pathSeparatorChar + "JKS";
    public static final String KEYSTORE_PASS_PROP = "felix.keystore.pass";
    public static final String KEYSTORE_PASS_VALUE = "changeit" + File.pathSeparatorChar + "changeit";
    private static Felix m_felix = null;
    private static final String DELIM_START = "${";
    private static final String DELIM_STOP = "}";

    public static void main(String[] argv) throws Exception {
        Main.loadSystemProperties();
        Properties configProps = Main.loadConfigProperties();
        String profileName = configProps.getProperty("felix.cache.profile");
        String profileDirName = configProps.getProperty("felix.cache.profiledir");
        System.out.println("\nWelcome to Felix.");
        System.out.println("=================\n");
        if (profileName == null && profileDirName == null) {
            System.out.print("Enter profile name: ");
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            try {
                profileName = in.readLine();
            }
            catch (IOException ex) {
                System.err.println("Could not read input.");
                System.exit(-1);
            }
            System.out.println("");
            if (profileName.length() != 0) {
                configProps.setProperty("felix.cache.profile", profileName);
            }
        }
        if (profileDirName == null && profileName.length() == 0) {
            System.err.println("You must specify a profile name or directory.");
            System.exit(-1);
        }
        try {
            m_felix = new Felix();
            m_felix.start(new MutablePropertyResolverImpl(new StringMap(configProps, false)), null, System.getSecurityManager() == null ? null : new TrustManager(configProps));
        }
        catch (Exception ex) {
            System.err.println("Could not create framework: " + ex);
            ex.printStackTrace();
            System.exit(-1);
        }
    }

    public static void loadSystemProperties() {
        int start;
        URL propURL = null;
        String custom = System.getProperty(SYSTEM_PROPERTIES_PROP);
        if (custom != null) {
            try {
                propURL = new URL(custom);
            }
            catch (MalformedURLException ex) {
                System.err.print("Main: " + ex);
                return;
            }
        }
        File confDir = null;
        String classpath = System.getProperty("java.class.path");
        int index = classpath.toLowerCase().indexOf("felix.jar");
        if (index > (start = classpath.lastIndexOf(File.pathSeparator, index) + 1)) {
            String jarLocation = classpath.substring(start, index);
            if (jarLocation.length() == 0) {
                jarLocation = ".";
            }
            confDir = new File(new File(jarLocation).getParent(), "conf");
        } else {
            confDir = new File(System.getProperty("user.dir"));
        }
        try {
            propURL = new File(confDir, SYSTEM_PROPERTIES_FILE_VALUE).toURL();
        }
        catch (MalformedURLException ex) {
            System.err.print("Main: " + ex);
            return;
        }
        Properties props = new Properties();
        InputStream is = null;
        try {
            is = propURL.openConnection().getInputStream();
            props.load(is);
            is.close();
        }
        catch (FileNotFoundException ex) {
        }
        catch (Exception ex) {
            System.err.println("Main: Error loading system properties from " + propURL);
            System.err.println("Main: " + ex);
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex2) {
                // empty catch block
            }
            return;
        }
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            System.setProperty(name, Main.substVars(props.getProperty(name), name, null, null));
        }
    }

    public static Properties loadConfigProperties() {
        int start;
        URL propURL = null;
        String custom = System.getProperty(CONFIG_PROPERTIES_PROP);
        if (custom != null) {
            try {
                propURL = new URL(custom);
            }
            catch (MalformedURLException ex) {
                System.err.print("Main: " + ex);
                return null;
            }
        }
        File confDir = null;
        String classpath = System.getProperty("java.class.path");
        int index = classpath.toLowerCase().indexOf("felix.jar");
        if (index > (start = classpath.lastIndexOf(File.pathSeparator, index) + 1)) {
            String jarLocation = classpath.substring(start, index);
            if (jarLocation.length() == 0) {
                jarLocation = ".";
            }
            confDir = new File(new File(jarLocation).getParent(), "conf");
        } else {
            confDir = new File(System.getProperty("user.dir"));
        }
        try {
            propURL = new File(confDir, CONFIG_PROPERTIES_FILE_VALUE).toURL();
        }
        catch (MalformedURLException ex) {
            System.err.print("Main: " + ex);
            return null;
        }
        Properties props = new Properties();
        InputStream is = null;
        try {
            is = propURL.openConnection().getInputStream();
            props.load(is);
            is.close();
        }
        catch (FileNotFoundException ex) {
        }
        catch (Exception ex) {
            System.err.println("Error loading config properties from " + propURL);
            System.err.println("Main: " + ex);
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex2) {
                // empty catch block
            }
            return null;
        }
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            props.setProperty(name, Main.substVars(props.getProperty(name), name, null, props));
        }
        return props;
    }

    public static String substVars(String val, String currentKey, Map cycleMap, Properties configProps) throws IllegalArgumentException {
        String substValue;
        int idx;
        if (cycleMap == null) {
            cycleMap = new HashMap<String, String>();
        }
        cycleMap.put(currentKey, currentKey);
        int stopDelim = val.indexOf(DELIM_STOP);
        int startDelim = val.indexOf(DELIM_START);
        while (stopDelim >= 0 && (idx = val.indexOf(DELIM_START, startDelim + DELIM_START.length())) >= 0 && idx <= stopDelim) {
            if (idx >= stopDelim) continue;
            startDelim = idx;
        }
        if (startDelim < 0 && stopDelim < 0) {
            return val;
        }
        if ((startDelim < 0 || startDelim > stopDelim) && stopDelim >= 0) {
            throw new IllegalArgumentException("stop delimiter with no start delimiter: " + val);
        }
        String variable = val.substring(startDelim + DELIM_START.length(), stopDelim);
        if (cycleMap.get(variable) != null) {
            throw new IllegalArgumentException("recursive variable reference: " + variable);
        }
        String string = substValue = configProps != null ? configProps.getProperty(variable, null) : null;
        if (substValue == null) {
            substValue = System.getProperty(variable, "");
        }
        cycleMap.remove(variable);
        val = val.substring(0, startDelim) + substValue + val.substring(stopDelim + DELIM_STOP.length(), val.length());
        val = Main.substVars(val, currentKey, cycleMap, configProps);
        return val;
    }

    private static class TrustManager
    extends AbstractCollection {
        private String[] m_keystores = null;
        private String[] m_passwds = null;
        private String[] m_types = null;
        private ArrayList m_stores = null;

        TrustManager(Properties config) {
            StringTokenizer tok = new StringTokenizer(System.getProperty(Main.KEYSTORE_FILE_PROP, config.getProperty(Main.KEYSTORE_FILE_PROP, KEYSTORE_FILE_VALUE)), File.pathSeparator);
            this.m_keystores = new String[tok.countTokens()];
            int i = 0;
            while (tok.hasMoreTokens()) {
                this.m_keystores[i] = tok.nextToken();
                ++i;
            }
            tok = new StringTokenizer(System.getProperty(Main.KEYSTORE_PASS_PROP, config.getProperty(Main.KEYSTORE_PASS_PROP, KEYSTORE_PASS_VALUE)), File.pathSeparator);
            this.m_passwds = new String[tok.countTokens()];
            i = 0;
            while (tok.hasMoreTokens()) {
                this.m_passwds[i] = tok.nextToken();
                ++i;
            }
            tok = new StringTokenizer(System.getProperty(Main.KEYSTORE_TYPE_PROP, config.getProperty(Main.KEYSTORE_TYPE_PROP, KEYSTORE_TYPE_VALUE)), File.pathSeparator);
            this.m_types = new String[tok.countTokens()];
            i = 0;
            while (tok.hasMoreTokens()) {
                this.m_types[i] = tok.nextToken();
                ++i;
            }
        }

        public synchronized Iterator iterator() {
            if (this.m_stores == null) {
                this.loadStores();
            }
            return this.m_stores.iterator();
        }

        public synchronized int size() {
            if (this.m_stores == null) {
                this.loadStores();
            }
            return this.m_stores.size();
        }

        private void loadStores() {
            this.m_stores = new ArrayList();
            if (this.m_keystores.length == this.m_passwds.length && this.m_passwds.length == this.m_types.length && System.getSecurityManager() != null) {
                AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ TrustManager this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public Object run() {
                        ArrayList<Certificate> certs = new ArrayList<Certificate>();
                        for (int i = 0; i < TrustManager.access$000(this.this$0).length; ++i) {
                            try {
                                KeyStore ks = KeyStore.getInstance(TrustManager.access$100(this.this$0)[i]);
                                ks.load(new FileInputStream(TrustManager.access$000(this.this$0)[i]), TrustManager.access$200(this.this$0)[i].toCharArray());
                                Enumeration<String> e = ks.aliases();
                                while (e.hasMoreElements()) {
                                    String alias = e.nextElement();
                                    if (!ks.isCertificateEntry(alias)) continue;
                                    certs.add(ks.getCertificate(alias));
                                }
                            }
                            catch (Exception ex) {
                                certs.clear();
                                ex.printStackTrace(System.err);
                                System.err.println("WARNING: Error accessing keystore: " + TrustManager.access$000(this.this$0)[i]);
                            }
                            if (certs.isEmpty()) continue;
                            TrustManager.access$300(this.this$0).addAll(certs);
                            certs.clear();
                        }
                        return null;
                    }
                });
            }
            if (this.m_stores.isEmpty()) {
                System.err.println("WARNING: No trusted CA certificates!");
            }
        }

        static /* synthetic */ String[] access$000(TrustManager x0) {
            return x0.m_keystores;
        }

        static /* synthetic */ String[] access$100(TrustManager x0) {
            return x0.m_types;
        }

        static /* synthetic */ String[] access$200(TrustManager x0) {
            return x0.m_passwds;
        }

        static /* synthetic */ ArrayList access$300(TrustManager x0) {
            return x0.m_stores;
        }
    }
}

