/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.security.AccessController;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.felix.framework.FilterImpl;
import org.apache.felix.framework.SignerMatcher;
import org.osgi.framework.AdminPermissionCollection;
import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;

public final class AdminPermission
extends BasicPermission {
    static final long serialVersionUID = 307051004521261705L;
    public static final String CLASS = "class";
    public static final String EXECUTE = "execute";
    public static final String EXTENSIONLIFECYCLE = "extensionLifecycle";
    public static final String LIFECYCLE = "lifecycle";
    public static final String LISTENER = "listener";
    public static final String METADATA = "metadata";
    public static final String RESOLVE = "resolve";
    public static final String RESOURCE = "resource";
    public static final String STARTLEVEL = "startlevel";
    private static final int CLASS_MASK = 1;
    private static final int EXECUTE_MASK = 2;
    private static final int EXTENSIONLIFECYCLE_MASK = 4;
    private static final int LIFECYCLE_MASK = 8;
    private static final int LISTENER_MASK = 16;
    private static final int METADATA_MASK = 32;
    private static final int RESOLVE_MASK = 64;
    private static final int RESOURCE_MASK = 128;
    private static final int STARTLEVEL_MASK = 256;
    private static final int ALL_MASK = 511;
    private String m_actions = null;
    int m_actionMask = 0;
    private FilterImpl m_filterImpl = null;
    private Bundle m_bundle = null;
    private Dictionary m_bundleDict = null;

    public AdminPermission() {
        this("*", 511);
    }

    public AdminPermission(Bundle bundle, String actions) {
        this(AdminPermission.createName(bundle), actions);
        this.m_bundle = bundle;
    }

    public AdminPermission(String filter, String actions) {
        super(filter == null || filter.equals("*") ? "(id=*)" : filter);
        this.m_actionMask = AdminPermission.parseActions(actions);
    }

    AdminPermission(String filter, int actionMask) {
        super(filter == null || filter.equals("*") ? "(id=*)" : filter);
        this.m_actionMask = actionMask;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AdminPermission)) {
            return false;
        }
        AdminPermission p = (AdminPermission)obj;
        return this.getName().equals(p.getName()) && this.m_actionMask == p.m_actionMask;
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.getActions().hashCode();
    }

    public String getActions() {
        if (this.m_actions == null) {
            this.m_actions = AdminPermission.createActionString(this.m_actionMask);
        }
        return this.m_actions;
    }

    public boolean implies(Permission p) {
        if (!(p instanceof AdminPermission)) {
            return false;
        }
        AdminPermission admin = (AdminPermission)p;
        if (admin.m_bundle == null && !admin.getName().equals("(id=*)")) {
            throw new RuntimeException("The specified permission was not constructed with a bundle or *!");
        }
        if ((this.m_actionMask & admin.m_actionMask) != admin.m_actionMask) {
            return false;
        }
        if (admin.getName().equals("(id=*)")) {
            return this.getName().equals("(id=*)");
        }
        if (this.getName().equals("(id=*)")) {
            return true;
        }
        if (this.m_filterImpl == null) {
            try {
                this.m_filterImpl = new FilterImpl(this.getName());
            }
            catch (InvalidSyntaxException ex) {
                return false;
            }
        }
        return this.m_filterImpl.match(admin.getBundleDictionary());
    }

    public PermissionCollection newPermissionCollection() {
        return new AdminPermissionCollection();
    }

    private Dictionary getBundleDictionary() {
        if (this.m_bundleDict == null) {
            this.m_bundleDict = new Hashtable();
            this.m_bundleDict.put("id", new Long(this.m_bundle.getBundleId()));
            String symbolicName = this.m_bundle.getSymbolicName();
            if (symbolicName != null) {
                this.m_bundleDict.put("name", symbolicName);
            }
            if (System.getSecurityManager() != null) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        AdminPermission.this.m_bundleDict.put("location", AdminPermission.this.m_bundle.getLocation());
                        return null;
                    }
                });
            } else {
                this.m_bundleDict.put("location", this.m_bundle.getLocation());
            }
            this.m_bundleDict.put("signer", new SignerMatcher(this.m_bundle));
        }
        return this.m_bundleDict;
    }

    private static int parseActions(String actions) {
        if (actions == null) {
            return 511;
        }
        int mask = 0;
        StringTokenizer st = new StringTokenizer(actions, ", ");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equals("*")) {
                mask = 511;
                break;
            }
            if (s.equalsIgnoreCase(CLASS)) {
                mask |= 1;
                continue;
            }
            if (s.equalsIgnoreCase(EXECUTE)) {
                mask |= 2;
                continue;
            }
            if (s.equalsIgnoreCase(EXTENSIONLIFECYCLE)) {
                mask |= 4;
                continue;
            }
            if (s.equalsIgnoreCase(LIFECYCLE)) {
                mask |= 8;
                continue;
            }
            if (s.equalsIgnoreCase(LISTENER)) {
                mask |= 0x10;
                continue;
            }
            if (s.equalsIgnoreCase(METADATA)) {
                mask |= 0x20;
                continue;
            }
            if (s.equalsIgnoreCase(RESOLVE)) {
                mask |= 0x40;
                continue;
            }
            if (s.equalsIgnoreCase(RESOURCE)) {
                mask |= 0x80;
                continue;
            }
            if (!s.equalsIgnoreCase(STARTLEVEL)) continue;
            mask |= 0x100;
        }
        return mask;
    }

    private static String createActionString(int mask) {
        StringBuffer sb = new StringBuffer();
        if ((mask & 1) > 0) {
            sb.append(CLASS);
            sb.append(",");
        }
        if ((mask & 2) > 0) {
            sb.append(EXECUTE);
            sb.append(",");
        }
        if ((mask & 4) > 0) {
            sb.append(EXTENSIONLIFECYCLE);
            sb.append(",");
        }
        if ((mask & 8) > 0) {
            sb.append(LIFECYCLE);
            sb.append(",");
        }
        if ((mask & 0x10) > 0) {
            sb.append(LISTENER);
            sb.append(",");
        }
        if ((mask & 0x20) > 0) {
            sb.append(METADATA);
            sb.append(",");
        }
        if ((mask & 0x40) > 0) {
            sb.append(RESOLVE);
            sb.append(",");
        }
        if ((mask & 0x80) > 0) {
            sb.append(RESOURCE);
            sb.append(",");
        }
        if ((mask & 0x100) > 0) {
            sb.append(STARTLEVEL);
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private static String createName(Bundle bundle) {
        StringBuffer sb = new StringBuffer();
        sb.append("(id=");
        sb.append(bundle.getBundleId());
        sb.append(")");
        return sb.toString();
    }
}

