/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.CharArrayReader;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.WeakHashMap;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.util.StringMap;
import org.apache.felix.framework.util.ldap.AttributeNotFoundException;
import org.apache.felix.framework.util.ldap.EvaluationException;
import org.apache.felix.framework.util.ldap.Evaluator;
import org.apache.felix.framework.util.ldap.LdapLexer;
import org.apache.felix.framework.util.ldap.Mapper;
import org.apache.felix.framework.util.ldap.ParseException;
import org.apache.felix.framework.util.ldap.Parser;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class FilterImpl
implements Filter {
    private static final WeakHashMap m_programCache = new WeakHashMap();
    private final ThreadLocal m_cache = new ThreadLocal();
    private final Logger m_logger;
    private final Object[] m_program;
    private volatile String m_toString;

    public FilterImpl(String expr) throws InvalidSyntaxException {
        this(null, expr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterImpl(Logger logger, String expr) throws InvalidSyntaxException {
        this.m_logger = logger;
        if (expr == null) {
            throw new NullPointerException("Filter cannot be null");
        }
        Object[] program = null;
        WeakHashMap weakHashMap = m_programCache;
        synchronized (weakHashMap) {
            program = (Object[])m_programCache.get(expr);
        }
        if (program == null) {
            CharArrayReader car = new CharArrayReader(expr.toCharArray());
            LdapLexer lexer = new LdapLexer(car);
            Parser parser = new Parser(lexer);
            try {
                if (!parser.start()) {
                    throw new InvalidSyntaxException("Failed to parse LDAP query.", expr);
                }
            }
            catch (ParseException ex) {
                throw new InvalidSyntaxException(ex.getMessage(), expr);
            }
            catch (IOException ex) {
                throw new InvalidSyntaxException(ex.getMessage(), expr);
            }
            program = parser.getProgram();
            WeakHashMap weakHashMap2 = m_programCache;
            synchronized (weakHashMap2) {
                if (!m_programCache.containsKey(expr)) {
                    m_programCache.put(expr, program);
                }
            }
        }
        this.m_program = program;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Filter) {
            return this.toString().equals(o.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    private boolean match(Dictionary dict, ServiceReference ref, boolean caseSensitive) throws IllegalArgumentException {
        boolean bl;
        block24: {
            SoftReference tupleRef;
            block21: {
                tupleRef = (SoftReference)this.m_cache.get();
                Evaluator evaluator = null;
                SimpleMapper mapper = null;
                Object[] tuple = null;
                if (tupleRef != null) {
                    tuple = (Object[])tupleRef.get();
                }
                if (tuple == null) {
                    evaluator = new Evaluator(this.m_program);
                    mapper = new SimpleMapper();
                } else {
                    evaluator = (Evaluator)tuple[0];
                    mapper = (SimpleMapper)tuple[1];
                    this.m_cache.set(null);
                }
                try {
                    if (dict != null) {
                        mapper.setSource(dict, caseSensitive);
                    } else {
                        mapper.setSource(ref);
                    }
                    bl = evaluator.evaluate(mapper);
                    if (dict != null) {
                        mapper.setSource(null, caseSensitive);
                    } else {
                        mapper.setSource(null);
                    }
                    if (tuple != null) break block21;
                }
                catch (AttributeNotFoundException ex) {
                    block22: {
                        this.log(4, "FilterImpl: Attribute not found.", ex);
                        if (dict != null) {
                            mapper.setSource(null, caseSensitive);
                        } else {
                            mapper.setSource(null);
                        }
                        if (tuple != null) break block22;
                        this.m_cache.set(new SoftReference<Object[]>(new Object[]{evaluator, mapper}));
                    }
                    this.m_cache.set(tupleRef);
                }
                catch (EvaluationException ex2) {
                    block23: {
                        this.log(1, "FilterImpl: " + this.toString(), ex2);
                        if (dict != null) {
                            mapper.setSource(null, caseSensitive);
                        } else {
                            mapper.setSource(null);
                        }
                        if (tuple != null) break block23;
                        {
                            catch (Throwable throwable) {
                                if (dict != null) {
                                    mapper.setSource(null, caseSensitive);
                                } else {
                                    mapper.setSource(null);
                                }
                                if (tuple == null) {
                                    this.m_cache.set(new SoftReference<Object[]>(new Object[]{evaluator, mapper}));
                                } else {
                                    this.m_cache.set(tupleRef);
                                }
                                throw throwable;
                            }
                        }
                        this.m_cache.set(new SoftReference<Object[]>(new Object[]{evaluator, mapper}));
                    }
                    this.m_cache.set(tupleRef);
                }
                this.m_cache.set(new SoftReference<Object[]>(new Object[]{evaluator, mapper}));
                break block24;
            }
            this.m_cache.set(tupleRef);
        }
        return bl;
        return false;
    }

    public boolean match(Dictionary dict) throws IllegalArgumentException {
        return this.match(dict, null, false);
    }

    public boolean match(ServiceReference ref) {
        return this.match(null, ref, false);
    }

    public boolean matchCase(Dictionary dict) {
        return this.match(dict, null, true);
    }

    public String toString() {
        if (this.m_toString == null) {
            this.m_toString = new Evaluator(this.m_program).toStringInfix();
        }
        return this.m_toString;
    }

    private void log(int flag, String msg, Throwable th) {
        if (this.m_logger == null) {
            System.out.println(msg + ": " + th);
        } else {
            this.m_logger.log(flag, msg, th);
        }
    }

    static class SimpleMapper
    implements Mapper {
        private ServiceReference m_ref = null;
        private StringMap m_map = null;

        SimpleMapper() {
        }

        public void setSource(ServiceReference ref) {
            this.m_ref = ref;
            this.m_map = null;
        }

        public void setSource(Dictionary dict, boolean caseSensitive) {
            if (this.m_map == null) {
                this.m_map = new StringMap();
            } else {
                this.m_map.clear();
            }
            this.m_map.setCaseSensitive(caseSensitive);
            if (dict != null) {
                Enumeration keys = dict.keys();
                while (keys.hasMoreElements()) {
                    Object key = keys.nextElement();
                    if (this.m_map.get(key) == null) {
                        this.m_map.put(key, dict.get(key));
                        continue;
                    }
                    throw new IllegalArgumentException("Duplicate attribute: " + key.toString());
                }
            }
            this.m_ref = null;
        }

        public Object lookup(String name) {
            if (this.m_map == null) {
                return this.m_ref.getProperty(name);
            }
            return this.m_map.get(name);
        }
    }
}

