/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.felix.gogo.commands;

import org.apache.felix.gogo.runtime.threadio.ThreadIOImpl;
import org.apache.felix.gogo.runtime.shell.CommandShellImpl;
import org.apache.felix.gogo.runtime.shell.CommandSessionImpl;

public class Context extends CommandShellImpl
{
    public static final String EMPTY = "";
    CommandSessionImpl session = (CommandSessionImpl) createSession(System.in, System.out, System.err);
    static ThreadIOImpl threadio;

    static
    {
        threadio = new ThreadIOImpl();
        threadio.start();

    }

    public Context()
    {
        setThreadio(threadio);
    }

    public Object execute(CharSequence source) throws Exception
    {
        return session.execute(source);
    }

    public void addCommand(String name, Object target)
    {
        put("test:" + name, target);
    }

    public void set(String name, Object value)
    {
        session.put(name, value);
    }


}