/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundleplugin;

import aQute.lib.osgi.Builder;
import aQute.lib.osgi.Jar;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.bundleplugin.BundlePlugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class AntPlugin
extends BundlePlugin {
    static final String BUILD_XML = "/build.xml";
    static final String BUILD_BND = "/maven-build.bnd";

    protected void execute(MavenProject currentProject, Map originalInstructions, Properties properties, Jar[] classpath) throws MojoExecutionException {
        String artifactId = this.getProject().getArtifactId();
        String baseDir = this.getProject().getBasedir().getPath();
        try {
            Builder builder = this.buildOSGiBundle(currentProject, originalInstructions, properties, classpath);
            Properties bndProperties = builder.getProperties();
            Iterator<Object> i = bndProperties.values().iterator();
            while (i.hasNext()) {
                if (i.next() instanceof String) continue;
                i.remove();
            }
            bndProperties.setProperty("-output", "${maven.build.dir}/${maven.build.finalName}.jar");
            FileOutputStream out = new FileOutputStream(baseDir + BUILD_BND);
            bndProperties.store(out, " Merged BND Instructions");
            IOUtil.close((OutputStream)out);
            String buildXml = IOUtil.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(BUILD_XML));
            buildXml = StringUtils.replace((String)buildXml, (String)"BND_VERSION", (String)builder.getVersion());
            buildXml = StringUtils.replace((String)buildXml, (String)"ARTIFACT_ID", (String)artifactId);
            FileUtils.fileWrite((String)(baseDir + BUILD_XML), (String)buildXml);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Problem creating Ant script", e);
        }
        this.getLog().info((CharSequence)("Wrote Ant bundle project for " + artifactId + " to " + baseDir));
    }
}

