/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.obrplugin;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Resource;

public class ObrUtils {
    private static final String DOT_XML = ".xml";
    private static final String REPO_XML = "repository.xml";
    private static final String OBR_XML = "obr.xml";

    public static URI findRepositoryXml(String mavenRepository, String obrRepository) {
        URI uri;
        String targetPath = obrRepository;
        Pattern ignoredNames = Pattern.compile("^(true|false|none|null)?$", 2);
        if (null == targetPath || ignoredNames.matcher(targetPath).matches()) {
            targetPath = mavenRepository + '/' + REPO_XML;
        } else if (!targetPath.toLowerCase().endsWith(DOT_XML)) {
            targetPath = targetPath + '/' + REPO_XML;
        }
        try {
            uri = new URI(targetPath);
            uri.toURL();
        }
        catch (Exception e) {
            uri = null;
        }
        if (null == uri || !uri.isAbsolute()) {
            uri = new File(targetPath).toURI();
        }
        return uri;
    }

    public static URI findObrXml(Collection resources) {
        Iterator i = resources.iterator();
        while (i.hasNext()) {
            Resource resource = (Resource)i.next();
            File obrFile = new File(resource.getDirectory(), OBR_XML);
            if (!obrFile.exists()) continue;
            return obrFile.toURI();
        }
        return null;
    }

    public static URI getArtifactURI(ArtifactRepository repository, Artifact artifact) {
        String baseDir = repository.getBasedir();
        String artifactPath = repository.pathOf(artifact);
        return ObrUtils.toFileURI(baseDir + '/' + artifactPath);
    }

    public static URI toFileURI(String path) {
        if (null == path) {
            return null;
        }
        if (path.startsWith("file:")) {
            return URI.create(path);
        }
        return new File(path).toURI();
    }

    public static URI getRelativeURI(URI repositoryXml, URI bundleJar) {
        try {
            String repositoryPath = repositoryXml.getPath();
            if (repositoryPath.toLowerCase().endsWith(DOT_XML)) {
                int dirnameIndex = repositoryPath.lastIndexOf(47);
                repositoryPath = repositoryPath.substring(0, dirnameIndex);
            }
            URI rootURI = new URI(null, repositoryPath, null);
            URI localURI = new URI(null, bundleJar.getPath(), null);
            return rootURI.relativize(localURI);
        }
        catch (Exception e) {
            return bundleJar;
        }
    }
}

