/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.plugin;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.felix.ipojo.manipulator.Pojoization;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

public class ManipulatorMojo
extends AbstractMojo {
    private String m_buildDirectory;
    private File m_outputDirectory;
    private String m_jarName;
    private String m_metadata;
    private String m_classifier;
    private MavenProject m_project;
    private MavenProjectHelper m_helper;
    private List m_supportedProjectTypes = Arrays.asList("bundle");
    private boolean m_ignoreAnnotations;

    protected MavenProject getProject() {
        return this.m_project;
    }

    public void execute() throws MojoExecutionException {
        if (!this.m_supportedProjectTypes.contains(this.getProject().getArtifact().getType())) {
            this.getLog().debug((CharSequence)("Ignoring project " + this.getProject().getArtifact() + " : type " + this.getProject().getArtifact().getType() + " is not supported by ipojo plugin, supported types are " + this.m_supportedProjectTypes));
            return;
        }
        this.getLog().info((CharSequence)"Start bundle manipulation");
        File meta = new File(this.m_outputDirectory + File.separator + this.m_metadata);
        if (!meta.exists()) {
            meta = new File(this.m_project.getBasedir() + File.separator + this.m_metadata);
        }
        this.getLog().info((CharSequence)("Metadata File : " + meta.getAbsolutePath()));
        if (!meta.exists()) {
            if (this.m_ignoreAnnotations) {
                this.getLog().info((CharSequence)"No metadata file found - ignore annotations");
                return;
            }
            this.getLog().info((CharSequence)"No metadata file found - try to use only annotations");
            meta = null;
        }
        File in = new File(this.m_buildDirectory + File.separator + this.m_jarName + ".jar");
        this.getLog().info((CharSequence)("Input Bundle File : " + in.getAbsolutePath()));
        if (!in.exists()) {
            throw new MojoExecutionException("the specified bundle file does not exists");
        }
        File out = new File(this.m_buildDirectory + File.separator + "_out.jar");
        Pojoization pojo = new Pojoization();
        if (!this.m_ignoreAnnotations) {
            pojo.setAnnotationProcessing();
        }
        pojo.pojoization(in, out, meta);
        for (int i = 0; i < pojo.getWarnings().size(); ++i) {
            this.getLog().warn((CharSequence)((String)pojo.getWarnings().get(i)));
        }
        if (pojo.getErrors().size() > 0) {
            throw new MojoExecutionException((String)pojo.getErrors().get(0));
        }
        if (this.m_classifier != null) {
            this.m_helper.attachArtifact(this.m_project, "jar", this.m_classifier, out);
        } else {
            in.delete();
            out.renameTo(in);
        }
        this.getLog().info((CharSequence)"Bundle manipulation - SUCCESS");
    }
}

