/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.plugin;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.felix.ipojo.manipulator.Pojoization;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

public class ManipulatorMojo
extends AbstractMojo {
    private String m_buildDirectory;
    private File m_outputDirectory;
    private String m_jarName;
    private String m_metadata;
    private String m_classifier;
    private MavenProject m_project;
    private MavenProjectHelper m_helper;
    private List m_supportedProjectTypes = Arrays.asList("bundle");
    private boolean m_ignoreAnnotations;
    private boolean m_ignoreEmbeddedXSD;

    protected MavenProject getProject() {
        return this.m_project;
    }

    private boolean isXML() {
        return this.m_metadata != null && this.m_metadata.indexOf(60) > -1;
    }

    public void execute() throws MojoExecutionException {
        if (!this.m_supportedProjectTypes.contains(this.getProject().getArtifact().getType())) {
            this.getLog().debug((CharSequence)("Ignoring project " + this.getProject().getArtifact() + " : type " + this.getProject().getArtifact().getType() + " is not supported by iPOJO plugin, supported types are " + this.m_supportedProjectTypes));
            return;
        }
        this.initializeSaxDriver();
        this.getLog().info((CharSequence)"Start bundle manipulation");
        InputStream is = null;
        if (this.isXML()) {
            is = new ByteArrayInputStream(this.m_metadata.getBytes());
        } else {
            File meta;
            if (this.m_metadata == null) {
                this.m_metadata = "metadata.xml";
            }
            if (!(meta = new File(this.m_outputDirectory + File.separator + this.m_metadata)).exists()) {
                meta = new File(this.m_project.getBasedir() + File.separator + this.m_metadata);
            }
            this.getLog().info((CharSequence)("Metadata file : " + meta.getAbsolutePath()));
            if (!meta.exists()) {
                if (this.m_ignoreAnnotations) {
                    this.getLog().info((CharSequence)"No metadata file found - ignoring annotations");
                    return;
                }
                this.getLog().info((CharSequence)"No metadata file found - trying to use only annotations");
                meta = null;
            }
            if (meta != null) {
                try {
                    is = new FileInputStream(meta);
                }
                catch (FileNotFoundException e) {
                    throw new MojoExecutionException("the specified metadata file does not exist: " + e.getMessage());
                }
            }
        }
        File in = new File(this.m_buildDirectory + File.separator + this.m_jarName + ".jar");
        this.getLog().info((CharSequence)("Input Bundle File : " + in.getAbsolutePath()));
        if (!in.exists()) {
            throw new MojoExecutionException("the specified bundle file does not exist");
        }
        File out = new File(this.m_buildDirectory + File.separator + "_out.jar");
        Pojoization pojo = new Pojoization();
        if (this.m_ignoreAnnotations) {
            pojo.disableAnnotationProcessing();
        }
        if (!this.m_ignoreEmbeddedXSD) {
            pojo.setUseLocalXSD();
        }
        if (is == null) {
            pojo.pojoization(in, out, (File)null);
        } else {
            pojo.pojoization(in, out, is);
        }
        for (int i = 0; i < pojo.getWarnings().size(); ++i) {
            this.getLog().warn((CharSequence)((String)pojo.getWarnings().get(i)));
        }
        if (pojo.getErrors().size() > 0) {
            throw new MojoExecutionException((String)pojo.getErrors().get(0));
        }
        if (this.m_classifier != null) {
            this.m_helper.attachArtifact(this.m_project, "jar", this.m_classifier, out);
        } else if (in.delete()) {
            if (!out.renameTo(in)) {
                this.getLog().warn((CharSequence)"Cannot rename the manipulated jar file");
            }
        } else {
            this.getLog().warn((CharSequence)"Cannot delete the input jar file");
        }
        this.getLog().info((CharSequence)"Bundle manipulation - SUCCESS");
    }

    private void initializeSaxDriver() {
        String version = System.getProperty("java.vm.version");
        if (version.startsWith("1.4")) {
            this.getLog().info((CharSequence)"Set the Sax driver to org.apache.xerces.parsers.SAXParser");
            System.setProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
        }
    }
}

