/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.obr.plugin;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.apache.felix.obr.plugin.Config;
import org.apache.felix.obr.plugin.ObrUpdate;
import org.apache.felix.obr.plugin.ObrUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public final class ObrInstall
extends AbstractMojo {
    private String obrRepository;
    private List supportedProjectTypes = Arrays.asList("jar", "bundle");
    private ArtifactRepository localRepository;
    private MavenProject project;

    public void execute() {
        if (!this.supportedProjectTypes.contains(this.project.getPackaging())) {
            this.getLog().info((CharSequence)("Ignoring packaging type " + this.project.getPackaging()));
            return;
        }
        if ("NONE".equalsIgnoreCase(this.obrRepository)) {
            this.getLog().info((CharSequence)"OBR update disabled (enable with -DobrRepository)");
            return;
        }
        Log log = this.getLog();
        try {
            String mavenRepository = this.localRepository.getBasedir();
            URI repositoryXml = ObrUtils.findRepositoryXml(mavenRepository, this.obrRepository);
            URI obrXmlFile = ObrUtils.findObrXml(this.project.getResources());
            URI bundleJar = ObrUtils.findBundleJar(this.localRepository, this.project.getArtifact());
            Config userConfig = new Config();
            ObrUpdate update = new ObrUpdate(repositoryXml, obrXmlFile, this.project, bundleJar, mavenRepository, userConfig, log);
            update.updateRepository();
        }
        catch (Exception e) {
            log.warn((CharSequence)("Exception while updating local OBR: " + e.getLocalizedMessage()), (Throwable)e);
        }
    }
}

