/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.obr.plugin;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.apache.felix.obr.plugin.AbstractFileMojo;
import org.apache.felix.obr.plugin.Config;
import org.apache.felix.obr.plugin.ObrUpdate;
import org.apache.felix.obr.plugin.ObrUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public final class ObrInstallFile
extends AbstractFileMojo {
    private String obrRepository;
    private List supportedProjectTypes = Arrays.asList("jar", "bundle");
    private ArtifactRepository localRepository;

    public void execute() throws MojoExecutionException {
        MavenProject project = this.getProject();
        if (!this.supportedProjectTypes.contains(project.getPackaging())) {
            this.getLog().info((CharSequence)("Ignoring packaging type " + project.getPackaging()));
            return;
        }
        if ("NONE".equalsIgnoreCase(this.obrRepository)) {
            this.getLog().info((CharSequence)"OBR update disabled (enable with -DobrRepository)");
            return;
        }
        Log log = this.getLog();
        String mavenRepository = this.localRepository.getBasedir();
        URI repositoryXml = ObrUtils.findRepositoryXml(mavenRepository, this.obrRepository);
        URI obrXmlFile = ObrUtils.toFileURI(this.obrXml);
        URI bundleJar = null == this.file ? ObrUtils.findBundleJar(this.localRepository, project.getArtifact()) : this.file.toURI();
        Config userConfig = new Config();
        ObrUpdate update = new ObrUpdate(repositoryXml, obrXmlFile, project, bundleJar, mavenRepository, userConfig, log);
        update.updateRepository();
    }
}

