/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.om;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.felix.scrplugin.om.AbstractObject;
import org.apache.felix.scrplugin.om.Implementation;
import org.apache.felix.scrplugin.om.Property;
import org.apache.felix.scrplugin.om.Reference;
import org.apache.felix.scrplugin.om.Service;
import org.apache.felix.scrplugin.tags.JavaClassDescription;
import org.apache.felix.scrplugin.tags.JavaMethod;
import org.apache.felix.scrplugin.tags.JavaParameter;
import org.apache.felix.scrplugin.tags.JavaTag;
import org.apache.maven.plugin.MojoExecutionException;

public class Component
extends AbstractObject {
    protected String name;
    protected Boolean enabled;
    protected Boolean immediate;
    protected String factory;
    protected Implementation implementation;
    protected List properties = new ArrayList();
    protected Service service;
    protected List references = new ArrayList();
    protected boolean isAbstract;
    protected boolean serviceFactory;

    public Component() {
        this(null);
    }

    public Component(JavaTag t) {
        super(t);
    }

    public List getProperties() {
        return this.properties;
    }

    public void setProperties(List properties) {
        this.properties = properties;
    }

    public void addProperty(Property property) {
        this.properties.add(property);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFactory() {
        return this.factory;
    }

    public void setFactory(String factory) {
        this.factory = factory;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean isImmediate() {
        return this.immediate;
    }

    public void setImmediate(Boolean immediate) {
        this.immediate = immediate;
    }

    public Implementation getImplementation() {
        return this.implementation;
    }

    public void setImplementation(Implementation implementation) {
        this.implementation = implementation;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public List getReferences() {
        return this.references;
    }

    public void setReferences(List references) {
        this.references = references;
    }

    public void addReference(Reference ref) {
        this.references.add(ref);
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public boolean isServiceFactory() {
        return this.serviceFactory;
    }

    public void setServiceFactory(boolean serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    public void validate(List issues, List warnings) throws MojoExecutionException {
        JavaClassDescription javaClass = this.tag.getJavaClassDescription();
        if (javaClass == null) {
            issues.add(this.getMessage("Tag not declared in a Java Class"));
        } else if (!this.isAbstract) {
            if (!javaClass.isPublic()) {
                issues.add(this.getMessage("Class must be pubic: " + javaClass.getName()));
            }
            if (javaClass.isAbstract() || javaClass.isInterface()) {
                issues.add(this.getMessage("Class must be concrete class (not abstract or interface) : " + javaClass.getName()));
            }
            if (issues.size() == 0) {
                this.checkActivationMethod(javaClass, "activate", warnings);
                this.checkActivationMethod(javaClass, "deactivate", warnings);
                boolean constructorFound = true;
                JavaMethod[] methods = javaClass.getMethods();
                for (int i = 0; methods != null && i < methods.length; ++i) {
                    if (!methods[i].isConstructor()) continue;
                    if (methods[i].isPublic() && (methods[i].getParameters() == null || methods[i].getParameters().length == 0)) {
                        constructorFound = true;
                        break;
                    }
                    constructorFound = false;
                }
                if (!constructorFound) {
                    issues.add(this.getMessage("Class must have public default constructor: " + javaClass.getName()));
                }
                Iterator pi = this.getProperties().iterator();
                while (pi.hasNext()) {
                    Property prop = (Property)pi.next();
                    prop.validate(issues, warnings);
                }
                if (this.getService() != null) {
                    this.getService().validate(issues, warnings);
                }
                if (this.isServiceFactory() && this.isImmediate() != null && this.isImmediate().booleanValue() && this.getFactory() != null) {
                    issues.add(this.getMessage("Component must not be a ServiceFactory, if immediate and/or component factory: " + javaClass.getName()));
                }
                Iterator ri = this.getReferences().iterator();
                while (ri.hasNext()) {
                    Reference ref = (Reference)ri.next();
                    ref.validate(issues, warnings);
                }
            }
        }
    }

    protected void checkActivationMethod(JavaClassDescription javaClass, String methodName, List warnings) {
        JavaMethod[] methods = javaClass.getMethods();
        JavaMethod activation = null;
        for (int i = 0; i < methods.length; ++i) {
            JavaParameter[] params;
            if (!methodName.equals(methods[i].getName()) || (params = methods[i].getParameters()) == null || params.length != 1) continue;
            if (activation != null) {
                return;
            }
            activation = methods[i];
        }
        if (activation == null) {
            return;
        }
        if (activation.isPublic()) {
            warnings.add(this.getMessage("Activation method " + activation.getName() + " should be declared protected"));
        } else if (!activation.isProtected()) {
            warnings.add(this.getMessage("Activation method " + activation.getName() + " has wrong qualifier, public or protected required"));
        }
        JavaParameter param = activation.getParameters()[0];
        if (!"org.osgi.service.component.ComponentContext".equals(param.getType())) {
            warnings.add(this.getMessage("Activation method " + methodName + " has wrong argument type " + param.getType()));
        }
    }
}

