/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.tags.qdox;

import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.model.Type;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.felix.scrplugin.tags.JavaClassDescription;
import org.apache.felix.scrplugin.tags.JavaClassDescriptorManager;
import org.apache.felix.scrplugin.tags.JavaField;
import org.apache.felix.scrplugin.tags.JavaMethod;
import org.apache.felix.scrplugin.tags.JavaTag;
import org.apache.felix.scrplugin.tags.qdox.QDoxJavaField;
import org.apache.felix.scrplugin.tags.qdox.QDoxJavaMethod;
import org.apache.felix.scrplugin.tags.qdox.QDoxJavaTag;
import org.apache.maven.plugin.MojoExecutionException;

public class QDoxJavaClassDescription
implements JavaClassDescription {
    protected final JavaClass javaClass;
    protected final JavaClassDescriptorManager manager;

    public QDoxJavaClassDescription(JavaSource source, JavaClassDescriptorManager m) {
        this.javaClass = source.getClasses()[0];
        this.manager = m;
    }

    public JavaClassDescription getSuperClass() throws MojoExecutionException {
        JavaClass parent = this.javaClass.getSuperJavaClass();
        if (parent != null) {
            return this.manager.getJavaClassDescription(parent.getFullyQualifiedName());
        }
        return null;
    }

    public JavaTag getTagByName(String name) {
        DocletTag tag = this.javaClass.getTagByName(name);
        if (tag == null) {
            return null;
        }
        return new QDoxJavaTag(tag, this);
    }

    public String getName() {
        return this.javaClass.getFullyQualifiedName();
    }

    public JavaTag[] getTagsByName(String name, boolean inherited) throws MojoExecutionException {
        JavaTag[] superTags;
        JavaTag[] javaTags;
        DocletTag[] tags = this.javaClass.getTagsByName(name, false);
        if (tags == null || tags.length == 0) {
            javaTags = new JavaTag[]{};
        } else {
            javaTags = new JavaTag[tags.length];
            for (int i = 0; i < tags.length; ++i) {
                javaTags[i] = new QDoxJavaTag(tags[i], this);
            }
        }
        if (inherited && this.getSuperClass() != null && (superTags = this.getSuperClass().getTagsByName(name, inherited)).length > 0) {
            ArrayList<JavaTag> list = new ArrayList<JavaTag>(Arrays.asList(javaTags));
            list.addAll(Arrays.asList(superTags));
            javaTags = list.toArray(new JavaTag[list.size()]);
        }
        return javaTags;
    }

    public JavaField[] getFields() {
        com.thoughtworks.qdox.model.JavaField[] fields = this.javaClass.getFields();
        if (fields == null || fields.length == 0) {
            return new JavaField[0];
        }
        JavaField[] f = new JavaField[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            f[i] = new QDoxJavaField(fields[i], this);
        }
        return f;
    }

    public JavaClassDescription[] getImplementedInterfaces() throws MojoExecutionException {
        JavaClass[] interfaces = this.javaClass.getImplementedInterfaces();
        if (interfaces == null || interfaces.length == 0) {
            return new JavaClassDescription[0];
        }
        JavaClassDescription[] descs = new JavaClassDescription[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            descs[i] = this.manager.getJavaClassDescription(interfaces[i].getFullyQualifiedName());
        }
        return descs;
    }

    public JavaMethod getMethodBySignature(String name, String[] parameters) throws MojoExecutionException {
        Type[] types = null;
        if (parameters == null || parameters.length == 0) {
            types = new Type[]{};
        } else {
            types = new Type[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                types[i] = new Type(parameters[i]);
            }
        }
        com.thoughtworks.qdox.model.JavaMethod m = this.javaClass.getMethodBySignature(name, types);
        if (m == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().getMethodBySignature(name, parameters);
            }
            return null;
        }
        return new QDoxJavaMethod(m);
    }

    public JavaMethod[] getMethods() {
        com.thoughtworks.qdox.model.JavaMethod[] methods = this.javaClass.getMethods();
        if (methods == null || methods.length == 0) {
            return new JavaMethod[0];
        }
        JavaMethod[] m = new JavaMethod[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            m[i] = new QDoxJavaMethod(methods[i]);
        }
        return m;
    }

    public boolean isA(String type) throws MojoExecutionException {
        Type qType = new Type(type);
        if (this.javaClass.isA(type)) {
            return true;
        }
        Type[] interfaces = this.javaClass.getImplements();
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                if (!interfaces[i].isA(qType)) continue;
                return true;
            }
        }
        if (this.getSuperClass() != null) {
            return this.getSuperClass().isA(type);
        }
        return false;
    }

    public boolean isAbstract() {
        return this.javaClass.isAbstract();
    }

    public boolean isInterface() {
        return this.javaClass.isInterface();
    }

    public boolean isPublic() {
        return this.javaClass.isPublic();
    }
}

