/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.xml;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerException;
import org.apache.felix.scrplugin.om.Component;
import org.apache.felix.scrplugin.om.Components;
import org.apache.felix.scrplugin.om.Implementation;
import org.apache.felix.scrplugin.om.Interface;
import org.apache.felix.scrplugin.om.Property;
import org.apache.felix.scrplugin.om.Reference;
import org.apache.felix.scrplugin.om.Service;
import org.apache.felix.scrplugin.xml.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class ComponentDescriptorIO {
    public static final String NAMESPACE_URI = "http://www.osgi.org/xmlns/scr/v1.0.0";
    private static final String PREFIX = "scr";
    private static final String COMPONENTS = "components";
    private static final String COMPONENT = "component";
    private static final String COMPONENT_QNAME = "scr:component";
    private static final String IMPLEMENTATION = "implementation";
    private static final String IMPLEMENTATION_QNAME = "scr:implementation";
    private static final String SERVICE = "service";
    private static final String SERVICE_QNAME = "scr:service";
    private static final String PROPERTY = "property";
    private static final String PROPERTY_QNAME = "scr:property";
    private static final String REFERENCE = "reference";
    private static final String REFERENCE_QNAME = "scr:reference";
    private static final String INTERFACE = "provide";
    private static final String INTERFACE_QNAME = "scr:provide";

    public static Components read(File file) throws MojoExecutionException {
        try {
            XmlHandler xmlHandler = new XmlHandler();
            IOUtils.parse(file, xmlHandler);
            return xmlHandler.components;
        }
        catch (TransformerException e) {
            throw new MojoExecutionException("Unable to read xml.", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read xml from " + file, (Exception)e);
        }
    }

    public static void write(Components components, File file, boolean isScrPrivateFile) throws MojoExecutionException {
        try {
            ComponentDescriptorIO.generateXML(components, IOUtils.getSerializer(file), isScrPrivateFile);
        }
        catch (TransformerException e) {
            throw new MojoExecutionException("Unable to write xml to " + file, (Exception)e);
        }
        catch (SAXException e) {
            throw new MojoExecutionException("Unable to generate xml for " + file, (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write xml to " + file, (Exception)e);
        }
    }

    protected static void generateXML(Components components, ContentHandler contentHandler, boolean isScrPrivateFile) throws SAXException {
        contentHandler.startDocument();
        contentHandler.startPrefixMapping(PREFIX, NAMESPACE_URI);
        contentHandler.startElement("", COMPONENTS, COMPONENTS, new AttributesImpl());
        IOUtils.newline(contentHandler);
        Iterator i = components.getComponents().iterator();
        while (i.hasNext()) {
            Component component = (Component)i.next();
            ComponentDescriptorIO.generateXML(component, contentHandler, isScrPrivateFile);
        }
        contentHandler.endElement("", COMPONENTS, COMPONENTS);
        IOUtils.newline(contentHandler);
        contentHandler.endPrefixMapping(PREFIX);
        contentHandler.endDocument();
    }

    protected static void generateXML(Component component, ContentHandler contentHandler, boolean isScrPrivateFile) throws SAXException {
        Iterator i;
        AttributesImpl ai = new AttributesImpl();
        IOUtils.addAttribute(ai, "enabled", component.isEnabled());
        IOUtils.addAttribute(ai, "immediate", component.isImmediate());
        IOUtils.addAttribute(ai, "name", component.getName());
        IOUtils.addAttribute(ai, "factory", component.getFactory());
        IOUtils.indent(contentHandler, 1);
        contentHandler.startElement(NAMESPACE_URI, COMPONENT, COMPONENT_QNAME, ai);
        IOUtils.newline(contentHandler);
        ComponentDescriptorIO.generateXML(component.getImplementation(), contentHandler);
        if (component.getService() != null) {
            ComponentDescriptorIO.generateXML(component.getService(), contentHandler);
        }
        if (component.getProperties() != null) {
            i = component.getProperties().iterator();
            while (i.hasNext()) {
                Property property = (Property)i.next();
                ComponentDescriptorIO.generateXML(property, contentHandler, isScrPrivateFile);
            }
        }
        if (component.getReferences() != null) {
            i = component.getReferences().iterator();
            while (i.hasNext()) {
                Reference reference = (Reference)i.next();
                ComponentDescriptorIO.generateXML(reference, contentHandler);
            }
        }
        IOUtils.indent(contentHandler, 1);
        contentHandler.endElement(NAMESPACE_URI, COMPONENT, COMPONENT_QNAME);
        IOUtils.newline(contentHandler);
    }

    protected static void generateXML(Implementation implementation, ContentHandler contentHandler) throws SAXException {
        AttributesImpl ai = new AttributesImpl();
        IOUtils.addAttribute(ai, "class", implementation.getClassame());
        IOUtils.indent(contentHandler, 2);
        contentHandler.startElement(NAMESPACE_URI, IMPLEMENTATION, IMPLEMENTATION_QNAME, ai);
        contentHandler.endElement(NAMESPACE_URI, IMPLEMENTATION, IMPLEMENTATION_QNAME);
        IOUtils.newline(contentHandler);
    }

    protected static void generateXML(Service service, ContentHandler contentHandler) throws SAXException {
        AttributesImpl ai = new AttributesImpl();
        IOUtils.addAttribute(ai, "servicefactory", String.valueOf(service.isServicefactory()));
        IOUtils.indent(contentHandler, 2);
        contentHandler.startElement(NAMESPACE_URI, SERVICE, SERVICE_QNAME, ai);
        if (service.getInterfaces() != null && service.getInterfaces().size() > 0) {
            IOUtils.newline(contentHandler);
            Iterator i = service.getInterfaces().iterator();
            while (i.hasNext()) {
                Interface interf = (Interface)i.next();
                ComponentDescriptorIO.generateXML(interf, contentHandler);
            }
            IOUtils.indent(contentHandler, 2);
        }
        contentHandler.endElement(NAMESPACE_URI, SERVICE, SERVICE_QNAME);
        IOUtils.newline(contentHandler);
    }

    protected static void generateXML(Interface interf, ContentHandler contentHandler) throws SAXException {
        AttributesImpl ai = new AttributesImpl();
        IOUtils.addAttribute(ai, "interface", interf.getInterfacename());
        IOUtils.indent(contentHandler, 3);
        contentHandler.startElement(NAMESPACE_URI, INTERFACE, INTERFACE_QNAME, ai);
        contentHandler.endElement(NAMESPACE_URI, INTERFACE, INTERFACE_QNAME);
        IOUtils.newline(contentHandler);
    }

    protected static void generateXML(Property property, ContentHandler contentHandler, boolean isScrPrivateFile) throws SAXException {
        AttributesImpl ai = new AttributesImpl();
        IOUtils.addAttribute(ai, "name", property.getName());
        IOUtils.addAttribute(ai, "type", property.getType());
        IOUtils.addAttribute(ai, "value", property.getValue());
        if (isScrPrivateFile) {
            IOUtils.addAttribute(ai, "private", String.valueOf(property.isPrivate()));
            if (property.getLabel() != null) {
                IOUtils.addAttribute(ai, "label", String.valueOf(property.getLabel()));
            }
            if (property.getDescription() != null) {
                IOUtils.addAttribute(ai, "description", String.valueOf(property.getDescription()));
            }
            if (property.getCardinality() != null) {
                IOUtils.addAttribute(ai, "cardinality", String.valueOf(property.getCardinality()));
            }
        }
        IOUtils.indent(contentHandler, 2);
        contentHandler.startElement(NAMESPACE_URI, PROPERTY, PROPERTY_QNAME, ai);
        if (property.getMultiValue() != null && property.getMultiValue().length > 0) {
            IOUtils.text(contentHandler, "\n");
            for (int i = 0; i < property.getMultiValue().length; ++i) {
                IOUtils.indent(contentHandler, 3);
                IOUtils.text(contentHandler, property.getMultiValue()[i]);
                IOUtils.newline(contentHandler);
            }
            IOUtils.indent(contentHandler, 2);
        }
        contentHandler.endElement(NAMESPACE_URI, PROPERTY, PROPERTY_QNAME);
        IOUtils.newline(contentHandler);
    }

    protected static void generateXML(Reference reference, ContentHandler contentHandler) throws SAXException {
        AttributesImpl ai = new AttributesImpl();
        IOUtils.addAttribute(ai, "name", reference.getName());
        IOUtils.addAttribute(ai, "interface", reference.getInterfacename());
        IOUtils.addAttribute(ai, "cardinality", reference.getCardinality());
        IOUtils.addAttribute(ai, "policy", reference.getPolicy());
        IOUtils.addAttribute(ai, "target", reference.getTarget());
        IOUtils.addAttribute(ai, "bind", reference.getBind());
        IOUtils.addAttribute(ai, "unbind", reference.getUnbind());
        IOUtils.indent(contentHandler, 2);
        contentHandler.startElement(NAMESPACE_URI, REFERENCE, REFERENCE_QNAME, ai);
        contentHandler.endElement(NAMESPACE_URI, REFERENCE, REFERENCE_QNAME);
        IOUtils.newline(contentHandler);
    }

    protected static final class XmlHandler
    extends DefaultHandler {
        protected final Components components = new Components();
        protected Component currentComponent;
        protected Service currentService;
        protected Property pendingProperty;
        protected boolean firstElement = true;
        protected String overrideNamespace;

        protected XmlHandler() {
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (this.firstElement) {
                this.firstElement = false;
                if (localName.equals(ComponentDescriptorIO.COMPONENT) && "".equals(uri)) {
                    this.overrideNamespace = ComponentDescriptorIO.NAMESPACE_URI;
                }
            }
            if (this.overrideNamespace != null && "".equals(uri)) {
                uri = this.overrideNamespace;
            }
            if (ComponentDescriptorIO.NAMESPACE_URI.equals(uri)) {
                if (localName.equals(ComponentDescriptorIO.COMPONENT)) {
                    this.currentComponent = new Component();
                    this.currentComponent.setName(attributes.getValue("name"));
                    if (attributes.getValue("enabled") != null) {
                        this.currentComponent.setEnabled(Boolean.valueOf(attributes.getValue("enabled")));
                    }
                    if (attributes.getValue("immediate") != null) {
                        this.currentComponent.setImmediate(Boolean.valueOf(attributes.getValue("immediate")));
                    }
                    this.currentComponent.setFactory(attributes.getValue("factory"));
                } else if (localName.equals(ComponentDescriptorIO.IMPLEMENTATION)) {
                    Implementation impl = new Implementation();
                    this.currentComponent.setImplementation(impl);
                    impl.setClassname(attributes.getValue("class"));
                } else if (localName.equals(ComponentDescriptorIO.PROPERTY)) {
                    Property prop = new Property();
                    prop.setName(attributes.getValue("name"));
                    prop.setType(attributes.getValue("type"));
                    if (attributes.getValue("value") != null) {
                        prop.setValue(attributes.getValue("value"));
                        this.currentComponent.addProperty(prop);
                    } else {
                        this.pendingProperty = prop;
                    }
                    prop.setLabel(attributes.getValue("label"));
                    prop.setDescription(attributes.getValue("description"));
                    prop.setCardinality(attributes.getValue("cardinality"));
                    String pValue = attributes.getValue("private");
                    if (pValue != null) {
                        prop.setPrivate(Boolean.valueOf(pValue));
                    }
                } else if (!localName.equals("properties")) {
                    if (localName.equals(ComponentDescriptorIO.SERVICE)) {
                        this.currentService = new Service();
                        this.currentService.setServicefactory(attributes.getValue("servicefactory"));
                        this.currentComponent.setService(this.currentService);
                    } else if (localName.equals(ComponentDescriptorIO.INTERFACE)) {
                        Interface interf = new Interface();
                        this.currentService.addInterface(interf);
                        interf.setInterfacename(attributes.getValue("interface"));
                    } else if (localName.equals(ComponentDescriptorIO.REFERENCE)) {
                        Reference ref = new Reference();
                        ref.setName(attributes.getValue("name"));
                        ref.setInterfacename(attributes.getValue("interface"));
                        ref.setCardinality(attributes.getValue("cardinality"));
                        ref.setPolicy(attributes.getValue("policy"));
                        ref.setTarget(attributes.getValue("target"));
                        ref.setBind(attributes.getValue("bind"));
                        ref.setUnbind(attributes.getValue("unbind"));
                        this.currentComponent.addReference(ref);
                    }
                }
            }
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            if (this.overrideNamespace != null && "".equals(uri)) {
                uri = this.overrideNamespace;
            }
            if (ComponentDescriptorIO.NAMESPACE_URI.equals(uri)) {
                if (localName.equals(ComponentDescriptorIO.COMPONENT)) {
                    this.components.addComponent(this.currentComponent);
                    this.currentComponent = null;
                } else if (localName.equals(ComponentDescriptorIO.PROPERTY) && this.pendingProperty != null) {
                    String text = this.pendingProperty.getValue();
                    if (text != null) {
                        StringTokenizer st = new StringTokenizer(text);
                        String[] values = new String[st.countTokens()];
                        int index = 0;
                        while (st.hasMoreTokens()) {
                            values[index] = st.nextToken();
                            ++index;
                        }
                        this.pendingProperty.setMultiValue(values);
                    }
                    this.currentComponent.addProperty(this.pendingProperty);
                    this.pendingProperty = null;
                }
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.pendingProperty != null) {
                String text = new String(ch, start, length);
                if (this.pendingProperty.getValue() == null) {
                    this.pendingProperty.setValue(text);
                } else {
                    this.pendingProperty.setValue(this.pendingProperty.getValue() + text);
                }
            }
        }
    }
}

