/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.om;

import org.apache.felix.scrplugin.IssueLog;
import org.apache.felix.scrplugin.om.AbstractObject;
import org.apache.felix.scrplugin.tags.JavaClassDescription;
import org.apache.felix.scrplugin.tags.JavaMethod;
import org.apache.felix.scrplugin.tags.JavaTag;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.StringUtils;

public class Reference
extends AbstractObject {
    protected String name;
    protected String interfacename;
    protected String target;
    protected String cardinality;
    protected String policy;
    protected String bind;
    protected String unbind;
    protected String strategy;
    protected boolean checked = false;
    protected final JavaClassDescription javaClassDescription;
    private static final String TYPE_SERVICE_REFERENCE = "org.osgi.framework.ServiceReference";
    private static final String TYPE_MAP = "java.util.Map";

    public Reference() {
        this(null, null);
    }

    public Reference(JavaTag t, JavaClassDescription desc) {
        super(t);
        this.javaClassDescription = desc;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getInterfacename() {
        return this.interfacename;
    }

    public void setInterfacename(String interfacename) {
        this.interfacename = interfacename;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(String cardinality) {
        this.cardinality = cardinality;
    }

    public String getPolicy() {
        return this.policy;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public String getBind() {
        return this.bind;
    }

    public void setBind(String bind) {
        this.bind = bind;
    }

    public String getUnbind() {
        return this.unbind;
    }

    public void setUnbind(String unbind) {
        this.unbind = unbind;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public String getStrategy() {
        return this.strategy;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public boolean isLookupStrategy() {
        return "lookup".equals(this.getStrategy());
    }

    public void validate(int specVersion, boolean componentIsAbstract, IssueLog iLog) throws MojoExecutionException {
        if (this.checked) {
            return;
        }
        int currentIssueCount = iLog.getNumberOfErrors();
        if (StringUtils.isEmpty((String)this.name)) {
            iLog.addError(this.getMessage("Reference has no name"));
        }
        if (StringUtils.isEmpty((String)this.interfacename)) {
            iLog.addError(this.getMessage("Missing interface name"));
        }
        if (this.cardinality == null) {
            this.cardinality = "1..1";
        } else if (!("0..1".equals(this.cardinality) || "1..1".equals(this.cardinality) || "0..n".equals(this.cardinality) || "1..n".equals(this.cardinality))) {
            iLog.addError(this.getMessage("Invalid Cardinality specification " + this.cardinality));
        }
        if (this.policy == null) {
            this.policy = "static";
        } else if (!"static".equals(this.policy) && !"dynamic".equals(this.policy)) {
            iLog.addError(this.getMessage("Invalid Policy specification " + this.policy));
        }
        if (this.strategy == null) {
            this.strategy = "event";
        } else if (!"event".equals(this.strategy) && !"lookup".equals(this.strategy)) {
            iLog.addError(this.getMessage("Invalid strategy type " + this.strategy));
        }
        if (!this.isLookupStrategy()) {
            if (this.bind == null) {
                this.setBind("bind");
            }
            if (this.unbind == null) {
                this.setUnbind("unbind");
            }
            String oldBind = this.bind;
            String oldUnbind = this.unbind;
            this.bind = this.validateMethod(specVersion, this.bind, componentIsAbstract, iLog);
            this.unbind = this.validateMethod(specVersion, this.unbind, componentIsAbstract, iLog);
            if (iLog.getNumberOfErrors() == currentIssueCount) {
                if (this.bind != null && this.unbind != null) {
                    this.checked = true;
                } else {
                    if (this.bind == null) {
                        this.bind = oldBind;
                    }
                    if (this.unbind == null) {
                        this.unbind = oldUnbind;
                    }
                }
            }
        } else {
            this.bind = null;
            this.unbind = null;
        }
    }

    protected String validateMethod(int specVersion, String methodName, boolean componentIsAbstract, IssueLog iLog) throws MojoExecutionException {
        JavaMethod method = this.findMethod(specVersion, methodName);
        if (method == null) {
            if (!componentIsAbstract) {
                iLog.addError(this.getMessage("Missing method " + methodName + " for reference " + this.getName()));
            }
            return null;
        }
        if (specVersion == 0) {
            if (method.isPublic()) {
                iLog.addWarning(this.getMessage("Method " + method.getName() + " should be declared protected"));
            } else if (!method.isProtected()) {
                iLog.addError(this.getMessage("Method " + method.getName() + " has wrong qualifier, public or protected required"));
                return null;
            }
        }
        return method.getName();
    }

    public JavaMethod findMethod(int specVersion, String methodName) throws MojoExecutionException {
        String[] sig = new String[]{TYPE_SERVICE_REFERENCE};
        String[] sig2 = new String[]{this.getInterfacename()};
        String[] sig3 = new String[]{this.getInterfacename(), TYPE_MAP};
        String realMethodName = methodName;
        JavaMethod method = this.javaClassDescription.getMethodBySignature(realMethodName, sig);
        if (method == null) {
            method = this.javaClassDescription.getMethodBySignature(realMethodName, sig2);
            if (specVersion == 1 && method == null) {
                method = this.javaClassDescription.getMethodBySignature(realMethodName, sig3);
            }
        }
        if (method == null) {
            realMethodName = methodName + Character.toUpperCase(this.name.charAt(0)) + this.name.substring(1);
            method = this.javaClassDescription.getMethodBySignature(realMethodName, sig);
        }
        if (method == null) {
            method = this.javaClassDescription.getMethodBySignature(realMethodName, sig2);
            if (specVersion == 1 && method == null) {
                method = this.javaClassDescription.getMethodBySignature(realMethodName, sig3);
            }
        }
        if (method == null) {
            int lastDot = this.getInterfacename().lastIndexOf(46);
            realMethodName = methodName + this.getInterfacename().substring(lastDot + 1);
            method = this.javaClassDescription.getMethodBySignature(realMethodName, sig);
        }
        if (method == null) {
            method = this.javaClassDescription.getMethodBySignature(realMethodName, sig2);
            if (specVersion == 1 && method == null) {
                method = this.javaClassDescription.getMethodBySignature(realMethodName, sig3);
            }
        }
        return method;
    }
}

