/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.tags.annotation.sling;

import com.thoughtworks.qdox.model.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.felix.scrplugin.tags.JavaField;
import org.apache.felix.scrplugin.tags.JavaTag;
import org.apache.felix.scrplugin.tags.annotation.AnnotationJavaClassDescription;
import org.apache.felix.scrplugin.tags.annotation.AnnotationTagProvider;
import org.apache.felix.scrplugin.tags.annotation.defaulttag.Util;
import org.apache.felix.scrplugin.tags.annotation.sling.SlingServletComponentTag;
import org.apache.felix.scrplugin.tags.annotation.sling.SlingServletPropertyTag;
import org.apache.felix.scrplugin.tags.annotation.sling.SlingServletServiceTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlingAnnotationTagProvider
implements AnnotationTagProvider {
    @Override
    public List<JavaTag> getTags(Annotation annotation, AnnotationJavaClassDescription description, JavaField field) {
        ArrayList<JavaTag> tags = new ArrayList<JavaTag>();
        if (annotation.getType().getJavaClass().getFullyQualifiedName().equals(SlingServlet.class.getName())) {
            String[] methods;
            String[] extensions;
            String[] selectors;
            String[] resourceTypes;
            String[] paths;
            boolean generateService;
            boolean generateComponent = Util.getBooleanValue(annotation, "generateComponent", SlingServlet.class);
            if (generateComponent) {
                tags.add(new SlingServletComponentTag(annotation, description));
            }
            if (generateService = Util.getBooleanValue(annotation, "generateService", SlingServlet.class)) {
                tags.add(new SlingServletServiceTag(annotation, description));
            }
            if ((paths = Util.getStringValues(annotation, description, "paths")) != null && paths.length != 0) {
                tags.add(new SlingServletPropertyTag(annotation, "sling.servlet.paths", paths, description));
            }
            if ((resourceTypes = Util.getStringValues(annotation, description, "resourceTypes")) != null && resourceTypes.length != 0) {
                tags.add(new SlingServletPropertyTag(annotation, "sling.servlet.resourceTypes", resourceTypes, description));
            }
            if ((selectors = Util.getStringValues(annotation, description, "selectors")) != null && selectors.length != 0) {
                tags.add(new SlingServletPropertyTag(annotation, "sling.servlet.selectors", selectors, description));
            }
            if ((extensions = Util.getStringValues(annotation, description, "extensions")) != null && extensions.length != 0) {
                tags.add(new SlingServletPropertyTag(annotation, "sling.servlet.extensions", extensions, description));
            }
            if ((methods = Util.getStringValues(annotation, description, "methods")) != null && methods.length != 0) {
                tags.add(new SlingServletPropertyTag(annotation, "sling.servlet.methods", methods, description));
            }
        }
        return tags;
    }
}

