/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.converter;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.osgi.util.converter.ConversionException;
import org.osgi.util.converter.Converter;
import org.osgi.util.converter.ConverterBuilder;
import org.osgi.util.converter.ConverterBuilderImpl;
import org.osgi.util.converter.ConverterFunction;
import org.osgi.util.converter.Converting;
import org.osgi.util.converter.Functioning;
import org.osgi.util.converter.FunctioningImpl;
import org.osgi.util.converter.InternalConverter;
import org.osgi.util.converter.InternalConverting;
import org.osgi.util.converter.TypeReference;
import org.osgi.util.converter.Util;

class CustomConverterImpl
implements InternalConverter {
    private final InternalConverter delegate;
    final Map<Type, List<ConverterFunction>> typeRules;
    final List<ConverterFunction> allRules;
    final List<ConverterFunction> errorHandlers;

    CustomConverterImpl(InternalConverter converter, Map<Type, List<ConverterFunction>> rules, List<ConverterFunction> catchAllRules, List<ConverterFunction> errHandlers) {
        this.delegate = converter;
        this.typeRules = rules;
        this.allRules = catchAllRules;
        this.errorHandlers = errHandlers;
    }

    @Override
    public InternalConverting convert(Object obj) {
        InternalConverting converting = this.delegate.convert(obj);
        converting.setConverter(this);
        return new ConvertingWrapper(obj, converting);
    }

    @Override
    public Functioning function() {
        return new FunctioningImpl(this);
    }

    @Override
    public ConverterBuilder newConverterBuilder() {
        return new ConverterBuilderImpl(this);
    }

    private class ConvertingWrapper
    implements InternalConverting {
        private final InternalConverting del;
        private final Object object;
        private volatile Object defaultValue;
        private volatile boolean hasDefault;

        ConvertingWrapper(Object obj, InternalConverting c) {
            this.object = obj;
            this.del = c;
        }

        @Override
        public Converting view() {
            this.del.view();
            return this;
        }

        @Override
        public Converting defaultValue(Object defVal) {
            this.del.defaultValue(defVal);
            this.defaultValue = defVal;
            this.hasDefault = true;
            return this;
        }

        @Override
        public Converting keysIgnoreCase() {
            this.del.keysIgnoreCase();
            return this;
        }

        @Override
        public void setConverter(Converter c) {
            this.del.setConverter(c);
        }

        @Override
        public Converting sourceAs(Class<?> type) {
            this.del.sourceAs(type);
            return this;
        }

        @Override
        public Converting sourceAsBean() {
            this.del.sourceAsBean();
            return this;
        }

        @Override
        public Converting sourceAsDTO() {
            this.del.sourceAsDTO();
            return this;
        }

        @Override
        public Converting targetAs(Class<?> cls) {
            this.del.targetAs(cls);
            return this;
        }

        @Override
        public Converting targetAsBean() {
            this.del.targetAsBean();
            return this;
        }

        @Override
        public Converting targetAsDTO() {
            this.del.targetAsDTO();
            return this;
        }

        @Override
        public <T> T to(Class<T> cls) {
            Class<T> type = cls;
            return (T)this.to((Type)type);
        }

        @Override
        public <T> T to(TypeReference<T> ref) {
            return (T)this.to(ref.getType());
        }

        public Object to(Type type) {
            List<ConverterFunction> tr = CustomConverterImpl.this.typeRules.get(Util.baseType(type));
            if (tr == null) {
                tr = Collections.emptyList();
            }
            ArrayList<ConverterFunction> converters = new ArrayList<ConverterFunction>(tr.size() + CustomConverterImpl.this.allRules.size());
            converters.addAll(tr);
            converters.addAll(CustomConverterImpl.this.allRules);
            try {
                Object result;
                if (this.object != null) {
                    for (ConverterFunction cf : converters) {
                        try {
                            Object res = cf.apply(this.object, type);
                            if (res == ConverterFunction.CANNOT_HANDLE) continue;
                            return res;
                        }
                        catch (Exception ex) {
                            if (this.hasDefault) {
                                return this.defaultValue;
                            }
                            throw new ConversionException("Cannot convert " + this.object + " to " + type, ex);
                        }
                    }
                }
                if ((result = this.del.to(type)) != null && Proxy.isProxyClass(result.getClass()) && CustomConverterImpl.this.errorHandlers.size() > 0) {
                    return this.wrapErrorHandling(result);
                }
                return result;
            }
            catch (Exception ex) {
                for (ConverterFunction eh : CustomConverterImpl.this.errorHandlers) {
                    try {
                        Object handled = eh.apply(this.object, type);
                        if (handled == ConverterFunction.CANNOT_HANDLE) continue;
                        return handled;
                    }
                    catch (RuntimeException re) {
                        throw re;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                throw ex;
            }
        }

        private Object wrapErrorHandling(final Object wrapped) {
            final Class<?> cls = wrapped.getClass();
            return Proxy.newProxyInstance(cls.getClassLoader(), cls.getInterfaces(), new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    Class<?> mdDecl = method.getDeclaringClass();
                    if (mdDecl.equals(Object.class)) {
                        switch (method.getName()) {
                            case "equals": {
                                return proxy == args[0];
                            }
                            case "hashCode": {
                                return System.identityHashCode(proxy);
                            }
                            case "toString": {
                                return "Proxy for " + cls;
                            }
                        }
                        throw new UnsupportedOperationException("Method " + method + " not supported on proxy for " + cls);
                    }
                    try {
                        return method.invoke(wrapped, args);
                    }
                    catch (Exception ex) {
                        for (ConverterFunction eh : CustomConverterImpl.this.errorHandlers) {
                            try {
                                Object handled = eh.apply(wrapped, method.getGenericReturnType());
                                if (handled == ConverterFunction.CANNOT_HANDLE) continue;
                                return handled;
                            }
                            catch (RuntimeException re) {
                                throw re;
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                        return null;
                    }
                }
            });
        }

        public String toString() {
            return this.to(String.class);
        }
    }
}

