/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dependencymanager;

import java.util.List;
import org.apache.felix.dependencymanager.ConfigurationDependency;
import org.apache.felix.dependencymanager.DependencyManager;
import org.apache.felix.dependencymanager.Logger;
import org.apache.felix.dependencymanager.Service;
import org.apache.felix.dependencymanager.ServiceDependency;
import org.apache.felix.dependencymanager.ServiceImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public abstract class DependencyActivatorBase
implements BundleActivator {
    private BundleContext m_context;
    private DependencyManager m_manager;
    private Logger m_logger;

    public abstract void init(BundleContext var1, DependencyManager var2) throws Exception;

    public abstract void destroy(BundleContext var1, DependencyManager var2) throws Exception;

    public void start(BundleContext context) throws Exception {
        this.m_context = context;
        this.m_logger = new Logger(context);
        this.m_manager = new DependencyManager(context, this.m_logger);
        this.init(this.m_context, this.m_manager);
    }

    public void stop(BundleContext context) throws Exception {
        this.destroy(this.m_context, this.m_manager);
        this.cleanup(this.m_manager);
        this.m_manager = null;
        this.m_context = null;
    }

    public Service createService() {
        return new ServiceImpl(this.m_context, this.m_manager, this.m_logger);
    }

    public ServiceDependency createServiceDependency() {
        return new ServiceDependency(this.m_context, this.m_logger);
    }

    public ConfigurationDependency createConfigurationDependency() {
        return new ConfigurationDependency(this.m_context, this.m_logger);
    }

    private void cleanup(DependencyManager manager) {
        List services = manager.getServices();
        for (int i = services.size() - 1; i >= 0; --i) {
            Service service = (Service)services.get(i);
            manager.remove(service);
            if (!(service instanceof ServiceImpl)) continue;
            ServiceImpl si = (ServiceImpl)service;
            si.removeStateListeners();
        }
    }
}

