/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm;

import org.apache.felix.dm.BundleDependency;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.ConfigurationDependency;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.PropertyMetaData;
import org.apache.felix.dm.ResourceDependency;
import org.apache.felix.dm.ServiceDependency;
import org.apache.felix.dm.TemporalServiceDependency;
import org.apache.felix.dm.impl.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public abstract class DependencyActivatorBase
implements BundleActivator {
    private BundleContext m_context;
    private DependencyManager m_manager;
    private Logger m_logger;

    public abstract void init(BundleContext var1, DependencyManager var2) throws Exception;

    public abstract void destroy(BundleContext var1, DependencyManager var2) throws Exception;

    public void start(BundleContext context) throws Exception {
        this.m_context = context;
        this.m_logger = new Logger(context);
        this.m_manager = new DependencyManager(context, this.m_logger);
        this.init(this.m_context, this.m_manager);
    }

    public void stop(BundleContext context) throws Exception {
        this.destroy(this.m_context, this.m_manager);
        this.m_manager.clear();
        this.m_manager = null;
        this.m_context = null;
    }

    public BundleContext getBundleContext() {
        return this.m_context;
    }

    public DependencyManager getDependencyManager() {
        return this.m_manager;
    }

    public Logger getLogger() {
        return this.m_logger;
    }

    public Component createComponent() {
        return this.m_manager.createComponent();
    }

    public ServiceDependency createServiceDependency() {
        return this.m_manager.createServiceDependency();
    }

    public TemporalServiceDependency createTemporalServiceDependency() {
        return this.m_manager.createTemporalServiceDependency();
    }

    public ConfigurationDependency createConfigurationDependency() {
        return this.m_manager.createConfigurationDependency();
    }

    public PropertyMetaData createPropertyMetaData() {
        return this.m_manager.createPropertyMetaData();
    }

    public BundleDependency createBundleDependency() {
        return this.m_manager.createBundleDependency();
    }

    public ResourceDependency createResourceDependency() {
        return this.m_manager.createResourceDependency();
    }

    public Component createAspectService(Class serviceInterface, String serviceFilter, int ranking, String attributeName) {
        return this.m_manager.createAspectService(serviceInterface, serviceFilter, ranking, attributeName);
    }

    public Component createAspectService(Class serviceInterface, String serviceFilter, int ranking) {
        return this.m_manager.createAspectService(serviceInterface, serviceFilter, ranking);
    }

    public Component createAspectService(Class serviceInterface, String serviceFilter, int ranking, String add, String change, String remove) {
        return this.m_manager.createAspectService(serviceInterface, serviceFilter, ranking, add, change, remove);
    }

    public Component createAdapterService(Class serviceInterface, String serviceFilter) {
        return this.m_manager.createAdapterService(serviceInterface, serviceFilter);
    }

    public Component createAdapterService(Class serviceInterface, String serviceFilter, String autoConfig) {
        return this.m_manager.createAdapterService(serviceInterface, serviceFilter, autoConfig);
    }

    public Component createAdapterService(Class serviceInterface, String serviceFilter, String add, String change, String remove) {
        return this.m_manager.createAdapterService(serviceInterface, serviceFilter, add, change, remove);
    }

    public Component createAdapterService(Class serviceInterface, String serviceFilter, String add, String change, String remove, String swap) {
        return this.m_manager.createAdapterService(serviceInterface, serviceFilter, add, change, remove, swap);
    }

    public Component createResourceAdapter(String resourceFilter, boolean propagate, Object callbackInstance, String callbackChanged) {
        return this.m_manager.createResourceAdapterService(resourceFilter, propagate, callbackInstance, callbackChanged);
    }

    public Component createResourceAdapter(String resourceFilter, boolean propagate, Object callbackInstance, String callbackSet, String callbackChanged) {
        return this.m_manager.createResourceAdapterService(resourceFilter, propagate, callbackInstance, callbackSet, callbackChanged);
    }

    public Component createResourceAdapter(String resourceFilter, Object propagateCallbackInstance, String propagateCallbackMethod, Object callbackInstance, String callbackChanged) {
        return this.m_manager.createResourceAdapterService(resourceFilter, propagateCallbackInstance, propagateCallbackMethod, callbackInstance, null, callbackChanged);
    }

    public Component createResourceAdapter(String resourceFilter, Object propagateCallbackInstance, String propagateCallbackMethod, Object callbackInstance, String callbackSet, String callbackChanged) {
        return this.m_manager.createResourceAdapterService(resourceFilter, propagateCallbackInstance, propagateCallbackMethod, callbackInstance, callbackSet, callbackChanged);
    }

    public Component createBundleAdapterService(int bundleStateMask, String bundleFilter, boolean propagate) {
        return this.m_manager.createBundleAdapterService(bundleStateMask, bundleFilter, propagate);
    }

    public Component createFactoryConfigurationAdapterService(String factoryPid, String update, boolean propagate) {
        return this.m_manager.createFactoryConfigurationAdapterService(factoryPid, update, propagate);
    }

    public Component createFactoryConfigurationAdapterService(String factoryPid, String update, boolean propagate, String heading, String desc, String localization, PropertyMetaData[] propertiesMetaData) {
        return this.m_manager.createFactoryConfigurationAdapterService(factoryPid, update, propagate, heading, desc, localization, propertiesMetaData);
    }
}

