/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import org.apache.felix.dm.FilterIndex;
import org.apache.felix.dm.ServiceUtil;
import org.apache.felix.dm.impl.index.AbstractFactoryFilterIndex;
import org.apache.felix.dm.tracker.ServiceTracker;
import org.apache.felix.dm.tracker.ServiceTrackerCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class AspectFilterIndex
extends AbstractFactoryFilterIndex
implements FilterIndex,
ServiceTrackerCustomizer {
    private static final String FILTER_START = "(&(objectClass=";
    private static final String FILTER_SUBSTRING_0 = ")(&(|(!(service.ranking=*))(service.ranking<=";
    private static final String FILTER_SUBSTRING_1 = "))(|(service.id=";
    private static final String FILTER_SUBSTRING_2 = ")(org.apache.felix.dependencymanager.aspect=";
    private static final String FILTER_END = "))))";
    private final Object m_lock = new Object();
    private ServiceTracker m_tracker;
    private BundleContext m_context;
    private final Map m_sidToObjectClassToRankingToListenersMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(BundleContext context) {
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_context != null) {
                throw new IllegalStateException("Filter already open.");
            }
            try {
                this.m_tracker = new ServiceTracker(context, context.createFilter("(objectClass=*)"), (ServiceTrackerCustomizer)this);
            }
            catch (InvalidSyntaxException e) {
                throw new Error();
            }
            this.m_context = context;
        }
        this.m_tracker.open(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ServiceTracker tracker;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_context == null) {
                throw new IllegalStateException("Filter already closed.");
            }
            tracker = this.m_tracker;
            this.m_tracker = null;
            this.m_context = null;
        }
        tracker.close();
    }

    public boolean isApplicable(String clazz, String filter) {
        return this.getFilterData(clazz, filter) != null;
    }

    private AbstractFactoryFilterIndex.FilterData getFilterData(String clazz, String filter) {
        if (filter != null && filter.startsWith(FILTER_START) && filter.endsWith(FILTER_END)) {
            long sid2;
            int i0 = filter.indexOf(FILTER_SUBSTRING_0);
            if (i0 == -1) {
                return null;
            }
            int i1 = filter.indexOf(FILTER_SUBSTRING_1);
            if (i1 == -1 || i1 <= i0) {
                return null;
            }
            int i2 = filter.indexOf(FILTER_SUBSTRING_2);
            if (i2 == -1 || i2 <= i1) {
                return null;
            }
            long sid = Long.parseLong(filter.substring(i1 + FILTER_SUBSTRING_1.length(), i2));
            if (sid != (sid2 = Long.parseLong(filter.substring(i2 + FILTER_SUBSTRING_2.length(), filter.length() - FILTER_END.length())))) {
                return null;
            }
            AbstractFactoryFilterIndex.FilterData result = new AbstractFactoryFilterIndex.FilterData();
            result.objectClass = filter.substring(FILTER_START.length(), i0);
            result.serviceId = sid;
            result.ranking = Integer.parseInt(filter.substring(i0 + FILTER_SUBSTRING_0.length(), i1));
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllServiceReferences(String clazz, String filter) {
        ArrayList<ServiceReference> result = new ArrayList<ServiceReference>();
        AbstractFactoryFilterIndex.FilterData data = this.getFilterData(clazz, filter);
        if (data != null) {
            SortedSet list = null;
            Map map = this.m_sidToServiceReferencesMap;
            synchronized (map) {
                list = (SortedSet)this.m_sidToServiceReferencesMap.get(data.serviceId);
                if (list != null) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        ServiceReference reference = (ServiceReference)iterator.next();
                        if (!this.referenceMatchesObjectClass(reference, data.objectClass) || ServiceUtil.getRanking(reference) > data.ranking) continue;
                        result.add(reference);
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceChanged(ServiceEvent event) {
        ArrayList list = new ArrayList();
        ServiceReference reference = event.getServiceReference();
        Long sidObject = ServiceUtil.getServiceIdObject(reference);
        int ranking = ServiceUtil.getRanking(reference);
        String[] objectClasses = (String[])reference.getProperty("objectClass");
        Map map = this.m_sidToObjectClassToRankingToListenersMap;
        synchronized (map) {
            for (int i = 0; i < objectClasses.length; ++i) {
                SortedMap rankingToListenersMap;
                String objectClass = objectClasses[i];
                SortedMap objectClassToRankingToListenersMap = (SortedMap)this.m_sidToObjectClassToRankingToListenersMap.get(sidObject);
                if (objectClassToRankingToListenersMap == null || (rankingToListenersMap = (SortedMap)objectClassToRankingToListenersMap.get(objectClass)) == null) continue;
                Iterator iterator = rankingToListenersMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (ranking > (Integer)entry.getKey()) continue;
                    list.addAll((Collection)entry.getValue());
                }
            }
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ServiceListener listener = (ServiceListener)iterator.next();
            listener.serviceChanged(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServiceListener(ServiceListener listener, String filter) {
        AbstractFactoryFilterIndex.FilterData data = this.getFilterData(null, filter);
        if (data != null) {
            Long sidObject = data.serviceId;
            Map map = this.m_sidToObjectClassToRankingToListenersMap;
            synchronized (map) {
                ArrayList<ServiceListener> listeners;
                TreeMap<Integer, ArrayList<ServiceListener>> rankingToListenersMap;
                TreeMap objectClassToRankingToListenersMap = (TreeMap)this.m_sidToObjectClassToRankingToListenersMap.get(sidObject);
                if (objectClassToRankingToListenersMap == null) {
                    objectClassToRankingToListenersMap = new TreeMap();
                    this.m_sidToObjectClassToRankingToListenersMap.put(sidObject, objectClassToRankingToListenersMap);
                }
                if ((rankingToListenersMap = (TreeMap<Integer, ArrayList<ServiceListener>>)objectClassToRankingToListenersMap.get(data.objectClass)) == null) {
                    rankingToListenersMap = new TreeMap<Integer, ArrayList<ServiceListener>>();
                    objectClassToRankingToListenersMap.put(data.objectClass, rankingToListenersMap);
                }
                if ((listeners = (ArrayList<ServiceListener>)rankingToListenersMap.get(data.ranking)) == null) {
                    listeners = new ArrayList<ServiceListener>();
                    rankingToListenersMap.put(data.ranking, listeners);
                }
                listeners.add(listener);
                this.m_listenerToFilterMap.put(listener, filter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceListener(ServiceListener listener) {
        Map map = this.m_sidToObjectClassToRankingToListenersMap;
        synchronized (map) {
            SortedMap rankingToListenersMap;
            Long sidObject;
            SortedMap objectClassToRankingToListenersMap;
            AbstractFactoryFilterIndex.FilterData data;
            String filter = (String)this.m_listenerToFilterMap.remove(listener);
            if (filter != null && (data = this.getFilterData(null, filter)) != null && (objectClassToRankingToListenersMap = (SortedMap)this.m_sidToObjectClassToRankingToListenersMap.get(sidObject = Long.valueOf(data.serviceId))) != null && (rankingToListenersMap = (SortedMap)objectClassToRankingToListenersMap.get(data.objectClass)) != null) {
                Collection listeners = (Collection)rankingToListenersMap.get(data.ranking);
                if (listeners != null) {
                    listeners.remove(listener);
                }
                if (listeners.isEmpty()) {
                    rankingToListenersMap.remove(data.ranking);
                }
                if (rankingToListenersMap.isEmpty()) {
                    objectClassToRankingToListenersMap.remove(data.objectClass);
                }
                if (objectClassToRankingToListenersMap.isEmpty()) {
                    this.m_sidToObjectClassToRankingToListenersMap.remove(sidObject);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addingService(ServiceReference reference) {
        BundleContext context;
        Object object = this.m_lock;
        synchronized (object) {
            context = this.m_context;
        }
        if (context != null) {
            return context.getService(reference);
        }
        throw new IllegalStateException("No valid bundle context.");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("AspectFilterIndex[");
        sb.append("S2R2L: " + this.m_sidToObjectClassToRankingToListenersMap.size());
        sb.append(", S2SR: " + this.m_sidToServiceReferencesMap.size());
        sb.append(", L2F: " + this.m_listenerToFilterMap.size());
        sb.append("]");
        return sb.toString();
    }
}

