/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl.dependencies;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.felix.dm.ComponentDependencyDeclaration;
import org.apache.felix.dm.ConfigurationDependency;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyActivation;
import org.apache.felix.dm.DependencyService;
import org.apache.felix.dm.InvocationUtil;
import org.apache.felix.dm.PropertyMetaData;
import org.apache.felix.dm.impl.Logger;
import org.apache.felix.dm.impl.dependencies.DependencyBase;
import org.apache.felix.dm.impl.metatype.MetaTypeProviderImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class ConfigurationDependencyImpl
extends DependencyBase
implements ConfigurationDependency,
ManagedService,
ComponentDependencyDeclaration,
DependencyActivation {
    private BundleContext m_context;
    private String m_pid;
    private ServiceRegistration m_registration;
    protected List m_services = new ArrayList();
    private Dictionary m_settings;
    private String m_callback;
    private final Set m_updateInvokedCache = new HashSet();
    private MetaTypeProviderImpl m_metaType;
    private boolean m_propagate;
    private Object m_propagateCallbackInstance;
    private String m_propagateCallbackMethod;
    static /* synthetic */ Class class$org$osgi$service$cm$ManagedService;
    static /* synthetic */ Class class$java$util$Dictionary;

    public ConfigurationDependencyImpl(BundleContext context, Logger logger) {
        super(logger);
        this.m_context = context;
    }

    public ConfigurationDependencyImpl(ConfigurationDependencyImpl prototype) {
        super(prototype);
        this.m_context = prototype.m_context;
        this.m_pid = prototype.m_pid;
        this.m_propagate = prototype.m_propagate;
        this.m_callback = prototype.m_callback;
        this.m_metaType = prototype.m_metaType;
        this.m_propagateCallbackInstance = prototype.m_propagateCallbackInstance;
        this.m_propagateCallbackMethod = prototype.m_propagateCallbackMethod;
    }

    public Dependency createCopy() {
        return new ConfigurationDependencyImpl(this);
    }

    public synchronized boolean isAvailable() {
        return this.m_settings != null;
    }

    public boolean isRequired() {
        return true;
    }

    public boolean isPropagated() {
        return this.m_propagate;
    }

    public ConfigurationDependency setInstanceBound(boolean isInstanceBound) {
        this.setIsInstanceBound(isInstanceBound);
        return this;
    }

    public Dictionary getConfiguration() {
        return this.m_settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(DependencyService service) {
        boolean needsStarting = false;
        ConfigurationDependencyImpl configurationDependencyImpl = this;
        synchronized (configurationDependencyImpl) {
            this.m_services.add(service);
            if (!this.m_isStarted) {
                this.m_isStarted = true;
                needsStarting = true;
            }
        }
        if (needsStarting) {
            Properties props = new Properties();
            props.put("service.pid", this.m_pid);
            Object ms = this;
            if (this.m_metaType != null) {
                ms = this.m_metaType;
            }
            this.m_registration = this.m_context.registerService((class$org$osgi$service$cm$ManagedService == null ? (class$org$osgi$service$cm$ManagedService = ConfigurationDependencyImpl.class$("org.osgi.service.cm.ManagedService")) : class$org$osgi$service$cm$ManagedService).getName(), ms, (Dictionary)props);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(DependencyService service) {
        boolean needsStopping = false;
        ConfigurationDependencyImpl configurationDependencyImpl = this;
        synchronized (configurationDependencyImpl) {
            if (this.m_services.size() == 1 && this.m_services.contains(service)) {
                this.m_isStarted = false;
                needsStopping = true;
            }
        }
        if (needsStopping) {
            this.m_registration.unregister();
            this.m_registration = null;
            this.m_services.remove(service);
        }
    }

    public ConfigurationDependency setCallback(String callback) {
        this.m_callback = callback;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(Dictionary settings) throws ConfigurationException {
        DependencyService ds;
        Set set = this.m_updateInvokedCache;
        synchronized (set) {
            this.m_updateInvokedCache.clear();
        }
        Dictionary oldSettings = null;
        ConfigurationDependencyImpl configurationDependencyImpl = this;
        synchronized (configurationDependencyImpl) {
            oldSettings = this.m_settings;
        }
        if (oldSettings == null && settings == null) {
            return;
        }
        Object[] services = this.m_services.toArray();
        for (int i = 0; i < services.length; ++i) {
            ds = (DependencyService)services[i];
            ds.initService();
            Object service = ds.getService();
            if (service == null) {
                this.m_logger.log(1, "Service " + ds + " with configuration dependency " + this + " could not be instantiated.");
                return;
            }
            this.invokeUpdate(ds, service, settings);
        }
        ConfigurationDependencyImpl i = this;
        synchronized (i) {
            this.m_settings = settings;
        }
        for (int i2 = 0; i2 < services.length; ++i2) {
            ds = (DependencyService)services[i2];
            if (oldSettings == null && settings != null) {
                ds.dependencyAvailable(this);
            }
            if (oldSettings != null && settings == null) {
                ds.dependencyUnavailable(this);
            }
            if (oldSettings == null || settings == null) continue;
            ds.dependencyChanged(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeUpdate(DependencyService ds, Object service, Dictionary settings) throws ConfigurationException {
        boolean wasAdded;
        Set set = this.m_updateInvokedCache;
        synchronized (set) {
            wasAdded = this.m_updateInvokedCache.add(ds);
        }
        if (wasAdded) {
            String callback = this.m_callback == null ? "updated" : this.m_callback;
            try {
                InvocationUtil.invokeCallbackMethod(service, callback, new Class[][]{{class$java$util$Dictionary == null ? (class$java$util$Dictionary = ConfigurationDependencyImpl.class$("java.util.Dictionary")) : class$java$util$Dictionary}}, new Object[][]{{settings}});
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof ConfigurationException) {
                    throw (ConfigurationException)e.getTargetException();
                }
                throw new ConfigurationException(null, "Service " + ds + " with " + this.toString() + " could not be updated", e.getTargetException());
            }
            catch (NoSuchMethodException e) {
            }
            catch (Throwable t) {
                throw new ConfigurationException(null, "Service " + ds + " with " + this.toString() + " could not be updated", t);
            }
        }
    }

    public ConfigurationDependency setPid(String pid) {
        this.ensureNotActive();
        this.m_pid = pid;
        return this;
    }

    public ConfigurationDependency setPropagate(boolean propagate) {
        this.ensureNotActive();
        this.m_propagate = propagate;
        return this;
    }

    private void ensureNotActive() {
        if (this.m_services != null && this.m_services.size() > 0) {
            throw new IllegalStateException("Cannot modify state while active.");
        }
    }

    public String toString() {
        return "ConfigurationDependency[" + this.m_pid + "]";
    }

    public String getName() {
        return this.m_pid;
    }

    public String getType() {
        return "configuration";
    }

    public Object getAutoConfigInstance() {
        return this.getConfiguration();
    }

    public String getAutoConfigName() {
        return null;
    }

    public Class getAutoConfigType() {
        return class$java$util$Dictionary == null ? (class$java$util$Dictionary = ConfigurationDependencyImpl.class$("java.util.Dictionary")) : class$java$util$Dictionary;
    }

    public void invokeAdded(DependencyService service) {
        try {
            this.invokeUpdate(service, service.getService(), this.getConfiguration());
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeRemoved(DependencyService service) {
        Set set = this.m_updateInvokedCache;
        synchronized (set) {
            this.m_updateInvokedCache.remove(service);
        }
    }

    public boolean isAutoConfig() {
        return false;
    }

    public ConfigurationDependency setPropagate(Object instance, String method) {
        this.setPropagate(instance != null && method != null);
        this.m_propagateCallbackInstance = instance;
        this.m_propagateCallbackMethod = method;
        return this;
    }

    public Dictionary getProperties() {
        Dictionary config = this.getConfiguration();
        if (config != null) {
            if (this.m_propagateCallbackInstance != null && this.m_propagateCallbackMethod != null) {
                try {
                    return (Dictionary)InvocationUtil.invokeCallbackMethod(this.m_propagateCallbackInstance, this.m_propagateCallbackMethod, new Class[][]{{class$java$util$Dictionary == null ? (class$java$util$Dictionary = ConfigurationDependencyImpl.class$("java.util.Dictionary")) : class$java$util$Dictionary}, new Class[0]}, new Object[][]{{config}, new Object[0]});
                }
                catch (InvocationTargetException e) {
                    this.m_logger.log(2, "Exception while invoking callback method", e.getCause());
                }
                catch (Exception e) {
                    this.m_logger.log(2, "Exception while trying to invoke callback method", e);
                }
                throw new IllegalStateException("Could not invoke callback");
            }
            return config;
        }
        throw new IllegalStateException("cannot find configuration");
    }

    public BundleContext getBundleContext() {
        return this.m_context;
    }

    public Logger getLogger() {
        return this.m_logger;
    }

    public ConfigurationDependency add(PropertyMetaData properties) {
        this.createMetaTypeImpl();
        this.m_metaType.add(properties);
        return this;
    }

    public ConfigurationDependency setDescription(String description) {
        this.createMetaTypeImpl();
        this.m_metaType.setDescription(description);
        return this;
    }

    public ConfigurationDependency setHeading(String heading) {
        this.createMetaTypeImpl();
        this.m_metaType.setName(heading);
        return this;
    }

    public ConfigurationDependency setLocalization(String path) {
        this.createMetaTypeImpl();
        this.m_metaType.setLocalization(path);
        return this;
    }

    private synchronized void createMetaTypeImpl() {
        if (this.m_metaType == null) {
            this.m_metaType = new MetaTypeProviderImpl(this.getName(), this.getBundleContext(), this.getLogger(), this, null);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

