/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl.dependencies;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.felix.dm.ComponentDependencyDeclaration;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyService;
import org.apache.felix.dm.InvocationUtil;
import org.apache.felix.dm.ServiceDependency;
import org.apache.felix.dm.ServiceUtil;
import org.apache.felix.dm.impl.DefaultNullObject;
import org.apache.felix.dm.impl.Logger;
import org.apache.felix.dm.impl.SerialExecutor;
import org.apache.felix.dm.impl.dependencies.DependencyBase;
import org.apache.felix.dm.tracker.ServiceTracker;
import org.apache.felix.dm.tracker.ServiceTrackerCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ServiceDependencyImpl
extends DependencyBase
implements ServiceDependency,
ServiceTrackerCustomizer,
ComponentDependencyDeclaration {
    protected final List m_services = new ArrayList();
    protected volatile ServiceTracker m_tracker;
    protected final BundleContext m_context;
    protected volatile Class m_trackedServiceName;
    private volatile Object m_nullObject;
    private volatile String m_trackedServiceFilter;
    private volatile String m_trackedServiceFilterUnmodified;
    private volatile ServiceReference m_trackedServiceReference;
    private volatile Object m_callbackInstance;
    private volatile String m_callbackAdded;
    private volatile String m_callbackChanged;
    private volatile String m_callbackRemoved;
    private volatile String m_callbackSwapped;
    private boolean m_autoConfig;
    private volatile String m_autoConfigInstance;
    private boolean m_autoConfigInvoked;
    private volatile Object m_defaultImplementation;
    private volatile Object m_defaultImplementationInstance;
    private boolean m_isAvailable;
    private volatile boolean m_propagate;
    private volatile Object m_propagateCallbackInstance;
    private volatile String m_propagateCallbackMethod;
    private final Map m_sr = new HashMap();
    private final Map m_componentByRank = new HashMap();
    private volatile boolean m_debug = false;
    private volatile String m_debugKey = null;
    private final SerialExecutor m_serial;
    private static final Comparator COMPARATOR = new Comparator(){

        public int getRank(ServiceReference ref) {
            Object ranking = ref.getProperty("service.ranking");
            if (ranking != null && ranking instanceof Integer) {
                return (Integer)ranking;
            }
            return 0;
        }

        public int compare(Object a, Object b) {
            int rankb;
            ServiceReference ra = (ServiceReference)a;
            ServiceReference rb = (ServiceReference)b;
            int ranka = this.getRank(ra);
            if (ranka < (rankb = this.getRank(rb))) {
                return -1;
            }
            if (ranka > rankb) {
                return 1;
            }
            return 0;
        }
    };
    static /* synthetic */ Class class$org$osgi$framework$ServiceReference;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$apache$felix$dm$Component;
    static /* synthetic */ Class class$java$util$Map;

    public ServiceDependencyImpl(BundleContext context, Logger logger) {
        super(logger);
        this.m_context = context;
        this.m_autoConfig = true;
        this.m_serial = new SerialExecutor(logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceDependencyImpl(ServiceDependencyImpl prototype) {
        super(prototype);
        this.m_serial = new SerialExecutor(this.m_logger);
        ServiceDependencyImpl serviceDependencyImpl = prototype;
        synchronized (serviceDependencyImpl) {
            this.m_context = prototype.m_context;
            this.m_autoConfig = prototype.m_autoConfig;
            this.m_trackedServiceName = prototype.m_trackedServiceName;
            this.m_nullObject = prototype.m_nullObject;
            this.m_trackedServiceFilter = prototype.m_trackedServiceFilter;
            this.m_trackedServiceFilterUnmodified = prototype.m_trackedServiceFilterUnmodified;
            this.m_trackedServiceReference = prototype.m_trackedServiceReference;
            this.m_callbackInstance = prototype.m_callbackInstance;
            this.m_callbackAdded = prototype.m_callbackAdded;
            this.m_callbackChanged = prototype.m_callbackChanged;
            this.m_callbackRemoved = prototype.m_callbackRemoved;
            this.m_callbackSwapped = prototype.m_callbackSwapped;
            this.m_autoConfigInstance = prototype.m_autoConfigInstance;
            this.m_defaultImplementation = prototype.m_defaultImplementation;
        }
    }

    public ServiceDependency setDebug(String identifier) {
        this.m_debug = true;
        this.m_debugKey = identifier;
        return this;
    }

    public Dependency createCopy() {
        return new ServiceDependencyImpl(this);
    }

    public synchronized boolean isAutoConfig() {
        return this.m_autoConfig;
    }

    public synchronized boolean isAvailable() {
        return this.m_isAvailable;
    }

    public void start(final DependencyService service) {
        this.m_serial.execute(new Runnable(){

            public void run() {
                ServiceDependencyImpl.this.doStart(service);
            }
        });
    }

    public void stop(final DependencyService service) {
        this.m_serial.execute(new Runnable(){

            public void run() {
                ServiceDependencyImpl.this.doStop(service);
            }
        });
    }

    public Object addingService(ServiceReference ref) {
        Object service = this.m_context.getService(ref);
        if (!this.m_trackedServiceName.isInstance(service)) {
            return null;
        }
        return service;
    }

    public void addedService(final ServiceReference ref, final Object service) {
        this.m_serial.execute(new Runnable(){

            public void run() {
                ServiceDependencyImpl.this.doAddedService(ref, service);
            }
        });
    }

    public void modifiedService(final ServiceReference ref, final Object service) {
        this.m_serial.execute(new Runnable(){

            public void run() {
                ServiceDependencyImpl.this.doModifiedService(ref, service);
            }
        });
    }

    public void removedService(final ServiceReference ref, final Object service) {
        this.m_serial.execute(new Runnable(){

            public void run() {
                ServiceDependencyImpl.this.doRemovedService(ref, service);
            }
        });
    }

    public void invokeAdded(final DependencyService service) {
        this.m_serial.execute(new Runnable(){

            public void run() {
                ServiceDependencyImpl.this.doInvokeAdded(service);
            }
        });
    }

    public void invokeRemoved(final DependencyService service) {
        this.m_serial.execute(new Runnable(){

            public void run() {
                ServiceDependencyImpl.this.doInvokeRemoved(service);
            }
        });
    }

    public synchronized String toString() {
        return "ServiceDependency[" + this.m_trackedServiceName + " " + this.m_trackedServiceFilterUnmodified + "]";
    }

    public String getAutoConfigName() {
        return this.m_autoConfigInstance;
    }

    public Object getAutoConfigInstance() {
        return this.lookupService();
    }

    public Class getAutoConfigType() {
        return this.getInterface();
    }

    public String getName() {
        StringBuilder sb = new StringBuilder();
        if (this.m_trackedServiceName != null) {
            sb.append(this.m_trackedServiceName.getName());
            if (this.m_trackedServiceFilterUnmodified != null) {
                sb.append(' ');
                sb.append(this.m_trackedServiceFilterUnmodified);
            }
        }
        if (this.m_trackedServiceReference != null) {
            sb.append("{service.id=" + this.m_trackedServiceReference.getProperty("service.id") + "}");
        }
        return sb.toString();
    }

    public String getType() {
        return "service";
    }

    public Dictionary getProperties() {
        ServiceReference reference = this.lookupServiceReference();
        Object service = this.lookupService();
        if (reference != null) {
            if (this.m_propagateCallbackInstance != null && this.m_propagateCallbackMethod != null) {
                try {
                    return (Dictionary)InvocationUtil.invokeCallbackMethod(this.m_propagateCallbackInstance, this.m_propagateCallbackMethod, new Class[][]{{class$org$osgi$framework$ServiceReference == null ? (class$org$osgi$framework$ServiceReference = ServiceDependencyImpl.class$("org.osgi.framework.ServiceReference")) : class$org$osgi$framework$ServiceReference, class$java$lang$Object == null ? (class$java$lang$Object = ServiceDependencyImpl.class$("java.lang.Object")) : class$java$lang$Object}, {class$org$osgi$framework$ServiceReference == null ? (class$org$osgi$framework$ServiceReference = ServiceDependencyImpl.class$("org.osgi.framework.ServiceReference")) : class$org$osgi$framework$ServiceReference}}, new Object[][]{{reference, service}, {reference}});
                }
                catch (InvocationTargetException e) {
                    this.m_logger.log(2, "Exception while invoking callback method", e.getCause());
                }
                catch (Exception e) {
                    this.m_logger.log(2, "Exception while trying to invoke callback method", e);
                }
                throw new IllegalStateException("Could not invoke callback");
            }
            Properties props = new Properties();
            String[] keys = reference.getPropertyKeys();
            for (int i = 0; i < keys.length; ++i) {
                if (keys[i].equals("service.id") || keys[i].equals("service.pid")) continue;
                props.put(keys[i], reference.getProperty(keys[i]));
            }
            return props;
        }
        throw new IllegalStateException("cannot find service reference");
    }

    public boolean isPropagated() {
        return this.m_propagate;
    }

    public synchronized ServiceDependency setService(Class serviceName) {
        this.setService(serviceName, null, null);
        return this;
    }

    public synchronized ServiceDependency setService(Class serviceName, String serviceFilter) {
        this.setService(serviceName, null, serviceFilter);
        return this;
    }

    public synchronized ServiceDependency setService(String serviceFilter) {
        if (serviceFilter == null) {
            throw new IllegalArgumentException("Service filter cannot be null.");
        }
        this.setService(null, null, serviceFilter);
        return this;
    }

    public synchronized ServiceDependency setService(Class serviceName, ServiceReference serviceReference) {
        this.setService(serviceName, serviceReference, null);
        return this;
    }

    public synchronized ServiceDependency setDefaultImplementation(Object implementation) {
        this.ensureNotActive();
        this.m_defaultImplementation = implementation;
        return this;
    }

    public synchronized ServiceDependency setRequired(boolean required) {
        this.ensureNotActive();
        this.setIsRequired(required);
        return this;
    }

    public ServiceDependency setInstanceBound(boolean isInstanceBound) {
        this.setIsInstanceBound(isInstanceBound);
        return this;
    }

    public synchronized ServiceDependency setAutoConfig(boolean autoConfig) {
        this.ensureNotActive();
        this.m_autoConfig = autoConfig;
        this.m_autoConfigInvoked = true;
        return this;
    }

    public synchronized ServiceDependency setAutoConfig(String instanceName) {
        this.ensureNotActive();
        this.m_autoConfig = instanceName != null;
        this.m_autoConfigInstance = instanceName;
        this.m_autoConfigInvoked = true;
        return this;
    }

    public synchronized ServiceDependency setCallbacks(String added, String removed) {
        return this.setCallbacks((Object)null, added, null, removed);
    }

    public synchronized ServiceDependency setCallbacks(String added, String changed, String removed) {
        return this.setCallbacks((Object)null, added, changed, removed);
    }

    public synchronized ServiceDependency setCallbacks(String added, String changed, String removed, String swapped) {
        return this.setCallbacks(null, added, changed, removed, swapped);
    }

    public synchronized ServiceDependency setCallbacks(Object instance, String added, String removed) {
        return this.setCallbacks(instance, added, (String)null, removed);
    }

    public synchronized ServiceDependency setCallbacks(Object instance, String added, String changed, String removed) {
        return this.setCallbacks(instance, added, changed, removed, null);
    }

    public synchronized ServiceDependency setCallbacks(Object instance, String added, String changed, String removed, String swapped) {
        this.ensureNotActive();
        if (!(added == null && removed == null && changed == null && swapped == null || this.m_autoConfigInvoked)) {
            this.setAutoConfig(false);
        }
        this.m_callbackInstance = instance;
        this.m_callbackAdded = added;
        this.m_callbackChanged = changed;
        this.m_callbackRemoved = removed;
        this.m_callbackSwapped = swapped;
        return this;
    }

    public ServiceDependency setPropagate(boolean propagate) {
        this.ensureNotActive();
        this.m_propagate = propagate;
        return this;
    }

    public ServiceDependency setPropagate(Object instance, String method) {
        this.setPropagate(instance != null && method != null);
        this.m_propagateCallbackInstance = instance;
        this.m_propagateCallbackMethod = method;
        return this;
    }

    public void invoke(Object[] callbackInstances, DependencyService dependencyService, ServiceReference reference, Object service, String name) {
        if (this.m_debug) {
            this.m_logger.log(4, "[" + this.m_debugKey + "] invoke: " + name);
        }
        if (name != null) {
            dependencyService.invokeCallbackMethod(callbackInstances, name, new Class[][]{{class$org$apache$felix$dm$Component == null ? (class$org$apache$felix$dm$Component = ServiceDependencyImpl.class$("org.apache.felix.dm.Component")) : class$org$apache$felix$dm$Component, class$org$osgi$framework$ServiceReference == null ? (class$org$osgi$framework$ServiceReference = ServiceDependencyImpl.class$("org.osgi.framework.ServiceReference")) : class$org$osgi$framework$ServiceReference, this.m_trackedServiceName}, {class$org$apache$felix$dm$Component == null ? (class$org$apache$felix$dm$Component = ServiceDependencyImpl.class$("org.apache.felix.dm.Component")) : class$org$apache$felix$dm$Component, class$org$osgi$framework$ServiceReference == null ? (class$org$osgi$framework$ServiceReference = ServiceDependencyImpl.class$("org.osgi.framework.ServiceReference")) : class$org$osgi$framework$ServiceReference, class$java$lang$Object == null ? (class$java$lang$Object = ServiceDependencyImpl.class$("java.lang.Object")) : class$java$lang$Object}, {class$org$apache$felix$dm$Component == null ? (class$org$apache$felix$dm$Component = ServiceDependencyImpl.class$("org.apache.felix.dm.Component")) : class$org$apache$felix$dm$Component, class$org$osgi$framework$ServiceReference == null ? (class$org$osgi$framework$ServiceReference = ServiceDependencyImpl.class$("org.osgi.framework.ServiceReference")) : class$org$osgi$framework$ServiceReference}, {class$org$apache$felix$dm$Component == null ? (class$org$apache$felix$dm$Component = ServiceDependencyImpl.class$("org.apache.felix.dm.Component")) : class$org$apache$felix$dm$Component, this.m_trackedServiceName}, {class$org$apache$felix$dm$Component == null ? (class$org$apache$felix$dm$Component = ServiceDependencyImpl.class$("org.apache.felix.dm.Component")) : class$org$apache$felix$dm$Component, class$java$lang$Object == null ? (class$java$lang$Object = ServiceDependencyImpl.class$("java.lang.Object")) : class$java$lang$Object}, {class$org$apache$felix$dm$Component == null ? (class$org$apache$felix$dm$Component = ServiceDependencyImpl.class$("org.apache.felix.dm.Component")) : class$org$apache$felix$dm$Component}, {class$org$apache$felix$dm$Component == null ? (class$org$apache$felix$dm$Component = ServiceDependencyImpl.class$("org.apache.felix.dm.Component")) : class$org$apache$felix$dm$Component, class$java$util$Map == null ? (class$java$util$Map = ServiceDependencyImpl.class$("java.util.Map")) : class$java$util$Map, this.m_trackedServiceName}, {class$org$osgi$framework$ServiceReference == null ? (class$org$osgi$framework$ServiceReference = ServiceDependencyImpl.class$("org.osgi.framework.ServiceReference")) : class$org$osgi$framework$ServiceReference, this.m_trackedServiceName}, {class$org$osgi$framework$ServiceReference == null ? (class$org$osgi$framework$ServiceReference = ServiceDependencyImpl.class$("org.osgi.framework.ServiceReference")) : class$org$osgi$framework$ServiceReference, class$java$lang$Object == null ? (class$java$lang$Object = ServiceDependencyImpl.class$("java.lang.Object")) : class$java$lang$Object}, {class$org$osgi$framework$ServiceReference == null ? (class$org$osgi$framework$ServiceReference = ServiceDependencyImpl.class$("org.osgi.framework.ServiceReference")) : class$org$osgi$framework$ServiceReference}, {this.m_trackedServiceName}, {class$java$lang$Object == null ? (class$java$lang$Object = ServiceDependencyImpl.class$("java.lang.Object")) : class$java$lang$Object}, new Class[0], {class$java$util$Map == null ? (class$java$util$Map = ServiceDependencyImpl.class$("java.util.Map")) : class$java$util$Map, this.m_trackedServiceName}}, new Object[][]{{dependencyService, reference, service}, {dependencyService, reference, service}, {dependencyService, reference}, {dependencyService, service}, {dependencyService, service}, {dependencyService}, {dependencyService, new ServicePropertiesMap(reference), service}, {reference, service}, {reference, service}, {reference}, {service}, {service}, new Object[0], {new ServicePropertiesMap(reference), service}});
        }
    }

    public void invokeSwappedCallback(Object[] callbackInstances, DependencyService component, ServiceReference previousReference, Object previous, ServiceReference currentServiceReference, Object current, String swapCallback) {
        Integer oldRank = (Integer)previousReference.getProperty("service.ranking");
        Integer newRank = (Integer)currentServiceReference.getProperty("service.ranking");
        if (oldRank != null && newRank != null && oldRank.equals(newRank)) {
            throw new IllegalStateException("Attempt to swap a service for a service with the same rank! previousReference: " + previousReference + ", currentReference: " + currentServiceReference);
        }
        component.invokeCallbackMethod(callbackInstances, swapCallback, new Class[][]{{this.m_trackedServiceName, this.m_trackedServiceName}, {class$java$lang$Object == null ? (class$java$lang$Object = ServiceDependencyImpl.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Object == null ? (class$java$lang$Object = ServiceDependencyImpl.class$("java.lang.Object")) : class$java$lang$Object}, {class$org$osgi$framework$ServiceReference == null ? (class$org$osgi$framework$ServiceReference = ServiceDependencyImpl.class$("org.osgi.framework.ServiceReference")) : class$org$osgi$framework$ServiceReference, this.m_trackedServiceName, class$org$osgi$framework$ServiceReference == null ? (class$org$osgi$framework$ServiceReference = ServiceDependencyImpl.class$("org.osgi.framework.ServiceReference")) : class$org$osgi$framework$ServiceReference, this.m_trackedServiceName}, {class$org$osgi$framework$ServiceReference == null ? (class$org$osgi$framework$ServiceReference = ServiceDependencyImpl.class$("org.osgi.framework.ServiceReference")) : class$org$osgi$framework$ServiceReference, class$java$lang$Object == null ? (class$java$lang$Object = ServiceDependencyImpl.class$("java.lang.Object")) : class$java$lang$Object, class$org$osgi$framework$ServiceReference == null ? (class$org$osgi$framework$ServiceReference = ServiceDependencyImpl.class$("org.osgi.framework.ServiceReference")) : class$org$osgi$framework$ServiceReference, class$java$lang$Object == null ? (class$java$lang$Object = ServiceDependencyImpl.class$("java.lang.Object")) : class$java$lang$Object}, {class$org$apache$felix$dm$Component == null ? (class$org$apache$felix$dm$Component = ServiceDependencyImpl.class$("org.apache.felix.dm.Component")) : class$org$apache$felix$dm$Component, this.m_trackedServiceName, this.m_trackedServiceName}, {class$org$apache$felix$dm$Component == null ? (class$org$apache$felix$dm$Component = ServiceDependencyImpl.class$("org.apache.felix.dm.Component")) : class$org$apache$felix$dm$Component, class$java$lang$Object == null ? (class$java$lang$Object = ServiceDependencyImpl.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Object == null ? (class$java$lang$Object = ServiceDependencyImpl.class$("java.lang.Object")) : class$java$lang$Object}, {class$org$apache$felix$dm$Component == null ? (class$org$apache$felix$dm$Component = ServiceDependencyImpl.class$("org.apache.felix.dm.Component")) : class$org$apache$felix$dm$Component, class$org$osgi$framework$ServiceReference == null ? (class$org$osgi$framework$ServiceReference = ServiceDependencyImpl.class$("org.osgi.framework.ServiceReference")) : class$org$osgi$framework$ServiceReference, this.m_trackedServiceName, class$org$osgi$framework$ServiceReference == null ? (class$org$osgi$framework$ServiceReference = ServiceDependencyImpl.class$("org.osgi.framework.ServiceReference")) : class$org$osgi$framework$ServiceReference, this.m_trackedServiceName}, {class$org$apache$felix$dm$Component == null ? (class$org$apache$felix$dm$Component = ServiceDependencyImpl.class$("org.apache.felix.dm.Component")) : class$org$apache$felix$dm$Component, class$org$osgi$framework$ServiceReference == null ? (class$org$osgi$framework$ServiceReference = ServiceDependencyImpl.class$("org.osgi.framework.ServiceReference")) : class$org$osgi$framework$ServiceReference, class$java$lang$Object == null ? (class$java$lang$Object = ServiceDependencyImpl.class$("java.lang.Object")) : class$java$lang$Object, class$org$osgi$framework$ServiceReference == null ? (class$org$osgi$framework$ServiceReference = ServiceDependencyImpl.class$("org.osgi.framework.ServiceReference")) : class$org$osgi$framework$ServiceReference, class$java$lang$Object == null ? (class$java$lang$Object = ServiceDependencyImpl.class$("java.lang.Object")) : class$java$lang$Object}}, new Object[][]{{previous, current}, {previous, current}, {previousReference, previous, currentServiceReference, current}, {previousReference, previous, currentServiceReference, current}, {component, previous, current}, {component, previous, current}, {component, previousReference, previous, currentServiceReference, current}, {component, previousReference, previous, currentServiceReference, current}});
    }

    protected synchronized boolean makeAvailable() {
        if (!this.isAvailable()) {
            this.m_isAvailable = true;
            return true;
        }
        return false;
    }

    protected synchronized Object getService() {
        Object service = null;
        if (this.m_isStarted) {
            service = this.m_tracker.getService();
        }
        if (service == null && this.isAutoConfig() && (service = this.getDefaultImplementation()) == null) {
            service = this.getNullObject();
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStart(DependencyService service) {
        boolean needsStarting = false;
        ServiceDependencyImpl serviceDependencyImpl = this;
        synchronized (serviceDependencyImpl) {
            this.m_services.add(service);
            if (!this.m_isStarted) {
                if (this.m_trackedServiceName != null) {
                    if (this.m_trackedServiceFilter != null) {
                        try {
                            this.m_tracker = new ServiceTracker(this.m_context, this.m_context.createFilter(this.m_trackedServiceFilter), (ServiceTrackerCustomizer)this);
                        }
                        catch (InvalidSyntaxException e) {
                            throw new IllegalStateException("Invalid filter definition for dependency: " + this.m_trackedServiceFilter);
                        }
                    } else {
                        this.m_tracker = this.m_trackedServiceReference != null ? new ServiceTracker(this.m_context, this.m_trackedServiceReference, (ServiceTrackerCustomizer)this) : new ServiceTracker(this.m_context, this.m_trackedServiceName.getName(), (ServiceTrackerCustomizer)this);
                    }
                } else {
                    throw new IllegalStateException("Could not create tracker for dependency, no service name specified.");
                }
                this.m_isStarted = true;
                needsStarting = true;
            }
        }
        if (needsStarting) {
            boolean trackAllServices = false;
            boolean trackAllAspects = false;
            if (this.m_callbackSwapped != null) {
                trackAllAspects = true;
            }
            this.m_tracker.open(trackAllServices, trackAllAspects);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStop(DependencyService service) {
        boolean needsStopping = false;
        ServiceDependencyImpl serviceDependencyImpl = this;
        synchronized (serviceDependencyImpl) {
            if (this.m_services.size() == 1 && this.m_services.contains(service)) {
                this.m_isStarted = false;
                needsStopping = true;
            }
        }
        if (needsStopping) {
            this.m_tracker.close();
            this.m_tracker = null;
        }
        serviceDependencyImpl = this;
        synchronized (serviceDependencyImpl) {
            this.m_services.remove(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAddedService(ServiceReference ref, Object service) {
        Object[] services;
        if (this.m_debug) {
            this.m_logger.log(4, "[" + this.m_debugKey + "] addedservice: " + ref);
        }
        boolean makeAvailable = this.makeAvailable();
        ServiceDependencyImpl serviceDependencyImpl = this;
        synchronized (serviceDependencyImpl) {
            services = this.m_services.toArray();
        }
        for (int i = 0; i < services.length; ++i) {
            DependencyService ds = (DependencyService)services[i];
            if (makeAvailable) {
                if (ds.isInstantiated() && this.isInstanceBound() && this.isRequired()) {
                    if (this.m_debug) {
                        this.m_logger.log(4, "[" + this.m_debugKey + "] invoke added: " + ref);
                    }
                    this.invokeAdded(ds, ref, service);
                }
                if (this.m_debug) {
                    this.m_logger.log(4, "[" + this.m_debugKey + "] dependency available: " + ref);
                }
                ds.dependencyAvailable(this);
                if (this.isRequired()) continue;
                if (this.m_debug) {
                    this.m_logger.log(4, "[" + this.m_debugKey + "] invoke added: " + ref);
                }
                this.invokeAdded(ds, ref, service);
                continue;
            }
            if (this.m_debug) {
                this.m_logger.log(4, "[" + this.m_debugKey + "] dependency added (was available): " + ref);
            }
            ds.autoConfig(this);
            if (!ds.isInstantiated() || ds.getCompositionInstances().length <= 0) continue;
            if (this.m_debug) {
                this.m_logger.log(4, "[" + this.m_debugKey + "] invoke added: " + ref);
            }
            if (!this.invokeAdded(ds, ref, service)) continue;
            ds.propagate(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doModifiedService(ServiceReference ref, Object service) {
        Object[] services;
        ServiceDependencyImpl serviceDependencyImpl = this;
        synchronized (serviceDependencyImpl) {
            services = this.m_services.toArray();
        }
        for (int i = 0; i < services.length; ++i) {
            DependencyService ds = (DependencyService)services[i];
            ds.autoConfig(this);
            if (!ds.isInstantiated() || !this.invokeChanged(ds, ref, service)) continue;
            ds.propagate(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemovedService(ServiceReference ref, Object service) {
        Object[] services;
        if (this.m_debug) {
            this.m_logger.log(4, "[" + this.m_debugKey + "] removedService: " + ref + ", rank: " + ref.getProperty("service.ranking"));
        }
        boolean makeUnavailable = this.makeUnavailable();
        if (this.m_debug) {
            this.m_logger.log(4, "[" + this.m_debugKey + "] make unavailable: " + makeUnavailable);
        }
        ServiceDependencyImpl serviceDependencyImpl = this;
        synchronized (serviceDependencyImpl) {
            services = this.m_services.toArray();
        }
        for (int i = 0; i < services.length; ++i) {
            DependencyService ds = (DependencyService)services[i];
            if (makeUnavailable) {
                ds.dependencyUnavailable(this);
                if (this.isRequired() && (!ds.isInstantiated() || !this.isInstanceBound())) continue;
                this.invokeRemoved(ds, ref, service);
                continue;
            }
            ds.autoConfig(this);
            if (!this.invokeRemoved(ds, ref, service)) continue;
            ds.propagate(this);
        }
        this.m_context.ungetService(ref);
    }

    private void doInvokeAdded(DependencyService service) {
        ServiceReference[] refs;
        if (this.m_debug) {
            this.m_logger.log(4, "[" + this.m_debugKey + "] invoke added due to configure. (component is activated)");
        }
        if ((refs = this.m_tracker.getServiceReferences()) != null) {
            for (int i = 0; i < refs.length; ++i) {
                ServiceReference sr = refs[i];
                Object svc = this.m_context.getService(sr);
                this.invokeAdded(service, sr, svc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInvokeRemoved(DependencyService service) {
        if (this.m_debug) {
            this.m_logger.log(4, "[" + this.m_debugKey + "] invoke removed due to unconfigure. (component is destroyed)");
        }
        Set references = null;
        Tuple[] tupleArray = null;
        Map map = this.m_sr;
        synchronized (map) {
            references = (Set)this.m_sr.get(service);
            if (references != null) {
                tupleArray = references.toArray(new Tuple[references.size()]);
            }
        }
        Tuple[] refs = tupleArray != null ? tupleArray : new Tuple[]{};
        for (int i = 0; i < refs.length; ++i) {
            ServiceReference sr = refs[i].getServiceReference();
            Object svc = refs[i].getService();
            this.invokeRemoved(service, sr, svc);
        }
    }

    /*
     * Unable to fully structure code
     */
    private Object lookupService() {
        service = null;
        if (this.m_isStarted) {
            service = this.getService();
        } else {
            refs = null;
            ref = null;
            if (this.m_trackedServiceName != null) {
                if (this.m_trackedServiceFilter != null) {
                    try {
                        refs = this.m_context.getServiceReferences(this.m_trackedServiceName.getName(), this.m_trackedServiceFilter);
                        if (refs == null) ** GOTO lbl18
                        Arrays.sort(refs, ServiceDependencyImpl.COMPARATOR);
                        ref = refs[0];
                    }
                    catch (InvalidSyntaxException e) {
                        throw new IllegalStateException("Invalid filter definition for dependency.");
                    }
                } else {
                    ref = this.m_trackedServiceReference != null ? this.m_trackedServiceReference : this.m_context.getServiceReference(this.m_trackedServiceName.getName());
                }
lbl18:
                // 3 sources

                if (ref != null) {
                    service = this.m_context.getService(ref);
                }
            } else {
                throw new IllegalStateException("Could not lookup dependency, no service name specified.");
            }
        }
        if (service == null && this.isAutoConfig() && (service = this.getDefaultImplementation()) == null) {
            service = this.getNullObject();
        }
        return service;
    }

    /*
     * Unable to fully structure code
     */
    private ServiceReference lookupServiceReference() {
        service = null;
        if (this.m_isStarted) {
            service = this.m_tracker.getServiceReference();
        } else {
            refs = null;
            ref = null;
            if (this.m_trackedServiceName != null) {
                if (this.m_trackedServiceFilter != null) {
                    try {
                        refs = this.m_context.getServiceReferences(this.m_trackedServiceName.getName(), this.m_trackedServiceFilter);
                        if (refs == null) ** GOTO lbl18
                        Arrays.sort(refs, ServiceDependencyImpl.COMPARATOR);
                        ref = refs[0];
                    }
                    catch (InvalidSyntaxException e) {
                        throw new IllegalStateException("Invalid filter definition for dependency.");
                    }
                } else {
                    ref = this.m_trackedServiceReference != null ? this.m_trackedServiceReference : this.m_context.getServiceReference(this.m_trackedServiceName.getName());
                }
lbl18:
                // 3 sources

                if (ref != null) {
                    service = ref;
                }
            } else {
                throw new IllegalStateException("Could not lookup dependency, no service name specified.");
            }
        }
        return service;
    }

    private synchronized Class getInterface() {
        return this.m_trackedServiceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getNullObject() {
        if (this.m_nullObject == null) {
            Class trackedServiceName;
            ServiceDependencyImpl serviceDependencyImpl = this;
            synchronized (serviceDependencyImpl) {
                trackedServiceName = this.m_trackedServiceName;
            }
            try {
                this.m_nullObject = Proxy.newProxyInstance(trackedServiceName.getClassLoader(), new Class[]{trackedServiceName}, (InvocationHandler)new DefaultNullObject());
            }
            catch (Exception e) {
                this.m_logger.log(1, "Could not create null object for " + trackedServiceName + ".", e);
            }
        }
        return this.m_nullObject;
    }

    private Object getDefaultImplementation() {
        if (this.m_defaultImplementation != null) {
            if (this.m_defaultImplementation instanceof Class) {
                try {
                    this.m_defaultImplementationInstance = ((Class)this.m_defaultImplementation).newInstance();
                }
                catch (Exception e) {
                    this.m_logger.log(1, "Could not create default implementation instance of class " + this.m_defaultImplementation + ".", e);
                }
            } else {
                this.m_defaultImplementationInstance = this.m_defaultImplementation;
            }
        }
        return this.m_defaultImplementationInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean invokeAdded(DependencyService dependencyService, ServiceReference reference, Object service) {
        if (this.m_debug) {
            this.m_logger.log(4, "[" + this.m_debugKey + "] invoke added");
        }
        boolean added = false;
        Map map = this.m_sr;
        synchronized (map) {
            HashSet<Tuple> set = (HashSet<Tuple>)this.m_sr.get(dependencyService);
            if (set == null) {
                set = new HashSet<Tuple>();
                this.m_sr.put(dependencyService, set);
            }
            added = set.add(new Tuple(reference, service));
        }
        if (added) {
            if (this.m_callbackSwapped != null) {
                return this.handleAspectAwareAdded(dependencyService, reference, service);
            }
            this.invoke(dependencyService, reference, service, this.m_callbackAdded);
            return true;
        }
        return false;
    }

    private boolean invokeChanged(DependencyService dependencyService, ServiceReference reference, Object service) {
        if (this.m_callbackSwapped != null) {
            if (this.m_debug) {
                this.m_logger.log(4, "[" + this.m_debugKey + "] handleAspectAwareChanged on " + service);
            }
            return this.handleAspectAwareChanged(dependencyService, reference, service);
        }
        this.invoke(dependencyService, reference, service, this.m_callbackChanged);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean invokeRemoved(DependencyService dependencyService, ServiceReference reference, Object service) {
        if (this.m_debug) {
            this.m_logger.log(4, "[" + this.m_debugKey + "] invoke removed");
        }
        boolean removed = false;
        Map map = this.m_sr;
        synchronized (map) {
            Set set = (Set)this.m_sr.get(dependencyService);
            removed = set != null && set.remove(new Tuple(reference, service));
        }
        if (this.m_debug) {
            this.m_logger.log(4, "[" + this.m_debugKey + "] removed: " + removed);
        }
        if (removed) {
            if (this.m_callbackSwapped != null) {
                return this.handleAspectAwareRemoved(dependencyService, reference, service);
            }
            this.invoke(dependencyService, reference, service, this.m_callbackRemoved);
            return true;
        }
        return false;
    }

    private void invoke(DependencyService dependencyService, ServiceReference reference, Object service, String name) {
        this.invoke(this.getCallbackInstances(dependencyService), dependencyService, reference, service, name);
    }

    private boolean handleAspectAwareAdded(DependencyService dependencyService, ServiceReference reference, Object service) {
        if (this.m_debug) {
            this.m_logger.log(4, "[" + this.m_debugKey + "] aspectawareadded: " + reference.getProperty("service.ranking"));
        }
        if (this.componentIsDependencyManagerFactory(dependencyService)) {
            return false;
        }
        boolean invokeAdded = false;
        boolean invokeSwapped = false;
        Integer ranking = ServiceUtil.getRankingAsInteger(reference);
        Tuple newHighestRankedService = null;
        Tuple prevHighestRankedService = null;
        HashMap<Integer, Tuple> rankings = null;
        Long originalServiceId = ServiceUtil.getServiceIdAsLong(reference);
        HashMap componentMap = (HashMap)this.m_componentByRank.get(dependencyService);
        if (componentMap == null) {
            componentMap = new HashMap();
            this.m_componentByRank.put(dependencyService, componentMap);
        }
        if ((rankings = (HashMap<Integer, Tuple>)componentMap.get(originalServiceId)) == null) {
            rankings = new HashMap<Integer, Tuple>();
            componentMap.put(originalServiceId, rankings);
            rankings.put(ranking, new Tuple(reference, service));
            invokeAdded = true;
        }
        if (!invokeAdded) {
            prevHighestRankedService = (Tuple)this.getHighestRankedService(dependencyService, originalServiceId).getValue();
            newHighestRankedService = this.swapHighestRankedService(dependencyService, originalServiceId, reference, service, ranking);
            if (this.m_debug) {
                this.m_logger.log(4, "[" + this.m_debugKey + "] prevhigh: " + prevHighestRankedService.getServiceReference().getProperty("service.ranking") + ", new high: " + newHighestRankedService.getServiceReference().getProperty("service.ranking"));
            }
            if (!prevHighestRankedService.getServiceReference().equals(newHighestRankedService.getServiceReference())) {
                if (this.m_debug) {
                    this.m_logger.log(4, "[" + this.m_debugKey + "] New highest ranked to swap to");
                }
                invokeSwapped = true;
            } else if (this.m_debug) {
                this.m_logger.log(4, "[" + this.m_debugKey + "] Ignoring lower ranked or irrelevant swap");
            }
        }
        if (this.m_debug) {
            this.m_logger.log(4, "[" + this.m_debugKey + "] " + this.m_componentByRank.toString());
        }
        if (invokeAdded) {
            if (this.m_debug) {
                this.m_logger.log(4, "[" + this.m_debugKey + "] invoke added: " + reference.getProperty("service.ranking"));
            }
            this.invoke(dependencyService, reference, service, this.m_callbackAdded);
            return true;
        }
        if (invokeSwapped) {
            if (this.m_debug) {
                this.m_logger.log(4, "[" + this.m_debugKey + "] invoke swapped: " + newHighestRankedService.getServiceReference().getProperty("service.ranking") + " replacing " + prevHighestRankedService.getServiceReference().getProperty("service.ranking"));
            }
            this.invokeSwappedCallback(dependencyService, prevHighestRankedService.getServiceReference(), prevHighestRankedService.getService(), newHighestRankedService.getServiceReference(), newHighestRankedService.getService());
            return true;
        }
        return false;
    }

    private boolean componentIsDependencyManagerFactory(DependencyService dependencyService) {
        Object component = dependencyService.getService();
        if (component != null) {
            String className = component.getClass().getName();
            return className.startsWith("org.apache.felix.dm") && !className.startsWith("org.apache.felix.dm.impl.AdapterServiceImpl$AdapterImpl") && !className.startsWith("org.apache.felix.dm.test");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tuple swapHighestRankedService(DependencyService dependencyService, Long serviceId, ServiceReference newReference, Object newService, Integer newRanking) {
        Map map = this.m_componentByRank;
        synchronized (map) {
            Map componentMap = (Map)this.m_componentByRank.get(dependencyService);
            Map rankings = (Map)componentMap.get(serviceId);
            rankings.put(newRanking, new Tuple(newReference, newService));
            Map.Entry highestEntry = this.getHighestRankedService(dependencyService, serviceId);
            return (Tuple)highestEntry.getValue();
        }
    }

    private Map.Entry getHighestRankedService(DependencyService dependencyService, Long serviceId) {
        Map.Entry highestEntry = null;
        Map componentMap = (Map)this.m_componentByRank.get(dependencyService);
        Map rankings = (Map)componentMap.get(serviceId);
        if (rankings != null) {
            Iterator entryIterator = rankings.entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry mapEntry = entryIterator.next();
                if (highestEntry == null) {
                    highestEntry = mapEntry;
                    continue;
                }
                if ((Integer)mapEntry.getKey() <= (Integer)highestEntry.getKey()) continue;
                highestEntry = mapEntry;
            }
        }
        return highestEntry;
    }

    private boolean isLastService(DependencyService dependencyService, ServiceReference reference, Object object, Long serviceId) {
        Map componentMap = (Map)this.m_componentByRank.get(dependencyService);
        Map rankings = null;
        if (componentMap != null) {
            rankings = (Map)componentMap.get(serviceId);
        }
        if (this.m_debug) {
            this.m_logger.log(4, "[" + this.m_debugKey + "] last service: " + this.m_componentByRank.toString());
        }
        return componentMap != null && rankings != null && rankings.size() == 1 && rankings.entrySet().iterator().next().getKey().equals(ServiceUtil.getRankingAsInteger(reference));
    }

    private boolean handleAspectAwareChanged(DependencyService dependencyService, ServiceReference reference, Object service) {
        Map rankings;
        if (this.m_debug) {
            this.m_logger.log(4, "[" + this.m_debugKey + "] aspectawareChanged: service.ranking=" + reference.getProperty("service.ranking"));
        }
        if (this.componentIsDependencyManagerFactory(dependencyService)) {
            return false;
        }
        boolean invokeChanged = false;
        Long serviceId = ServiceUtil.getServiceIdAsLong(reference);
        Map componentMap = (Map)this.m_componentByRank.get(dependencyService);
        if (componentMap != null && (rankings = (Map)componentMap.get(serviceId)) != null) {
            Map.Entry highestEntry = this.getHighestRankedService(dependencyService, serviceId);
            if (this.m_debug) {
                this.m_logger.log(4, "[" + this.m_debugKey + "] highest service ref:" + highestEntry);
            }
            if (highestEntry == null) {
                invokeChanged = true;
            } else {
                Tuple tuple = (Tuple)highestEntry.getValue();
                if (reference.equals(tuple.getServiceReference())) {
                    invokeChanged = true;
                }
            }
        }
        if (this.m_debug) {
            this.m_logger.log(4, "[" + this.m_debugKey + "] invokeChanged=" + invokeChanged);
        }
        if (invokeChanged) {
            if (this.m_debug) {
                this.m_logger.log(4, "[" + this.m_debugKey + "] invoke changed: ref ranking=" + reference.getProperty("service.ranking"));
            }
            this.invoke(dependencyService, reference, service, this.m_callbackChanged);
            return true;
        }
        return false;
    }

    private boolean handleAspectAwareRemoved(DependencyService dependencyService, ServiceReference reference, Object service) {
        Map componentMap;
        if (this.m_debug) {
            this.m_logger.log(4, "[" + this.m_debugKey + "] aspectawareremoved: " + reference.getProperty("service.ranking"));
        }
        if (this.componentIsDependencyManagerFactory(dependencyService)) {
            return false;
        }
        boolean invokeRemoved = false;
        Long serviceId = ServiceUtil.getServiceIdAsLong(reference);
        Tuple prevHighestRankedService = null;
        Tuple newHighestRankedService = null;
        boolean invokeSwapped = false;
        Map rankings = null;
        Long originalServiceId = ServiceUtil.getServiceIdAsLong(reference);
        if (this.isLastService(dependencyService, reference, service, serviceId)) {
            invokeRemoved = true;
        } else {
            prevHighestRankedService = (Tuple)this.getHighestRankedService(dependencyService, originalServiceId).getValue();
            if (prevHighestRankedService.getServiceReference().equals(reference)) {
                if (this.m_debug) {
                    this.m_logger.log(4, "[" + this.m_debugKey + "] Swap out on remove!");
                }
                invokeSwapped = true;
            }
        }
        if (this.m_debug) {
            this.m_logger.log(4, "[" + this.m_debugKey + "] is last service: " + invokeRemoved);
        }
        if ((componentMap = (Map)this.m_componentByRank.get(dependencyService)) != null) {
            rankings = (Map)componentMap.get(originalServiceId);
            ArrayList rankingsToRemove = new ArrayList();
            Iterator entryIterator = rankings.entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry mapEntry = entryIterator.next();
                if (!((Tuple)mapEntry.getValue()).getServiceReference().equals(reference)) continue;
                rankingsToRemove.add(mapEntry.getKey());
            }
            Iterator rankingIterator = rankingsToRemove.iterator();
            while (rankingIterator.hasNext()) {
                rankings.remove(rankingIterator.next());
            }
            if (rankings.size() == 0) {
                componentMap.remove(originalServiceId);
            }
            if (componentMap.size() == 0) {
                this.m_componentByRank.remove(dependencyService);
            }
        }
        if (invokeSwapped) {
            newHighestRankedService = (Tuple)this.getHighestRankedService(dependencyService, originalServiceId).getValue();
        }
        if (invokeRemoved) {
            if (this.m_debug) {
                this.m_logger.log(4, "[" + this.m_debugKey + "] invoke removed: " + reference.getProperty("service.ranking"));
            }
            this.invoke(dependencyService, reference, service, this.m_callbackRemoved);
            return true;
        }
        if (invokeSwapped) {
            if (this.m_debug) {
                this.m_logger.log(4, "[" + this.m_debugKey + "] invoke swapped: " + newHighestRankedService.getServiceReference().getProperty("service.ranking") + " replacing " + prevHighestRankedService.getServiceReference().getProperty("service.ranking"));
            }
            this.invokeSwappedCallback(dependencyService, prevHighestRankedService.getServiceReference(), prevHighestRankedService.getService(), newHighestRankedService.getServiceReference(), newHighestRankedService.getService());
            return true;
        }
        return false;
    }

    private void invokeSwappedCallback(DependencyService component, ServiceReference previousReference, Object previous, ServiceReference currentServiceReference, Object current) {
        this.invokeSwappedCallback(this.getCallbackInstances(component), component, previousReference, previous, currentServiceReference, current, this.m_callbackSwapped);
    }

    private synchronized boolean makeUnavailable() {
        if (!(!this.isAvailable() || this.m_isStarted && this.m_tracker.hasReference())) {
            this.m_isAvailable = false;
            return true;
        }
        return false;
    }

    private synchronized Object[] getCallbackInstances(DependencyService dependencyService) {
        if (this.m_callbackInstance == null) {
            return dependencyService.getCompositionInstances();
        }
        return new Object[]{this.m_callbackInstance};
    }

    private void setService(Class serviceName, ServiceReference serviceReference, String serviceFilter) {
        this.ensureNotActive();
        this.m_trackedServiceName = serviceName == null ? (class$java$lang$Object == null ? (class$java$lang$Object = ServiceDependencyImpl.class$("java.lang.Object")) : class$java$lang$Object) : serviceName;
        if (serviceFilter != null) {
            this.m_trackedServiceFilterUnmodified = serviceFilter;
            this.m_trackedServiceFilter = serviceName == null ? serviceFilter : "(&(objectClass=" + serviceName.getName() + ")" + serviceFilter + ")";
        } else {
            this.m_trackedServiceFilterUnmodified = null;
            this.m_trackedServiceFilter = null;
        }
        if (serviceReference != null) {
            this.m_trackedServiceReference = serviceReference;
            if (serviceFilter != null) {
                throw new IllegalArgumentException("Cannot specify both a filter and a service reference.");
            }
        } else {
            this.m_trackedServiceReference = null;
        }
    }

    private void ensureNotActive() {
        if (this.m_tracker != null) {
            throw new IllegalStateException("Cannot modify state while active.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class ServicePropertiesMap
    extends AbstractMap {
        private final ServiceReference m_ref;

        public ServicePropertiesMap(ServiceReference ref) {
            this.m_ref = ref;
        }

        public Object get(Object key) {
            return this.m_ref.getProperty(key.toString());
        }

        public int size() {
            return this.m_ref.getPropertyKeys().length;
        }

        public Set entrySet() {
            HashSet<ServicePropertiesMapEntry> set = new HashSet<ServicePropertiesMapEntry>();
            String[] keys = this.m_ref.getPropertyKeys();
            for (int i = 0; i < keys.length; ++i) {
                set.add(new ServicePropertiesMapEntry(keys[i], this.m_ref.getProperty(keys[i])));
            }
            return set;
        }
    }

    private static final class ServicePropertiesMapEntry
    implements Map.Entry {
        private final String m_key;
        private Object m_value;

        public ServicePropertiesMapEntry(String key, Object value) {
            this.m_key = key;
            this.m_value = value;
        }

        public Object getKey() {
            return this.m_key;
        }

        public Object getValue() {
            return this.m_value;
        }

        public String toString() {
            return this.m_key + "=" + this.m_value;
        }

        public Object setValue(Object value) {
            Object oldValue = this.m_value;
            this.m_value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return ServicePropertiesMapEntry.eq(this.m_key, e.getKey()) && ServicePropertiesMapEntry.eq(this.m_value, e.getValue());
        }

        public int hashCode() {
            return (this.m_key == null ? 0 : this.m_key.hashCode()) ^ (this.m_value == null ? 0 : this.m_value.hashCode());
        }

        private static final boolean eq(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }
    }

    private static final class Tuple {
        private final ServiceReference m_serviceReference;
        private final Object m_service;

        public Tuple(ServiceReference first, Object last) {
            this.m_serviceReference = first;
            this.m_service = last;
        }

        public ServiceReference getServiceReference() {
            return this.m_serviceReference;
        }

        public Object getService() {
            return this.m_service;
        }

        public boolean equals(Object obj) {
            return ((Tuple)obj).getServiceReference().equals(this.getServiceReference());
        }

        public int hashCode() {
            return this.m_serviceReference.hashCode();
        }

        public String toString() {
            return "{" + this.m_serviceReference.getProperty("service.id") + "=" + this.m_service + "}";
        }
    }
}

