/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl.index.multiproperty;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.felix.dm.impl.index.multiproperty.Property;

public class Filter {
    private boolean m_valid = true;
    private Map m_properties = new HashMap();
    private Set m_propertyKeys = new TreeSet(String.CASE_INSENSITIVE_ORDER);

    private Filter() {
    }

    public static Filter parse(String filterString) {
        Filter filter = new Filter();
        StringTokenizer tokenizer = new StringTokenizer(filterString, "(&|=)", true);
        String token = null;
        String prevToken = null;
        String key = null;
        StringBuilder valueBuilder = new StringBuilder();
        boolean negate = false;
        while (tokenizer.hasMoreTokens()) {
            Property property;
            prevToken = token;
            token = tokenizer.nextToken();
            if (token.equals("|")) {
                filter.m_valid = false;
                break;
            }
            if (token.equals("!")) {
                negate = true;
                continue;
            }
            if (token.equals("=")) {
                key = prevToken.toLowerCase();
                continue;
            }
            if (key == null) continue;
            if (!token.equals(")")) {
                valueBuilder.append(token);
            }
            if (!token.equals(")")) continue;
            if (filter.m_properties.containsKey(key)) {
                property = (Property)filter.m_properties.get(key);
                property.addValue(valueBuilder.toString(), negate);
            } else {
                property = new Property(negate, key, valueBuilder.toString());
                filter.m_properties.put(key, property);
                filter.m_propertyKeys.add(key);
            }
            negate = false;
            key = null;
            valueBuilder = new StringBuilder();
        }
        return filter;
    }

    public boolean containsProperty(String propertyKey) {
        return this.m_properties.containsKey(propertyKey);
    }

    public Set getPropertyKeys() {
        return this.m_properties.keySet();
    }

    public Property getProperty(String key) {
        return (Property)this.m_properties.get(key);
    }

    public boolean isValid() {
        if (!this.m_valid) {
            return this.m_valid;
        }
        Iterator propertiesIterator = this.m_properties.values().iterator();
        while (propertiesIterator.hasNext()) {
            Property property = (Property)propertiesIterator.next();
            if (property.isValid()) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        Filter parser = Filter.parse("(&(objectClass=OBJECTCLASS)(&(a=x)(a=n)(a=y)(b=y)(c=z)))");
        System.out.println("key: " + parser.createKey());
    }

    protected String createKey() {
        StringBuilder builder = new StringBuilder();
        Iterator keys = this.m_propertyKeys.iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Property prop = (Property)this.m_properties.get(key);
            if (prop.isWildcard()) continue;
            Iterator values = prop.getValues().iterator();
            while (values.hasNext()) {
                String value = (String)values.next();
                builder.append(key);
                builder.append("=");
                builder.append(value);
                if (!keys.hasNext() && !values.hasNext()) continue;
                builder.append(";");
            }
        }
        if (builder.charAt(builder.length() - 1) == ';') {
            return builder.toString().substring(0, builder.length() - 1);
        }
        return builder.toString();
    }
}

