/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.runtime;

import org.apache.felix.dm.BundleDependency;
import org.apache.felix.dm.ConfigurationDependency;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.ResourceDependency;
import org.apache.felix.dm.ServiceDependency;
import org.apache.felix.dm.runtime.MetaData;
import org.apache.felix.dm.runtime.Params;
import org.osgi.framework.Bundle;

public class DependencyBuilder {
    private MetaData m_metaData;

    public DependencyBuilder(MetaData dependencyMetaData) {
        this.m_metaData = dependencyMetaData;
    }

    public Dependency build(Bundle b, DependencyManager dm) throws Exception {
        DependencyType type;
        Dependency dp = null;
        try {
            type = DependencyType.valueOf(this.m_metaData.getString(Params.type));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("no \"type\" parameter found from metaData: " + this.m_metaData);
        }
        switch (type) {
            case ServiceDependency: {
                dp = this.createServiceDependency(b, dm);
                break;
            }
            case ConfigurationDependency: {
                dp = this.createConfigurationDependency(dm);
                break;
            }
            case BundleDependency: {
                dp = this.createBundleDependency(dm);
                break;
            }
            case ResourceDependency: {
                dp = this.createResourceDependency(dm);
                break;
            }
            default: {
                throw new IllegalArgumentException("Can't build service dependency: " + (Object)((Object)type));
            }
        }
        return dp;
    }

    private Dependency createServiceDependency(Bundle b, DependencyManager dm) throws ClassNotFoundException {
        String service = this.m_metaData.getString(Params.service);
        Class serviceClass = b.loadClass(service);
        String serviceFilter = this.m_metaData.getString(Params.filter, null);
        String defaultServiceImpl = this.m_metaData.getString(Params.defaultImpl, null);
        Class defaultServiceImplClass = defaultServiceImpl != null ? b.loadClass(defaultServiceImpl) : null;
        String added = this.m_metaData.getString(Params.added, null);
        long timeout = this.m_metaData.getLong(Params.timeout, -1L);
        String changed = timeout != -1L ? null : this.m_metaData.getString(Params.changed, null);
        String removed = timeout != -1L ? null : this.m_metaData.getString(Params.removed, null);
        String autoConfigField = this.m_metaData.getString(Params.autoConfig, null);
        boolean required = "true".equals(this.m_metaData.getString(Params.required, "true"));
        boolean propagate = "true".equals(this.m_metaData.getString(Params.propagate, "false"));
        Dependency dp = this.createServiceDependency(dm, serviceClass, serviceFilter, defaultServiceImplClass, added, changed, removed, autoConfigField, timeout, required, propagate);
        return dp;
    }

    private Dependency createServiceDependency(DependencyManager dm, Class<?> serviceClass, String serviceFilter, Class<?> defaultServiceImplClass, String added, String changed, String removed, String autoConfigField, long timeout, boolean required, boolean propagate) {
        ServiceDependency sd = timeout != -1L ? dm.createTemporalServiceDependency(timeout) : dm.createServiceDependency();
        sd.setService(serviceClass, serviceFilter);
        if (defaultServiceImplClass != null) {
            sd.setDefaultImplementation(defaultServiceImplClass);
        }
        sd.setCallbacks(added, changed, removed);
        if (autoConfigField != null) {
            sd.setAutoConfig(autoConfigField);
        }
        if (timeout == -1L) {
            sd.setRequired(required);
        }
        sd.setPropagate(propagate);
        return sd;
    }

    private Dependency createConfigurationDependency(DependencyManager dm) {
        String pid = this.m_metaData.getString(Params.pid);
        boolean propagate = "true".equals(this.m_metaData.getString(Params.propagate, "false"));
        String callback = this.m_metaData.getString(Params.updated, "updated");
        Dependency dp = this.createConfigurationDependency(dm, pid, callback, propagate);
        return dp;
    }

    private Dependency createConfigurationDependency(DependencyManager dm, String pid, String callback, boolean propagate) {
        if (pid == null) {
            throw new IllegalArgumentException("pid attribute not provided in ConfigurationDependency declaration");
        }
        ConfigurationDependency cd = dm.createConfigurationDependency();
        cd.setPid(pid);
        cd.setCallback(callback);
        cd.setPropagate(propagate);
        return cd;
    }

    private Dependency createBundleDependency(DependencyManager dm) {
        String added = this.m_metaData.getString(Params.added, null);
        String changed = this.m_metaData.getString(Params.changed, null);
        String removed = this.m_metaData.getString(Params.removed, null);
        boolean required = "true".equals(this.m_metaData.getString(Params.required, "true"));
        String filter = this.m_metaData.getString(Params.filter, null);
        int stateMask = this.m_metaData.getInt(Params.stateMask, -1);
        boolean propagate = "true".equals(this.m_metaData.getString(Params.propagate, "false"));
        Dependency dp = this.createBundleDependency(dm, added, changed, removed, required, propagate, filter, stateMask);
        return dp;
    }

    private Dependency createBundleDependency(DependencyManager dm, String added, String changed, String removed, boolean required, boolean propagate, String filter, int stateMask) {
        BundleDependency bd = dm.createBundleDependency();
        bd.setCallbacks(added, changed, removed);
        bd.setRequired(required);
        bd.setPropagate(propagate);
        if (filter != null) {
            bd.setFilter(filter);
        }
        if (stateMask != -1) {
            bd.setStateMask(stateMask);
        }
        return bd;
    }

    private Dependency createResourceDependency(DependencyManager dm) {
        String added = this.m_metaData.getString(Params.added, null);
        String changed = this.m_metaData.getString(Params.changed, null);
        String removed = this.m_metaData.getString(Params.removed, null);
        String filter = this.m_metaData.getString(Params.filter, null);
        boolean required = "true".equals(this.m_metaData.getString(Params.required, "true"));
        boolean propagate = "true".equals(this.m_metaData.getString(Params.propagate, "false"));
        String autoConfigField = this.m_metaData.getString(Params.autoConfig, null);
        Dependency dp = this.createResourceDependency(dm, added, changed, removed, required, filter, propagate, autoConfigField);
        return dp;
    }

    private Dependency createResourceDependency(DependencyManager dm, String added, String changed, String removed, boolean required, String filter, boolean propagate, String autoConfigField) {
        ResourceDependency rd = dm.createResourceDependency();
        rd.setCallbacks(added, changed, removed);
        rd.setRequired(required);
        if (filter != null) {
            rd.setFilter(filter);
        }
        if (autoConfigField != null) {
            rd.setAutoConfig(autoConfigField);
        }
        rd.setPropagate(propagate);
        return rd;
    }

    public static enum DependencyType {
        ServiceDependency,
        TemporalServiceDependency,
        ConfigurationDependency,
        BundleDependency,
        ResourceDependency;

    }
}

