/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.shell;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.ComponentDeclaration;
import org.apache.felix.dm.ComponentDependencyDeclaration;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.shell.ComponentId;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Descriptor;
import org.apache.felix.service.command.Parameter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

@Descriptor(value="Commands used to dump all existing Dependency Manager components")
public class DMCommand {
    private final BundleContext m_context;
    private static final DependencyManagerSorter SORTER = new DependencyManagerSorter();
    private static final String SERVICE = "service";
    private static final String CONFIGURATION = "configuration";
    private static final String ENV_COMPACT = "dependencymanager.compact";
    private static final String ENV_SERVICES = "dependencymanager.services";
    private static final String ENV_COMPONENTS = "dependencymanager.components";

    public DMCommand(BundleContext context) {
        this.m_context = context;
    }

    @Descriptor(value="List dependency manager components")
    public void dm(CommandSession session, @Descriptor(value="Hides component dependencies") @Parameter(names={"nodeps", "nd"}, presentValue="true", absentValue="false") boolean nodeps, @Descriptor(value="Displays components using a compact form") @Parameter(names={"compact", "cp"}, presentValue="true", absentValue="") String compact, @Descriptor(value="Only displays unavailable components") @Parameter(names={"notavail", "na"}, presentValue="true", absentValue="false") boolean notavail, @Descriptor(value="Detects where are the root failures") @Parameter(names={"wtf"}, presentValue="true", absentValue="false") boolean wtf, @Descriptor(value="Displays components statistics") @Parameter(names={"stats", "stat", "st"}, presentValue="true", absentValue="false") boolean stats, @Descriptor(value="<OSGi filter used to filter some service properties>") @Parameter(names={"services", "s"}, absentValue="") String services, @Descriptor(value="<Regex(s) used to filter on component implementation class names (comma separated), can be negated using \"!\" prefix>") @Parameter(names={"components", "c"}, absentValue="") String components, @Descriptor(value="<List of component identifiers to display (comma separated)>") @Parameter(names={"componentIds", "cid", "ci"}, absentValue="") String componentIds, @Descriptor(value="<List of bundle ids or bundle symbolic names to display (comma separated)>") @Parameter(names={"bundleIds", "bid", "bi", "b"}, absentValue="") String bundleIds, @Descriptor(value="<Max number of top components to display (0=all)> This command displays components callbacks (init/start) times>") @Parameter(names={"top"}, absentValue="-1") int top) throws Throwable {
        boolean comp = Boolean.parseBoolean(this.getParam(session, ENV_COMPACT, compact));
        services = this.getParam(session, ENV_SERVICES, services);
        String[] componentsRegex = this.getParams(session, ENV_COMPONENTS, components);
        ArrayList<String> bids = new ArrayList<String>();
        ArrayList<Long> cids = new ArrayList<Long>();
        StringTokenizer tok = new StringTokenizer(componentIds, ", ");
        while (tok.hasMoreTokens()) {
            try {
                cids.add(Long.parseLong(tok.nextToken()));
            }
            catch (NumberFormatException e) {
                System.out.println("Invalid value for componentIds option");
                return;
            }
        }
        Filter servicesFilter = null;
        try {
            if (services != null) {
                servicesFilter = this.m_context.createFilter(services);
            }
        }
        catch (InvalidSyntaxException e) {
            System.out.println("Invalid services OSGi filter: " + services);
            e.printStackTrace(System.err);
            return;
        }
        tok = new StringTokenizer(bundleIds, ", ");
        while (tok.hasMoreTokens()) {
            bids.add(tok.nextToken());
        }
        if (top != -1) {
            this.showTopComponents(top);
            return;
        }
        if (wtf) {
            this.wtf();
            return;
        }
        List managers = DependencyManager.getDependencyManagers();
        Collections.sort(managers, SORTER);
        Iterator iterator = managers.iterator();
        long numberOfComponents = 0L;
        long numberOfDependencies = 0L;
        long lastBundleId = -1L;
        while (iterator.hasNext()) {
            DependencyManager manager = (DependencyManager)iterator.next();
            List complist = manager.getComponents();
            for (Component component : complist) {
                ComponentDependencyDeclaration[] dependencies;
                ComponentDeclaration sc = component.getComponentDeclaration();
                String name = sc.getName();
                if (!this.mayDisplay(component, servicesFilter, componentsRegex, cids)) continue;
                int state = sc.getState();
                Bundle bundle = sc.getBundleContext().getBundle();
                if (!this.matchBundle(bundle, bids)) continue;
                long bundleId = bundle.getBundleId();
                if (notavail && sc.getState() != 0) continue;
                ++numberOfComponents;
                if (lastBundleId != bundleId) {
                    lastBundleId = bundleId;
                    if (comp) {
                        System.out.println("[" + bundleId + "] " + this.compactName(bundle.getSymbolicName()));
                    } else {
                        System.out.println("[" + bundleId + "] " + bundle.getSymbolicName());
                    }
                }
                if (comp) {
                    System.out.print(" [" + sc.getId() + "] " + this.compactName(name) + " " + this.compactState(ComponentDeclaration.STATE_NAMES[state]));
                } else {
                    System.out.println(" [" + sc.getId() + "] " + name + " " + ComponentDeclaration.STATE_NAMES[state]);
                }
                if (!nodeps && (dependencies = sc.getComponentDependencies()) != null && dependencies.length > 0) {
                    numberOfDependencies += (long)dependencies.length;
                    if (comp) {
                        System.out.print('(');
                    }
                    for (int j = 0; j < dependencies.length; ++j) {
                        ComponentDependencyDeclaration dep = dependencies[j];
                        if (notavail && !this.isUnavailable(dep)) continue;
                        String depName = dep.getName();
                        String depType = dep.getType();
                        int depState = dep.getState();
                        if (comp) {
                            if (j > 0) {
                                System.out.print(' ');
                            }
                            System.out.print(this.compactName(depName) + " " + this.compactState(depType) + " " + this.compactState(ComponentDependencyDeclaration.STATE_NAMES[depState]));
                            continue;
                        }
                        System.out.println("    " + depName + " " + depType + " " + ComponentDependencyDeclaration.STATE_NAMES[depState]);
                    }
                    if (comp) {
                        System.out.print(')');
                    }
                }
                if (!comp) continue;
                System.out.println();
            }
        }
        if (stats) {
            System.out.println("Statistics:");
            System.out.println(" - Dependency managers: " + managers.size());
            System.out.println(" - Components: " + numberOfComponents);
            if (!nodeps) {
                System.out.println(" - Dependencies: " + numberOfDependencies);
            }
        }
    }

    private void showTopComponents(int max) {
        ArrayList components = new ArrayList();
        for (DependencyManager manager : DependencyManager.getDependencyManagers()) {
            components.addAll(manager.getComponents());
        }
        Collections.sort(components, new Comparator<Component>(){

            @Override
            public int compare(Component c1, Component c2) {
                Map c1Times = c1.getComponentDeclaration().getCallbacksTime();
                Map c2Times = c2.getComponentDeclaration().getCallbacksTime();
                Long c1Start = (Long)c1Times.get("start");
                Long c2Start = (Long)c2Times.get("start");
                if (c1Start != null) {
                    if (c2Start != null) {
                        return c1Start > c2Start ? 1 : -1;
                    }
                    return 1;
                }
                if (c2Start != null) {
                    return -1;
                }
                return 0;
            }
        });
        Collections.reverse(components);
        System.out.printf("%-100s %10s %10s%n%n", "Top components (sorted by start duration time)", "[init time]", "[start time]");
        if (components.size() > 0) {
            System.out.println();
            max = max == 0 ? components.size() : Math.min(components.size(), max);
            for (int i = 0; i < components.size() && i < max; ++i) {
                ComponentDeclaration decl = ((Component)components.get(i)).getComponentDeclaration();
                System.out.printf("%-100s %10d %10d%n", decl.getClassName(), decl.getCallbacksTime().get("init"), decl.getCallbacksTime().get("start"));
            }
        }
    }

    private boolean isUnavailable(ComponentDependencyDeclaration dep) {
        switch (dep.getState()) {
            case 0: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    private boolean matchBundle(Bundle bundle, List<String> ids) {
        if (ids.size() == 0) {
            return true;
        }
        for (int i = 0; i < ids.size(); ++i) {
            String id = ids.get(i);
            try {
                Long longId = Long.valueOf(id);
                if (longId.longValue() != bundle.getBundleId()) continue;
                return true;
            }
            catch (NumberFormatException e) {
                if (!id.equals(bundle.getSymbolicName())) continue;
                return true;
            }
        }
        return false;
    }

    private String getParam(CommandSession session, String param, String value) {
        if (value != null && value.length() > 0) {
            return value;
        }
        Object shellParamValue = session.get(param);
        return shellParamValue != null ? shellParamValue.toString() : null;
    }

    private String[] getParams(CommandSession session, String name, String value) {
        String values = null;
        if (value == null || value.length() == 0) {
            value = (String)session.get(name);
            if (value != null) {
                values = value;
            }
        } else {
            values = value;
        }
        if (values == null) {
            return new String[0];
        }
        return values.trim().split(", ");
    }

    private boolean mayDisplay(Component component, Filter servicesFilter, String[] components, List<Long> componentIds) {
        long componentId;
        if (componentIds.size() > 0 && componentIds.indexOf(componentId = ((ComponentDeclaration)component).getId()) == -1) {
            return false;
        }
        if (servicesFilter == null && components.length == 0) {
            return true;
        }
        boolean servicesMatches = this.servicesMatches(component, servicesFilter);
        boolean componentsMatches = this.componentMatches(((ComponentDeclaration)component).getClassName(), components);
        return servicesMatches || componentsMatches;
    }

    private boolean servicesMatches(Component component, Filter servicesFilter) {
        String[] services;
        boolean match = false;
        if (servicesFilter != null && (services = ((ComponentDeclaration)component).getServices()) != null) {
            Hashtable<String, String[]> properties = component.getServiceProperties();
            if (properties == null) {
                properties = new Hashtable<String, String[]>();
            }
            if (((Dictionary)properties).get("objectClass") == null) {
                ((Dictionary)properties).put("objectClass", services);
            }
            match = servicesFilter.match(properties);
        }
        return match;
    }

    private boolean componentMatches(String description, String[] names) {
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            boolean not = false;
            if (name.startsWith("!")) {
                name = name.substring(1);
                not = true;
            }
            boolean match = false;
            if (description.matches(name)) {
                match = true;
            }
            if (not) {
                boolean bl = match = !match;
            }
            if (!match) continue;
            return true;
        }
        return false;
    }

    private String compactState(String input) {
        StringBuffer output = new StringBuffer();
        StringTokenizer st = new StringTokenizer(input);
        while (st.hasMoreTokens()) {
            output.append(st.nextToken().toUpperCase().charAt(0));
        }
        return output.toString();
    }

    private String compactName(String input) {
        StringBuffer output = new StringBuffer();
        int lastIndex = 0;
        block4: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '.': {
                    output.append(input.charAt(lastIndex));
                    output.append('.');
                    lastIndex = i + 1;
                    continue block4;
                }
                case ' ': 
                case ',': {
                    if (lastIndex < i) {
                        output.append(input.substring(lastIndex, i));
                    }
                    output.append(c);
                    lastIndex = i + 1;
                    continue block4;
                }
            }
        }
        if (lastIndex < input.length()) {
            output.append(input.substring(lastIndex));
        }
        return output.toString();
    }

    public void wtf() {
        List<ComponentDeclaration> downComponents = this.getComponentsThatAreUnregistered();
        if (downComponents.isEmpty()) {
            System.out.println("No missing dependencies found.");
        } else {
            String message = downComponents.size() + " missing dependencies found.";
            System.out.println(message);
            System.out.println("----------------------------------------------------".substring(0, message.length()));
        }
        this.listResolvedBundles();
        this.listInstalledBundles();
        Set<ComponentId> downComponentsRoot = this.getTheRootCouses(downComponents);
        this.listAllMissingConfigurations(downComponentsRoot);
        this.listAllMissingServices(downComponents, downComponentsRoot);
    }

    private Set<ComponentId> getTheRootCouses(List<ComponentDeclaration> downComponents) {
        TreeSet<ComponentId> downComponentsRoot = new TreeSet<ComponentId>();
        for (ComponentDeclaration c : downComponents) {
            List<ComponentId> root = this.getRoot(downComponents, c, new ArrayList<ComponentId>());
            downComponentsRoot.addAll(root);
        }
        return downComponentsRoot;
    }

    private List<ComponentDeclaration> getComponentsThatAreUnregistered() {
        List dependencyManagers = DependencyManager.getDependencyManagers();
        ArrayList<ComponentDeclaration> unregisteredComponents = new ArrayList<ComponentDeclaration>();
        for (DependencyManager dm : dependencyManagers) {
            List components = dm.getComponents();
            for (Component c : components) {
                ComponentDeclaration cd = c.getComponentDeclaration();
                if (cd.getState() != 0) continue;
                unregisteredComponents.add(cd);
            }
        }
        return unregisteredComponents;
    }

    private void listResolvedBundles() {
        boolean areResolved = false;
        for (Bundle b : this.m_context.getBundles()) {
            if (b.getState() != 4 || this.isFragment(b)) continue;
            areResolved = true;
            break;
        }
        if (areResolved) {
            System.out.println("Please note that the following bundles are in the RESOLVED state:");
            for (Bundle b : this.m_context.getBundles()) {
                if (b.getState() != 4 || this.isFragment(b)) continue;
                System.out.println(" * [" + b.getBundleId() + "] " + b.getSymbolicName());
            }
        }
    }

    private void listInstalledBundles() {
        boolean areResolved = false;
        for (Bundle b : this.m_context.getBundles()) {
            if (b.getState() != 2) continue;
            areResolved = true;
            break;
        }
        if (areResolved) {
            System.out.println("Please note that the following bundles are in the INSTALLED state:");
            for (Bundle b : this.m_context.getBundles()) {
                if (b.getState() != 2) continue;
                System.out.println(" * [" + b.getBundleId() + "] " + b.getSymbolicName());
            }
        }
    }

    private boolean isFragment(Bundle b) {
        Dictionary headers = b.getHeaders();
        return headers.get("Fragment-Host") != null;
    }

    private void listAllMissingConfigurations(Set<ComponentId> unregisteredComponentsRoot) {
        if (this.hasMissingType(unregisteredComponentsRoot, CONFIGURATION)) {
            System.out.println("The following configuration(s) are missing: ");
            for (ComponentId s : unregisteredComponentsRoot) {
                if (!CONFIGURATION.equals(s.getType())) continue;
                System.out.println(" * " + s.getName() + " for bundle " + s.getBundleName());
            }
        }
    }

    private void listAllMissingServices(List<ComponentDeclaration> downComponents, Set<ComponentId> unregisteredComponentsRoot) {
        if (this.hasMissingType(unregisteredComponentsRoot, SERVICE)) {
            System.out.println("The following service(s) are missing: ");
            for (ComponentId s : unregisteredComponentsRoot) {
                if (!SERVICE.equals(s.getType())) continue;
                System.out.print(" * " + s.getName());
                ComponentDeclaration component = this.getComponentDeclaration(s.getName(), downComponents);
                if (component == null) {
                    System.out.println(" is not found in the service registry");
                    continue;
                }
                ComponentDependencyDeclaration[] componentDependencies = component.getComponentDependencies();
                System.out.println(" and needs:");
                for (ComponentDependencyDeclaration cdd : componentDependencies) {
                    if (cdd.getState() != 2) continue;
                    System.out.println(cdd.getName());
                }
                System.out.println(" to work");
            }
        }
    }

    private boolean hasMissingType(Set<ComponentId> downComponentsRoot, String type) {
        for (ComponentId s : downComponentsRoot) {
            if (!type.equals(s.getType())) continue;
            return true;
        }
        return false;
    }

    private List<ComponentId> getRoot(List<ComponentDeclaration> downComponents, ComponentDeclaration c, List<ComponentId> backTrace) {
        ComponentDependencyDeclaration[] componentDependencies = c.getComponentDependencies();
        int unregisteredDeps = 0;
        ArrayList<ComponentId> result = new ArrayList<ComponentId>();
        for (ComponentDependencyDeclaration cdd : componentDependencies) {
            if (cdd.getState() != 2) continue;
            ++unregisteredDeps;
            if (CONFIGURATION.equals(cdd.getType())) {
                String bsn = c.getBundleContext().getBundle().getSymbolicName();
                result.add(new ComponentId(cdd.getName(), cdd.getType(), bsn));
                continue;
            }
            ComponentDeclaration component = this.getComponentDeclaration(cdd.getName(), downComponents);
            if (component == null) {
                result.add(new ComponentId(cdd.getName(), cdd.getType(), null));
                continue;
            }
            ComponentId componentId = new ComponentId(cdd.getName(), cdd.getType(), null);
            if (backTrace.contains(componentId)) {
                System.out.print("Circular dependency found:\n *");
                for (ComponentId cid : backTrace) {
                    System.out.print(" -> " + cid.getName() + " ");
                }
                System.out.println(" -> " + componentId.getName());
                result.add(new ComponentId(c.getName(), SERVICE, c.getBundleContext().getBundle().getSymbolicName()));
                continue;
            }
            backTrace.add(componentId);
            return this.getRoot(downComponents, component, backTrace);
        }
        if (unregisteredDeps > 0 && result.isEmpty()) {
            result.add(new ComponentId(c.getName(), SERVICE, c.getBundleContext().getBundle().getSymbolicName()));
        }
        return result;
    }

    private ComponentDeclaration getComponentDeclaration(String fullName, List<ComponentDeclaration> list) {
        String simpleName = this.getSimpleName(fullName);
        Properties props = this.parseProperties(fullName);
        for (ComponentDeclaration c : list) {
            String serviceNames = c.getName();
            int cuttOff = serviceNames.indexOf("(");
            if (cuttOff != -1) {
                serviceNames = serviceNames.substring(0, cuttOff).trim();
            }
            for (String serviceName : serviceNames.split(",")) {
                if (!simpleName.equals(serviceName.trim()) || !this.doPropertiesMatch(props, this.parseProperties(c.getName()))) continue;
                return c;
            }
        }
        return null;
    }

    private boolean doPropertiesMatch(Properties need, Properties provide) {
        for (Map.Entry<Object, Object> entry : need.entrySet()) {
            Object prop = provide.get(entry.getKey());
            if (prop != null && prop.equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    private String getSimpleName(String name) {
        int cuttOff = name.indexOf("(");
        if (cuttOff != -1) {
            return name.substring(0, cuttOff).trim();
        }
        return name.trim();
    }

    private Properties parseProperties(String name) {
        Properties result = new Properties();
        int cuttOff = name.indexOf("(");
        if (cuttOff != -1) {
            String[] split;
            String propsText = name.substring(cuttOff + 1, name.indexOf(")"));
            for (String prop : split = propsText.split(",")) {
                String[] kv = prop.split("=");
                if (kv.length != 2) continue;
                result.put(kv[0], kv[1]);
            }
        }
        return result;
    }

    public static class DependencyManagerSorter
    implements Comparator<DependencyManager> {
        @Override
        public int compare(DependencyManager dm1, DependencyManager dm2) {
            long id2;
            long id1 = dm1.getBundleContext().getBundle().getBundleId();
            return id1 > (id2 = dm2.getBundleContext().getBundle().getBundleId()) ? 1 : -1;
        }
    }
}

