/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.felix.dm.Logger;
import org.apache.felix.dm.context.DependencyContext;
import org.apache.felix.dm.context.Event;

public class FieldUtil {
    public static boolean injectField(Object[] targets, String fieldName, Class<?> clazz, final Object service, final Logger logger) {
        if (service == null) {
            return true;
        }
        return FieldUtil.mapField(true, clazz, targets, fieldName, logger, new FieldFunction(){

            @Override
            public void injectField(Field f, Object target) {
                try {
                    f.setAccessible(true);
                    f.set(target, service);
                }
                catch (Throwable e) {
                    logger.log(1, "Could not set field " + f + " in class " + target.getClass().getName(), e);
                }
            }

            @Override
            public void injectIterableField(Field f, Object target) {
            }

            @Override
            public void injectMapField(Field f, Object target) {
            }
        });
    }

    public static boolean injectDependencyField(Object[] targets, String fieldName, Class<?> clazz, final DependencyContext dc, final Logger logger) {
        final Event event = dc.getService();
        if (event == null) {
            return true;
        }
        return FieldUtil.mapField(false, clazz, targets, fieldName, logger, new FieldFunction(){

            @Override
            public void injectField(Field f, Object target) {
                try {
                    f.setAccessible(true);
                    f.set(target, event.getEvent());
                }
                catch (Throwable e) {
                    logger.log(1, "Could not set field " + f + " in class " + target.getClass().getName(), e);
                }
            }

            @Override
            public void injectIterableField(Field f, Object target) {
                f.setAccessible(true);
                try {
                    ConcurrentLinkedQueue iter = (ConcurrentLinkedQueue)f.get(target);
                    if (iter == null) {
                        iter = new ConcurrentLinkedQueue();
                        f.set(target, iter);
                    }
                    dc.copyToCollection(iter);
                }
                catch (Throwable e) {
                    logger.log(1, "Could not set field " + f + " in class " + target.getClass().getName(), e);
                }
            }

            @Override
            public void injectMapField(Field f, Object target) {
                f.setAccessible(true);
                try {
                    ConcurrentHashMap map = (ConcurrentHashMap)f.get(target);
                    if (map == null) {
                        map = new ConcurrentHashMap();
                        f.set(target, map);
                    }
                    dc.copyToMap(map);
                }
                catch (Throwable e) {
                    logger.log(1, "Could not set field " + f + " in class " + target.getClass().getName(), e);
                }
            }
        });
    }

    public static void updateDependencyField(Object[] targets, String fieldName, final boolean update, final boolean add, Class<?> clazz, final Event event, final DependencyContext dc, final Logger logger) {
        FieldUtil.mapField(false, clazz, targets, fieldName, logger, new FieldFunction(){

            @Override
            public void injectField(Field f, Object target) {
                try {
                    f.setAccessible(true);
                    f.set(target, dc.getService().getEvent());
                }
                catch (Throwable e) {
                    logger.log(1, "Could not set field " + f + " in class " + target.getClass().getName(), e);
                }
            }

            @Override
            public void injectIterableField(Field f, Object target) {
                if (update) {
                    return;
                }
                f.setAccessible(true);
                try {
                    Collection coll = (Collection)f.get(target);
                    if (add) {
                        coll.add(event.getEvent());
                    } else {
                        coll.remove(event.getEvent());
                    }
                }
                catch (Throwable e) {
                    logger.log(1, "Could not set field " + f + " in class " + target.getClass().getName(), e);
                }
            }

            @Override
            public void injectMapField(Field f, Object target) {
                f.setAccessible(true);
                try {
                    Map map = (Map)f.get(target);
                    if (add) {
                        map.put(event.getEvent(), event.getProperties());
                    } else {
                        map.remove(event.getEvent());
                    }
                }
                catch (Throwable e) {
                    logger.log(1, "Could not set field " + f + " in class " + target.getClass().getName(), e);
                }
            }
        });
    }

    private static boolean mapField(boolean strict, Class<?> clazz, Object[] targets, String fieldName, Logger logger, FieldFunction func) {
        boolean injected = false;
        if (targets != null && clazz != null) {
            for (int i = 0; i < targets.length; ++i) {
                Object target = targets[i];
                Class<?> targetClass = target.getClass();
                if (Proxy.isProxyClass(targetClass)) {
                    target = Proxy.getInvocationHandler(target);
                    targetClass = target.getClass();
                }
                while (targetClass != null) {
                    Field[] fields = targetClass.getDeclaredFields();
                    for (int j = 0; j < fields.length; ++j) {
                        Field field = fields[j];
                        Class<?> fieldType = field.getType();
                        if (fieldName == null) {
                            if (fieldType.equals(clazz)) {
                                injected = true;
                                func.injectField(field, target);
                                continue;
                            }
                            if (!strict && FieldUtil.mayInjectToIterable(clazz, field, true)) {
                                injected = true;
                                func.injectIterableField(field, target);
                                continue;
                            }
                            if (strict || !FieldUtil.mayInjectToMap(clazz, field, true)) continue;
                            injected = true;
                            func.injectMapField(field, target);
                            continue;
                        }
                        if (!field.getName().equals(fieldName)) continue;
                        if (fieldType.isAssignableFrom(clazz)) {
                            injected = true;
                            func.injectField(field, target);
                            continue;
                        }
                        if (!strict && FieldUtil.mayInjectToIterable(clazz, field, false)) {
                            injected = true;
                            func.injectIterableField(field, target);
                            continue;
                        }
                        if (!strict && FieldUtil.mayInjectToMap(clazz, field, false)) {
                            injected = true;
                            func.injectMapField(field, target);
                            continue;
                        }
                        logger.log(1, "Could not set field " + field + " in class " + target.getClass().getName() + ": the type of the field type should be either assignable from " + clazz.getName() + " or Collection, or Map");
                    }
                    targetClass = targetClass.getSuperclass();
                }
            }
        }
        return injected;
    }

    private static boolean mayInjectToIterable(Class<?> clazz, Field field, boolean strictClassEquality) {
        Class<?> fieldType = field.getType();
        if (Iterable.class.isAssignableFrom(fieldType)) {
            ParameterizedType parameterType = (ParameterizedType)field.getGenericType();
            if (parameterType == null) {
                return false;
            }
            Type[] types = parameterType.getActualTypeArguments();
            if (types == null || types.length == 0) {
                return false;
            }
            if (types[0] instanceof Class) {
                Class parameterizedTypeClass = (Class)types[0];
                return strictClassEquality ? parameterizedTypeClass.equals(clazz) : parameterizedTypeClass.isAssignableFrom(clazz);
            }
        }
        return false;
    }

    private static boolean mayInjectToMap(Class<?> clazz, Field field, boolean strictClassEquality) {
        Class<?> fieldType = field.getType();
        if (Map.class.isAssignableFrom(fieldType)) {
            Type mapValueGenericType;
            if (!(field.getGenericType() instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType parameterType = (ParameterizedType)field.getGenericType();
            if (parameterType == null) {
                return false;
            }
            Type[] types = parameterType.getActualTypeArguments();
            if (types == null || types.length < 2) {
                return false;
            }
            if (!(types[0] instanceof Class)) {
                return false;
            }
            if (types[1] instanceof Class ? !(mapValueGenericType = (Class)types[1]).equals(Dictionary.class) : types[1] instanceof ParameterizedType && !(mapValueGenericType = (ParameterizedType)types[1]).getRawType().equals(Dictionary.class)) {
                return false;
            }
            Class K = (Class)types[0];
            return strictClassEquality ? K.equals(clazz) : K.isAssignableFrom(clazz);
        }
        return false;
    }

    private static interface FieldFunction {
        public void injectField(Field var1, Object var2);

        public void injectIterableField(Field var1, Object var2);

        public void injectMapField(Field var1, Object var2);
    }
}

