/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.annotation.plugin.bnd;

import aQute.bnd.osgi.Annotation;
import aQute.bnd.osgi.ClassDataCollector;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Verifier;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.felix.dm.annotation.api.AdapterService;
import org.apache.felix.dm.annotation.api.AspectService;
import org.apache.felix.dm.annotation.api.BundleAdapterService;
import org.apache.felix.dm.annotation.api.BundleDependency;
import org.apache.felix.dm.annotation.api.Component;
import org.apache.felix.dm.annotation.api.Composition;
import org.apache.felix.dm.annotation.api.ConfigurationDependency;
import org.apache.felix.dm.annotation.api.Destroy;
import org.apache.felix.dm.annotation.api.FactoryConfigurationAdapterService;
import org.apache.felix.dm.annotation.api.Init;
import org.apache.felix.dm.annotation.api.Inject;
import org.apache.felix.dm.annotation.api.LifecycleController;
import org.apache.felix.dm.annotation.api.Registered;
import org.apache.felix.dm.annotation.api.ResourceAdapterService;
import org.apache.felix.dm.annotation.api.ResourceDependency;
import org.apache.felix.dm.annotation.api.ServiceDependency;
import org.apache.felix.dm.annotation.api.Start;
import org.apache.felix.dm.annotation.api.Stop;
import org.apache.felix.dm.annotation.api.Unregistered;
import org.apache.felix.dm.annotation.plugin.bnd.EntryParam;
import org.apache.felix.dm.annotation.plugin.bnd.EntryType;
import org.apache.felix.dm.annotation.plugin.bnd.EntryWriter;
import org.apache.felix.dm.annotation.plugin.bnd.Logger;
import org.apache.felix.dm.annotation.plugin.bnd.MetaType;
import org.apache.felix.dm.annotation.plugin.bnd.Patterns;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AnnotationCollector
extends ClassDataCollector {
    private static final String A_INIT = Init.class.getName();
    private static final String A_START = Start.class.getName();
    private static final String A_STOP = Stop.class.getName();
    private static final String A_DESTROY = Destroy.class.getName();
    private static final String A_COMPOSITION = Composition.class.getName();
    private static final String A_LIFCLE_CTRL = LifecycleController.class.getName();
    private static final String A_COMPONENT = Component.class.getName();
    private static final String A_SERVICE_DEP = ServiceDependency.class.getName();
    private static final String A_CONFIGURATION_DEPENDENCY = ConfigurationDependency.class.getName();
    private static final String A_BUNDLE_DEPENDENCY = BundleDependency.class.getName();
    private static final String A_RESOURCE_DEPENDENCY = ResourceDependency.class.getName();
    private static final String A_ASPECT_SERVICE = AspectService.class.getName();
    private static final String A_ADAPTER_SERVICE = AdapterService.class.getName();
    private static final String A_BUNDLE_ADAPTER_SERVICE = BundleAdapterService.class.getName();
    private static final String A_RESOURCE_ADAPTER_SERVICE = ResourceAdapterService.class.getName();
    private static final String A_FACTORYCONFIG_ADAPTER_SERVICE = FactoryConfigurationAdapterService.class.getName();
    private static final String A_INJECT = Inject.class.getName();
    private static final String A_REGISTERED = Registered.class.getName();
    private static final String A_UNREGISTERED = Unregistered.class.getName();
    private Logger m_logger;
    private String m_className;
    private String[] m_interfaces;
    private boolean m_isField;
    private String m_field;
    private String m_method;
    private String m_descriptor;
    private Set<String> m_dependencyNames = new HashSet<String>();
    private List<EntryWriter> m_writers = new ArrayList<EntryWriter>();
    private MetaType m_metaType;
    private String m_startMethod;
    private String m_stopMethod;
    private String m_initMethod;
    private String m_destroyMethod;
    private String m_compositionMethod;
    private String m_starter;
    private String m_stopper;
    private Set<String> m_importService = new HashSet<String>();
    private Set<String> m_exportService = new HashSet<String>();
    private String m_bundleContextField;
    private String m_dependencyManagerField;
    private String m_componentField;
    private String m_registeredMethod;
    private String m_unregisteredMethod;

    public AnnotationCollector(Logger reporter, MetaType metaType) {
        this.m_logger = reporter;
        this.m_metaType = metaType;
    }

    public void classBegin(int access, Descriptors.TypeRef name) {
        this.m_className = name.getFQN();
        this.m_logger.debug("class name: %s", this.m_className);
    }

    public void implementsInterfaces(Descriptors.TypeRef[] interfaces) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < interfaces.length; ++i) {
            if (interfaces[i].getBinary().equals("scala/ScalaObject")) continue;
            result.add(interfaces[i].getFQN());
        }
        this.m_interfaces = result.toArray(new String[result.size()]);
        this.m_logger.debug("implements: %s", Arrays.toString(this.m_interfaces));
    }

    public void method(Clazz.MethodDef method) {
        this.m_logger.debug("Parsed method %s, descriptor=%s", method.getName(), method.getDescriptor());
        this.m_isField = false;
        this.m_method = method.getName();
        this.m_descriptor = method.getDescriptor().toString();
    }

    public void field(Clazz.FieldDef field) {
        this.m_logger.debug("Parsed field %s, descriptor=%s", field.getName(), field.getDescriptor());
        this.m_isField = true;
        this.m_field = field.getName();
        this.m_descriptor = field.getDescriptor().toString();
    }

    public void annotation(Annotation annotation) {
        this.m_logger.debug("Parsing annotation: %s", annotation.getName());
        if (annotation.getName().getFQN().equals(A_COMPONENT)) {
            this.parseComponentAnnotation(annotation);
        } else if (annotation.getName().getFQN().equals(A_ASPECT_SERVICE)) {
            this.parseAspectService(annotation);
        } else if (annotation.getName().getFQN().equals(A_ADAPTER_SERVICE)) {
            this.parseAdapterService(annotation);
        } else if (annotation.getName().getFQN().equals(A_BUNDLE_ADAPTER_SERVICE)) {
            this.parseBundleAdapterService(annotation);
        } else if (annotation.getName().getFQN().equals(A_RESOURCE_ADAPTER_SERVICE)) {
            this.parseResourceAdapterService(annotation);
        } else if (annotation.getName().getFQN().equals(A_FACTORYCONFIG_ADAPTER_SERVICE)) {
            this.parseFactoryConfigurationAdapterService(annotation);
        } else if (annotation.getName().getFQN().equals(A_INIT)) {
            this.m_initMethod = this.m_method;
        } else if (annotation.getName().getFQN().equals(A_START)) {
            this.m_startMethod = this.m_method;
        } else if (annotation.getName().getFQN().equals(A_REGISTERED)) {
            this.m_registeredMethod = this.m_method;
        } else if (annotation.getName().getFQN().equals(A_STOP)) {
            this.m_stopMethod = this.m_method;
        } else if (annotation.getName().getFQN().equals(A_UNREGISTERED)) {
            this.m_unregisteredMethod = this.m_method;
        } else if (annotation.getName().getFQN().equals(A_DESTROY)) {
            this.m_destroyMethod = this.m_method;
        } else if (annotation.getName().getFQN().equals(A_COMPOSITION)) {
            Patterns.parseMethod(this.m_method, this.m_descriptor, Patterns.COMPOSITION);
            this.m_compositionMethod = this.m_method;
        } else if (annotation.getName().getFQN().equals(A_LIFCLE_CTRL)) {
            this.parseLifecycleAnnotation(annotation);
        } else if (annotation.getName().getFQN().equals(A_SERVICE_DEP)) {
            this.parseServiceDependencyAnnotation(annotation);
        } else if (annotation.getName().getFQN().equals(A_CONFIGURATION_DEPENDENCY)) {
            this.parseConfigurationDependencyAnnotation(annotation);
        } else if (annotation.getName().getFQN().equals(A_BUNDLE_DEPENDENCY)) {
            this.parseBundleDependencyAnnotation(annotation);
        } else if (annotation.getName().getFQN().equals(A_RESOURCE_DEPENDENCY)) {
            this.parseRersourceDependencyAnnotation(annotation);
        } else if (annotation.getName().getFQN().equals(A_INJECT)) {
            this.parseInject(annotation);
        }
    }

    public boolean finish() {
        if (this.m_writers.size() == 0) {
            this.m_logger.info("No components found for class " + this.m_className, new Object[0]);
            return false;
        }
        this.checkServiceDeclared(EntryType.Component, EntryType.AspectService, EntryType.AdapterService, EntryType.BundleAdapterService, EntryType.ResourceAdapterService, EntryType.FactoryConfigurationAdapterService);
        StringBuilder sb = new StringBuilder();
        sb.append("Parsed annotation for class ");
        sb.append(this.m_className);
        for (int i = this.m_writers.size() - 1; i >= 0; --i) {
            sb.append("\n\t").append(this.m_writers.get(i).toString());
        }
        this.m_logger.info(sb.toString(), new Object[0]);
        return true;
    }

    public void writeTo(PrintWriter pw) {
        for (int i = this.m_writers.size() - 1; i >= 0; --i) {
            pw.println(this.m_writers.get(i).toString());
        }
    }

    public Set<String> getImportService() {
        return this.m_importService;
    }

    public Set<String> getExportService() {
        return this.m_exportService;
    }

    private void parseComponentAnnotation(Annotation annotation) {
        String factoryName;
        String factorySetName;
        EntryWriter writer = new EntryWriter(EntryType.Component);
        this.m_writers.add(writer);
        this.addCommonServiceParams(writer);
        writer.put(EntryParam.impl, this.m_className);
        this.parseProperties(annotation, EntryParam.properties, writer);
        if (writer.putClassArray(annotation, EntryParam.provides, this.m_interfaces, this.m_exportService) == 0) {
            this.checkRegisteredUnregisteredNotPresent();
        }
        if ((factorySetName = writer.putString(annotation, EntryParam.factorySet, null)) != null) {
            this.m_exportService.add("java.util.Set");
        }
        if ((factoryName = writer.putString(annotation, EntryParam.factoryName, null)) != null) {
            this.m_exportService.add("org.apache.felix.dependencymanager.runtime.api.ComponentFactory");
        }
        writer.putString(annotation, EntryParam.factoryConfigure, null);
        writer.putString(annotation, EntryParam.factoryMethod, null);
    }

    private void addCommonServiceParams(EntryWriter writer) {
        if (this.m_initMethod != null) {
            writer.put(EntryParam.init, this.m_initMethod);
        }
        if (this.m_startMethod != null) {
            writer.put(EntryParam.start, this.m_startMethod);
        }
        if (this.m_registeredMethod != null) {
            writer.put(EntryParam.registered, this.m_registeredMethod);
        }
        if (this.m_stopMethod != null) {
            writer.put(EntryParam.stop, this.m_stopMethod);
        }
        if (this.m_unregisteredMethod != null) {
            writer.put(EntryParam.unregistered, this.m_unregisteredMethod);
        }
        if (this.m_destroyMethod != null) {
            writer.put(EntryParam.destroy, this.m_destroyMethod);
        }
        if (this.m_compositionMethod != null) {
            writer.put(EntryParam.composition, this.m_compositionMethod);
        }
        if (this.m_starter != null) {
            writer.put(EntryParam.starter, this.m_starter);
        }
        if (this.m_stopper != null) {
            writer.put(EntryParam.stopper, this.m_stopper);
            if (this.m_starter == null) {
                throw new IllegalArgumentException("Can't use a @LifecycleController annotation for stopping a service without declaring a @LifecycleController that starts the component in class " + this.m_className);
            }
        }
        if (this.m_bundleContextField != null) {
            writer.put(EntryParam.bundleContextField, this.m_bundleContextField);
        }
        if (this.m_dependencyManagerField != null) {
            writer.put(EntryParam.dependencyManagerField, this.m_dependencyManagerField);
        }
        if (this.m_componentField != null) {
            writer.put(EntryParam.componentField, this.m_componentField);
        }
    }

    private void parseServiceDependencyAnnotation(Annotation annotation) {
        String filter;
        EntryWriter writer = new EntryWriter(EntryType.ServiceDependency);
        this.m_writers.add(writer);
        String service = (String)annotation.get(EntryParam.service.toString());
        service = service != null ? Patterns.parseClass(service, Patterns.CLASS, 1) : (this.m_isField ? Patterns.parseClass(this.m_descriptor, Patterns.CLASS, 1) : Patterns.parseClass(this.m_descriptor, Patterns.BIND_CLASS, 2));
        writer.put(EntryParam.service, service);
        this.m_importService.add(service);
        if (this.m_isField) {
            writer.put(EntryParam.autoConfig, this.m_field);
        }
        if ((filter = (String)annotation.get(EntryParam.filter.toString())) != null) {
            Verifier.verifyFilter((String)filter, (int)0);
            writer.put(EntryParam.filter, filter);
        }
        writer.putClass(annotation, EntryParam.defaultImpl, null);
        writer.putString(annotation, EntryParam.added, !this.m_isField ? this.m_method : null);
        writer.putString(annotation, EntryParam.timeout, null);
        Long t = (Long)annotation.get(EntryParam.timeout.toString());
        if (t != null && t < -1L) {
            throw new IllegalArgumentException("Invalid timeout value " + t + " in ServiceDependency annotation from class " + this.m_className);
        }
        writer.putString(annotation, EntryParam.required, null);
        writer.putString(annotation, EntryParam.changed, null);
        writer.putString(annotation, EntryParam.removed, null);
        this.parseDependencyName(writer, annotation);
        writer.putString(annotation, EntryParam.propagate, null);
    }

    private void parseConfigurationDependencyAnnotation(Annotation annotation) {
        EntryWriter writer = new EntryWriter(EntryType.ConfigurationDependency);
        this.m_writers.add(writer);
        String pid = (String)annotation.get(EntryParam.pidClass.toString());
        pid = pid != null ? Patterns.parseClass(pid, Patterns.CLASS, 1) : this.get(annotation, EntryParam.pid.toString(), this.m_className);
        writer.put(EntryParam.pid, pid);
        writer.put(EntryParam.updated, this.m_method);
        writer.putString(annotation, EntryParam.propagate, null);
        this.parseMetaTypes(annotation, pid, false);
        this.parseDependencyName(writer, annotation);
    }

    private void parseAspectService(Annotation annotation) {
        EntryWriter writer = new EntryWriter(EntryType.AspectService);
        this.m_writers.add(writer);
        this.addCommonServiceParams(writer);
        String filter = (String)annotation.get(EntryParam.filter.toString());
        if (filter != null) {
            Verifier.verifyFilter((String)filter, (int)0);
            writer.put(EntryParam.filter, filter);
        }
        Integer ranking = (Integer)annotation.get(EntryParam.ranking.toString());
        writer.put(EntryParam.ranking, ranking.toString());
        writer.put(EntryParam.impl, this.m_className);
        this.parseProperties(annotation, EntryParam.properties, writer);
        this.parseAspectOrAdapterCallbackMethods(annotation, writer);
        Object service = annotation.get(EntryParam.service.toString());
        if (service == null) {
            if (this.m_interfaces == null) {
                throw new IllegalStateException("Invalid AspectService annotation: the service attribute has not been set and the class " + this.m_className + " does not implement any interfaces");
            }
            if (this.m_interfaces.length != 1) {
                throw new IllegalStateException("Invalid AspectService annotation: the service attribute has not been set and the class " + this.m_className + " implements more than one interface");
            }
            writer.put(EntryParam.service, this.m_interfaces[0]);
        } else {
            writer.putClass(annotation, EntryParam.service, null);
        }
        writer.putString(annotation, EntryParam.factoryMethod, null);
    }

    private void parseAspectOrAdapterCallbackMethods(Annotation annotation, EntryWriter writer) {
        String field = (String)annotation.get(EntryParam.field.toString());
        String added = (String)annotation.get(EntryParam.added.toString());
        String changed = (String)annotation.get(EntryParam.changed.toString());
        String removed = (String)annotation.get(EntryParam.removed.toString());
        String swap = (String)annotation.get(EntryParam.swap.toString());
        if (field != null && (added != null || changed != null || removed != null || swap != null)) {
            throw new IllegalStateException("Annotation " + annotation + "can't applied on " + this.m_className + " can't mix \"field\" attribute with \"added/changed/removed\" attributes");
        }
        writer.putString(annotation, EntryParam.field, null);
        writer.putString(annotation, EntryParam.added, null);
        writer.putString(annotation, EntryParam.changed, null);
        writer.putString(annotation, EntryParam.removed, null);
        writer.putString(annotation, EntryParam.swap, null);
    }

    private void parseAdapterService(Annotation annotation) {
        EntryWriter writer = new EntryWriter(EntryType.AdapterService);
        this.m_writers.add(writer);
        this.addCommonServiceParams(writer);
        writer.put(EntryParam.impl, this.m_className);
        String adapteeFilter = (String)annotation.get(EntryParam.adapteeFilter.toString());
        if (adapteeFilter != null) {
            Verifier.verifyFilter((String)adapteeFilter, (int)0);
            writer.put(EntryParam.adapteeFilter, adapteeFilter);
        }
        writer.putClass(annotation, EntryParam.adapteeService, null);
        this.parseProperties(annotation, EntryParam.properties, writer);
        if (writer.putClassArray(annotation, EntryParam.provides, this.m_interfaces, this.m_exportService) == 0) {
            this.checkRegisteredUnregisteredNotPresent();
        }
        writer.putString(annotation, EntryParam.factoryMethod, null);
        writer.putString(annotation, EntryParam.propagate, null);
        this.parseAspectOrAdapterCallbackMethods(annotation, writer);
    }

    private void parseBundleAdapterService(Annotation annotation) {
        EntryWriter writer = new EntryWriter(EntryType.BundleAdapterService);
        this.m_writers.add(writer);
        this.addCommonServiceParams(writer);
        writer.put(EntryParam.impl, this.m_className);
        String filter = (String)annotation.get(EntryParam.filter.toString());
        if (filter != null) {
            Verifier.verifyFilter((String)filter, (int)0);
            writer.put(EntryParam.filter, filter);
        }
        writer.putString(annotation, EntryParam.stateMask, Integer.valueOf(38).toString());
        this.parseProperties(annotation, EntryParam.properties, writer);
        if (writer.putClassArray(annotation, EntryParam.provides, this.m_interfaces, this.m_exportService) == 0) {
            this.checkRegisteredUnregisteredNotPresent();
        }
        writer.putString(annotation, EntryParam.propagate, Boolean.FALSE.toString());
        writer.putString(annotation, EntryParam.factoryMethod, null);
    }

    private void parseResourceAdapterService(Annotation annotation) {
        EntryWriter writer = new EntryWriter(EntryType.ResourceAdapterService);
        this.m_writers.add(writer);
        this.addCommonServiceParams(writer);
        writer.put(EntryParam.impl, this.m_className);
        String filter = (String)annotation.get(EntryParam.filter.toString());
        if (filter != null) {
            Verifier.verifyFilter((String)filter, (int)0);
            writer.put(EntryParam.filter, filter);
        }
        this.parseProperties(annotation, EntryParam.properties, writer);
        if (writer.putClassArray(annotation, EntryParam.provides, this.m_interfaces, this.m_exportService) == 0) {
            this.checkRegisteredUnregisteredNotPresent();
        }
        writer.putString(annotation, EntryParam.propagate, Boolean.FALSE.toString());
        writer.putString(annotation, EntryParam.changed, null);
    }

    private void parseFactoryConfigurationAdapterService(Annotation annotation) {
        EntryWriter writer = new EntryWriter(EntryType.FactoryConfigurationAdapterService);
        this.m_writers.add(writer);
        this.addCommonServiceParams(writer);
        writer.put(EntryParam.impl, this.m_className);
        String factoryPid = (String)annotation.get(EntryParam.factoryPidClass.toString());
        factoryPid = factoryPid != null ? Patterns.parseClass(factoryPid, Patterns.CLASS, 1) : this.get(annotation, EntryParam.factoryPid.toString(), this.m_className);
        writer.put(EntryParam.factoryPid, factoryPid);
        writer.putString(annotation, EntryParam.updated, "updated");
        writer.putString(annotation, EntryParam.propagate, Boolean.FALSE.toString());
        if (writer.putClassArray(annotation, EntryParam.provides, this.m_interfaces, this.m_exportService) == 0) {
            this.checkRegisteredUnregisteredNotPresent();
        }
        this.parseProperties(annotation, EntryParam.properties, writer);
        this.parseMetaTypes(annotation, factoryPid, true);
        writer.putString(annotation, EntryParam.factoryMethod, null);
    }

    private void parseBundleDependencyAnnotation(Annotation annotation) {
        EntryWriter writer = new EntryWriter(EntryType.BundleDependency);
        this.m_writers.add(writer);
        String filter = (String)annotation.get(EntryParam.filter.toString());
        if (filter != null) {
            Verifier.verifyFilter((String)filter, (int)0);
            writer.put(EntryParam.filter, filter);
        }
        writer.putString(annotation, EntryParam.added, this.m_method);
        writer.putString(annotation, EntryParam.changed, null);
        writer.putString(annotation, EntryParam.removed, null);
        writer.putString(annotation, EntryParam.required, null);
        writer.putString(annotation, EntryParam.stateMask, null);
        writer.putString(annotation, EntryParam.propagate, null);
        this.parseDependencyName(writer, annotation);
    }

    private void parseRersourceDependencyAnnotation(Annotation annotation) {
        EntryWriter writer = new EntryWriter(EntryType.ResourceDependency);
        this.m_writers.add(writer);
        String filter = (String)annotation.get(EntryParam.filter.toString());
        if (filter != null) {
            Verifier.verifyFilter((String)filter, (int)0);
            writer.put(EntryParam.filter, filter);
        }
        if (this.m_isField) {
            writer.put(EntryParam.autoConfig, this.m_field);
        }
        writer.putString(annotation, EntryParam.added, !this.m_isField ? this.m_method : null);
        writer.putString(annotation, EntryParam.changed, null);
        writer.putString(annotation, EntryParam.removed, null);
        writer.putString(annotation, EntryParam.required, null);
        writer.putString(annotation, EntryParam.propagate, null);
        writer.putString(annotation, EntryParam.factoryMethod, null);
        this.parseDependencyName(writer, annotation);
    }

    private void parseDependencyName(EntryWriter writer, Annotation annotation) {
        String name = (String)annotation.get(EntryParam.name.toString());
        if (name != null) {
            if (!this.m_dependencyNames.add(name)) {
                throw new IllegalArgumentException("Duplicate dependency name " + name + " in Dependency " + annotation + " from class " + this.m_className);
            }
            writer.put(EntryParam.name, name);
        }
    }

    private void parseLifecycleAnnotation(Annotation annotation) {
        Patterns.parseField(this.m_field, this.m_descriptor, Patterns.RUNNABLE);
        if ("true".equals(this.get(annotation, EntryParam.start.name(), "true"))) {
            if (this.m_starter != null) {
                throw new IllegalStateException("Lifecycle annotation already defined on field " + this.m_starter + " in class " + this.m_className);
            }
            this.m_starter = this.m_field;
        } else {
            if (this.m_stopper != null) {
                throw new IllegalStateException("Lifecycle annotation already defined on field " + this.m_stopper + " in class " + this.m_className);
            }
            this.m_stopper = this.m_field;
        }
    }

    private void parseMetaTypes(Annotation annotation, String pid, boolean factory) {
        if (annotation.get("metadata") != null) {
            String propertiesHeading = (String)annotation.get("heading");
            String propertiesDesc = (String)annotation.get("description");
            MetaType.OCD ocd = new MetaType.OCD(pid, propertiesHeading, propertiesDesc);
            for (Object p : (Object[])annotation.get("metadata")) {
                Annotation property = (Annotation)p;
                String heading = (String)property.get("heading");
                String id = (String)property.get("id");
                String type = (String)property.get("type");
                type = type != null ? Patterns.parseClass(type, Patterns.CLASS, 1) : null;
                Object[] defaults = (Object[])property.get("defaults");
                String description = (String)property.get("description");
                Integer cardinality = (Integer)property.get("cardinality");
                Boolean required = (Boolean)property.get("required");
                MetaType.AD ad = new MetaType.AD(id, type, defaults, heading, description, cardinality, required);
                Object[] optionLabels = (Object[])property.get("optionLabels");
                Object[] optionValues = (Object[])property.get("optionValues");
                if (optionLabels == null && optionValues != null || optionLabels != null && optionValues == null || optionLabels != null && optionValues != null && optionLabels.length != optionValues.length) {
                    throw new IllegalArgumentException("invalid option labels/values specified for property " + id + " in PropertyMetadata annotation from class " + this.m_className);
                }
                if (optionValues != null) {
                    for (int i = 0; i < optionValues.length; ++i) {
                        ad.add(new MetaType.Option(optionValues[i].toString(), optionLabels[i].toString()));
                    }
                }
                ocd.add(ad);
            }
            this.m_metaType.add(ocd);
            MetaType.Designate designate = new MetaType.Designate(pid, factory);
            this.m_metaType.add(designate);
            this.m_logger.info("Parsed MetaType Properties from class " + this.m_className, new Object[0]);
        }
    }

    private void parseProperties(Annotation annotation, EntryParam attribute, EntryWriter writer) {
        block15: {
            try {
                Object[] parameters = (Object[])annotation.get(attribute.toString());
                if (parameters == null) break block15;
                JSONObject properties = new JSONObject();
                for (Object p : parameters) {
                    Class<String> classType;
                    Annotation a = (Annotation)p;
                    String name = (String)a.get("name");
                    String type = (String)a.get("type");
                    try {
                        classType = type == null ? String.class : Class.forName(Patterns.parseClass(type, Patterns.CLASS, 1));
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalArgumentException("Invalid Property type " + type + " from annotation " + annotation + " in class " + this.m_className);
                    }
                    Object[] values = (Object[])a.get("value");
                    if (values != null) {
                        values = this.checkPropertyType(name, classType, values);
                        this.addProperty(properties, name, values, classType);
                        continue;
                    }
                    values = (Object[])a.get("values");
                    if (values != null) {
                        values = this.checkPropertyType(name, classType, values);
                        this.addProperty(properties, name, values, classType);
                        continue;
                    }
                    values = (Object[])a.get("longValue");
                    if (values != null) {
                        this.addProperty(properties, name, values, Long.class);
                        continue;
                    }
                    values = (Object[])a.get("doubleValue");
                    if (values != null) {
                        this.addProperty(properties, name, values, Double.class);
                        continue;
                    }
                    values = (Object[])a.get("floatValue");
                    if (values != null) {
                        this.addProperty(properties, name, values, Float.class);
                        continue;
                    }
                    values = (Object[])a.get("intValue");
                    if (values != null) {
                        this.addProperty(properties, name, values, Integer.class);
                        continue;
                    }
                    values = (Object[])a.get("byteValue");
                    if (values != null) {
                        this.addProperty(properties, name, values, Byte.class);
                        continue;
                    }
                    values = (Object[])a.get("charValue");
                    if (values != null) {
                        this.addProperty(properties, name, values, Character.class);
                        continue;
                    }
                    values = (Object[])a.get("booleanValue");
                    if (values != null) {
                        this.addProperty(properties, name, values, Boolean.class);
                        continue;
                    }
                    values = (Object[])a.get("shortValue");
                    if (values != null) {
                        this.addProperty(properties, name, values, Short.class);
                        continue;
                    }
                    throw new IllegalArgumentException("Missing Property value from annotation " + annotation + " in class " + this.m_className);
                }
                writer.putJsonObject(attribute, properties);
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("UNexpected exception while parsing Property from annotation " + annotation + " in class " + this.m_className, e);
            }
        }
    }

    private Object[] checkPropertyType(String name, Class<?> type, Object ... values) {
        block27: {
            block33: {
                block32: {
                    block31: {
                        block30: {
                            block29: {
                                block28: {
                                    block26: {
                                        if (type.equals(String.class)) {
                                            return values;
                                        }
                                        if (!type.equals(Long.class)) break block26;
                                        for (Object value : values) {
                                            try {
                                                Long.valueOf(value.toString());
                                            }
                                            catch (NumberFormatException e) {
                                                throw new IllegalArgumentException("Property \"" + name + "\" in class " + this.m_className + " does not contain a valid Long value (" + value.toString() + ")");
                                            }
                                        }
                                        break block27;
                                    }
                                    if (!type.equals(Double.class)) break block28;
                                    for (Object value : values) {
                                        try {
                                            Double.valueOf(value.toString());
                                        }
                                        catch (NumberFormatException e) {
                                            throw new IllegalArgumentException("Property \"" + name + "\" in class " + this.m_className + " does not contain a valid Double value (" + value.toString() + ")");
                                        }
                                    }
                                    break block27;
                                }
                                if (!type.equals(Float.class)) break block29;
                                for (Object value : values) {
                                    try {
                                        Float.valueOf(value.toString());
                                    }
                                    catch (NumberFormatException e) {
                                        throw new IllegalArgumentException("Property \"" + name + "\" in class " + this.m_className + " does not contain a valid Float value (" + value.toString() + ")");
                                    }
                                }
                                break block27;
                            }
                            if (!type.equals(Integer.class)) break block30;
                            for (Object value : values) {
                                try {
                                    Integer.valueOf(value.toString());
                                }
                                catch (NumberFormatException e) {
                                    throw new IllegalArgumentException("Property \"" + name + "\" in class " + this.m_className + " does not contain a valid Integer value (" + value.toString() + ")");
                                }
                            }
                            break block27;
                        }
                        if (!type.equals(Byte.class)) break block31;
                        for (Object value : values) {
                            try {
                                Byte.valueOf(value.toString());
                            }
                            catch (NumberFormatException e) {
                                throw new IllegalArgumentException("Property \"" + name + "\" in class " + this.m_className + " does not contain a valid Byte value (" + value.toString() + ")");
                            }
                        }
                        break block27;
                    }
                    if (!type.equals(Character.class)) break block32;
                    for (int i = 0; i < values.length; ++i) {
                        try {
                            Integer.valueOf(values[i].toString());
                            continue;
                        }
                        catch (NumberFormatException e) {
                            if (values[i].toString().length() != 1) {
                                throw new IllegalArgumentException("Property \"" + name + "\" in class " + this.m_className + " does not contain a valid Character value (" + values[i] + ")");
                            }
                            try {
                                values[i] = (int)values[i].toString().charAt(0);
                                continue;
                            }
                            catch (NumberFormatException e2) {
                                throw new IllegalArgumentException("Property \"" + name + "\" in class " + this.m_className + " does not contain a valid Character value (" + values[i].toString() + ")");
                            }
                        }
                    }
                    break block27;
                }
                if (!type.equals(Boolean.class)) break block33;
                for (Object value : values) {
                    if (value.toString().equalsIgnoreCase("false") || value.toString().equalsIgnoreCase("true")) continue;
                    throw new IllegalArgumentException("Property \"" + name + "\" in class " + this.m_className + " does not contain a valid Boolean value (" + value.toString() + ")");
                }
                break block27;
            }
            if (!type.equals(Short.class)) break block27;
            for (Object value : values) {
                try {
                    Short.valueOf(value.toString());
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Property \"" + name + "\" in class " + this.m_className + " does not contain a valid Short value (" + value.toString() + ")");
                }
            }
        }
        return values;
    }

    private void addProperty(JSONObject props, String name, Object value, Class<?> type) throws JSONException {
        Object[] array;
        if (value.getClass().isArray() && (array = (Object[])value).length == 1) {
            value = array[0];
        }
        if (type.equals(String.class)) {
            props.put(name, value.getClass().isArray() ? new JSONArray(value) : value);
        } else {
            JSONObject jsonValue = new JSONObject();
            jsonValue.put("type", type.getName());
            jsonValue.put("value", value.getClass().isArray() ? new JSONArray(value) : value);
            props.put(name, jsonValue);
        }
    }

    private void parseInject(Annotation annotation) {
        if (Patterns.BUNDLE_CONTEXT.matcher(this.m_descriptor).matches()) {
            this.m_bundleContextField = this.m_field;
        } else if (Patterns.DEPENDENCY_MANAGER.matcher(this.m_descriptor).matches()) {
            this.m_dependencyManagerField = this.m_field;
        } else if (Patterns.COMPONENT.matcher(this.m_descriptor).matches()) {
            this.m_componentField = this.m_field;
        } else {
            throw new IllegalArgumentException("@Inject annotation can't be applied on the field \"" + this.m_field + "\" in class " + this.m_className);
        }
    }

    private void checkServiceDeclared(EntryType ... types) {
        boolean ok = false;
        if (this.m_writers.size() > 0) {
            for (EntryType type : types) {
                if (this.m_writers.get(this.m_writers.size() - 1).getEntryType() != type) continue;
                ok = true;
                break;
            }
        }
        if (!ok) {
            throw new IllegalStateException(": the class must be annotated with either one of the following types: " + Arrays.toString((Object[])types));
        }
    }

    private void checkRegisteredUnregisteredNotPresent() {
        if (this.m_registeredMethod != null) {
            throw new IllegalStateException("@Registered annotation can't be used on a Component  which does not provide a service (class=" + this.m_className + ")");
        }
        if (this.m_unregisteredMethod != null) {
            throw new IllegalStateException("@Unregistered annotation can't be used on a Component  which does not provide a service (class=" + this.m_className + ")");
        }
    }

    private <T> T get(Annotation annotation, String name, T defaultValue) {
        Object value = annotation.get(name);
        return (T)(value != null ? value : defaultValue);
    }
}

