/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.felix.cm.PersistenceManager;

class CachingPersistenceManagerProxy
implements PersistenceManager {
    private final PersistenceManager pm;
    private final Hashtable cache;
    private final ReadWriteLock globalLock = new ReentrantReadWriteLock();
    private boolean fullyLoaded;

    public CachingPersistenceManagerProxy(PersistenceManager pm) {
        this.pm = pm;
        this.cache = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String pid) throws IOException {
        Lock lock = this.globalLock.writeLock();
        try {
            lock.lock();
            this.cache.remove(pid);
            this.pm.delete(pid);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String pid) {
        Lock lock = this.globalLock.readLock();
        try {
            lock.lock();
            boolean bl = this.cache.containsKey(pid) || !this.fullyLoaded && this.pm.exists(pid);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getDictionaries() throws IOException {
        Lock lock = this.globalLock.readLock();
        try {
            lock.lock();
            if (!this.fullyLoaded) {
                lock.unlock();
                lock = this.globalLock.writeLock();
                lock.lock();
                if (!this.fullyLoaded) {
                    Enumeration fromPm = this.pm.getDictionaries();
                    while (fromPm.hasMoreElements()) {
                        Dictionary next = (Dictionary)fromPm.nextElement();
                        String pid = (String)next.get("service.pid");
                        if (pid == null) continue;
                        this.cache.put(pid, next);
                    }
                    this.fullyLoaded = true;
                }
            }
            Vector<Dictionary> configs = new Vector<Dictionary>();
            for (Object o : this.cache.values()) {
                configs.add(this.copy((Dictionary)o));
            }
            Enumeration enumeration = configs.elements();
            return enumeration;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dictionary load(String pid) throws IOException {
        Lock lock = this.globalLock.readLock();
        try {
            lock.lock();
            Dictionary loaded = (Dictionary)this.cache.get(pid);
            if (loaded == null && !this.fullyLoaded) {
                lock.unlock();
                lock = this.globalLock.writeLock();
                lock.lock();
                loaded = (Dictionary)this.cache.get(pid);
                if (loaded == null) {
                    loaded = this.pm.load(pid);
                    this.cache.put(pid, loaded);
                }
            }
            Dictionary dictionary = this.copy(loaded);
            return dictionary;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(String pid, Dictionary properties) throws IOException {
        Lock lock = this.globalLock.writeLock();
        try {
            lock.lock();
            this.pm.store(pid, properties);
            this.cache.put(pid, this.copy(properties));
        }
        finally {
            lock.unlock();
        }
    }

    Dictionary copy(Dictionary source) {
        Hashtable copy = new Hashtable();
        if (source instanceof Map) {
            copy.putAll((Map)((Object)source));
        } else {
            Enumeration keys = source.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                copy.put(key, source.get(key));
            }
        }
        return copy;
    }
}

