/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jline.keymap.BindingReader;
import org.jline.keymap.KeyMap;
import org.jline.terminal.Attributes;
import org.jline.terminal.MouseEvent;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.Display;
import org.jline.utils.InfoCmp;
import org.mozilla.universalchardet.UniversalDetector;

public class Nano {
    protected final Terminal terminal;
    protected final Display display;
    protected final BindingReader bindingReader;
    protected final Size size;
    protected final Path root;
    protected KeyMap<Operation> keys;
    public String title = "JLine Nano 3.0.0";
    public boolean printLineNumbers = true;
    public boolean wrapping = true;
    public boolean smoothScrolling = true;
    public boolean mouseSupport = false;
    public boolean oneMoreLine = true;
    public boolean constantCursor;
    public int tabs = 4;
    public String brackets = "\"\u2019)>]}";
    public String matchBrackets = "(<[{)>]}";
    public String punct = "!.?";
    public String quoteStr = "^([ \\t]*[#:>\\|}])+";
    protected final List<Buffer> buffers = new ArrayList<Buffer>();
    protected int bufferIndex;
    protected Buffer buffer;
    protected String message;
    protected int nbBindings = 0;
    protected LinkedHashMap<String, String> shortcuts;
    protected String editMessage;
    protected final StringBuilder editBuffer = new StringBuilder();
    protected boolean searchCaseSensitive;
    protected boolean searchRegexp;
    protected boolean searchBackwards;
    protected String searchTerm;
    protected WriteMode writeMode = WriteMode.WRITE;
    protected boolean writeBackup;
    protected boolean readNewBuffer = true;

    public Nano(Terminal terminal, File root) {
        this(terminal, root.toPath());
    }

    public Nano(Terminal terminal, Path root) {
        this.terminal = terminal;
        this.root = root;
        this.display = new Display(terminal, true);
        this.bindingReader = new BindingReader(terminal.reader());
        this.size = new Size();
        this.bindKeys();
    }

    public void open(String ... files) throws IOException {
        this.open(Arrays.asList(files));
    }

    public void open(List<String> files) throws IOException {
        for (String file : files) {
            this.buffers.add(new Buffer(file));
        }
    }

    public void run() throws IOException {
        if (this.buffers.isEmpty()) {
            this.buffers.add(new Buffer(null));
        }
        this.buffer = this.buffers.get(this.bufferIndex);
        Attributes attributes = this.terminal.getAttributes();
        Attributes newAttr = new Attributes(attributes);
        newAttr.setLocalFlags(EnumSet.of(Attributes.LocalFlag.ICANON, Attributes.LocalFlag.ECHO, Attributes.LocalFlag.IEXTEN), false);
        newAttr.setInputFlags(EnumSet.of(Attributes.InputFlag.IXON, Attributes.InputFlag.ICRNL, Attributes.InputFlag.INLCR), false);
        newAttr.setControlChar(Attributes.ControlChar.VMIN, 1);
        newAttr.setControlChar(Attributes.ControlChar.VTIME, 0);
        newAttr.setControlChar(Attributes.ControlChar.VINTR, 0);
        this.terminal.setAttributes(newAttr);
        Terminal.SignalHandler prevHandler = this.terminal.handle(Terminal.Signal.WINCH, this::handle);
        this.terminal.puts(InfoCmp.Capability.enter_ca_mode, new Object[0]);
        this.terminal.puts(InfoCmp.Capability.keypad_xmit, new Object[0]);
        this.size.copy(this.terminal.getSize());
        this.display.clear();
        this.display.reset();
        this.display.resize(this.size.getRows(), this.size.getColumns());
        if (this.mouseSupport) {
            this.terminal.trackMouse(Terminal.MouseTracking.Normal);
        }
        this.shortcuts = this.standardShortcuts();
        try {
            this.buffer.open();
            if (this.buffer.file != null) {
                this.setMessage("Read " + this.buffer.lines.size() + " lines");
            }
            this.display();
            while (true) {
                Operation op = this.readOperation(this.keys);
                switch (op) {
                    case QUIT: {
                        if (!this.quit()) break;
                        return;
                    }
                    case WRITE: {
                        this.write();
                        break;
                    }
                    case READ: {
                        this.read();
                        break;
                    }
                    case UP: {
                        this.buffer.moveUp(1);
                        break;
                    }
                    case DOWN: {
                        this.buffer.moveDown(1);
                        break;
                    }
                    case LEFT: {
                        this.buffer.moveLeft(1);
                        break;
                    }
                    case RIGHT: {
                        this.buffer.moveRight(1);
                        break;
                    }
                    case INSERT: {
                        this.buffer.insert(this.bindingReader.getLastBinding());
                        break;
                    }
                    case BACKSPACE: {
                        this.buffer.backspace(1);
                        break;
                    }
                    case DELETE: {
                        this.buffer.delete(1);
                        break;
                    }
                    case WRAP: {
                        this.wrap();
                        break;
                    }
                    case NUMBERS: {
                        this.numbers();
                        break;
                    }
                    case SMOOTH_SCROLLING: {
                        this.smoothScrolling();
                        break;
                    }
                    case MOUSE_SUPPORT: {
                        this.mouseSupport();
                        break;
                    }
                    case ONE_MORE_LINE: {
                        this.oneMoreLine();
                        break;
                    }
                    case CLEAR_SCREEN: {
                        this.clearScreen();
                        break;
                    }
                    case PREV_BUFFER: {
                        this.prevBuffer();
                        break;
                    }
                    case NEXT_BUFFER: {
                        this.nextBuffer();
                        break;
                    }
                    case CUR_POS: {
                        this.curPos();
                        break;
                    }
                    case PREV_WORD: {
                        this.buffer.prevWord();
                        break;
                    }
                    case NEXT_WORD: {
                        this.buffer.nextWord();
                        break;
                    }
                    case BEGINNING_OF_LINE: {
                        this.buffer.beginningOfLine();
                        break;
                    }
                    case END_OF_LINE: {
                        this.buffer.endOfLine();
                        break;
                    }
                    case FIRST_LINE: {
                        this.buffer.firstLine();
                        break;
                    }
                    case LAST_LINE: {
                        this.buffer.lastLine();
                        break;
                    }
                    case PREV_PAGE: {
                        this.buffer.prevPage();
                        break;
                    }
                    case NEXT_PAGE: {
                        this.buffer.nextPage();
                        break;
                    }
                    case SCROLL_UP: {
                        this.buffer.scrollUp(1);
                        break;
                    }
                    case SCROLL_DOWN: {
                        this.buffer.scrollDown(1);
                        break;
                    }
                    case SEARCH: {
                        this.search();
                        break;
                    }
                    case NEXT_SEARCH: {
                        this.buffer.nextSearch();
                        break;
                    }
                    case HELP: {
                        this.help("nano-main-help.txt");
                        break;
                    }
                    case CONSTANT_CURSOR: {
                        this.constantCursor();
                        break;
                    }
                    case VERBATIM: {
                        this.buffer.insert(new String(Character.toChars(this.bindingReader.readCharacter())));
                        break;
                    }
                    case MATCHING: {
                        this.buffer.matching();
                        break;
                    }
                    case MOUSE_EVENT: {
                        this.mouseEvent();
                        break;
                    }
                    default: {
                        this.setMessage("Unsupported " + op.name().toLowerCase().replace('_', '-'));
                    }
                }
                this.display();
            }
        }
        finally {
            if (this.mouseSupport) {
                this.terminal.trackMouse(Terminal.MouseTracking.Off);
            }
            this.terminal.puts(InfoCmp.Capability.exit_ca_mode, new Object[0]);
            this.terminal.puts(InfoCmp.Capability.keypad_local, new Object[0]);
            this.terminal.flush();
            this.terminal.setAttributes(attributes);
            this.terminal.handle(Terminal.Signal.WINCH, prevHandler);
        }
    }

    boolean write() throws IOException {
        char i;
        KeyMap<Operation> writeKeyMap = new KeyMap<Operation>();
        writeKeyMap.setUnicode(Operation.INSERT);
        for (i = ' '; i < '\u0100'; i = (char)(i + '\u0001')) {
            writeKeyMap.bind(Operation.INSERT, (CharSequence)Character.toString(i));
        }
        for (i = 'A'; i <= 'Z'; i = (char)(i + '\u0001')) {
            writeKeyMap.bind(Operation.DO_LOWER_CASE, (CharSequence)KeyMap.alt(i));
        }
        writeKeyMap.bind(Operation.BACKSPACE, (CharSequence)KeyMap.del());
        writeKeyMap.bind(Operation.MAC_FORMAT, (CharSequence)KeyMap.alt('m'));
        writeKeyMap.bind(Operation.DOS_FORMAT, (CharSequence)KeyMap.alt('d'));
        writeKeyMap.bind(Operation.APPEND_MODE, (CharSequence)KeyMap.alt('a'));
        writeKeyMap.bind(Operation.PREPEND_MODE, (CharSequence)KeyMap.alt('p'));
        writeKeyMap.bind(Operation.BACKUP, (CharSequence)KeyMap.alt('b'));
        writeKeyMap.bind(Operation.TO_FILES, (CharSequence)KeyMap.ctrl('T'));
        writeKeyMap.bind(Operation.ACCEPT, (CharSequence)"\r");
        writeKeyMap.bind(Operation.CANCEL, (CharSequence)KeyMap.ctrl('C'));
        writeKeyMap.bind(Operation.HELP, KeyMap.ctrl('G'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f1));
        writeKeyMap.bind(Operation.MOUSE_EVENT, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_mouse));
        this.editMessage = this.getWriteMessage();
        this.editBuffer.setLength(0);
        this.editBuffer.append(this.buffer.file == null ? "" : this.buffer.file);
        this.shortcuts = this.writeShortcuts();
        this.display();
        while (true) {
            switch (this.readOperation(writeKeyMap)) {
                case INSERT: {
                    this.editBuffer.append(this.bindingReader.getLastBinding());
                    break;
                }
                case BACKSPACE: {
                    if (this.editBuffer.length() <= 0) break;
                    this.editBuffer.setLength(this.editBuffer.length() - 1);
                    break;
                }
                case CANCEL: {
                    this.editMessage = null;
                    this.shortcuts = this.standardShortcuts();
                    return false;
                }
                case ACCEPT: {
                    this.editMessage = null;
                    if (this.save(this.editBuffer.toString())) {
                        this.shortcuts = this.standardShortcuts();
                        return true;
                    }
                    return false;
                }
                case HELP: {
                    this.help("nano-write-help.txt");
                    break;
                }
                case MAC_FORMAT: {
                    this.buffer.format = this.buffer.format == WriteFormat.MAC ? WriteFormat.UNIX : WriteFormat.MAC;
                    break;
                }
                case DOS_FORMAT: {
                    this.buffer.format = this.buffer.format == WriteFormat.DOS ? WriteFormat.UNIX : WriteFormat.DOS;
                    break;
                }
                case APPEND_MODE: {
                    this.writeMode = this.writeMode == WriteMode.APPEND ? WriteMode.WRITE : WriteMode.APPEND;
                    break;
                }
                case PREPEND_MODE: {
                    this.writeMode = this.writeMode == WriteMode.PREPEND ? WriteMode.WRITE : WriteMode.PREPEND;
                    break;
                }
                case BACKUP: {
                    this.writeBackup = !this.writeBackup;
                    break;
                }
                case MOUSE_EVENT: {
                    this.mouseEvent();
                }
            }
            this.editMessage = this.getWriteMessage();
            this.display();
        }
    }

    private Operation readOperation(KeyMap<Operation> keymap) {
        Operation op;
        while ((op = this.bindingReader.readBinding(keymap)) == Operation.DO_LOWER_CASE) {
            this.bindingReader.runMacro(this.bindingReader.getLastBinding().toLowerCase());
        }
        return op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean save(String name) throws IOException {
        Operation op;
        boolean isSame;
        Path orgPath = this.buffer.file != null ? this.root.resolve(this.buffer.file) : null;
        Path newPath = this.root.resolve(name);
        boolean bl = isSame = orgPath != null && Files.isSameFile(orgPath, newPath);
        if (!isSame && Files.exists(Paths.get(name, new String[0]), new LinkOption[0]) && (op = this.getYNC("File exists, OVERWRITE ? ")) != Operation.YES) {
            return false;
        }
        Path t = Files.createTempFile(newPath.getParent(), "jline-", ".temp", new FileAttribute[0]);
        try {
            boolean bl2;
            Throwable throwable;
            OutputStream os;
            block28: {
                block29: {
                    os = Files.newOutputStream(t, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
                    throwable = null;
                    if (this.writeMode == WriteMode.APPEND && Files.isReadable(newPath)) {
                        Files.copy(newPath, os);
                    }
                    OutputStreamWriter w = new OutputStreamWriter(os, this.buffer.charset);
                    for (int i = 0; i < this.buffer.lines.size(); ++i) {
                        if (i > 0) {
                            switch (this.buffer.format) {
                                case UNIX: {
                                    w.write("\n");
                                    break;
                                }
                                case DOS: {
                                    w.write("\r\n");
                                    break;
                                }
                                case MAC: {
                                    w.write("\r");
                                }
                            }
                        }
                        w.write(this.buffer.lines.get(i));
                    }
                    ((Writer)w).flush();
                    if (this.writeMode == WriteMode.PREPEND && Files.isReadable(newPath)) {
                        Files.copy(newPath, os);
                    }
                    if (this.writeBackup) {
                        Files.move(newPath, newPath.resolveSibling(newPath.getFileName().toString() + "~"), StandardCopyOption.REPLACE_EXISTING);
                    }
                    Files.move(t, newPath, StandardCopyOption.REPLACE_EXISTING);
                    this.buffer.file = name;
                    this.buffer.dirty = false;
                    this.setMessage("Wrote " + this.buffer.lines.size() + " lines");
                    bl2 = true;
                    if (os == null) break block28;
                    if (throwable == null) break block29;
                    try {
                        os.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block28;
                }
                os.close();
            }
            return bl2;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (os != null) {
                            if (throwable != null) {
                                try {
                                    os.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                os.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (IOException e) {
                    this.setMessage("Error writing " + name + ": " + e.toString());
                    boolean bl3 = false;
                    return bl3;
                }
            }
        }
        finally {
            Files.deleteIfExists(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Operation getYNC(String message) {
        String oldEditMessage = this.editMessage;
        String oldEditBuffer = this.editBuffer.toString();
        LinkedHashMap<String, String> oldShortcuts = this.shortcuts;
        try {
            this.editMessage = message;
            this.editBuffer.setLength(0);
            KeyMap<Operation> yncKeyMap = new KeyMap<Operation>();
            yncKeyMap.bind(Operation.YES, "y", "Y");
            yncKeyMap.bind(Operation.NO, "n", "N");
            yncKeyMap.bind(Operation.CANCEL, (CharSequence)KeyMap.ctrl('C'));
            this.shortcuts = new LinkedHashMap();
            this.shortcuts.put(" Y", "Yes");
            this.shortcuts.put(" N", "No");
            this.shortcuts.put("^C", "Cancel");
            this.display();
            Operation operation = this.readOperation(yncKeyMap);
            return operation;
        }
        finally {
            this.editMessage = oldEditMessage;
            this.editBuffer.append(oldEditBuffer);
            this.shortcuts = oldShortcuts;
        }
    }

    private String getWriteMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("File Name to ");
        switch (this.writeMode) {
            case WRITE: {
                sb.append("Write");
                break;
            }
            case APPEND: {
                sb.append("Append");
                break;
            }
            case PREPEND: {
                sb.append("Prepend");
            }
        }
        switch (this.buffer.format) {
            case UNIX: {
                break;
            }
            case DOS: {
                sb.append(" [DOS Format]");
                break;
            }
            case MAC: {
                sb.append(" [Mac Format]");
            }
        }
        if (this.writeBackup) {
            sb.append(" [Backup]");
        }
        sb.append(": ");
        return sb.toString();
    }

    void read() {
        char i;
        KeyMap<Operation> readKeyMap = new KeyMap<Operation>();
        readKeyMap.setUnicode(Operation.INSERT);
        for (i = ' '; i < '\u0100'; i = (char)(i + '\u0001')) {
            readKeyMap.bind(Operation.INSERT, (CharSequence)Character.toString(i));
        }
        for (i = 'A'; i <= 'Z'; i = (char)(i + '\u0001')) {
            readKeyMap.bind(Operation.DO_LOWER_CASE, (CharSequence)KeyMap.alt(i));
        }
        readKeyMap.bind(Operation.BACKSPACE, (CharSequence)KeyMap.del());
        readKeyMap.bind(Operation.NEW_BUFFER, (CharSequence)KeyMap.alt('f'));
        readKeyMap.bind(Operation.TO_FILES, (CharSequence)KeyMap.ctrl('T'));
        readKeyMap.bind(Operation.EXECUTE, (CharSequence)KeyMap.ctrl('X'));
        readKeyMap.bind(Operation.ACCEPT, (CharSequence)"\r");
        readKeyMap.bind(Operation.CANCEL, (CharSequence)KeyMap.ctrl('C'));
        readKeyMap.bind(Operation.HELP, KeyMap.ctrl('G'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f1));
        readKeyMap.bind(Operation.MOUSE_EVENT, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_mouse));
        this.editMessage = this.getReadMessage();
        this.editBuffer.setLength(0);
        this.shortcuts = this.readShortcuts();
        this.display();
        while (true) {
            switch (this.readOperation(readKeyMap)) {
                case INSERT: {
                    this.editBuffer.append(this.bindingReader.getLastBinding());
                    break;
                }
                case BACKSPACE: {
                    if (this.editBuffer.length() <= 0) break;
                    this.editBuffer.setLength(this.editBuffer.length() - 1);
                    break;
                }
                case CANCEL: {
                    this.editMessage = null;
                    this.shortcuts = this.standardShortcuts();
                    return;
                }
                case ACCEPT: {
                    Path p;
                    this.editMessage = null;
                    String file = this.editBuffer.toString();
                    boolean empty = file.isEmpty();
                    Path path = p = empty ? null : this.root.resolve(file);
                    if (!(this.readNewBuffer || empty || Files.exists(p, new LinkOption[0]))) {
                        this.setMessage("\"" + file + "\" not found");
                    } else if (!empty && Files.isDirectory(p, new LinkOption[0])) {
                        this.setMessage("\"" + file + "\" is a directory");
                    } else if (!empty && !Files.isRegularFile(p, new LinkOption[0])) {
                        this.setMessage("\"" + file + "\" is not a regular file");
                    } else {
                        Buffer buf = new Buffer(empty ? null : file);
                        try {
                            buf.open();
                            if (this.readNewBuffer) {
                                this.buffers.add(++this.bufferIndex, buf);
                                this.buffer = buf;
                            } else {
                                this.buffer.insert(String.join((CharSequence)"\n", buf.lines));
                            }
                            this.setMessage(null);
                        }
                        catch (IOException e) {
                            this.setMessage("Error reading " + file + ": " + e.getMessage());
                        }
                    }
                    this.shortcuts = this.standardShortcuts();
                    return;
                }
                case HELP: {
                    this.help("nano-read-help.txt");
                    break;
                }
                case NEW_BUFFER: {
                    this.readNewBuffer = !this.readNewBuffer;
                    break;
                }
                case MOUSE_EVENT: {
                    this.mouseEvent();
                }
            }
            this.editMessage = this.getReadMessage();
            this.display();
        }
    }

    private String getReadMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("File to insert");
        if (this.readNewBuffer) {
            sb.append(" into new buffer");
        }
        sb.append(" [from ./]: ");
        return sb.toString();
    }

    private LinkedHashMap<String, String> readShortcuts() {
        LinkedHashMap<String, String> shortcuts = new LinkedHashMap<String, String>();
        shortcuts.put("^G", "Get Help");
        shortcuts.put("^T", "To Files");
        shortcuts.put("M-F", "New Buffer");
        shortcuts.put("^C", "Cancel");
        shortcuts.put("^X", "Execute Command");
        return shortcuts;
    }

    private LinkedHashMap<String, String> writeShortcuts() {
        LinkedHashMap<String, String> s = new LinkedHashMap<String, String>();
        s.put("^G", "Get Help");
        s.put("^T", "To Files");
        s.put("M-M", "Mac Format");
        s.put("M-P", "Prepend");
        s.put("^C", "Cancel");
        s.put("M-D", "DOS Format");
        s.put("M-A", "Append");
        s.put("M-B", "Backup File");
        return s;
    }

    private LinkedHashMap<String, String> helpShortcuts() {
        LinkedHashMap<String, String> s = new LinkedHashMap<String, String>();
        s.put("^L", "Refresh");
        s.put("^Y", "Prev Page");
        s.put("^P", "Prev Line");
        s.put("M-\\", "First Line");
        s.put("^X", "Exit");
        s.put("^V", "Next Page");
        s.put("^N", "Next Line");
        s.put("M-/", "Last Line");
        return s;
    }

    private LinkedHashMap<String, String> searchShortcuts() {
        LinkedHashMap<String, String> s = new LinkedHashMap<String, String>();
        s.put("^G", "Get Help");
        s.put("^Y", "First Line");
        s.put("^R", "Replace");
        s.put("^W", "Beg of Par");
        s.put("M-C", "Case Sens");
        s.put("M-R", "Regexp");
        s.put("^C", "Cancel");
        s.put("^V", "Last Line");
        s.put("^T", "Go To Line");
        s.put("^O", "End of Par");
        s.put("M-B", "Backwards");
        s.put("^P", "PrevHstory");
        return s;
    }

    private LinkedHashMap<String, String> standardShortcuts() {
        LinkedHashMap<String, String> s = new LinkedHashMap<String, String>();
        s.put("^G", "Get Help");
        s.put("^O", "WriteOut");
        s.put("^R", "Read File");
        s.put("^O", "WriteOut");
        s.put("^Y", "Prev Page");
        s.put("^K", "Cut Text");
        s.put("^C", "Cur Pos");
        s.put("^X", "Exit");
        s.put("^J", "Justify");
        s.put("^W", "Where Is");
        s.put("^V", "Next Page");
        s.put("^U", "UnCut Text");
        s.put("^T", "To Spell");
        return s;
    }

    void help(String help) {
        Buffer org = this.buffer;
        Buffer newBuf = new Buffer(null);
        try (InputStream is = this.getClass().getResourceAsStream(help);){
            newBuf.open(is);
        }
        catch (IOException e) {
            this.setMessage("Unable to read help");
            return;
        }
        LinkedHashMap<String, String> oldShortcuts = this.shortcuts;
        this.shortcuts = this.helpShortcuts();
        boolean oldWrapping = this.wrapping;
        boolean oldPrintLineNumbers = this.printLineNumbers;
        boolean oldConstantCursor = this.constantCursor;
        this.wrapping = true;
        this.printLineNumbers = false;
        this.constantCursor = false;
        this.buffer = newBuf;
        try {
            this.message = null;
            this.terminal.puts(InfoCmp.Capability.cursor_invisible, new Object[0]);
            this.display();
            while (true) {
                switch (this.readOperation(this.keys)) {
                    case QUIT: {
                        return;
                    }
                    case FIRST_LINE: {
                        this.buffer.firstLine();
                        break;
                    }
                    case LAST_LINE: {
                        this.buffer.lastLine();
                        break;
                    }
                    case PREV_PAGE: {
                        this.buffer.prevPage();
                        break;
                    }
                    case NEXT_PAGE: {
                        this.buffer.nextPage();
                        break;
                    }
                    case UP: {
                        this.buffer.scrollUp(1);
                        break;
                    }
                    case DOWN: {
                        this.buffer.scrollDown(1);
                        break;
                    }
                    case CLEAR_SCREEN: {
                        this.clearScreen();
                        break;
                    }
                    case MOUSE_EVENT: {
                        this.mouseEvent();
                    }
                }
                this.display();
            }
        }
        finally {
            this.buffer = org;
            this.wrapping = oldWrapping;
            this.printLineNumbers = oldPrintLineNumbers;
            this.constantCursor = oldConstantCursor;
            this.shortcuts = oldShortcuts;
            this.terminal.puts(InfoCmp.Capability.cursor_visible, new Object[0]);
        }
    }

    void search() throws IOException {
        KeyMap<Operation> searchKeyMap = new KeyMap<Operation>();
        searchKeyMap.setUnicode(Operation.INSERT);
        for (char i = 'A'; i <= 'Z'; i = (char)(i + '\u0001')) {
            searchKeyMap.bind(Operation.DO_LOWER_CASE, (CharSequence)KeyMap.alt(i));
        }
        searchKeyMap.bind(Operation.CASE_SENSITIVE, (CharSequence)KeyMap.alt('c'));
        searchKeyMap.bind(Operation.BACKWARDS, (CharSequence)KeyMap.alt('b'));
        searchKeyMap.bind(Operation.REGEXP, (CharSequence)KeyMap.alt('r'));
        searchKeyMap.bind(Operation.ACCEPT, (CharSequence)"\r");
        searchKeyMap.bind(Operation.CANCEL, (CharSequence)KeyMap.ctrl('C'));
        searchKeyMap.bind(Operation.FIRST_LINE, (CharSequence)KeyMap.ctrl('Y'));
        searchKeyMap.bind(Operation.LAST_LINE, (CharSequence)KeyMap.ctrl('V'));
        searchKeyMap.bind(Operation.MOUSE_EVENT, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_mouse));
        this.editMessage = this.getSearchMessage();
        this.editBuffer.setLength(0);
        this.shortcuts = this.searchShortcuts();
        this.display();
        try {
            while (true) {
                switch (this.readOperation(searchKeyMap)) {
                    case INSERT: {
                        this.editBuffer.append(this.bindingReader.getLastBinding());
                        break;
                    }
                    case CASE_SENSITIVE: {
                        this.searchCaseSensitive = !this.searchCaseSensitive;
                        break;
                    }
                    case BACKWARDS: {
                        this.searchBackwards = !this.searchBackwards;
                        break;
                    }
                    case REGEXP: {
                        this.searchRegexp = !this.searchRegexp;
                        break;
                    }
                    case CANCEL: {
                        return;
                    }
                    case BACKSPACE: {
                        if (this.editBuffer.length() <= 0) break;
                        this.editBuffer.setLength(this.editBuffer.length() - 1);
                        break;
                    }
                    case ACCEPT: {
                        if (this.editBuffer.length() > 0) {
                            this.searchTerm = this.editBuffer.toString();
                        }
                        if (this.searchTerm == null || this.searchTerm.isEmpty()) {
                            this.setMessage("Cancelled");
                        } else {
                            this.buffer.nextSearch();
                        }
                        return;
                    }
                    case HELP: {
                        this.help("nano-search-help.txt");
                        break;
                    }
                    case FIRST_LINE: {
                        this.buffer.firstLine();
                        return;
                    }
                    case LAST_LINE: {
                        this.buffer.lastLine();
                        return;
                    }
                    case MOUSE_EVENT: {
                        this.mouseEvent();
                    }
                }
                this.editMessage = this.getSearchMessage();
                this.display();
            }
        }
        finally {
            this.shortcuts = this.standardShortcuts();
            this.editMessage = null;
        }
    }

    private String getSearchMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Search");
        if (this.searchCaseSensitive) {
            sb.append(" [Case Sensitive]");
        }
        if (this.searchRegexp) {
            sb.append(" [Regexp]");
        }
        if (this.searchBackwards) {
            sb.append(" [Backwards]");
        }
        if (this.searchTerm != null) {
            sb.append(" [");
            sb.append(this.searchTerm);
            sb.append("]");
        }
        sb.append(": ");
        return sb.toString();
    }

    String computeCurPos() {
        int chari = 0;
        int chart = 0;
        for (int i = 0; i < this.buffer.lines.size(); ++i) {
            int l = this.buffer.lines.get(i).length() + 1;
            if (i < this.buffer.line) {
                chari += l;
            } else if (i == this.buffer.line) {
                chari += this.buffer.offsetInLine + this.buffer.column;
            }
            chart += l;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("line ");
        sb.append(this.buffer.line + 1);
        sb.append("/");
        sb.append(this.buffer.lines.size());
        sb.append(" (");
        sb.append(Math.round(100.0 * (double)this.buffer.line / (double)this.buffer.lines.size()));
        sb.append("%), ");
        sb.append("col ");
        sb.append(this.buffer.offsetInLine + this.buffer.column + 1);
        sb.append("/");
        sb.append(this.buffer.lines.get(this.buffer.line).length() + 1);
        sb.append(" (");
        if (this.buffer.lines.get(this.buffer.line).length() > 0) {
            sb.append(Math.round(100.0 * (double)(this.buffer.offsetInLine + this.buffer.column) / (double)this.buffer.lines.get(this.buffer.line).length()));
        } else {
            sb.append("100");
        }
        sb.append("%), ");
        sb.append("char ");
        sb.append(chari + 1);
        sb.append("/");
        sb.append(chart);
        sb.append(" (");
        sb.append(Math.round(100.0 * (double)chari / (double)chart));
        sb.append("%)");
        return sb.toString();
    }

    void curPos() {
        this.setMessage(this.computeCurPos());
    }

    void prevBuffer() throws IOException {
        if (this.buffers.size() > 1) {
            this.bufferIndex = (this.bufferIndex + this.buffers.size() - 1) % this.buffers.size();
            this.buffer = this.buffers.get(this.bufferIndex);
            this.setMessage("Switched to " + this.buffer.getTitle());
            this.buffer.open();
            this.display.clear();
        } else {
            this.setMessage("No more open file buffers");
        }
    }

    void nextBuffer() throws IOException {
        if (this.buffers.size() > 1) {
            this.bufferIndex = (this.bufferIndex + 1) % this.buffers.size();
            this.buffer = this.buffers.get(this.bufferIndex);
            this.setMessage("Switched to " + this.buffer.getTitle());
            this.buffer.open();
            this.display.clear();
        } else {
            this.setMessage("No more open file buffers");
        }
    }

    void setMessage(String message) {
        this.message = message;
        this.nbBindings = 25;
    }

    boolean quit() throws IOException {
        if (this.buffer.dirty) {
            Operation op = this.getYNC("Save modified buffer (ANSWERING \"No\" WILL DESTROY CHANGES) ? ");
            switch (op) {
                case CANCEL: {
                    return false;
                }
                case NO: {
                    break;
                }
                case YES: {
                    if (this.write()) break;
                    return false;
                }
            }
        }
        this.buffers.remove(this.bufferIndex);
        if (this.bufferIndex == this.buffers.size() && this.bufferIndex > 0) {
            this.bufferIndex = this.buffers.size() - 1;
        }
        if (this.buffers.isEmpty()) {
            this.buffer = null;
            return true;
        }
        this.buffer = this.buffers.get(this.bufferIndex);
        this.buffer.open();
        this.display.clear();
        this.setMessage("Switched to " + this.buffer.getTitle());
        return false;
    }

    void numbers() {
        this.printLineNumbers = !this.printLineNumbers;
        this.resetDisplay();
        this.setMessage("Lines numbering " + (this.printLineNumbers ? "enabled" : "disabled"));
    }

    void smoothScrolling() {
        this.smoothScrolling = !this.smoothScrolling;
        this.setMessage("Smooth scrolling " + (this.smoothScrolling ? "enabled" : "disabled"));
    }

    void mouseSupport() throws IOException {
        this.mouseSupport = !this.mouseSupport;
        this.setMessage("Mouse support " + (this.mouseSupport ? "enabled" : "disabled"));
        this.terminal.trackMouse(this.mouseSupport ? Terminal.MouseTracking.Normal : Terminal.MouseTracking.Off);
    }

    void constantCursor() {
        this.constantCursor = !this.constantCursor;
        this.setMessage("Constant cursor position display " + (this.constantCursor ? "enabled" : "disabled"));
    }

    void oneMoreLine() {
        this.oneMoreLine = !this.oneMoreLine;
        this.setMessage("Use of one more line for editing " + (this.oneMoreLine ? "enabled" : "disabled"));
    }

    void wrap() {
        this.wrapping = !this.wrapping;
        this.resetDisplay();
        this.setMessage("Lines wrapping " + (this.wrapping ? "enabled" : "disabled"));
    }

    void clearScreen() {
        this.resetDisplay();
    }

    void mouseEvent() {
        MouseEvent event = this.terminal.readMouseEvent();
        if (event.getModifiers().isEmpty() && event.getType() == MouseEvent.Type.Released && event.getButton() == MouseEvent.Button.Button1) {
            int x = event.getX();
            int y = event.getY();
            int hdr = this.buffer.computeHeader().size();
            int ftr = this.computeFooter().size();
            if (y >= hdr) {
                if (y < this.size.getRows() - ftr) {
                    this.buffer.moveTo(x, y - hdr);
                } else {
                    int cols = (this.shortcuts.size() + 1) / 2;
                    int cw = this.size.getColumns() / cols;
                    int l = y - (this.size.getRows() - ftr) - 1;
                    int si = l * cols + x / cw;
                    String shortcut = null;
                    Iterator<String> it = this.shortcuts.keySet().iterator();
                    while (si-- >= 0 && it.hasNext()) {
                        shortcut = it.next();
                    }
                    if (shortcut != null) {
                        shortcut = shortcut.replaceAll("M-", "\\\\E");
                        String seq = KeyMap.translate(shortcut);
                        this.bindingReader.runMacro(seq);
                    }
                }
            }
        } else if (event.getType() == MouseEvent.Type.Wheel) {
            if (event.getButton() == MouseEvent.Button.WheelDown) {
                this.buffer.moveDown(1);
            } else if (event.getButton() == MouseEvent.Button.WheelUp) {
                this.buffer.moveUp(1);
            }
        }
    }

    public String getTitle() {
        return this.title;
    }

    void resetDisplay() {
        this.display.clear();
        this.display.resize(this.size.getRows(), this.size.getColumns());
        for (Buffer buffer : this.buffers) {
            buffer.resetDisplay();
        }
    }

    synchronized void display() {
        int cursor;
        if (this.nbBindings > 0 && --this.nbBindings == 0) {
            this.message = null;
        }
        List<AttributedString> header = this.buffer.computeHeader();
        List<AttributedString> footer = this.computeFooter();
        int nbLines = this.size.getRows() - header.size() - footer.size();
        List<AttributedString> newLines = this.buffer.getDisplayedLines(nbLines);
        newLines.addAll(0, header);
        newLines.addAll(footer);
        if (this.editMessage != null) {
            cursor = this.editMessage.length() + this.editBuffer.length();
            cursor = this.size.cursorPos(this.size.getRows() - footer.size(), cursor);
        } else {
            cursor = this.size.cursorPos(header.size(), this.buffer.getDisplayedCursor());
        }
        this.display.update(newLines, cursor);
        this.flush();
    }

    protected void flush() {
        this.terminal.flush();
    }

    protected List<AttributedString> computeFooter() {
        ArrayList<AttributedString> footer = new ArrayList<AttributedString>();
        if (this.editMessage != null) {
            AttributedStringBuilder sb = new AttributedStringBuilder();
            sb.style(AttributedStyle.INVERSE);
            sb.append(this.editMessage);
            sb.append(this.editBuffer);
            for (int i = this.editMessage.length() + this.editBuffer.length(); i < this.size.getColumns(); ++i) {
                sb.append(' ');
            }
            sb.append('\n');
            footer.add(sb.toAttributedString());
        } else if (this.message != null || this.constantCursor) {
            int rwidth = this.size.getColumns();
            String text = "[ " + (this.message == null ? this.computeCurPos() : this.message) + " ]";
            int len = text.length();
            AttributedStringBuilder sb = new AttributedStringBuilder();
            for (int i = 0; i < (rwidth - len) / 2; ++i) {
                sb.append(' ');
            }
            sb.style(AttributedStyle.INVERSE);
            sb.append(text);
            sb.append('\n');
            footer.add(sb.toAttributedString());
        } else {
            footer.add(new AttributedString("\n"));
        }
        Iterator<Map.Entry<String, String>> sit = this.shortcuts.entrySet().iterator();
        int cols = (this.shortcuts.size() + 1) / 2;
        int cw = (this.size.getColumns() - 1) / cols;
        int rem = (this.size.getColumns() - 1) % cols;
        for (int l = 0; l < 2; ++l) {
            AttributedStringBuilder sb = new AttributedStringBuilder();
            for (int c = 0; c < cols; ++c) {
                Map.Entry<String, String> entry = sit.hasNext() ? sit.next() : null;
                String key = entry != null ? entry.getKey() : "";
                String val = entry != null ? entry.getValue() : "";
                sb.style(AttributedStyle.INVERSE);
                sb.append(key);
                sb.style(AttributedStyle.DEFAULT);
                sb.append(" ");
                int nb = cw - key.length() - 1 + (c < rem ? 1 : 0);
                if (val.length() > nb) {
                    sb.append(val.substring(0, nb));
                    continue;
                }
                sb.append(val);
                if (c >= cols - 1) continue;
                for (int i = 0; i < nb - val.length(); ++i) {
                    sb.append(" ");
                }
            }
            sb.append('\n');
            footer.add(sb.toAttributedString());
        }
        return footer;
    }

    protected void handle(Terminal.Signal signal) {
        this.size.copy(this.terminal.getSize());
        this.buffer.computeAllOffsets();
        this.buffer.moveToChar(this.buffer.offsetInLine + this.buffer.column);
        this.resetDisplay();
        this.display();
    }

    protected void bindKeys() {
        char i;
        this.keys = new KeyMap();
        this.keys.setUnicode(Operation.INSERT);
        for (i = ' '; i < '\u0080'; i = (char)((char)(i + 1))) {
            this.keys.bind(Operation.INSERT, (CharSequence)Character.toString(i));
        }
        this.keys.bind(Operation.BACKSPACE, (CharSequence)KeyMap.del());
        for (i = 'A'; i <= 'Z'; i = (char)(i + '\u0001')) {
            this.keys.bind(Operation.DO_LOWER_CASE, (CharSequence)KeyMap.alt(i));
        }
        this.keys.bind(Operation.HELP, KeyMap.ctrl('G'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f1));
        this.keys.bind(Operation.QUIT, KeyMap.ctrl('X'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f2));
        this.keys.bind(Operation.WRITE, KeyMap.ctrl('O'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f3));
        this.keys.bind(Operation.JUSTIFY_PARAGRAPH, KeyMap.ctrl('J'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f4));
        this.keys.bind(Operation.READ, KeyMap.ctrl('R'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f5));
        this.keys.bind(Operation.SEARCH, KeyMap.ctrl('W'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f6));
        this.keys.bind(Operation.PREV_PAGE, KeyMap.ctrl('Y'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f7));
        this.keys.bind(Operation.NEXT_PAGE, KeyMap.ctrl('V'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f8));
        this.keys.bind(Operation.CUT, KeyMap.ctrl('K'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f9));
        this.keys.bind(Operation.UNCUT, KeyMap.ctrl('U'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f10));
        this.keys.bind(Operation.CUR_POS, KeyMap.ctrl('C'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f11));
        this.keys.bind(Operation.TO_SPELL, KeyMap.ctrl('T'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f11));
        this.keys.bind(Operation.GOTO, KeyMap.ctrl('_'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f13), KeyMap.alt('g'));
        this.keys.bind(Operation.REPLACE, KeyMap.ctrl('\\'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f14), KeyMap.alt('r'));
        this.keys.bind(Operation.MARK, KeyMap.ctrl('^'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f15), KeyMap.alt('a'));
        this.keys.bind(Operation.NEXT_SEARCH, KeyMap.key(this.terminal, InfoCmp.Capability.key_f16), KeyMap.alt('w'));
        this.keys.bind(Operation.COPY, (CharSequence)KeyMap.alt('^'));
        this.keys.bind(Operation.INDENT, (CharSequence)KeyMap.alt('}'));
        this.keys.bind(Operation.UNINDENT, (CharSequence)KeyMap.alt('{'));
        this.keys.bind(Operation.RIGHT, (CharSequence)KeyMap.ctrl('F'));
        this.keys.bind(Operation.LEFT, (CharSequence)KeyMap.ctrl('B'));
        this.keys.bind(Operation.NEXT_WORD, (CharSequence)KeyMap.ctrl(' '));
        this.keys.bind(Operation.PREV_WORD, (CharSequence)KeyMap.alt(' '));
        this.keys.bind(Operation.UP, (CharSequence)KeyMap.ctrl('P'));
        this.keys.bind(Operation.DOWN, (CharSequence)KeyMap.ctrl('N'));
        this.keys.bind(Operation.BEGINNING_OF_LINE, (CharSequence)KeyMap.ctrl('A'));
        this.keys.bind(Operation.END_OF_LINE, (CharSequence)KeyMap.ctrl('E'));
        this.keys.bind(Operation.BEGINNING_OF_PARAGRAPH, KeyMap.alt('('), KeyMap.alt('9'));
        this.keys.bind(Operation.END_OF_PARAGRAPH, KeyMap.alt(')'), KeyMap.alt('0'));
        this.keys.bind(Operation.FIRST_LINE, KeyMap.alt('\\'), KeyMap.alt('|'));
        this.keys.bind(Operation.LAST_LINE, KeyMap.alt('/'), KeyMap.alt('?'));
        this.keys.bind(Operation.MATCHING, (CharSequence)KeyMap.alt(']'));
        this.keys.bind(Operation.SCROLL_UP, KeyMap.alt('-'), KeyMap.alt('_'));
        this.keys.bind(Operation.SCROLL_DOWN, KeyMap.alt('+'), KeyMap.alt('='));
        this.keys.bind(Operation.PREV_BUFFER, (CharSequence)KeyMap.alt('<'));
        this.keys.bind(Operation.NEXT_BUFFER, (CharSequence)KeyMap.alt('>'));
        this.keys.bind(Operation.PREV_BUFFER, (CharSequence)KeyMap.alt(','));
        this.keys.bind(Operation.NEXT_BUFFER, (CharSequence)KeyMap.alt('.'));
        this.keys.bind(Operation.VERBATIM, (CharSequence)KeyMap.alt('v'));
        this.keys.bind(Operation.INSERT, KeyMap.ctrl('I'), KeyMap.ctrl('M'));
        this.keys.bind(Operation.DELETE, (CharSequence)KeyMap.ctrl('D'));
        this.keys.bind(Operation.BACKSPACE, (CharSequence)KeyMap.ctrl('H'));
        this.keys.bind(Operation.CUT_TO_END, (CharSequence)KeyMap.alt('t'));
        this.keys.bind(Operation.JUSTIFY_FILE, (CharSequence)KeyMap.alt('j'));
        this.keys.bind(Operation.COUNT, (CharSequence)KeyMap.alt('d'));
        this.keys.bind(Operation.CLEAR_SCREEN, (CharSequence)KeyMap.ctrl('L'));
        this.keys.bind(Operation.HELP, (CharSequence)KeyMap.alt('x'));
        this.keys.bind(Operation.CONSTANT_CURSOR, (CharSequence)KeyMap.alt('c'));
        this.keys.bind(Operation.ONE_MORE_LINE, (CharSequence)KeyMap.alt('o'));
        this.keys.bind(Operation.SMOOTH_SCROLLING, (CharSequence)KeyMap.alt('s'));
        this.keys.bind(Operation.MOUSE_SUPPORT, (CharSequence)KeyMap.alt('m'));
        this.keys.bind(Operation.WHITESPACE, (CharSequence)KeyMap.alt('p'));
        this.keys.bind(Operation.HIGHLIGHT, (CharSequence)KeyMap.alt('y'));
        this.keys.bind(Operation.SMART_HOME_KEY, (CharSequence)KeyMap.alt('h'));
        this.keys.bind(Operation.AUTO_INDENT, (CharSequence)KeyMap.alt('i'));
        this.keys.bind(Operation.CUT_TO_END_TOGGLE, (CharSequence)KeyMap.alt('k'));
        this.keys.bind(Operation.TABS_TO_SPACE, (CharSequence)KeyMap.alt('q'));
        this.keys.bind(Operation.BACKUP, (CharSequence)KeyMap.alt('b'));
        this.keys.bind(Operation.NUMBERS, (CharSequence)KeyMap.alt('n'));
        this.keys.bind(Operation.UP, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_up));
        this.keys.bind(Operation.DOWN, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_down));
        this.keys.bind(Operation.RIGHT, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_right));
        this.keys.bind(Operation.LEFT, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_left));
        this.keys.bind(Operation.MOUSE_EVENT, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_mouse));
    }

    protected static enum Operation {
        DO_LOWER_CASE,
        QUIT,
        WRITE,
        READ,
        GOTO,
        FIND,
        WRAP,
        NUMBERS,
        SMOOTH_SCROLLING,
        MOUSE_SUPPORT,
        ONE_MORE_LINE,
        CLEAR_SCREEN,
        UP,
        DOWN,
        LEFT,
        RIGHT,
        INSERT,
        BACKSPACE,
        NEXT_BUFFER,
        PREV_BUFFER,
        HELP,
        NEXT_PAGE,
        PREV_PAGE,
        SCROLL_UP,
        SCROLL_DOWN,
        NEXT_WORD,
        PREV_WORD,
        BEGINNING_OF_LINE,
        END_OF_LINE,
        FIRST_LINE,
        LAST_LINE,
        CUR_POS,
        CASE_SENSITIVE,
        BACKWARDS,
        REGEXP,
        ACCEPT,
        CANCEL,
        SEARCH,
        MAC_FORMAT,
        DOS_FORMAT,
        APPEND_MODE,
        PREPEND_MODE,
        BACKUP,
        TO_FILES,
        YES,
        NO,
        NEW_BUFFER,
        EXECUTE,
        NEXT_SEARCH,
        MATCHING,
        VERBATIM,
        DELETE,
        JUSTIFY_PARAGRAPH,
        TO_SPELL,
        CUT,
        REPLACE,
        MARK,
        COPY,
        INDENT,
        UNINDENT,
        BEGINNING_OF_PARAGRAPH,
        END_OF_PARAGRAPH,
        CUT_TO_END,
        JUSTIFY_FILE,
        COUNT,
        CONSTANT_CURSOR,
        WHITESPACE,
        HIGHLIGHT,
        SMART_HOME_KEY,
        AUTO_INDENT,
        CUT_TO_END_TOGGLE,
        TABS_TO_SPACE,
        UNCUT,
        MOUSE_EVENT;

    }

    protected class Buffer {
        String file;
        Charset charset;
        WriteFormat format = WriteFormat.UNIX;
        List<String> lines;
        int firstLineToDisplay;
        int firstColumnToDisplay;
        int offsetInLineToDisplay;
        int line;
        List<LinkedList<Integer>> offsets = new ArrayList<LinkedList<Integer>>();
        int offsetInLine;
        int column;
        int wantedColumn;
        boolean dirty;

        protected Buffer(String file) {
            this.file = file;
        }

        void open() throws IOException {
            if (this.lines != null) {
                return;
            }
            this.lines = new ArrayList<String>();
            this.lines.add("");
            this.charset = Charset.defaultCharset();
            this.computeAllOffsets();
            if (this.file == null) {
                return;
            }
            Path path = Nano.this.root.resolve(this.file);
            if (Files.isDirectory(path, new LinkOption[0])) {
                Nano.this.setMessage("\"" + this.file + "\" is a directory");
                return;
            }
            try (InputStream fis = Files.newInputStream(path, new OpenOption[0]);){
                this.read(fis);
            }
            catch (IOException e) {
                Nano.this.setMessage("Error reading " + this.file + ": " + e.getMessage());
            }
        }

        void open(InputStream is) throws IOException {
            if (this.lines != null) {
                return;
            }
            this.lines = new ArrayList<String>();
            this.lines.add("");
            this.charset = Charset.defaultCharset();
            this.computeAllOffsets();
            this.read(is);
        }

        void read(InputStream fis) throws IOException {
            int remaining;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((remaining = fis.read(buffer)) > 0) {
                bos.write(buffer, 0, remaining);
            }
            byte[] bytes = bos.toByteArray();
            try {
                UniversalDetector detector = new UniversalDetector(null);
                detector.handleData(bytes, 0, bytes.length);
                detector.dataEnd();
                if (detector.getDetectedCharset() != null) {
                    this.charset = Charset.forName(detector.getDetectedCharset());
                }
            }
            catch (Throwable detector) {
                // empty catch block
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), this.charset));){
                String line;
                this.lines.clear();
                while ((line = reader.readLine()) != null) {
                    this.lines.add(line);
                }
            }
            if (this.lines.isEmpty()) {
                this.lines.add("");
            }
            this.computeAllOffsets();
            this.moveToChar(0);
        }

        void insert(String insert) {
            String text = this.lines.get(this.line);
            int pos = this.offsetInLine + this.column;
            insert = insert.replaceAll("\r\n", "\n");
            insert = insert.replaceAll("\r", "\n");
            String mod = pos == text.length() ? text + insert : text.substring(0, pos) + insert + text.substring(pos);
            ArrayList<String> ins = new ArrayList<String>();
            int last = 0;
            int idx = mod.indexOf(10, last);
            while (idx >= 0) {
                ins.add(mod.substring(last, idx));
                last = idx + 1;
                idx = mod.indexOf(10, last);
            }
            ins.add(mod.substring(last));
            this.lines.set(this.line, (String)ins.get(0));
            this.offsets.set(this.line, this.computeOffsets((String)ins.get(0)));
            for (int i = 1; i < ins.size(); ++i) {
                ++this.line;
                this.lines.add(this.line, (String)ins.get(i));
                this.offsets.add(this.line, this.computeOffsets((String)ins.get(i)));
            }
            this.moveToChar(((String)ins.get(ins.size() - 1)).length() - (text.length() - pos));
            this.dirty = true;
        }

        void computeAllOffsets() {
            this.offsets.clear();
            for (String text : this.lines) {
                this.offsets.add(this.computeOffsets(text));
            }
        }

        LinkedList<Integer> computeOffsets(String text) {
            int width = Nano.this.size.getColumns() - (Nano.this.printLineNumbers ? 8 : 0);
            LinkedList<Integer> offsets = new LinkedList<Integer>();
            offsets.add(0);
            int last = 0;
            int prevword = 0;
            boolean inspace = false;
            for (int i = 0; i < text.length(); ++i) {
                if (this.isBreakable(text.charAt(i))) {
                    inspace = true;
                } else if (inspace) {
                    prevword = i;
                    inspace = false;
                }
                if (i != last + width - 1) continue;
                if (prevword == last) {
                    prevword = i;
                }
                offsets.add(prevword);
                last = prevword;
            }
            return offsets;
        }

        boolean isBreakable(char ch) {
            return ch == ' ';
        }

        void moveToChar(int pos) {
            this.offsetInLine = this.prevLineOffset(this.line, pos + 1).get();
            this.column = pos - this.offsetInLine;
        }

        void delete(int count) {
            while (--count >= 0 && this.moveRight(1) && this.backspace(1)) {
            }
        }

        boolean backspace(int count) {
            while (count > 0) {
                String text = this.lines.get(this.line);
                int pos = this.offsetInLine + this.column;
                if (pos == 0) {
                    if (this.line == 0) {
                        this.bof();
                        return false;
                    }
                    String prev = this.lines.get(--this.line);
                    this.lines.set(this.line, prev + text);
                    this.offsets.set(this.line, this.computeOffsets(prev + text));
                    this.moveToChar(this.length(prev, Nano.this.tabs));
                    this.lines.remove(this.line + 1);
                    this.offsets.remove(this.line + 1);
                    --count;
                    this.dirty = true;
                    continue;
                }
                int nb = Math.min(pos, count);
                text = text.substring(0, pos - nb) + text.substring(pos);
                this.lines.set(this.line, text);
                this.offsets.set(this.line, this.computeOffsets(text));
                this.moveToChar(this.offsetInLine + this.column - nb);
                count -= nb;
                this.dirty = true;
            }
            return true;
        }

        boolean moveLeft(int chars) {
            boolean ret = true;
            while (--chars >= 0) {
                if (this.offsetInLine + this.column > 0) {
                    this.moveToChar(this.offsetInLine + this.column - 1);
                    continue;
                }
                if (this.line > 0) {
                    --this.line;
                    this.moveToChar(this.length(this.getLine(this.line), Nano.this.tabs));
                    continue;
                }
                this.bof();
                ret = false;
                break;
            }
            this.wantedColumn = this.column;
            this.ensureCursorVisible();
            return ret;
        }

        boolean moveRight(int chars) {
            boolean ret = true;
            while (--chars >= 0) {
                int len = this.length(this.getLine(this.line), Nano.this.tabs);
                if (this.offsetInLine + this.column + 1 <= len) {
                    this.moveToChar(this.offsetInLine + this.column + 1);
                    continue;
                }
                if (this.getLine(this.line + 1) != null) {
                    ++this.line;
                    this.offsetInLine = 0;
                    this.column = 0;
                    continue;
                }
                this.eof();
                ret = false;
                break;
            }
            this.wantedColumn = this.column;
            this.ensureCursorVisible();
            return ret;
        }

        void moveDown(int lines) {
            this.cursorDown(lines);
            this.ensureCursorVisible();
        }

        void moveUp(int lines) {
            this.cursorUp(lines);
            this.ensureCursorVisible();
        }

        private Optional<Integer> prevLineOffset(int line, int offsetInLine) {
            if (line >= this.offsets.size()) {
                return Optional.empty();
            }
            Iterator<Integer> it = this.offsets.get(line).descendingIterator();
            while (it.hasNext()) {
                int off = it.next();
                if (off >= offsetInLine) continue;
                return Optional.of(off);
            }
            return Optional.empty();
        }

        private Optional<Integer> nextLineOffset(int line, int offsetInLine) {
            if (line >= this.offsets.size()) {
                return Optional.empty();
            }
            return this.offsets.get(line).stream().filter(o -> o > offsetInLine).findFirst();
        }

        void moveDisplayDown(int lines) {
            int height = Nano.this.size.getRows() - this.computeHeader().size() - Nano.this.computeFooter().size();
            while (--lines >= 0) {
                int lastLineToDisplay = this.firstLineToDisplay;
                if (this.firstColumnToDisplay > 0 || !Nano.this.wrapping) {
                    lastLineToDisplay += height - 1;
                } else {
                    int off = this.offsetInLineToDisplay;
                    for (int l = 0; l < height - 1; ++l) {
                        Optional<Integer> next = this.nextLineOffset(lastLineToDisplay, off);
                        if (next.isPresent()) {
                            off = next.get();
                            continue;
                        }
                        off = 0;
                        ++lastLineToDisplay;
                    }
                }
                if (this.getLine(lastLineToDisplay) == null) {
                    this.eof();
                    return;
                }
                Optional<Integer> next = this.nextLineOffset(this.firstLineToDisplay, this.offsetInLineToDisplay);
                if (next.isPresent()) {
                    this.offsetInLineToDisplay = next.get();
                    continue;
                }
                this.offsetInLineToDisplay = 0;
                ++this.firstLineToDisplay;
            }
        }

        void moveDisplayUp(int lines) {
            int width = Nano.this.size.getColumns() - (Nano.this.printLineNumbers ? 8 : 0);
            while (--lines >= 0) {
                if (this.offsetInLineToDisplay > 0) {
                    this.offsetInLineToDisplay = Math.max(0, this.offsetInLineToDisplay - (width - 1));
                    continue;
                }
                if (this.firstLineToDisplay > 0) {
                    --this.firstLineToDisplay;
                    this.offsetInLineToDisplay = this.prevLineOffset(this.firstLineToDisplay, Integer.MAX_VALUE).get();
                    continue;
                }
                this.bof();
                return;
            }
        }

        private void cursorDown(int lines) {
            while (--lines >= 0) {
                if (this.firstColumnToDisplay > 0 || !Nano.this.wrapping) {
                    if (this.getLine(this.line + 1) != null) {
                        ++this.line;
                        this.offsetInLine = 0;
                        this.column = Math.min(this.getLine(this.line).length(), this.wantedColumn);
                        continue;
                    }
                    this.bof();
                    break;
                }
                String txt = this.getLine(this.line);
                Optional<Integer> off = this.nextLineOffset(this.line, this.offsetInLine);
                if (off.isPresent()) {
                    this.offsetInLine = off.get();
                } else {
                    if (this.getLine(this.line + 1) == null) {
                        this.eof();
                        break;
                    }
                    ++this.line;
                    this.offsetInLine = 0;
                    txt = this.getLine(this.line);
                }
                String curLine = txt;
                int next = this.nextLineOffset(this.line, this.offsetInLine).orElseGet(curLine::length);
                this.column = Math.min(this.wantedColumn, next - this.offsetInLine);
            }
        }

        private void cursorUp(int lines) {
            while (--lines >= 0) {
                if (this.firstColumnToDisplay > 0 || !Nano.this.wrapping) {
                    if (this.line > 0) {
                        --this.line;
                        this.column = Math.min(this.length(this.getLine(this.line), Nano.this.tabs) - this.offsetInLine, this.wantedColumn);
                        continue;
                    }
                    this.bof();
                    break;
                }
                Optional<Integer> prev = this.prevLineOffset(this.line, this.offsetInLine);
                if (prev.isPresent()) {
                    this.offsetInLine = prev.get();
                    continue;
                }
                if (this.line > 0) {
                    --this.line;
                    this.offsetInLine = this.prevLineOffset(this.line, Integer.MAX_VALUE).get();
                    int next = this.nextLineOffset(this.line, this.offsetInLine).orElse(this.getLine(this.line).length());
                    this.column = Math.min(this.wantedColumn, next - this.offsetInLine);
                    continue;
                }
                this.bof();
                break;
            }
        }

        void ensureCursorVisible() {
            List<AttributedString> header = this.computeHeader();
            int rwidth = Nano.this.size.getColumns();
            int height = Nano.this.size.getRows() - header.size() - Nano.this.computeFooter().size();
            while (this.line < this.firstLineToDisplay || this.line == this.firstLineToDisplay && this.offsetInLine < this.offsetInLineToDisplay) {
                this.moveDisplayUp(Nano.this.smoothScrolling ? 1 : height / 2);
            }
            while (true) {
                int cursor = header.size() * Nano.this.size.getColumns() + (Nano.this.printLineNumbers ? 8 : 0);
                int cur = this.firstLineToDisplay;
                int off = this.offsetInLineToDisplay;
                while (cur < this.line || off < this.offsetInLine) {
                    if (this.firstColumnToDisplay > 0 || !Nano.this.wrapping) {
                        cursor += rwidth;
                        ++cur;
                        continue;
                    }
                    cursor += rwidth;
                    Optional<Integer> next = this.nextLineOffset(cur, off);
                    if (next.isPresent()) {
                        off = next.get();
                        continue;
                    }
                    ++cur;
                    off = 0;
                }
                if (cur != this.line) {
                    throw new IllegalStateException();
                }
                if ((cursor += this.column) < (height + header.size()) * rwidth) break;
                this.moveDisplayDown(Nano.this.smoothScrolling ? 1 : height / 2);
            }
        }

        void eof() {
        }

        void bof() {
        }

        void resetDisplay() {
            int width = Nano.this.size.getColumns() - (Nano.this.printLineNumbers ? 8 : 0);
            this.column = this.offsetInLine + this.column;
            this.offsetInLine = this.column / width * (width - 1);
            this.column -= this.offsetInLine;
        }

        String getLine(int line) {
            return line < this.lines.size() ? this.lines.get(line) : null;
        }

        String getTitle() {
            return this.file != null ? "File: " + this.file : "New Buffer";
        }

        List<AttributedString> computeHeader() {
            String left = Nano.this.getTitle();
            String middle = null;
            String right = this.dirty ? "Modified" : "        ";
            int width = Nano.this.size.getColumns();
            int mstart = 2 + left.length() + 1;
            int mend = width - 2 - 8;
            if (this.file == null) {
                middle = "New Buffer";
            } else {
                int max = mend - mstart;
                String src = this.file;
                if ("File: ".length() + src.length() > max) {
                    int lastSep = src.lastIndexOf(47);
                    if (lastSep > 0) {
                        String p1 = src.substring(lastSep);
                        String p0 = src.substring(0, lastSep);
                        while (p0.startsWith(".")) {
                            p0 = p0.substring(1);
                        }
                        int nb = max - p1.length() - "File: ...".length();
                        int cut = Math.max(0, Math.min(p0.length(), p0.length() - nb));
                        middle = "File: ..." + p0.substring(cut, p0.length()) + p1;
                    }
                    if (middle == null || middle.length() > max) {
                        left = null;
                        max = mend - 2;
                        int nb = max - "File: ...".length();
                        int cut = Math.max(0, Math.min(src.length(), src.length() - nb));
                        middle = "File: ..." + src.substring(cut, src.length());
                        if (middle.length() > max) {
                            middle = middle.substring(0, max);
                        }
                    }
                } else {
                    middle = "File: " + src;
                }
            }
            int pos = 0;
            AttributedStringBuilder sb = new AttributedStringBuilder();
            sb.style(AttributedStyle.INVERSE);
            sb.append("  ");
            pos += 2;
            if (left != null) {
                sb.append(left);
                pos += left.length();
                sb.append(" ");
                ++pos;
                for (int i = 1; i < (Nano.this.size.getColumns() - middle.length()) / 2 - left.length() - 1 - 2; ++i) {
                    sb.append(" ");
                    ++pos;
                }
            }
            sb.append(middle);
            pos += middle.length();
            while (pos < width - 8 - 2) {
                sb.append(" ");
                ++pos;
            }
            sb.append(right);
            sb.append("  \n");
            if (Nano.this.oneMoreLine) {
                return Collections.singletonList(sb.toAttributedString());
            }
            return Arrays.asList(sb.toAttributedString(), new AttributedString("\n"));
        }

        List<AttributedString> getDisplayedLines(int nbLines) {
            AttributedStyle s = AttributedStyle.DEFAULT.foreground(8);
            AttributedString cut = new AttributedString("\u2026", s);
            AttributedString ret = new AttributedString("\u21a9", s);
            ArrayList<AttributedString> newLines = new ArrayList<AttributedString>();
            int rwidth = Nano.this.size.getColumns();
            int width = rwidth - (Nano.this.printLineNumbers ? 8 : 0);
            int curLine = this.firstLineToDisplay;
            int curOffset = this.offsetInLineToDisplay;
            int prevLine = -1;
            for (int terminalLine = 0; terminalLine < nbLines; ++terminalLine) {
                AttributedStringBuilder line = new AttributedStringBuilder().tabs(Nano.this.tabs);
                if (Nano.this.printLineNumbers && curLine < this.lines.size()) {
                    line.style(s);
                    if (curLine != prevLine) {
                        line.append(String.format("%7d ", curLine + 1));
                    } else {
                        line.append("      \u2027 ");
                    }
                    line.style(AttributedStyle.DEFAULT);
                    prevLine = curLine;
                }
                if (curLine < this.lines.size()) {
                    if (this.firstColumnToDisplay > 0 || !Nano.this.wrapping) {
                        AttributedString disp = new AttributedString(this.getLine(curLine));
                        if ((disp = disp.columnSubSequence(this.firstColumnToDisplay, Integer.MAX_VALUE)).columnLength() >= width) {
                            line.append(disp.columnSubSequence(0, width - cut.columnLength()));
                            line.append(cut);
                        } else {
                            line.append(disp);
                        }
                        ++curLine;
                    } else {
                        AttributedString disp;
                        Optional<Integer> nextOffset = this.nextLineOffset(curLine, curOffset);
                        if (nextOffset.isPresent()) {
                            disp = new AttributedString(this.getLine(curLine));
                            line.append(disp.columnSubSequence(curOffset, nextOffset.get()));
                            line.append(ret);
                            curOffset = nextOffset.get();
                        } else {
                            disp = new AttributedString(this.getLine(curLine));
                            line.append(disp.columnSubSequence(curOffset, Integer.MAX_VALUE));
                            ++curLine;
                            curOffset = 0;
                        }
                    }
                }
                line.append('\n');
                newLines.add(line.toAttributedString());
            }
            return newLines;
        }

        public void moveTo(int x, int y) {
            if (Nano.this.printLineNumbers) {
                x = Math.max(x - 8, 0);
            }
            this.line = this.firstLineToDisplay;
            this.offsetInLine = this.offsetInLineToDisplay;
            this.wantedColumn = x;
            this.cursorDown(y);
        }

        public int getDisplayedCursor() {
            int rwidth = Nano.this.size.getColumns() + 1;
            int cursor = Nano.this.printLineNumbers ? 8 : 0;
            int cur = this.firstLineToDisplay;
            int off = this.offsetInLineToDisplay;
            while (cur < this.line || off < this.offsetInLine) {
                if (this.firstColumnToDisplay > 0 || !Nano.this.wrapping) {
                    cursor += rwidth;
                    ++cur;
                    continue;
                }
                cursor += rwidth;
                Optional<Integer> next = this.nextLineOffset(cur, off);
                if (next.isPresent()) {
                    off = next.get();
                    continue;
                }
                ++cur;
                off = 0;
            }
            if (cur != this.line) {
                throw new IllegalStateException();
            }
            return cursor += this.column;
        }

        char getCurrentChar() {
            String str = this.lines.get(this.line);
            if (this.column + this.offsetInLine < str.length()) {
                return str.charAt(this.column + this.offsetInLine);
            }
            if (this.line < this.lines.size() - 1) {
                return '\n';
            }
            return '\u0000';
        }

        public void prevWord() {
            while (Character.isAlphabetic(this.getCurrentChar()) && this.moveLeft(1)) {
            }
            while (!Character.isAlphabetic(this.getCurrentChar()) && this.moveLeft(1)) {
            }
            while (Character.isAlphabetic(this.getCurrentChar()) && this.moveLeft(1)) {
            }
            this.moveRight(1);
        }

        public void nextWord() {
            while (Character.isAlphabetic(this.getCurrentChar()) && this.moveRight(1)) {
            }
            while (!Character.isAlphabetic(this.getCurrentChar()) && this.moveRight(1)) {
            }
        }

        public void beginningOfLine() {
            this.offsetInLine = 0;
            this.column = 0;
            this.wantedColumn = 0;
        }

        public void endOfLine() {
            this.column = this.length(this.lines.get(this.line), Nano.this.tabs);
            int width = Nano.this.size.getColumns() - (Nano.this.printLineNumbers ? 8 : 0);
            this.offsetInLine = this.column / width * (width - 1);
            this.column -= this.offsetInLine;
            this.wantedColumn = this.column;
        }

        public void prevPage() {
            int height = Nano.this.size.getRows() - this.computeHeader().size() - Nano.this.computeFooter().size();
            this.scrollUp(height - 2);
        }

        public void nextPage() {
            int height = Nano.this.size.getRows() - this.computeHeader().size() - Nano.this.computeFooter().size();
            this.scrollDown(height - 2);
        }

        public void scrollUp(int lines) {
            this.cursorUp(lines);
            this.moveDisplayUp(lines);
        }

        public void scrollDown(int lines) {
            this.cursorDown(lines);
            this.moveDisplayDown(lines);
        }

        public void firstLine() {
            this.line = 0;
            this.column = 0;
            this.offsetInLine = 0;
            this.ensureCursorVisible();
        }

        public void lastLine() {
            this.line = this.lines.size() - 1;
            this.column = 0;
            this.offsetInLine = 0;
            this.ensureCursorVisible();
        }

        void nextSearch() {
            if (Nano.this.searchTerm == null) {
                Nano.this.setMessage("No current search pattern");
                return;
            }
            Nano.this.setMessage(null);
            int cur = this.line;
            int dir = Nano.this.searchBackwards ? -1 : 1;
            int newPos = -1;
            int newLine = -1;
            List<Integer> curRes = this.doSearch(this.lines.get(this.line));
            if (Nano.this.searchBackwards) {
                Collections.reverse(curRes);
            }
            for (int r : curRes) {
                if (!(Nano.this.searchBackwards ? r < this.offsetInLine + this.column : r > this.offsetInLine + this.column)) continue;
                newPos = r;
                newLine = this.line;
                break;
            }
            if (newPos < 0) {
                while ((cur = (cur + dir + this.lines.size()) % this.lines.size()) != this.line) {
                    List<Integer> res = this.doSearch(this.lines.get(cur));
                    if (res.isEmpty()) continue;
                    newPos = Nano.this.searchBackwards ? res.get(res.size() - 1).intValue() : res.get(0).intValue();
                    newLine = cur;
                    break;
                }
            }
            if (newPos < 0 && !curRes.isEmpty()) {
                newPos = curRes.get(0);
                newLine = this.line;
            }
            if (newPos >= 0) {
                if (newLine == this.line && newPos == this.offsetInLine + this.column) {
                    Nano.this.setMessage("This is the only occurence");
                    return;
                }
                if (Nano.this.searchBackwards && (newLine > this.line || newLine == this.line && newPos > this.offsetInLine + this.column) || !Nano.this.searchBackwards && (newLine < this.line || newLine == this.line && newPos < this.offsetInLine + this.column)) {
                    Nano.this.setMessage("Search Wrapped");
                }
                int width = Nano.this.size.getColumns() - (Nano.this.printLineNumbers ? 8 : 0);
                this.line = newLine;
                this.column = newPos;
                this.offsetInLine = this.column / width * (width - 1);
                this.ensureCursorVisible();
            } else {
                Nano.this.setMessage("\"" + Nano.this.searchTerm + "\" not found");
            }
        }

        private List<Integer> doSearch(String text) {
            Pattern pat = Pattern.compile(Nano.this.searchTerm, (Nano.this.searchCaseSensitive ? 0 : 66) | (Nano.this.searchRegexp ? 0 : 16));
            Matcher m = pat.matcher(text);
            ArrayList<Integer> res = new ArrayList<Integer>();
            while (m.find()) {
                res.add(m.start());
            }
            return res;
        }

        public void matching() {
            char opening = this.getCurrentChar();
            int idx = Nano.this.matchBrackets.indexOf(opening);
            if (idx >= 0) {
                int dir = idx >= Nano.this.matchBrackets.length() / 2 ? -1 : 1;
                char closing = Nano.this.matchBrackets.charAt((idx + Nano.this.matchBrackets.length() / 2) % Nano.this.matchBrackets.length());
                int lvl = 1;
                int cur = this.line;
                int pos = this.offsetInLine + this.column;
                while (true) {
                    if (pos + dir >= 0 && pos + dir < this.getLine(cur).length()) {
                        pos += dir;
                    } else if (cur + dir >= 0 && cur + dir < this.lines.size()) {
                        pos = dir > 0 ? 0 : this.lines.get(cur += dir).length() - 1;
                        if (pos < 0 || pos >= this.lines.get(cur).length()) {
                            continue;
                        }
                    } else {
                        Nano.this.setMessage("No matching bracket");
                        return;
                    }
                    char c = this.lines.get(cur).charAt(pos);
                    if (c == opening) {
                        ++lvl;
                        continue;
                    }
                    if (c == closing && --lvl == 0) break;
                }
                this.line = cur;
                this.moveToChar(pos);
                this.ensureCursorVisible();
                return;
            }
            Nano.this.setMessage("Not a bracket");
        }

        private int length(String line, int tabs) {
            return new AttributedStringBuilder().tabs(tabs).append(line).columnLength();
        }
    }

    protected static enum WriteFormat {
        UNIX,
        DOS,
        MAC;

    }

    protected static enum WriteMode {
        WRITE,
        APPEND,
        PREPEND;

    }
}

