/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl.index;

import java.io.File;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public abstract class BundleContextInterceptorBase
implements BundleContext,
ServiceListener {
    protected final BundleContext m_context;
    private final Map<ServiceListener, String> m_serviceListenerFilterMap = new HashMap<ServiceListener, String>();
    private long m_currentVersion = 0L;
    private long m_entryVersion = -1L;
    private Map.Entry<ServiceListener, String>[] m_serviceListenerFilterMapEntries;

    public BundleContextInterceptorBase(BundleContext context) {
        this.m_context = context;
    }

    public String getProperty(String key) {
        return this.m_context.getProperty(key);
    }

    public Bundle getBundle() {
        return this.m_context.getBundle();
    }

    public Bundle installBundle(String location) throws BundleException {
        return this.m_context.installBundle(location);
    }

    public Bundle installBundle(String location, InputStream input) throws BundleException {
        return this.m_context.installBundle(location, input);
    }

    public Bundle getBundle(long id) {
        return this.m_context.getBundle(id);
    }

    public Bundle[] getBundles() {
        return this.m_context.getBundles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServiceListener(ServiceListener listener, String filter) throws InvalidSyntaxException {
        Map<ServiceListener, String> map = this.m_serviceListenerFilterMap;
        synchronized (map) {
            this.m_serviceListenerFilterMap.put(listener, filter);
            ++this.m_currentVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServiceListener(ServiceListener listener) {
        Map<ServiceListener, String> map = this.m_serviceListenerFilterMap;
        synchronized (map) {
            this.m_serviceListenerFilterMap.put(listener, null);
            ++this.m_currentVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceListener(ServiceListener listener) {
        Map<ServiceListener, String> map = this.m_serviceListenerFilterMap;
        synchronized (map) {
            this.m_serviceListenerFilterMap.remove(listener);
            ++this.m_currentVersion;
        }
    }

    public void addBundleListener(BundleListener listener) {
        this.m_context.addBundleListener(listener);
    }

    public void removeBundleListener(BundleListener listener) {
        this.m_context.removeBundleListener(listener);
    }

    public void addFrameworkListener(FrameworkListener listener) {
        this.m_context.addFrameworkListener(listener);
    }

    public void removeFrameworkListener(FrameworkListener listener) {
        this.m_context.removeFrameworkListener(listener);
    }

    public ServiceRegistration registerService(String[] clazzes, Object service, Dictionary properties) {
        return this.m_context.registerService(clazzes, service, properties);
    }

    public ServiceRegistration registerService(String clazz, Object service, Dictionary properties) {
        return this.m_context.registerService(clazz, service, properties);
    }

    public ServiceReference[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        return this.m_context.getServiceReferences(clazz, filter);
    }

    public ServiceReference[] getAllServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        return this.m_context.getAllServiceReferences(clazz, filter);
    }

    public ServiceReference getServiceReference(String clazz) {
        return this.m_context.getServiceReference(clazz);
    }

    public Object getService(ServiceReference reference) {
        return this.m_context.getService(reference);
    }

    public boolean ungetService(ServiceReference reference) {
        return this.m_context.ungetService(reference);
    }

    public File getDataFile(String filename) {
        return this.m_context.getDataFile(filename);
    }

    public Filter createFilter(String filter) throws InvalidSyntaxException {
        return this.m_context.createFilter(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map.Entry<ServiceListener, String>[] synchronizeCollection() {
        Map<ServiceListener, String> map = this.m_serviceListenerFilterMap;
        synchronized (map) {
            if (this.m_currentVersion != this.m_entryVersion) {
                this.m_serviceListenerFilterMapEntries = this.m_serviceListenerFilterMap.entrySet().toArray(new Map.Entry[this.m_serviceListenerFilterMap.size()]);
                this.m_entryVersion = this.m_currentVersion;
            }
        }
        return this.m_serviceListenerFilterMapEntries;
    }
}

