/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.runtime;

import java.util.Dictionary;
import java.util.List;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.runtime.AbstractBuilder;
import org.apache.felix.dm.runtime.MetaData;
import org.apache.felix.dm.runtime.Params;
import org.apache.felix.dm.runtime.ServiceLifecycleHandler;
import org.osgi.framework.Bundle;

public class AdapterServiceBuilder
extends AbstractBuilder {
    private static final String TYPE = "AdapterService";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void build(MetaData srvMeta, List<MetaData> depsMeta, Bundle b, DependencyManager dm) throws Exception {
        Class adapterImplClass = b.loadClass(srvMeta.getString(Params.impl));
        String[] provides = srvMeta.getStrings(Params.provides, null);
        Dictionary<String, Object> adapterProperties = srvMeta.getDictionary(Params.properties, null);
        Class adapteeService = b.loadClass(srvMeta.getString(Params.adapteeService));
        String adapteeFilter = srvMeta.getString(Params.adapteeFilter, null);
        String field = srvMeta.getString(Params.field, null);
        String added = srvMeta.getString(Params.added, null);
        String changed = srvMeta.getString(Params.changed, null);
        String removed = srvMeta.getString(Params.removed, null);
        String swap = srvMeta.getString(Params.swap, null);
        boolean propagate = "true".equals(srvMeta.getString(Params.propagate, "true"));
        if (field != null && (added != null || changed != null || removed != null || swap != null)) {
            throw new IllegalArgumentException("autoconfig field " + field + " can't be defined with both added/changed/removed/swap calllbacks");
        }
        Component c = field != null ? dm.createAdapterService(adapteeService, adapteeFilter, field, null, null, null, null, null, propagate) : (added != null || changed != null || removed != null || swap != null ? dm.createAdapterService(adapteeService, adapteeFilter, null, null, added, changed, removed, swap, propagate) : dm.createAdapterService(adapteeService, adapteeFilter, null, null, null, null, null, null, propagate));
        this.setCommonServiceParams(c, srvMeta);
        c.setInterface(provides, adapterProperties);
        String factoryMethod = srvMeta.getString(Params.factoryMethod, null);
        if (factoryMethod == null) {
            c.setImplementation((Object)adapterImplClass);
        } else {
            c.setFactory((Object)adapterImplClass, factoryMethod);
        }
        c.setComposition(srvMeta.getString(Params.composition, null));
        ServiceLifecycleHandler lfcleHandler = new ServiceLifecycleHandler(c, b, dm, srvMeta, depsMeta);
        c.setCallbacks((Object)lfcleHandler, "init", "start", "stop", "destroy");
        AdapterServiceBuilder.addUnamedDependencies(b, dm, c, srvMeta, depsMeta);
        dm.add(c);
    }
}

