/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.runtime;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.runtime.AbstractBuilder;
import org.apache.felix.dm.runtime.ComponentFactoryImpl;
import org.apache.felix.dm.runtime.FactorySet;
import org.apache.felix.dm.runtime.Log;
import org.apache.felix.dm.runtime.MetaData;
import org.apache.felix.dm.runtime.Params;
import org.apache.felix.dm.runtime.ServiceLifecycleHandler;
import org.apache.felix.dm.runtime.api.ComponentFactory;
import org.osgi.framework.Bundle;

public class ComponentBuilder
extends AbstractBuilder {
    private static final String TYPE = "Component";
    public static final String FACTORY_NAME = "dm.factory.name";
    public static final String FACTORY_INSTANCE = "dm.factory.instance";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void build(MetaData srvMeta, List<MetaData> depsMeta, Bundle b, DependencyManager dm) throws Exception {
        Component c = dm.createComponent();
        String factory = srvMeta.getString(Params.factorySet, null);
        String factoryName = srvMeta.getString(Params.factoryName, null);
        this.setCommonServiceParams(c, srvMeta);
        if (factory == null && factoryName == null) {
            Log.instance().info("ComponentBuilder: building service %s with dependencies %s", srvMeta, depsMeta);
            String impl = srvMeta.getString(Params.impl);
            String composition = srvMeta.getString(Params.composition, null);
            String factoryMethod = srvMeta.getString(Params.factoryMethod, null);
            if (factoryMethod == null) {
                c.setImplementation((Object)b.loadClass(impl));
            } else {
                c.setFactory((Object)b.loadClass(impl), factoryMethod);
            }
            c.setComposition(composition);
            ComponentBuilder.addUnamedDependencies(b, dm, c, srvMeta, depsMeta);
            ServiceLifecycleHandler lfcleHandler = new ServiceLifecycleHandler(c, b, dm, srvMeta, depsMeta);
            c.setCallbacks((Object)lfcleHandler, "init", "start", "stop", "destroy");
            Dictionary<String, Object> properties = srvMeta.getDictionary(Params.properties, null);
            String[] services = srvMeta.getStrings(Params.provides, null);
            c.setInterface(services, properties);
        } else if (factory != null) {
            Log.instance().info("ComponentBuilder: providing factory set for service %s with dependencies %s", srvMeta, depsMeta);
            FactorySet factorySet = new FactorySet(b, srvMeta, depsMeta);
            c.setImplementation((Object)factorySet);
            c.setCallbacks(null, "start", "stop", null);
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put(FACTORY_NAME, factory);
            c.setInterface(Set.class.getName(), props);
        } else if (factoryName != null) {
            Log.instance().info("ComponentBuilder: providing component factory for service %s with dependencies %s", srvMeta, depsMeta);
            ComponentFactoryImpl compFactory = new ComponentFactoryImpl(b, srvMeta, depsMeta);
            c.setImplementation((Object)compFactory);
            c.setCallbacks(null, "start", "stop", null);
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put(FACTORY_NAME, factoryName);
            c.setInterface(ComponentFactory.class.getName(), props);
        }
        dm.add(c);
    }
}

