/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.Dictionary;
import org.apache.felix.dm.BundleDependency;
import org.apache.felix.dm.ComponentDependencyDeclaration;
import org.apache.felix.dm.context.AbstractDependency;
import org.apache.felix.dm.context.DependencyContext;
import org.apache.felix.dm.context.Event;
import org.apache.felix.dm.context.EventType;
import org.apache.felix.dm.impl.BundleEventImpl;
import org.apache.felix.dm.impl.DefaultNullObject;
import org.apache.felix.dm.impl.InvocationUtil;
import org.apache.felix.dm.tracker.BundleTracker;
import org.apache.felix.dm.tracker.BundleTrackerCustomizer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

public class BundleDependencyImpl
extends AbstractDependency<BundleDependency>
implements BundleDependency,
BundleTrackerCustomizer,
ComponentDependencyDeclaration {
    private BundleTracker m_tracker;
    private int m_stateMask = 38;
    private Bundle m_bundleInstance;
    private Filter m_filter;
    private long m_bundleId = -1L;
    private Object m_nullObject;
    private boolean m_propagate;
    private Object m_propagateCallbackInstance;
    private String m_propagateCallbackMethod;

    public BundleDependencyImpl() {
    }

    public BundleDependencyImpl(BundleDependencyImpl prototype) {
        super(prototype);
        this.m_stateMask = prototype.m_stateMask;
        this.m_nullObject = prototype.m_nullObject;
        this.m_bundleInstance = prototype.m_bundleInstance;
        this.m_filter = prototype.m_filter;
        this.m_bundleId = prototype.m_bundleId;
        this.m_propagate = prototype.m_propagate;
        this.m_propagateCallbackInstance = prototype.m_propagateCallbackInstance;
        this.m_propagateCallbackMethod = prototype.m_propagateCallbackMethod;
    }

    @Override
    public DependencyContext createCopy() {
        return new BundleDependencyImpl(this);
    }

    @Override
    public void start() {
        this.m_tracker = new BundleTracker(this.m_component.getBundleContext(), this.m_stateMask, this);
        this.m_tracker.open();
        super.start();
    }

    @Override
    public void stop() {
        this.m_tracker.close();
        this.m_tracker = null;
        super.stop();
    }

    @Override
    public String getName() {
        StringBuilder sb = new StringBuilder();
        this.getSimpleName(sb);
        if (this.m_filter != null) {
            sb.append(" ");
            sb.append(this.m_filter.toString());
        }
        if (this.m_bundleId != -1L) {
            sb.append("{bundle.id=" + this.m_bundleId + "}");
        }
        return sb.toString();
    }

    @Override
    public String getSimpleName() {
        StringBuilder sb = new StringBuilder();
        if ((this.m_stateMask & 0x20) != 0) {
            sb.append("active");
        }
        if ((this.m_stateMask & 2) != 0) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append("installed");
        }
        if ((this.m_stateMask & 4) != 0) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append("resolved");
        }
        return sb.toString();
    }

    @Override
    public String getFilter() {
        if (this.m_filter != null || this.m_bundleId != -1L) {
            StringBuilder sb = new StringBuilder();
            if (this.m_filter != null) {
                sb.append(this.m_filter.toString());
            }
            if (this.m_bundleId != -1L) {
                sb.append("{bundle.id=" + this.m_bundleId + "}");
            }
            return sb.toString();
        }
        return null;
    }

    @Override
    public String getType() {
        return "bundle";
    }

    @Override
    public Object addingBundle(Bundle bundle, BundleEvent event) {
        Dictionary headers;
        long bundleId = bundle.getBundleId();
        if (this.m_bundleId >= 0L && this.m_bundleId != bundleId) {
            return null;
        }
        Filter filter = this.m_filter;
        if (filter != null && !this.m_filter.match(headers = bundle.getHeaders())) {
            return null;
        }
        return bundle;
    }

    @Override
    public void addedBundle(Bundle bundle, BundleEvent event, Object object) {
        this.m_component.handleEvent(this, EventType.ADDED, new BundleEventImpl(bundle, event));
    }

    @Override
    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
        this.m_component.handleEvent(this, EventType.CHANGED, new BundleEventImpl(bundle, event));
    }

    @Override
    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        this.m_component.handleEvent(this, EventType.REMOVED, new BundleEventImpl(bundle, event));
    }

    @Override
    public void invokeCallback(EventType type, Event ... e) {
        switch (type) {
            case ADDED: {
                if (this.m_add == null) break;
                this.invoke(this.m_add, e[0]);
                break;
            }
            case CHANGED: {
                if (this.m_change == null) break;
                this.invoke(this.m_change, e[0]);
                break;
            }
            case REMOVED: {
                if (this.m_remove == null) break;
                this.invoke(this.m_remove, e[0]);
                break;
            }
        }
    }

    private void invoke(String method, Event e) {
        BundleEventImpl be = (BundleEventImpl)e;
        this.m_component.invokeCallbackMethod(this.getInstances(), method, new Class[][]{{Bundle.class}, {Object.class}, new Class[0]}, new Object[][]{{be.getBundle()}, {be.getBundle()}, new Object[0]});
    }

    @Override
    public BundleDependency setBundle(Bundle bundle) {
        this.m_bundleId = bundle.getBundleId();
        return this;
    }

    @Override
    public BundleDependency setFilter(String filter) throws IllegalArgumentException {
        if (filter != null) {
            try {
                this.m_filter = FrameworkUtil.createFilter((String)filter);
            }
            catch (InvalidSyntaxException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        return this;
    }

    @Override
    public BundleDependency setStateMask(int mask) {
        this.m_stateMask = mask;
        return this;
    }

    @Override
    public Class<?> getAutoConfigType() {
        return Bundle.class;
    }

    @Override
    public Dictionary<String, Object> getProperties() {
        Event event = this.getService();
        if (event != null) {
            Bundle bundle = (Bundle)event.getEvent();
            if (this.m_propagateCallbackInstance != null && this.m_propagateCallbackMethod != null) {
                try {
                    return (Dictionary)InvocationUtil.invokeCallbackMethod(this.m_propagateCallbackInstance, this.m_propagateCallbackMethod, new Class[][]{{Bundle.class}}, new Object[][]{{bundle}});
                }
                catch (InvocationTargetException e) {
                    this.m_component.getLogger().warn("Exception while invoking callback method", e.getCause(), new Object[0]);
                }
                catch (Throwable e) {
                    this.m_component.getLogger().warn("Exception while trying to invoke callback method", e, new Object[0]);
                }
                throw new IllegalStateException("Could not invoke callback");
            }
            return bundle.getHeaders();
        }
        throw new IllegalStateException("cannot find bundle");
    }

    @Override
    public Object getDefaultService(boolean nullObject) {
        Bundle service = null;
        if (this.isAutoConfig() && service == null && nullObject) {
            service = this.getNullObject();
        }
        return service;
    }

    private Bundle getNullObject() {
        if (this.m_nullObject == null) {
            try {
                this.m_nullObject = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Bundle.class}, (InvocationHandler)new DefaultNullObject());
            }
            catch (Throwable e) {
                this.m_component.getLogger().err("Could not create null object for Bundle.", e, new Object[0]);
            }
        }
        return (Bundle)this.m_nullObject;
    }

    private void getSimpleName(StringBuilder sb) {
        if ((this.m_stateMask & 0x20) != 0) {
            sb.append("active");
        }
        if ((this.m_stateMask & 2) != 0) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append("installed");
        }
        if ((this.m_stateMask & 4) != 0) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append("resolved");
        }
    }
}

