/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.annotation.plugin.bnd;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Patterns {
    public static final Pattern VOID = Pattern.compile("\\(\\)V");
    public static final Pattern COMPOSITION = Pattern.compile("\\(\\)\\[Ljava/lang/Object;");
    public static final Pattern BIND_CLASS = Pattern.compile("\\((L[^;]+;)?L([^;]+);\\)V");
    public static final Pattern CLASS = Pattern.compile("L([^;]+);");
    public static final Pattern RUNNABLE = Pattern.compile("Ljava/lang/Runnable;");
    public static final Pattern BUNDLE_CONTEXT = Pattern.compile("Lorg/osgi/framework/BundleContext;");
    public static final Pattern DEPENDENCY_MANAGER = Pattern.compile("Lorg.apache.felix.dm.DependencyManager;");
    public static final Pattern COMPONENT = Pattern.compile("Lorg.apache.felix.dm.Component;");

    public static String parseClass(String clazz, Pattern pattern, int group) {
        Matcher matcher = pattern.matcher(clazz);
        if (matcher.matches()) {
            return matcher.group(group).replace("/", ".");
        }
        throw new IllegalArgumentException("Invalid class descriptor: " + clazz);
    }

    public static void parseMethod(String method, String descriptor, Pattern pattern) {
        Matcher matcher = pattern.matcher(descriptor);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid method " + method + ", wrong signature: " + descriptor);
        }
    }

    public static void parseField(String field, String descriptor, Pattern pattern) {
        Matcher matcher = pattern.matcher(descriptor);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid field " + field + ", wrong signature: " + descriptor);
        }
    }
}

