/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.felix.dm.DependencyManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class Logger
implements ServiceListener {
    private static final String LOG_SINGLE_CONTEXT = "org.apache.felix.dependencymanager.singleContextLog";
    public static final int LOG_ERROR = 1;
    public static final int LOG_WARNING = 2;
    public static final int LOG_INFO = 3;
    public static final int LOG_DEBUG = 4;
    private final BundleContext m_context;
    private static final int LOGGER_OBJECT_IDX = 0;
    private static final int LOGGER_METHOD_IDX = 1;
    private static final String ENABLED_LOG_LEVEL = "org.apache.felix.dependencymanager.loglevel";
    private ServiceReference m_logRef = null;
    private Object[] m_logger = null;
    private int m_enabledLevel = 2;
    private String m_debugKey;

    public Logger(BundleContext context) {
        this.m_context = context != null && "true".equals(context.getProperty(LOG_SINGLE_CONTEXT)) ? FrameworkUtil.getBundle(DependencyManager.class).getBundleContext() : context;
        if (this.m_context != null) {
            String enabledLevel = this.m_context.getProperty(ENABLED_LOG_LEVEL);
            if (enabledLevel != null) {
                try {
                    this.m_enabledLevel = Integer.valueOf(enabledLevel);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.startListeningForLogService();
        }
    }

    public final void log(int level, String msg) {
        this._log(null, level, msg, null);
    }

    public final void log(int level, String msg, Throwable throwable) {
        this._log(null, level, msg, throwable);
    }

    public final void log(ServiceReference sr, int level, String msg) {
        this._log(sr, level, msg, null);
    }

    public final void log(ServiceReference sr, int level, String msg, Throwable throwable) {
        this._log(sr, level, msg, throwable);
    }

    protected void doLog(ServiceReference sr, int level, String msg, Throwable throwable) {
        String s = sr == null ? null : "SvcRef " + sr;
        s = s == null ? msg : s + " " + msg;
        s = throwable == null ? s : s + " (" + throwable + ")";
        switch (level) {
            case 4: {
                System.out.println("DEBUG: " + s);
                break;
            }
            case 1: {
                System.out.println("ERROR: " + s);
                if (throwable == null) break;
                if (throwable instanceof BundleException && ((BundleException)throwable).getNestedException() != null) {
                    throwable = ((BundleException)throwable).getNestedException();
                }
                throwable.printStackTrace();
                break;
            }
            case 3: {
                System.out.println("INFO: " + s);
                break;
            }
            case 2: {
                System.out.println("WARNING: " + s);
                break;
            }
            default: {
                System.out.println("UNKNOWN[" + level + "]: " + s);
            }
        }
    }

    private void _log(ServiceReference sr, int level, String msg, Throwable throwable) {
        if (level <= this.m_enabledLevel) {
            StringBuilder sb = new StringBuilder("[");
            if (this.m_debugKey != null) {
                sb.append(this.m_debugKey).append(" - ");
            }
            sb.append(Thread.currentThread().getName());
            sb.append("] ");
            sb.append(msg);
            Object[] logger = this.m_logger;
            if (logger != null) {
                this._logReflectively(logger, sr, level, sb.toString(), throwable);
            } else {
                this.doLog(sr, level, sb.toString(), throwable);
            }
        }
    }

    private void _logReflectively(Object[] logger, ServiceReference sr, int level, String msg, Throwable throwable) {
        if (logger != null) {
            Object[] params = new Object[]{sr, new Integer(level), msg, throwable};
            try {
                ((Method)logger[1]).invoke(logger[0], params);
            }
            catch (InvocationTargetException ex) {
                System.err.println("Logger: " + ex);
            }
            catch (IllegalAccessException ex) {
                System.err.println("Logger: " + ex);
            }
        }
    }

    private synchronized void startListeningForLogService() {
        try {
            this.m_context.addServiceListener((ServiceListener)this, "(objectClass=org.osgi.service.log.LogService)");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        this.m_logRef = this.m_context.getServiceReference("org.osgi.service.log.LogService");
        if (this.m_logRef != null) {
            this.setLogger(this.m_context.getService(this.m_logRef));
        }
    }

    public final synchronized void serviceChanged(ServiceEvent event) {
        if (event.getType() == 1 && this.m_logRef == null) {
            this.m_logRef = event.getServiceReference();
            this.setLogger(this.m_context.getService(this.m_logRef));
        } else if (event.getType() == 1 && this.m_logRef != null) {
            ServiceReference ref = this.m_context.getServiceReference("org.osgi.service.log.LogService");
            if (!ref.equals(this.m_logRef)) {
                this.m_context.ungetService(this.m_logRef);
                this.m_logRef = ref;
                this.setLogger(this.m_context.getService(this.m_logRef));
            }
        } else if (event.getType() == 4 && this.m_logRef != null && this.m_logRef.equals(event.getServiceReference())) {
            this.m_context.ungetService(this.m_logRef);
            this.m_logRef = this.m_context.getServiceReference("org.osgi.service.log.LogService");
            if (this.m_logRef != null) {
                this.setLogger(this.m_context.getService(this.m_logRef));
            } else {
                this.setLogger(null);
            }
        }
    }

    private void setLogger(Object logObj) {
        if (logObj == null) {
            this.m_logger = null;
        } else {
            Class[] formalParams = new Class[]{ServiceReference.class, Integer.TYPE, String.class, Throwable.class};
            try {
                Method logMethod = logObj.getClass().getMethod("log", formalParams);
                logMethod.setAccessible(true);
                this.m_logger = new Object[]{logObj, logMethod};
            }
            catch (NoSuchMethodException ex) {
                System.err.println("Logger: " + ex);
                this.m_logger = null;
            }
        }
    }

    public void setEnabledLevel(int enabledLevel) {
        this.m_enabledLevel = enabledLevel;
    }

    public void setDebugKey(String debugKey) {
        this.m_debugKey = debugKey;
    }

    public String getDebugKey() {
        return this.m_debugKey;
    }

    public void err(String format, Object ... params) {
        this.log(1, String.format(format, params));
    }

    public void err(String format, Throwable err, Object ... params) {
        this.log(1, String.format(format, params), err);
    }

    public void warn(String format, Object ... params) {
        this.log(2, String.format(format, params));
    }

    public void warn(String format, Throwable err, Object ... params) {
        this.log(2, String.format(format, params), err);
    }

    public boolean info() {
        return this.m_enabledLevel >= 3;
    }

    public void info(String format, Object ... params) {
        this.log(3, String.format(format, params));
    }

    public void info(String format, Throwable err, Object ... params) {
        this.log(3, String.format(format, params), err);
    }

    public boolean debug() {
        return this.m_enabledLevel >= 4;
    }

    public void debug(String format, Object ... params) {
        this.log(4, String.format(format, params));
    }

    public void debug(String format, Throwable err, Object ... params) {
        this.log(4, String.format(format, params), err);
    }
}

