/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl;

import java.net.URL;
import java.util.Dictionary;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.ComponentStateListener;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.context.ComponentContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;

public abstract class AbstractDecorator {
    protected volatile DependencyManager m_manager;
    private final Map<Object, Component> m_services = new ConcurrentHashMap<Object, Component>();

    public abstract Component createService(Object[] var1);

    public void init(Component c) {
        this.m_manager = c.getDependencyManager();
    }

    public void updateService(Object[] properties) {
        throw new NoSuchMethodError("Method updateService not implemented");
    }

    public void setServiceProperties(Dictionary<?, ?> serviceProperties) {
        for (Component component : this.m_services.values()) {
            component.setServiceProperties(serviceProperties);
        }
    }

    public void addStateListener(ComponentStateListener listener) {
        for (Component component : this.m_services.values()) {
            component.add(listener);
        }
    }

    public void removeStateListener(ComponentStateListener listener) {
        for (Component component : this.m_services.values()) {
            component.remove(listener);
        }
    }

    public void addDependency(Dependency ... dependencies) {
        for (Component component : this.m_services.values()) {
            component.add(dependencies);
        }
    }

    public void removeDependency(Dependency d) {
        for (Component component : this.m_services.values()) {
            component.remove(d);
        }
    }

    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        try {
            Component service = this.m_services.get(pid);
            if (service == null) {
                service = this.createService(new Object[]{properties});
                this.m_services.put(pid, service);
                this.m_manager.add(service);
            } else {
                this.updateService(new Object[]{properties, service});
            }
        }
        catch (Throwable t) {
            if (t instanceof ConfigurationException) {
                throw (ConfigurationException)t;
            }
            if (t.getCause() instanceof ConfigurationException) {
                throw (ConfigurationException)t.getCause();
            }
            throw new ConfigurationException(null, "Could not create service for ManagedServiceFactory Pid " + pid, t);
        }
    }

    public void deleted(String pid) {
        Component service = this.m_services.remove(pid);
        if (service != null) {
            this.m_manager.remove(service);
        }
    }

    public void added(URL resource) {
        Component newService = this.createService(new Object[]{resource});
        this.m_services.put(resource, newService);
        this.m_manager.add(newService);
    }

    public void removed(URL resource) {
        Component newService = this.m_services.remove(resource);
        if (newService == null) {
            throw new IllegalStateException("Service should not be null here.");
        }
        this.m_manager.remove(newService);
    }

    public void added(ServiceReference ref, Object service) {
        Component newService = this.createService(new Object[]{ref, service});
        this.m_services.put(ref, newService);
        this.m_manager.add(newService);
    }

    public void removed(ServiceReference ref, Object service) {
        Component newService = this.m_services.remove(ref);
        if (newService == null) {
            throw new IllegalStateException("Service should not be null here.");
        }
        this.m_manager.remove(newService);
    }

    public void swapped(ServiceReference oldRef, Object oldService, ServiceReference newRef, Object newService) {
        Component service = this.m_services.remove(oldRef);
        if (service == null) {
            throw new IllegalStateException("Service should not be null here.");
        }
        this.m_services.put(newRef, service);
    }

    public void added(Bundle bundle) {
        Component newService = this.createService(new Object[]{bundle});
        this.m_services.put(bundle, newService);
        this.m_manager.add(newService);
    }

    public void removed(Bundle bundle) {
        Component newService = this.m_services.remove(bundle);
        if (newService == null) {
            throw new IllegalStateException("Service should not be null here.");
        }
        this.m_manager.remove(newService);
    }

    public void stop() {
        for (Component component : this.m_services.values()) {
            this.m_manager.remove(component);
        }
    }

    public void configureAutoConfigState(Component target, ComponentContext source) {
        this.configureAutoConfigState(target, source, BundleContext.class);
        this.configureAutoConfigState(target, source, ServiceRegistration.class);
        this.configureAutoConfigState(target, source, DependencyManager.class);
        this.configureAutoConfigState(target, source, Component.class);
    }

    public Map<Object, Component> getServices() {
        return this.m_services;
    }

    private void configureAutoConfigState(Component target, ComponentContext source, Class<?> clazz) {
        String name = source.getAutoConfigInstance(clazz);
        if (name != null) {
            target.setAutoConfig(clazz, name);
        } else {
            target.setAutoConfig(clazz, source.getAutoConfig(clazz));
        }
    }
}

