/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.felix.dm.ServiceDependency;
import org.apache.felix.dm.context.DependencyContext;
import org.apache.felix.dm.context.EventType;
import org.apache.felix.dm.impl.ServiceDependencyImpl;
import org.apache.felix.dm.impl.ServiceEventImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class TemporalServiceDependencyImpl
extends ServiceDependencyImpl
implements ServiceDependency,
InvocationHandler {
    private final long m_timeout;
    private final Bundle m_frameworkBundle;
    private volatile Object m_serviceInstance;

    public TemporalServiceDependencyImpl(BundleContext context, long timeout) {
        super.setRequired(true);
        if (timeout < 0L) {
            throw new IllegalArgumentException("Invalid timeout value: " + timeout);
        }
        this.m_timeout = timeout;
        this.m_frameworkBundle = context.getBundle(0L);
    }

    public TemporalServiceDependencyImpl(TemporalServiceDependencyImpl prototype) {
        super(prototype);
        super.setRequired(true);
        this.m_timeout = prototype.m_timeout;
        this.m_frameworkBundle = prototype.m_frameworkBundle;
    }

    @Override
    public DependencyContext createCopy() {
        return new TemporalServiceDependencyImpl(this);
    }

    @Override
    public ServiceDependency setRequired(boolean required) {
        if (!required) {
            throw new IllegalArgumentException("A Temporal Service dependency can't be optional");
        }
        super.setRequired(required);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addedService(ServiceReference ref, Object service) {
        boolean makeAvailable = false;
        TemporalServiceDependencyImpl temporalServiceDependencyImpl = this;
        synchronized (temporalServiceDependencyImpl) {
            if (this.m_serviceInstance == null) {
                this.m_serviceInstance = Proxy.newProxyInstance(this.m_trackedServiceName.getClassLoader(), new Class[]{this.m_trackedServiceName}, (InvocationHandler)this);
                makeAvailable = true;
            }
        }
        if (makeAvailable) {
            this.getComponentContext().handleEvent(this, EventType.ADDED, new ServiceEventImpl(this.m_component.getBundle(), this.m_component.getBundleContext(), ref, this.m_serviceInstance));
        }
    }

    @Override
    public void modifiedService(ServiceReference ref, Object service) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removedService(ServiceReference ref, Object service) {
        if (this.m_frameworkBundle.getState() == 16) {
            boolean makeUnavailable = false;
            TemporalServiceDependencyImpl temporalServiceDependencyImpl = this;
            synchronized (temporalServiceDependencyImpl) {
                if (this.m_tracker.getService() == null) {
                    makeUnavailable = true;
                }
            }
            if (makeUnavailable) {
                this.m_component.handleEvent(this, EventType.REMOVED, new ServiceEventImpl(this.m_component.getBundle(), this.m_component.getBundleContext(), ref, this.m_serviceInstance));
            }
        } else {
            this.m_component.getBundleContext().ungetService(ref);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object service = null;
        try {
            service = this.m_tracker.waitForService(this.m_timeout);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (service == null) {
            throw new IllegalStateException("Service unavailable: " + this.m_trackedServiceName.getName());
        }
        try {
            try {
                return method.invoke(service, args);
            }
            catch (IllegalAccessException iae) {
                method.setAccessible(true);
                return method.invoke(service, args);
            }
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }
}

