/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.runtime;

import java.lang.reflect.Method;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.runtime.DependencyBuilder;
import org.apache.felix.dm.runtime.InvocationUtil;
import org.apache.felix.dm.runtime.Log;
import org.apache.felix.dm.runtime.MetaData;
import org.apache.felix.dm.runtime.Params;
import org.apache.felix.dm.runtime.ServiceLifecycleHandler;
import org.apache.felix.dm.runtime.api.ComponentInstance;
import org.osgi.framework.Bundle;

public class ComponentInstanceImpl
implements ComponentInstance {
    private final MetaData m_srvMeta;
    private final List<MetaData> m_depsMeta;
    private final DependencyManager m_dm;
    private final Bundle m_bundle;
    private final Object m_impl;
    private final Component m_component;

    public ComponentInstanceImpl(DependencyManager dm, Bundle b, MetaData srvMeta, List<MetaData> depsMeta, Dictionary<String, ?> conf) throws Exception {
        this.m_bundle = b;
        this.m_dm = dm;
        this.m_srvMeta = srvMeta;
        this.m_depsMeta = depsMeta;
        this.m_component = this.m_dm.createComponent();
        Class implClass = this.m_bundle.loadClass(this.m_srvMeta.getString(Params.impl));
        Object impl = conf.get("dm.factory.instance");
        if (impl == null) {
            String factoryMethod = this.m_srvMeta.getString(Params.factoryMethod, null);
            if (factoryMethod == null) {
                impl = implClass.newInstance();
            } else {
                Method m = implClass.getDeclaredMethod(factoryMethod, new Class[0]);
                m.setAccessible(true);
                impl = m.invoke(null, new Object[0]);
            }
        }
        this.m_impl = impl;
        String configure = this.m_srvMeta.getString(Params.factoryConfigure, null);
        if (configure != null) {
            this.invokeConfigure(impl, configure, conf);
        }
        this.m_component.setImplementation(impl);
        String[] provides = this.m_srvMeta.getStrings(Params.provides, null);
        if (provides != null) {
            Dictionary<String, Object> serviceProperties = this.m_srvMeta.getDictionary(Params.properties, null);
            serviceProperties = this.mergeSettings(serviceProperties, conf);
            this.m_component.setInterface(provides, serviceProperties);
        }
        this.m_component.setComposition(this.m_srvMeta.getString(Params.composition, null));
        ServiceLifecycleHandler lfcleHandler = new ServiceLifecycleHandler(this.m_component, this.m_bundle, this.m_dm, this.m_srvMeta, this.m_depsMeta);
        this.m_component.setCallbacks((Object)lfcleHandler, "init", "start", "stop", "destroy");
        for (MetaData dependency : this.m_depsMeta) {
            String name = dependency.getString(Params.name, null);
            if (name != null) continue;
            DependencyBuilder depBuilder = new DependencyBuilder(dependency);
            Log.instance().info("ServiceLifecycleHandler.init: adding dependency %s into service %s", dependency, this.m_srvMeta);
            Dependency d = depBuilder.build(this.m_bundle, this.m_dm);
            this.m_component.add(new Dependency[]{d});
        }
        Log.instance().info("ServiceFactory: created service %s", this.m_srvMeta);
        this.m_dm.add(this.m_component);
    }

    @Override
    public void dispose() {
        this.m_dm.remove(this.m_component);
    }

    @Override
    public void update(Dictionary<String, ?> conf) {
        String[] provides;
        String configure = this.m_srvMeta.getString(Params.factoryConfigure, null);
        if (configure != null) {
            Log.instance().info("ServiceFactory: updating service %s", this.m_impl);
            this.invokeConfigure(this.m_impl, configure, conf);
        }
        if ((provides = this.m_srvMeta.getStrings(Params.provides, null)) != null) {
            Dictionary<String, Object> serviceProperties = this.m_srvMeta.getDictionary(Params.properties, null);
            serviceProperties = this.mergeSettings(serviceProperties, conf);
            this.m_component.setServiceProperties(serviceProperties);
        }
    }

    private void invokeConfigure(Object impl, String configure, Dictionary<String, ?> config) {
        try {
            InvocationUtil.invokeCallbackMethod(impl, configure, new Class[][]{{Dictionary.class}}, new Object[][]{{config}});
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException("Could not invoke method " + configure + " on object " + impl, t);
        }
    }

    private Dictionary<String, Object> mergeSettings(Dictionary<String, ?> serviceProperties, Dictionary<String, ?> factoryConfiguration) {
        Object val;
        String key;
        Enumeration<String> keys;
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        if (serviceProperties != null) {
            keys = serviceProperties.keys();
            while (keys.hasMoreElements()) {
                key = keys.nextElement();
                val = serviceProperties.get(key);
                ((Dictionary)props).put(key, val);
            }
        }
        keys = factoryConfiguration.keys();
        while (keys.hasMoreElements()) {
            key = keys.nextElement();
            if (key.toString().startsWith(".")) continue;
            val = factoryConfiguration.get(key);
            ((Dictionary)props).put(key, val);
        }
        return props;
    }
}

