/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.annotation.plugin.bnd;

import aQute.service.reporter.Reporter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.felix.dm.annotation.plugin.bnd.Logger;

public class BndLogger
extends Logger {
    private final Reporter m_reporter;
    private final PrintWriter logWriter;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("E yyyy.MM.dd hh:mm:ss.S");
    private Logger.Level logEnabled = Logger.Level.Warn;

    public BndLogger(Reporter reporter, String bsn) {
        this.m_reporter = reporter;
        File logFilePath = new File(System.getProperty("java.io.tmpdir") + File.separator + "dmplugin" + File.separator + bsn + ".log");
        new File(logFilePath.getParent()).mkdirs();
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(logFilePath, false));
        }
        catch (IOException e) {
            reporter.exception((Throwable)e, "Could not create scrplugin log file: %s", new Object[]{logFilePath});
            writer = null;
        }
        this.logWriter = writer;
    }

    public void close() {
        if (this.logWriter != null) {
            this.logWriter.close();
        }
    }

    public void setLevel(String level) {
        try {
            level = Character.toUpperCase(level.charAt(0)) + level.substring(1).toLowerCase();
            this.logEnabled = Logger.Level.valueOf(level);
        }
        catch (IllegalArgumentException e) {
            this.logEnabled = Logger.Level.Warn;
            this.warn("Bnd scrplugin logger initialized with invalid log level: " + level, new Object[0]);
        }
    }

    public boolean isDebugEnabled() {
        return this.logEnabled.ordinal() >= Logger.Level.Debug.ordinal();
    }

    @Override
    public void debug(String content, Object ... args) {
        if (this.isDebugEnabled()) {
            this.m_reporter.trace(content, args);
            this.logDebug(String.format(content, args), null);
        }
    }

    public boolean isInfoEnabled() {
        return this.logEnabled.ordinal() >= Logger.Level.Info.ordinal();
    }

    @Override
    public void info(String content, Object ... args) {
        if (this.isInfoEnabled()) {
            this.m_reporter.trace(content, args);
            this.logInfo(String.format(content, args), null);
        }
    }

    public boolean isWarnEnabled() {
        return this.logEnabled.ordinal() >= Logger.Level.Warn.ordinal();
    }

    @Override
    public void warn(String content, Object ... args) {
        if (this.isWarnEnabled()) {
            this.m_reporter.warning(content, args);
            this.logWarn(String.format(content, args), null);
        }
    }

    public void warn(String content, Throwable err, Object ... args) {
        if (this.isWarnEnabled()) {
            this.m_reporter.warning(content, args);
            this.logWarn(String.format(content, args), err);
        }
    }

    public boolean isErrorEnabled() {
        return this.logEnabled.ordinal() >= Logger.Level.Error.ordinal();
    }

    @Override
    public void error(String content, Object ... args) {
        this.m_reporter.error(content, args);
        this.logErr(String.format(content, args), null);
    }

    @Override
    public void error(String content, Throwable err, Object ... args) {
        this.m_reporter.error(content, args);
        this.logErr(String.format(content, args), err);
    }

    private void logErr(String msg, Throwable t) {
        this.log(Logger.Level.Error, msg, t);
    }

    private void logWarn(String msg, Throwable t) {
        this.log(Logger.Level.Warn, msg, t);
    }

    private void logInfo(String msg, Throwable t) {
        this.log(Logger.Level.Info, msg, t);
    }

    private void logDebug(String msg, Throwable t) {
        this.log(Logger.Level.Debug, msg, t);
    }

    private void log(Logger.Level level, String msg, Throwable t) {
        if (this.logWriter != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(dateFormat.format(new Date()));
            sb.append(" - ");
            sb.append((Object)level);
            sb.append(": ");
            sb.append(msg);
            if (t != null) {
                sb.append(" - ").append(BndLogger.toString(t));
            }
            this.logWriter.println(sb.toString());
        }
    }

    private static String toString(Throwable e) {
        StringWriter buffer = new StringWriter();
        PrintWriter pw = new PrintWriter(buffer);
        e.printStackTrace(pw);
        return buffer.toString();
    }
}

